//#include <cstdlib>
#include <string>
#include <iostream.h>
#include "makebin.h"
#include "WavFile.h"

int main(int argc, char *argv[]) {
	unsigned char inbyte;
	unsigned char scbuffer[8448];
	int page_num,byte_num;
	unsigned char checksum_read, checksum;

	SCWavFile InFile(argv[1],atoi(argv[2]));

//	InFile.Describe_SCWav();
//	cout << '\n';

	scbuffer[0x2000] = InFile.ReadAByte();
	scbuffer[0x2001] = InFile.ReadAByte(); // hi byte of start addr
	scbuffer[0x2002] = InFile.ReadAByte(); // control byte

	scbuffer[0x2003] = InFile.ReadAByte(); // count of pages

	scbuffer[0x2004] = InFile.ReadAByte(); // header checksum

	scbuffer[0x2005] = InFile.ReadAByte(); // unique number id

	scbuffer[0x2006] = InFile.ReadAByte(); // tape load speed lo byte

	scbuffer[0x2007] = InFile.ReadAByte(); // tape load speed hi byte

	cout.setf(ios::hex);

	for (page_num = 0; page_num < scbuffer[0x2003]; page_num++) {
		inbyte = InFile.ReadAByte();
		scbuffer[0x2010+page_num] = inbyte;
		checksum = 0x55 - inbyte;
		checksum_read = InFile.ReadAByte();
		for (byte_num = 0; byte_num < 256; byte_num++) {
			inbyte = InFile.ReadAByte();
			scbuffer[0x0000 + (page_num * 0x100) + byte_num]=inbyte;
			checksum -= inbyte;
		}
		cout << "Page " << page_num << " Checksum Read " << (unsigned int)checksum_read
			 << " Checksum Calc " << (unsigned int)checksum << '\n';
	}

	ofstream ofs_SCBin("test.bin",ios::out|ios::binary|ios::trunc);
	if (!ofs_SCBin) {
		cerr << "Unable to open test.bin";
		exit(1);
	}

	ofs_SCBin.write(scbuffer,8448);

	return 0;
}
