#include <ctype.h>
#ifdef _MSC_EXTENSIONS
#include <excpt.h>
#endif
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sapGlobals.h"

double oldVal=0.0;
const double cutFreq = 20000.0 / 44100.0; // cutoff frequency = 20000, sampling frequency = 44100
const int samplerRate = 0x2836D6; // (1773447 / 44100) * 65536;

#define MAKESAMPLE\
	{\
		ss+=0x10000;\
		if( ss>=samplerRate )\
		{\
			ss -= samplerRate;\
			DWORD pomd; int pomi;\
			pomd = ((((sj3qs[0]&sj3qsA[0]) ^ sso[0]) & frse[0]) | acld[0]) & acl2[0];\
			pomd = pomd + (pomd>>16);\
			pomi = (int)( pomd + (pomd>>8) ) & 255;\
			pomi <<= 9;\
			{\
				double output;\
				output = oldVal + cutFreq*( ((double)pomi) - oldVal );\
				oldVal = output;\
				pomi = (int)output;\
				if( pomi<0 ) pomi = 0; else if( pomi>32767 ) pomi = 32767;\
			}\
			sndBuf[sndBufPtr&8191] = (WORD)pomi;\
			sndBufPtr = (sndBufPtr+1)&8191;\
		}\
	}


//#define MAKESAMPLE MAKESAMPLE2();

namespace POKEY_NAMESPACE {

int sndBufPtrUpp;

int divideByN[4];
int divideByN_Latch[4];
int divideByN_Latch2[4];

BYTE AUDCTL;
int pcc1564,noiseAND,pokeyClockCounter64k;

DWORD pokeyClockCounter;
DWORD poly4Counter,poly5Counter,poly4_5Counter;

BYTE switch_J2_signal_Q[4];
BYTE signal_state_out[4];
BYTE switch_J3_Q_state[4];
BYTE switch_J3_Q_stateAND[4];
BYTE audioControl_Latch[4];
BYTE audioControl_Latch2[4];
BYTE audioControl_Latch_Digi[4];
BYTE freq_sequre[4];

const DWORD *sj3qs = (DWORD*)&switch_J3_Q_state[0];
const DWORD *sj3qsA = (DWORD*)&switch_J3_Q_stateAND[0];
const DWORD *sso = (DWORD*)&signal_state_out[0];
const DWORD *acld = (DWORD*)&audioControl_Latch_Digi[0];
const DWORD *acl2 = (DWORD*)&audioControl_Latch2[0];
const DWORD *frse = (DWORD*)&freq_sequre[0];


// poly4 has 15 values repeated 17 times
BYTE poly4[15] = {
15, 15, 15, 15, 0, 0, 0, 15, 0, 0, 15, 15, 0, 15, 0
};

BYTE poly5[31] = {
15, 15, 15, 15, 0, 15, 15, 0, 15, 0, 0, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 0, 15, 0, 0, 0, 15, 0, 15, 0
};

BYTE poly17[0x20000];

BYTE poly4_b[36000]; // minimum size is 312*114+15
BYTE poly5_b[36000]; // minimum size is 312*114+31
BYTE poly4_5_b[37000]; // minimum size is 312*114+465

void (*Channel0Distortion)(void);
void (*Channel1Distortion)(void);
void (*Channel2Distortion)(void);
void (*Channel3Distortion)(void);

void MAKESAMPLE2( void )
{
	DWORD pomd; int pomi;
	pomd = ((((sj3qs[0]&sj3qsA[0]) ^ sso[0]) & frse[0]) | acld[0]) & acl2[0];
	pomd = pomd + (pomd>>16);
	pomi = (int)( pomd + (pomd>>8) ) & 255;
	pomi <<= 9;
	{
		double output;
		output = oldVal + cutFreq*( ((double)pomi) - oldVal );
		oldVal = output;
		pomi = (int)output;
		if( pomi<0 ) pomi = 0; else if( pomi>32767 ) pomi = 32767;
	}
	sndBuf[sndBufPtr&8191] = (WORD)pomi;
	sndBufPtr = (sndBufPtr+1)&8191;
}

//---
void channel0_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[0] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel0_2( void )
{
	signal_state_out[0] = signal_state_out[0] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel0_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[0] = poly4_b[ poly4Counter + pokeyClockCounter ];
}
void channel0_8( void )
{
	signal_state_out[0] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel0_A( void )
{
	signal_state_out[0] = signal_state_out[0] ^ 15;
}
void channel0_C( void )
{
	signal_state_out[0] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
//---
void channel1_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[1] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel1_2( void )
{
	signal_state_out[1] = signal_state_out[1] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel1_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[1] = poly4_b[ poly4Counter + pokeyClockCounter ];
}
void channel1_8( void )
{
	signal_state_out[1] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel1_A( void )
{
	signal_state_out[1] = signal_state_out[1] ^ 15;
}
void channel1_C( void )
{
	signal_state_out[1] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
//---
void channel2_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[2] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel2_2( void )
{
	signal_state_out[2] = signal_state_out[2] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel2_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[2] = poly4_b[ poly4Counter + pokeyClockCounter ];
}
void channel2_8( void )
{
	signal_state_out[2] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel2_A( void )
{
	signal_state_out[2] = signal_state_out[2] ^ 15;
}
void channel2_C( void )
{
	signal_state_out[2] = poly4_b[ pokeyClockCounter + poly4Counter ];
}
//---
void channel3_0( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[3] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel3_2( void )
{
	signal_state_out[3] = signal_state_out[3] ^ poly5_b[ poly5Counter + pokeyClockCounter ];
}
void channel3_4( void )
{
	if( poly5_b[ poly5Counter + pokeyClockCounter ]!=0 )
		signal_state_out[3] = poly4_b[ poly4Counter + pokeyClockCounter ];
}
void channel3_8( void )
{
	signal_state_out[3] = poly17[ pokeyClockCounter & noiseAND ];
}
void channel3_A( void )
{
	signal_state_out[3] = signal_state_out[3] ^ 15;
}
void channel3_C( void )
{
	signal_state_out[3] = poly4_b[ pokeyClockCounter + poly4Counter ];
}

typedef void (*funcPoint)(void);
funcPoint channelsDistorionTable[4][8]={
	{ &channel0_0, &channel0_2, &channel0_4, &channel0_2, &channel0_8, &channel0_A, &channel0_C, &channel0_A },
	{ &channel1_0, &channel1_2, &channel1_4, &channel1_2, &channel1_8, &channel1_A, &channel1_C, &channel1_A },
	{ &channel2_0, &channel2_2, &channel2_4, &channel2_2, &channel2_8, &channel2_A, &channel2_C, &channel2_A },
	{ &channel3_0, &channel3_2, &channel3_4, &channel3_2, &channel3_8, &channel3_A, &channel3_C, &channel3_A },
};

void pus_zero( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 

	i = n;
	do
	{
		pokeyClockCounter++;
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
			ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
			ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
			ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		}
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;

}

void pus_2h( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
			ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
			ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		}
		ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;
}

void pus_23h( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
			ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
		}
		ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
		ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;
}

void pus_0h( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
			ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
			ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		}
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;
}

void pus_01h( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
		ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
			ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		}
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;

}

void pus_02h( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
			ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		}
		ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;
}

void pus_012h( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
		ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		}
		ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;
}

void pus_023h( int n )
{
int i,ch,pp,ss;

	pp = pokeyClockCounter + (pcc1564 - pokeyClockCounter64k);
	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
		if( pokeyClockCounter>=pp )
		{
			pp = pokeyClockCounter + pcc1564;
			ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
		}
		ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
		ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
	pokeyClockCounter64k = pcc1564 + pokeyClockCounter - pp ;
}

void pus_0123h( int n )
{
int i,ch,ss;

	ss = sndBufPtrUpp; 
	i = n;
	do
	{
		pokeyClockCounter++;
		ch = 0; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel0Distortion(); } }
		ch = 1; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel1Distortion(); } }
		ch = 2; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel2Distortion(); switch_J3_Q_state[0] = signal_state_out[0]; } }
		ch = 3; { if( --divideByN[ch]==0 ) { divideByN[ch] = divideByN_Latch2[ch]; Channel3Distortion(); switch_J3_Q_state[1] = signal_state_out[1]; } }
		MAKESAMPLE
	} while(--i);
	sndBufPtrUpp = ss;
}

typedef void (*funcPoint2)(int n);
funcPoint2 channelsGeneration[16]={
	&pus_zero,	&pus_zero,	&pus_zero,	&pus_zero,
	&pus_2h,	&pus_23h,	&pus_2h,	&pus_23h,
	&pus_0h,	&pus_0h,	&pus_01h,	&pus_01h,
	&pus_02h,	&pus_023h,	&pus_012h,	&pus_0123h
};

#ifdef _EXCEPTION_
BYTE wasNoExc;
#endif
}; // end of namespace POKEY_NAMESPACE

using namespace POKEY_NAMESPACE;

void pokeyInit( void )
{
int i;
DWORD pol;
BYTE old;

	pol = 0x1FFFF;
	for( i=0; i<0x20000; i++ )
	{
		poly17[i] = (BYTE)(pol&1 ? 15:0);
		pol = pol | (((pol&1) ^ ((pol>>5)&1)) << 17);
		pol>>=1;
	}

	for( i=0; i<sizeof(poly4_b); i++ ) // this table repeats after 15
		poly4_b[i] = poly4[i % 15];

	for( i=0; i<sizeof(poly5_b); i++ ) // this table repeats after 31
		poly5_b[i] = poly5[i % 31];

	old = 0;
	for( i=0; i<sizeof(poly4_5_b); i++ ) // this table repeats after 465
	{
		if( poly5[i % 31] )
			old = poly4[i % 15];
		poly4_5_b[i] = old;
	}

}


void pokeyReset( void )
{
int i;

	poly4Counter = 0;
	poly5Counter = 0;
	poly4_5Counter = 0;
	pokeyClockCounter = 0;
	pokeyClockCounter64k = 0;
	pcc1564 = 28;

	for( i=0; i<4; i++ )
	{
		divideByN[i] = 1;
		divideByN_Latch[i] = 0;
		divideByN_Latch2[i] = 0;
		switch_J2_signal_Q[i] = 0;
		signal_state_out[i] = 0;
		switch_J3_Q_state[i] = 0;
		switch_J3_Q_stateAND[i] = 0;
		audioControl_Latch[i] = 0;
		audioControl_Latch2[i] = 0;
		audioControl_Latch_Digi[i] = 0;
		freq_sequre[i] = 0;
	}

	for( i=0; i<16; i++ )
		pokeyWriteByte( 0xD200+i, 0 );
	AUDCTL = 0;

	sndBufPtrUpp = 0;
	sndBufPtr = 0;
#ifdef _EXCEPTION_
	wasNoExc = 1;
#endif

}

void pokeyUpdateSound( int n )
{
#ifdef _EXCEPTION_
EXCEPTION_POINTERS *ep;
	__try
	{
#endif

	channelsGeneration[ (AUDCTL>>3)&15 ](n);

#ifdef _EXCEPTION_
	}
	__except( ep = GetExceptionInformation(), 1 )
	{
		if( wasNoExc )
		{
			// now we should just stop playing
		}
		wasNoExc = 0;
	}
#endif
}


void pokeyUpdateSoundCounters( void )
{

	pokeyClockCounter = pokeyClockCounter & 0x7FFFFFFF;
	poly4Counter = (int)(((DWORD)(poly4Counter+pokeyClockCounter)) % 15) - pokeyClockCounter;
	poly5Counter = (int)(((DWORD)(poly5Counter+pokeyClockCounter)) % 31) - pokeyClockCounter;
	poly4_5Counter = (int)(((DWORD)(poly4_5Counter+pokeyClockCounter)) % 465) - pokeyClockCounter;

}

BYTE pokeyReadByte( short unsigned int address)
{
BYTE retVal;

	switch( address&0x0F )
	{
		case 0x09:
			return 0xFF;
		case 0x0A:
			retVal = (BYTE)((255*rand())/RAND_MAX);
			return retVal;
		case 0x0E:
			return 0xFF;
		case 0x0F:
			return 0xFF;
	}
	return 0xFF;
}


#define SetupChannels01\
			switch( AUDCTL&0x50 )\
			{\
				case 0x00:\
					divideByN_Latch2[0] = divideByN_Latch[0]+1;\
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )\
						freq_sequre[0] = 0;\
					else\
						freq_sequre[0] = 15;\
					divideByN_Latch2[1] = divideByN_Latch[1]+1;\
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )\
						freq_sequre[1] = 0;\
					else\
						freq_sequre[1] = 15;\
					break;\
				case 0x10:\
					divideByN_Latch2[0] = divideByN_Latch[0]+1;\
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<3) )\
						freq_sequre[0] = 0;\
					else\
						freq_sequre[0] = 15;\
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];\
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )\
						freq_sequre[1] = 0;\
					else\
						freq_sequre[1] = 15;\
					break;\
				case 0x40:\
					divideByN_Latch2[0] = divideByN_Latch[0]+4;\
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x50) )\
						freq_sequre[0] = 0;\
					else\
						freq_sequre[0] = 15;\
					divideByN_Latch2[1] = divideByN_Latch[1]+1;\
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<3) )\
						freq_sequre[1] = 0;\
					else\
						freq_sequre[1] = 15;\
					break;\
				case 0x50:\
					divideByN_Latch2[0] = divideByN_Latch[0]+7;\
					freq_sequre[0] = 0;\
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];\
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<0x50) )\
						freq_sequre[1] = 0;\
					else\
						freq_sequre[1] = 15;\
					break;\
			}

/*
				case 0x50:\
					divideByN_Latch2[0] = divideByN_Latch[0]+7;\
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[0]<0x50) )\
						freq_sequre[0] = 0;\
					else\
						freq_sequre[0] = 15;\
					divideByN_Latch2[1] = divideByN_Latch[1]*256+divideByN_Latch2[0];\
					if( ((audioControl_Latch[1]&0xA0)==0xA0) && (divideByN_Latch2[1]<0x50) )\
						freq_sequre[1] = 0;\
					else\
						freq_sequre[1] = 15;\
					break;\
*/

#define SetupChannels23\
			switch( AUDCTL&0x28 )\
			{\
				case 0x00:\
					divideByN_Latch2[2] = divideByN_Latch[2]+1;\
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )\
						freq_sequre[2] = 0;\
					else\
						freq_sequre[2] = 15;\
					divideByN_Latch2[3] = divideByN_Latch[3]+1;\
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )\
						freq_sequre[3] = 0;\
					else\
						freq_sequre[3] = 15;\
					break;\
				case 0x08:\
					divideByN_Latch2[2] = divideByN_Latch[2]+1;\
					if( ((audioControl_Latch[0]&0xA0)==0xA0) && (divideByN_Latch2[2]<3) )\
						freq_sequre[2] = 0;\
					else\
						freq_sequre[2] = 15;\
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];\
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )\
						freq_sequre[3] = 0;\
					else\
						freq_sequre[3] = 15;\
					break;\
				case 0x20:\
					divideByN_Latch2[2] = divideByN_Latch[2]+4;\
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x50) )\
						freq_sequre[2] = 0;\
					else\
						freq_sequre[2] = 15;\
					divideByN_Latch2[3] = divideByN_Latch[3]+1;\
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<3) )\
						freq_sequre[3] = 0;\
					else\
						freq_sequre[3] = 15;\
					break;\
				case 0x28:\
					divideByN_Latch2[2] = divideByN_Latch[2]+7;\
					freq_sequre[2] = 0;\
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];\
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<0x50) )\
						freq_sequre[3] = 0;\
					else\
						freq_sequre[3] = 15;\
					break;\
			}
/*
				case 0x28:\
					divideByN_Latch2[2] = divideByN_Latch[2]+7;\
					if( ((audioControl_Latch[2]&0xA0)==0xA0) && (divideByN_Latch2[2]<0x50) )\
						freq_sequre[2] = 0;\
					else\
						freq_sequre[2] = 15;\
					divideByN_Latch2[3] = divideByN_Latch[3]*256+divideByN_Latch2[2];\
					if( ((audioControl_Latch[3]&0xA0)==0xA0) && (divideByN_Latch2[3]<0x50) )\
						freq_sequre[3] = 0;\
					else\
						freq_sequre[3] = 15;\
					break;\
*/


void pokeyWriteByte( short unsigned int address, BYTE value )
{
	address&=0x0F;

	switch( address )
	{
		case 0x00:
			divideByN_Latch[0] = value;
			SetupChannels01;
			break;
		case 0x01:
			audioControl_Latch[0] = value;
			audioControl_Latch2[0] = value&15;
			audioControl_Latch_Digi[0] = (value>>4)&1 ? 15:0;
			Channel0Distortion = channelsDistorionTable[0][ (value>>5)&7 ];
			SetupChannels01;
			break;
		case 0x02:
			divideByN_Latch[1] = value;
			SetupChannels01;
			break;
		case 0x03:
			audioControl_Latch[1] = value;
			audioControl_Latch2[1] = value&15;
			audioControl_Latch_Digi[1] = (value>>4)&1 ? 15:0;
			Channel1Distortion = channelsDistorionTable[1][ (value>>5)&7 ];
			SetupChannels01;
			break;
		case 0x04:
			divideByN_Latch[2] = value;
			SetupChannels23;
			break;
		case 0x05:
			audioControl_Latch[2] = value;
			audioControl_Latch2[2] = value&15;
			audioControl_Latch_Digi[2] = (value>>4)&1 ? 15:0;
			Channel2Distortion = channelsDistorionTable[2][ (value>>5)&7 ];
			SetupChannels23;
			break;
		case 0x06:
			divideByN_Latch[3] = value;
			SetupChannels23;
			break;
		case 0x07:
			audioControl_Latch[3] = value;
			audioControl_Latch2[3] = value&15;
			audioControl_Latch_Digi[3] = (value>>4)&1 ? 15:0;
			Channel3Distortion = channelsDistorionTable[3][ (value>>5)&7 ];
			SetupChannels23;
			break;
		case 0x08:
		{
			BYTE prevAUDCTL;
			prevAUDCTL = AUDCTL;
			AUDCTL = value;
			pcc1564 = value & 1 ? 112:28;

			noiseAND = AUDCTL & 128 ? 0x1FF:0x1FFFF;

			switch_J3_Q_stateAND[0] = AUDCTL&4 ? 15:0;
			switch_J3_Q_stateAND[1] = AUDCTL&2 ? 15:0;

			SetupChannels01;
			SetupChannels23;

			if( (prevAUDCTL^AUDCTL)&0x10 )
				divideByN[1] = 2;
			if( (prevAUDCTL^AUDCTL)&0x8 )
				divideByN[3] = 2;

			break;
		}
		case 0x0D:
			break;
		case 0x0E:
			break;
		case 0x0F:
			break;
	}
}


