/*****************************************************************************/
/*                                                                           */
/* Module:  Test                                                             */
/* Purpose: Tests the SOUND.C and POKEY11.C modules.  Also, provides an      */
/*          example of their use. V1.1.                                      */
/* Author:  Ron Fries                                                        */
/* Date:    September 23, 1996                                               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*                 License Information and Copyright Notice                  */
/*                 ========================================                  */
/*                                                                           */
/* PokeySound is Copyright(c) 1996 by Ron Fries                              */
/*                                                                           */
/* This library is free software; you can redistribute it and/or modify it   */
/* under the terms of version 2 of the GNU Library General Public License    */
/* as published by the Free Software Foundation.                             */
/*                                                                           */
/* This library is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library */
/* General Public License for more details.                                  */
/* To obtain a copy of the GNU Library General Public License, write to the  */
/* Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   */
/*                                                                           */
/* Any permitted reproduction of these routines, in whole or in part, must   */
/* bear this legend.                                                         */
/*                                                                           */
/*****************************************************************************/

#include <conio.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#include "sound.h"
#include "pokey11.h"

int main(int argc, char *argv[])
{
   char done = 0;
   char c;
   uint8 AUDF[4] = {0,0,0,0},
         AUDC[4] = {0,0,0,0},
         AUDCTL = 0;

   uint8 chan;
   uint8 x;
   uint16 playback_freq = FREQ_17_APPROX / 28 / 3;
   uint32 sample_freq = FREQ_17_APPROX;
   uint8 num_bufs = 2;
   uint16 buffer_size = 400;

   printf ("\n");
   printf ("                       Pokey Sound Generator Test Program\n");
   printf ("                       ==================================\n");
   printf ("\n");
   printf ("Command line options:\n");
   printf ("\n");
   printf ("SNDTEST [-fxxxxx] [-pxxxxx] [-nx] [-sxxxxx]\n");
   printf ("\n");
   printf ("   -f Sets the main clock frequency, default = %ld\n",sample_freq);
   printf ("   -p Sets the playback frequency, default = %d\n",playback_freq);
   printf ("   -n Sets the number of playback buffers, default = %d\n",num_bufs);
   printf ("   -s Sets the size of each playback buffer, default = %d\n",buffer_size);
   printf ("\n");
   printf ("All parameters are optional.\n");
   printf ("\n");
   printf ("Use keys 'a'-'l' and 'z'-'.' to adjust the AUDF and AUDC parameters.\n");
   printf ("\n");

   x = 1;
   while (x<argc)
   {
      if (argv[x][0] == '-')
      {
         switch (toupper(argv[x][1]))
         {
            case 'F':
               sample_freq = atol (argv[x]+2);
               break;

            case 'P':
               playback_freq = atoi (argv[x]+2);
               break;

            case 'N':
               num_bufs = atoi (argv[x]+2);
               break;

            case 'S':
               buffer_size = atoi (argv[x]+2);
               break;
         }
      }
      x++;
   }


   printf ("Sample Frequency set to: %ld\n",sample_freq);
   printf ("Playback Frequency set to: %d\n",playback_freq);
   printf ("Number of Buffers: %d\n",num_bufs);
   printf ("Buffer Size: %d\n",buffer_size);
   printf ("\n");

   OpenSB (playback_freq, num_bufs, buffer_size);

   Pokey_sound_init (sample_freq, playback_freq);

   while (!done)
   {
      while (!kbhit())
      {
         Fillbuffer();
      }

      c = getch();

      chan = 0;      /* assume channel 0 */

      switch (toupper(c))
      {
         case 'Q':
           done = 1;
           break;

         case 'J':       /* ch 4 */
           chan++;
         case 'G':       /* ch 3 */
           chan++;
         case 'D':       /* ch 2 */
           chan++;
         case 'A':       /* ch 1 */
           AUDF[chan]++;
           Update_pokey_sound (0xd200 + chan * 2, AUDF[chan]);
           break;


         case 'M':       /* ch 4 */
           chan++;
         case 'B':       /* ch 3 */
           chan++;
         case 'C':       /* ch 2 */
           chan++;
         case 'Z':       /* ch 1 */
           AUDF[chan]--;
           Update_pokey_sound (0xd200 + chan * 2, AUDF[chan]);
           break;


         case 'K':       /* ch 4 */
           chan++;
         case 'H':       /* ch 3 */
           chan++;
         case 'F':       /* ch 2 */
           chan++;
         case 'S':       /* ch 1 */
           AUDC[chan]++;
           Update_pokey_sound (0xd201 + chan * 2, AUDC[chan]);
           break;


         case ',':       /* ch 4 */
           chan++;
         case 'N':       /* ch 3 */
           chan++;
         case 'V':       /* ch 2 */
           chan++;
         case 'X':       /* ch 1 */
           AUDC[chan]--;
           Update_pokey_sound (0xd201 + chan * 2, AUDC[chan]);
           break;

         case 'L':       /* AUDCTL */
           AUDCTL++;
           Update_pokey_sound (0xd208, AUDCTL);
           break;

         case '.':
           AUDCTL--;
           Update_pokey_sound (0xd208, AUDCTL);
           break;

      }

      printf ("F1=%02hx C1=%02hx, F2=%02x C2=%02x, F3=%02x C3=%02x, F4=%02x C4=%02x, CTL=%02hx\r",
         AUDF[0],AUDC[0],AUDF[1],AUDC[1],AUDF[2],AUDC[2],AUDF[3],AUDC[3],AUDCTL);
   }

   CloseSB();

   return (0);
}
