
/* global defs for CC65 */

#undef M6502

/* added by jrd.  don't generate arg counts here */
#define NOARGC
/* ... and generate entries with fixed arg counts */
#define FIXARGC

#define cout	Cout
extern int debug;

#ifdef M6502
#define EOL	155
#define TABCHAR	127
#else
#define EOL	'\n'
#define TABCHAR	'\t'
#endif

/*
#define CRITIC		0x42
#define SDMCTL		0x22F
#define DMACTL		0xD400
#define CH		0x2FC
#define MEMLO		0x2E7
*/

#define HTABSZ		128
#define MACARGSZ	64
#define MAXFILES	3
#define MAXTYPELEN	30
#define N_IFDEF		5
/* #define LITLAB		1 */

extern int litlab;		/* current one */
extern int litspace;		/* total string space used */

#ifdef M6502
/* native compiler */
/* #define GSPACE		7000 */
/* #define GSPACE		2200	-- now it's dynamically allocated */
#define LSPACE		256
#define HTSTART		0x0500

#define MASTART		0x0480
#define MHTSTART	0x0600
#define OUTQSZ		500

/* declare some vars to be on page 0.  see ccpage0.m65 */
#define CCPAGE0 1

#else

/* cross-compiler... */
#define GSPACE		10000
#define LSPACE		4800
#define OUTQSZ		8000

#define printmsg printf

#endif

/*
 * storage classes
 */
#define SC_STATIC	0x00
#define SC_STACK	0x01
#define SC_STORAGE	0x02
#define SC_ONSTACK	0x03
#define SC_INMEM	0x02
#define SC_DEFINED	0x04
#define SC_EXTERN	0x08
#define SC_ENUM		0x10
#define SC_DEFAULT	0x40
#define SC_STRUCT	0x80
#define SC_SFLD		0x80
#define SC_STAG		0x81

/*
  data types
*/
#define	T_END		'\0'
#define T_CHAR		0x11
#define T_INT		0x12
#define	T_SHORT		0x13
#define T_LONG		0x14
#define T_ENUM		0x15
#define T_UCHAR		0x19
#define T_UINT		0x1A
#define T_FLOAT		0x25
#define T_DOUBLE	0x26
#define T_FUNC		0x07
#define T_UNSIGNED	0x08
#define T_INTEGER	0x10
#define T_REAL		0x20
#define T_POINTER	0x40
#define T_PTR		0x49
#define T_ARRAY		0x4A
#define T_STRUCT	0x80
#define T_UNION		0xC0
#define T_SMASK		0x3F

#define E_MGLOBAL	0x80
#define E_MLOCAL	0x40
#define E_MCONST	0x20
#define E_MEXPR		0x10
#define E_MEOFFS	0x11
#define E_MCTYPE	0x07
#define E_TCONST	0
#define E_TGLAB		1
#define E_TLIT		2
#define E_TLOFFS	3

/* jrd added these defs as values for the e_test field of
   a struct expent.  The idea is that internals of the expr
   parsers will set the e_test slot of a struct expent to
   one of these values.  0 means no specific test info, do
   it the old way. */

		/* expr has already set cond codes apropos result value */
#define E_CC		1
		/* if expr has NOT set CC, force a test-style access */
#define E_TEST		2
		/* expr has left a logical value (1 or 0) in AX */
#define E_LOGL		4

		/* flip this bit to invert sense of test */
#define E_XINV		8


#define	NAMESIZE 9
#define NAMEMAX  8

#define	wqtabsz		128
#define	wqsiz		6
#define	wqmax		wq+wqtabsz-wqsiz
#define	wqsym		0
#define	wqsp		1
#define	wqloop		2
#define	wqlab		3
#define	wqinc		4
#define	wqstat		5
#define	litabsz		512
#define	litmax		litabsz-1

#ifdef M6502
#define	linesize	100
#else
#define	linesize	200
#endif

#define	linemax		linesize-1
#define	mpmax		linemax

struct hashent 
{
  struct hashent * h_ptr;
  char h_glb;
  char h_loc;
  char * h_gtptr;
  char * h_ltptr;
  struct hashent * h_link;
  int h_gdata;
  int h_ldata;
  char h_name[1];
};

/* not used anymore?...
struct kw 
{
    char *	t_sym;
    char	t_value;
    char	t_next;
    };
*/

/* used by newpre.c and newcmd.c.  sort of like op_alist... */
struct tok_elt 
{
  char * toknam;
  int toknbr;
};

struct expent 
{
  /* this used to be just an int.  jrd split it into two bytes,
     in order to have an extra field for tests without taking up
     any more space ...
     int		e_flags;	*/
    
  unsigned char e_flags;
  unsigned char e_test;
  char * e_tptr;
  int e_const;
};

struct filent 
{
#ifdef old_cruft
  int f_iocb;
#else
  FILE * f_iocb;
#endif
  char * f_name;
  int f_ln;
};

extern char		litq[];
extern char		macltab[256];
extern int		wq[wqtabsz];
extern struct hashent * lvtab[128];
extern char		outq[OUTQSZ];

#ifdef M6502

#define htab		((struct hashent ** ) HTSTART)
#define macarg		((char ** ) MASTART)
#define machtab		((char ** ) MHTSTART)

#else

extern struct hashent * htab[HTABSZ];
extern char *		macarg[MACARGSZ];
extern char *		machtab[HTABSZ];

#endif

extern int	absdecl;
/* extern int	critic; */
extern int	glblbl;

/* extern char	glbspace[GSPACE]; */
extern char *	gblspace;	/* global heap */
extern char *	gblend;		/* gblspace limit */

extern struct hashent * glvptr;
extern char *	gsptr;
extern int	hashval;
extern int	i_ifdef;
extern char	locspace[LSPACE];
extern int	lovptr;
extern char *	lsptr;
extern char	macdef;		/* T if any defines defined */
extern char *	outqi;
extern int	outqsz;
/* extern int	ret_addr; */
extern char	s_ifdef[N_IFDEF];
extern int	tbllen;
extern char *	tblptr;
extern char *	type_char;
extern char *	type_int;
extern char *	type_ifunc;

extern int *	wqptr;
extern char *	line;
extern char *	mline;
extern int	litptr;
extern char *	lptr;
extern char *	mptr;
extern int	nxtlab,
	oursp,
	argstk,
	ncmp,
	errcnt,
	eof,
	glbflag;

extern struct filent	filetab[MAXFILES];
extern int	ifile;

/*
#ifdef M6502
extern int	inp;
extern int	output;
#else
*/
extern FILE *	inp;
extern FILE *	output;
/* #endif */

extern int	ln;
extern char *	fin;

#ifdef M6502
extern char	fname[20];
#else
extern char	fname[80];
#endif

extern int	curtok;
extern int	curval;
extern int	nxttok;
extern int	nxtval;

extern char	optimize;	/* optimize flag */
extern char	verbose;	/* verbose flag */
extern int	n_funargs;	/* n args in function def */
extern int	asm_kludge;	/* kludge for #asm processing */
extern char *	incl_dir;	/* dir for include files */

/* extern char	get_test;	/* flag for getmem */
#ifndef M6502
extern char	source;		/* put source in m65 file as comments */
#endif

char *	Gmalloc();
char *	Lmalloc();

#ifdef M6502
/* use jrd's hand-coded tiny printf */
#define printf tprintf
#endif

#ifndef M6502
#define dbgprintf(foo,bar) {}
#endif

/* this struct added by jrd, used in unified code-generation stuff.  see
   exp1, exp2, exp3.  */
struct op_alist
{
  int tok;			/* token representing op */
  int (* gen)();		/* generator function that goes with it */
};

/* end of global file for cc */
