
/*
   Error reporting code
*/

#include <stdio.h>
#include "cclex.h"
#include "cc65.h"

/*
  Error( msg )
  Print error with no prefix.
*/
Error(msg)
char * msg;
{
  PError("", msg);
}

/*
  Syntax()
  Flag a syntax error.
*/
Syntax()
{
  Error("syntax error");
}

/*
  Illegal( msg )
  Handle "illegal ..." messages.
*/
Illegal(msg)
{
  PError("illegal ", msg);
}

/*
  Missing( msg )
  Handle "missing ..." messages.
*/
Missing(msg)
char * msg;
{
  PError("missing ", msg);
}

/*
  MultDef( msg )
  Handle "multipy defined ..." messages.
*/
MultDef(msg)
char * msg;
{
  PError("multiply defined ", msg);
}

/*
  Need( msg )
  Handle "need ..." messages.
*/
Need(msg)
char * msg;
{
  PError("need ", msg);
}

/*
  needlval()
  Handle "need lvalue" messages.
*/
needlval()
{
  Need("lvalue");
}

/* from here on down, we want to generate argcounts, so we undefine
   the magic symbol */

#undef NOARGC

/*
  ersum()
  Report errors for user
*/
ersum()
{
  /* see if anything left hanging... */
  if (ncmp)
    Missing("closing bracket");
  if (errcnt == 0)
    {
      printf("No errors.\n");
    }
}

/*
  PError( pfx, msg )
  Print prefix message pfx followed by error message msg.
*/
PError(pfx, msg)
char * msg;
{
#ifdef M6502
  tprintf("\n%s: line %d:\n%s%s\nline:%s\n", fin, ln, pfx, msg, line);
#else
  printf("%s, line %d : %s%s\n", fin, ln, pfx, msg);
  printf("line: %s\n", line);
  printf("curtok = %d\n", curtok);
  printf("nxttok = %d\n", nxttok);
#endif
  if (++errcnt > 6)
    fatal("too many errors");
}

/*
  fatal( msg )
  Fatal error - print message and die
*/
fatal(msg)
char * msg;
{
#ifdef M6502
  tprintf("fatal error: %s\nline: %s\n", msg, line);
  exit(2);
#else
  printf("fatal error: %s\n", msg);
  printf("line: %s\n", line);
  printf("curtok = %d\n", curtok);
  printf("nxttok = %d\n", nxttok);
  printf("Can't recover from previous errors:  Good-bye!\n");
  exit(2);
#endif
}

/*
  Warning( msg )
  Print warning message.
*/
Warning(msg)
char * msg;
{
#ifdef M6502
  tprintf("Warning: %s\n", msg);
#else
  printf("warning: %s\n", msg);
  printf("line: %s\n", line);
  printf("curtok = %d\n", curtok);
  printf("nxttok = %d\n", nxttok);
#endif
}
