
/*
   This software is copyright 1989 by John Dunning.  See the file
   'COPYLEFT.JRD' for the full copyright notice.
*/

/* misc utils for assembler */

#include <stdio.h>

/*
char char_upcase(c)
char c;
{
  if ((c >= 'a') && (c <= 'z'))
	c -= 0x20;
  return(c);
}
*/

int string_equal(s1, s2)
char * s1, * s2;
{
  if (strlen(s1) != strlen(s2))
	return(0);
  for ( ; *s1 && *s2 ; ++s1, ++s2)
	if (toupper(*s1) != toupper(*s2))
		return(0);
  return(1);
}

int read_line(f, l)
FILE * f;
char * l;
{
  int c;
  int ok;

  ok = 0;
  for ( ; ((c = fgetc(f)) != EOF) ; )
	{
/* printf("read-char '%c' %X ptr %X\n", c, c, l); */
	ok = 1;
	if (c == '\n')
		break;
	if (!(
#ifndef M6502
/* protect against mush-dos format files */
(c == '\r') ||
#endif
		 (c == '\f')))	/* ^L */
		*l++ = c;
	}
  *l = '\0';
  return(ok);
}

#ifdef M6502

extern char * _himem;		/* mem mgr's lo-free-mem marker */

char * malloc(n)
int n;
{
  char * p;

/* check for being close to out of memory */
  if ((_himem + n) > (&p - 128))
	barf("Out of memory!\n");
  p = pmalloc(n);
/* printf("malloc(%d)->%X\n", n, p); */
  bzero(p, n);
  return(p);
}

/* file-name frobber */
char * frob_name(name)
char * name;
{
  char * new_name;
  
  if (!strchr(name, ':'))
	{
	new_name = malloc(strlen(name)+3);
	strcpy(new_name, "D:");
	strcat(new_name, name);
	return(new_name);
	}
  return(name);
}
#else

char * frob_name(char *name)
{
  return(name);
}
#endif

