;
; BUFFER.ASM - Routines for manipulating text buffers
;
;Buffer command
;
;Display current buffers
BUFFER:	JSR	MOVCBF	;Put curbuf away
	INC	REDRFG
	JSR	PRTBUF	;Print buffers
; Now, get buffer # to switch to
	JSR	UPPER
	JSR	RDTRCH	;Get char no echo
	PHA
	JSR	RECASE
	PLA
	CMP	#'A'
	BCC	BUFFR2
	CMP	#'O'	;A-N only
	BCS	BUFFR2
	AND	#$0F	;mask off trash
	STA	SELBUF	;have new buffer
	DEC	SELBUF	;normalize to 0
	STX	REDTTL	;rewrite title bar
	;Entry used by FINDF when file is already in
GOTOBF:	JSR	MOVBFC	;get buffer #curbuf
			;Marks buffer used
	JSR	REPOSN	;Reset PS for new screen
	LDY	#0	;Flag success
	RTS
BUFFR2:	JSR	PUSHC	;Push back invalid key
	JSR	MOVBFC	;Go back to old buffer
	JSR	REPOSN	;Reset PS for new screen
	JMP	NEXFNR	;
;
;Routine prints buffer names and information
;
PRTBUF:	JSR	HOME
;Loop to write buffer names
	FORB	R0,0,14	;Buffer 14 will be free bytes
;Write Bn
	LDA	#0
	JSR	SETCRS
	LDA	R0,X
	CLC
	ADC	#'A'
	JSR	L$WXEP	;Buffer num
;Put an * on selected buffer
	LDA	R0,X
	CMP	SELBUF
	BNE	PRTBF1
	WXEP	#42	;'*'
;Write file name
PRTBF1:	LDA	#3
	JSR	SETCRS
	LDA	#HIGH FNAMES
	STA	R2+1,X	;Build addr of fnam
	LDA	R0,X	;Buffer
	JSR	ASLA4
	STA	R2,X
	PUSHST	R2
	WRITREC	0	;Wr filnam
	POPST	R2
;Now its flags
	LDA	#20
	JSR	SETCRS	;Loc of flags
	LDY	R0,X	;Buffer #
	LDA	bflg,Y
	CLC
	ADC	#'0'
	JSR	L$WXEP
;Now the length
	LDA	#24
	JSR	SETCRS
;Get the difference between pointers to 
;this and the next buffer bottom
	; R2 = bufbt+1 - bufbt
	ldy	r0,x	;buffer #
	lda	bufbtl+1,y
	sec
	sbc	bufbtl,y
	STA	R2,X
	LDA	bufbth+1,Y
	SBC	bufbth,Y
	STA	R2+1,X
;Now display buffer size
	CALL	R2, PRT16
	NEXTB	R0
	RTS
;Sets cursor at R1=A
SETC24:	LDY	#24	;Convenience for TITLE
	STY	R0,X	
SETCRS:	STA	R1,X	;
	JSR	POSITN	;For pos of name;
	RTS
;
; Loads Y with CURBUF.  Ret w/A=bflg, TEMP2=CURBUF*4
;
T2TOBF:	JSR	GETBPT		;current
	STA	TEMP2		;bufdef
	LDA	bflg,Y
	RTS
;
GETBPT:	LDA	CURBUF
	tay
ASLA4:	ASL A
	ASL A
	ASL A
	ASL A
	RTS
;
;Put current buffer away
;
MOVCBF:	LDA	CURBUF
	CMP	#14
	BEQ	MCBFEX
	JSR	PAKCUR
	JSR	BUFP1
	JMP	MOVCBF
MCBFEX:	RTS
;
;Pack up current buffer
;
PAKCUR:	ldy	curbuf
	; bufpl = PL-bufbt
	SEC
	LDA	PL
	SBC	bufbtl,Y
	STA	bufpll,Y
	LDA	PL+1
	SBC	bufbth,Y
	STA	bufplh,Y
	JSR	ENDBF1	;endbuf, no setpt
	; bufpt = PT-bufbt
	JSR	MOVPTR	;If PT=PU PT<-PL
	ldy	curbuf
	SEC
	LDA	PT
	SBC	bufbtl,Y
	STA	bufptl,Y
	LDA	PT+1
	SBC	bufbth,Y
	STA	bufpth,Y
	;Now load flags
	LDA	bflg,Y
	PHA
	LDA	MODIFY
	BEQ	PAKCR1
	;Was mod..set bit
	PLA
	ORA	#3
	BNE	PAKCR2
	;No mod..clr bit
PAKCR1:	PLA
	AND	#$FD
	;write back
PAKCR2:	STA	bflg,Y
	LDA	#0
	STA	MODIFY
	RTS
;
;Move current buffer up one
;
BUFP1:	INC	CURBUF
	ldy	curbuf
	; TEXBOT = bufbt = PL
	LDA	PL
	STA	bufbtl,Y
	STA	TEXBOT
	LDA	PL+1
	STA	bufbth,Y
	STA	TEXBOT+1
	; TEXTOP = bufbt @curbuf+1
	LDA	bufbtl+1,Y
	STA	TEXTOP
	LDA	bufbth+1,Y
	STA	TEXTOP+1
;Now start unpacking the stuff
	JSR	ENDBF1	;move text to bb
UNPACK:	; pt = bufbt + bufpt
	ldy	curbuf		;arrggh
	CLC
	LDA	bufbtl,Y
	ADC	bufptl,Y
	STA	PT
	LDA	bufbth,Y
	ADC	bufpth,Y
	STA	PT+1
	JSR	MOVPTL	;If PT=PL PT<-PU
	; R0 = bufbt + bufpl
	CLC
	LDA	bufbtl,Y
	ADC	bufpll,Y
	STA	R0,X
	LDA	bufbth,Y
	ADC	bufplh,Y
	STA	R0+1,X
	;Now move cursor back until R0=PL
BUFP4:	LDA	R0,X
	CMP	PL
	BNE	BUFP2
	LDA	R0+1,X
	CMP	PL+1
	BEQ	BUFP3
BUFP2:	JSR	CURSLF
	BPL	BUFP4
BUFP3:	JSR	MBCEX	;unpack modify flag
	RTS
;
;Move selected buffer to main
;
MOVBFC:	ldy	CURBUF
	cpy	SELBUF
	BEQ	MBCEX
	JSR	PAKCUR	;Write pointers to bufdef
	JSR	BUFM1
	JMP	MOVBFC
	;Set up to get modify status
MBCEX:	LDA	#0
	STA	MODIFY
	ldy	curbuf
	LDA	bflg,Y
	AND	#2
	BEQ	MBC1
	STX	MODIFY
MBC1:	RTS
;
;Move current buffer down one
;
BUFM1:	JSR	BEGBF1	;Move text up
	ldy	curbuf
	; TEXTOP = bufbt = PU
	LDA	PU
	STA	bufbtl,Y
	STA	TEXTOP
	LDA	PU+1
	STA	bufbth,Y
	STA	TEXTOP+1
	;
	DEC	CURBUF
	dey			;track curbuf
	; TEXBOT = bufbt
	LDA	bufbtl,Y
	STA	TEXBOT
	LDA	bufbth,Y
	STA	TEXBOT+1
	JSR	UNPACK	; Set up PT, PL
	RTS
;
;Insert buffer at PU
;
INSBUF:	JSR	LINE24
	WXEP	#73	;'I'
	JSR	RDTRCH	;Get char no echo
	AND	#$5F	;convert to upper
	PHA
	JSR	L$WXEP
	PLA
	SEC
	SBC	#'A'
	BMI	INSBF2
	CMP	#14	;A-N only
	BCS	INSBF2	;A=buf num
	CMP	SELBUF
	BEQ	INSBF2	;no if its yourself

	tay		;setup selected buffer #

	lda	bufbtl,Y
	sta	R0,X
	lda	bufbth,Y
	sta	R0+1,X

	lda	bufbtl+1,Y
	sta	R1,X
	lda	bufbth+1,Y
	sta	R1+1,X

INSBF4:	BEQWRR	R0, R1, INSBF3
	INDIR	LDA, R0
	STA	CHARAC
	INCWR	R0
	JSR	INSERT
	BPL	INSBF4	;Loops if it fits
INSBF3:	stx	REDRFG
INSBF2:	RTS
;
;Convert and print 16-bit value (in R0)
;
PRT16:	LDA	#0
	STA	R2,X	;Flag for leading zero suppression
	LOADIW	10000, R1
	JSR	PRT17
	LOADIW	1000, R1
	JSR	PRT17
	LOADIW	100, R1
	JSR	PRT17
	LOADIW	10, R1
	JSR	PRT17
	LOADIW	1, R1
	INC	R2,X	;Make sure at least LS 0 prints
	JSR	PRT17
	RTS
PRT17:	LDY	#'0'	;ascii zero
PRT18:	BLSWRR	R0, R1, PRT19
	SUBWR	R1, R0, R0
	INY
	BNE	PRT18
PRT19:	CPY	#'0'
	BNE	PRT20
	LDA	R2,X
	BEQ	PRT21
PRT20:	TYA
	INC	R2,X
	JSR	L$WXEP
PRT21:	RTS
;
