;
REDRAW:	JSR	HOME	;Clear screen
;Redraw from R0 down
REDRDN:	LDA	#23
	STA	R1,X
;
;DRAW LINE routine - redraws lines from
;		#R0 to R1 (incl)
; Fast version - does strings in one call
;
DRAWLN:	JSR	BURSTM
	LOADW	PS, R4
	FORB	R2, 0, 23;nul
	LDA	R2,X
	STA	ROWCRS
	LDA	#0
	STA	COLCRS
	JSR	BELL
	JSR	REPOIN
	FORB	R3, 0, LINSIZ
;Start a new line
DRAWL7:	JSR	PTRCHK
	JSR	LDAR4I
	BMI	DRAWL3		;eol
	BEQ	DRAWL5		;move on for normal char
	cpy	#1
	beq	drwtab
	pha
	jsr	wrtxln		;write out the line
	beq	draw10
	jsr	l$wxesc		;insert esc
	pla
	jsr	l$wxep
	db	$A9		;LDA Imm opcode... br+1 over pla
draw10:	pla
	jsr	repoin		;write all esc seq as one char rec
	jmp	drawl7
drwtab:	JSR	WRTXLN		;leaves 0 in R6
	LOADIW	D$SPAC,R5	;spaces
DRAWL6:	LDA	R3,X
	CMP	#LINSIZ+1
	BEQ	DRAWLA
	INC	R6,X
	INC	R3,X
	LDA	R3,X
	AND	#7
	BNE	DRAWL6
;r6 = len of tab string
	JSR	WRTXLN
	JMP	DRAWL7
DRAWL5:	INC	R6,X	;count #spaces to print
DRAWL4:	NEXTB	R3
DRAWLA:	JSR	WRTXLN
	BEQ	DRAWL8	;tests if line is within range to be written
	WXEP	#20	;dot
DRAWL8:	JSR	PTRCHK
	JSR	LDAR4I
	BPL	DRAWL8	;br if not eol
DRAWL3:	JSR	WRTXLN
DRAWLB:	NEXTIF	R2, R1	;Loop if LE.R1
DRAWL2:	JSR	NOBURS
	RTS
;
PTRCHK:	BNEWAR	PL, R4, PTRC1
	LOADW	PU, R4	;Now upper
	JSR	WRTXLN
PTRC1:	BNEWAR	TEXTOP, R4, PTRC2
	PLA ! PLA	;Pop to caller when done
	jsr	noburs
	;
	;Fall through
	;
WRTXLN:	LDA	R2,X
	CMP	R0,X
	BCS	WRTXL3
	LDY	#0
	RTS		;If out of range ret EQ
WRTXL3:	LDA	R6,X
	BNE	WRTXL2
	JSR	REPOIN
	ldy	#1	;If none to write ret PL
	rts
wrtxl2:	PUSHST	R5
	WRITCHR	0
	POPST	R5
	;Fall through
REPOIN:	MOVRR	R4, R5	;base of record
	CLRWR	R6	;length
	LDY	#$80	;Wrote some - ret MI
PTRC2:	RTS
;
LDAR4I:	INDIR	LDA, R4
	INCWR	R4
	cmp	#eol
	bne	ldar2
	ldy	#$80
	rts
ldar2:	cmp	#tab
	bne	ldar3
	ldy	#1
	rts
ldar3:	cmp	#ESC
	bcc	ldar4
	cmp	#32	;last of arrow keys
	bcc	ldar7
	cmp	#125
	bcc	ldar4	;1 lt CLS
ldar7:	ldy	#2	;mark to be escaped
	rts
ldar4:	ldy	#0	;regular char
	rts
;
