;
; ECTL1.ASM - Control Key Functions part 1
;
LITRAL:	INC	LITFLG
	RTS
;
BEGLINE:
	JSR	crlf	;mov cursor, no error at bb
	BMI	BEGLN1
	jsr	chtest
	BEQ	BEGLINE	;Y=1 if EOL
	JSR	crrt
BEGLN1:	RTS
;
CHGCS:	JSR	SETMOD	; CHANGE CASE
	JSR	CURTSP
	BMI	CHGC2
	AND  #$DF	; MAKE LWR, UPR
	CMP  #$41	; A
	BCC  CHGC1
	CMP  #$5B	; [=Z+1
	BCS  CHGC1
	LDA  (PU),Y	; GET CHR
	EOR  #$20	; INV CASE
	STA  (PU),Y	; REPLACE
	JSR	L$WXEP	;Print new
CHGC1:	JSR	CURSRT
	JSR	SCREEN
CHGC2:	RTS	;EXIT
;
;
CUTSR:	LOADW	PT, R0
	JSR	PULTR0
	STOREW	R0, PT	;In case it don't fit in kilbuf, make continung easier
	JSR	CUT
	BNEZWR	R0, cutsrx
	JSR	REDCLN
	RTS
cutsrx:	STX	REDRFG
	RTS
;
;CUT is a general routine which cuts
;up to killbuf size between PU and R0.
;Ret w/ num EOLs in R0
;
CUT:	JSR	SETMOD
	LDA	FUNCID
	CMP	LASTFN
	BEQ	CUT1
	; If no repeat, reset buffer
	MOVW	KILLBOT, KILLTOP
CUT1:	JSR	PULTR0
	CLRWR	R2	;Counts EOLs for display routine
	; Do the move
	;Check upper limit
CUT2:	BEQWI	KILLTOP, KILLIM, CUT3	;check full
	BEQWAR	PU, R0, CUT3		;check done
	LDY	#0
	LDA	(PU),Y
	STA	(KILLTOP),Y
	CMP	#EOL
	BNE	CUT4
	INCWR	R2	;Inc R2 if EOL
CUT4:	INCW	PU
	INCW	KILLTOP
	JMP	CUT2
CUT3:	MOVRR	R2, R0	;No. of EOLs
	RTS
;
; Make PU.LT.R0 if it isn't already
;
PULTR0:	BGEWRA	R0, PU, PULT1
MKPLR0:	MOVRR	R0, R1
	LOADW	PU, R0
PULT2:	JSR	CURSLF
	BMI	PULT1
	BNEWAR	PL, R1, PULT2
PULT1:	RTS
;
; Make PU Greater then R0
;
MKPGR0:	MOVRR	R0, R1
	LOADW	PL, R0
PUGT2:	BEQWAR	PU, R1, PUGT1
	JSR	CURSRT
	BPL	PUGT2
PUGT1:	RTS
;
DELC:	JSR	CURSRT
	BMI	DELC1
	JSR	SCANSCR
	JSR	POSITN
	JSR	D$DEL
DELC1:	RTS
;
ENDLIN:	JSR	crrt
	BMI	ENDLN1	;End of buffer
	jsr	chtest
	BEQ	ENDLIN
	JSR	crlf
ENDLN1:	RTS
;
SWPCUR:	LOADW	PT, R0
	BEQW	PU, PT, SWAP1
	BGEW	PU, PT, SWAP2
	JSR	MKPGR0
	JMP	SWAP3
SWAP2:	JSR	MKPLR0
SWAP3:	STOREW	R0, PT
SWAP1:	RTS	;EXIT
;
DELBW:	JSR	BACKW
	JSR	CUT
	BNEZWR	R0, DELBW1
	JSR	REDCLN
	RTS
DELBW1:	JMP	D$DEL2	;
;
CUTSRC:	RTS
;
BACKW:	LOADW	PU, R0	;Save current
BACKW2:	JSR	CURSLF
	BNE	BACKW1	;Quit on EOL,BB
	CMP	#32
	BEQ	BACKW2	;Loop over spcs
	CMP	#127
	BEQ	BACKW1	;Quit on TAB
;	Have non-space
BACKW3:	JSR	CURSLF
	BMI	BACKW1	;Quit on BB
	BNE	BACKW4	;Stop on: EOL,
	CMP	#32
	BEQ	BACKW4	; SPC,
	CMP	#127
	BNE	BACKW3	; TAB
BACKW4:	JSR	CURSRT
BACKW1:	RTS
;
FILL:	;Test for zero length
	beqw	pt, pu, backw1
	JSR	SETMOD
	STX	REDRFG
	LOADW	PT, R0	;Load R0 for
	JSR	PULTR0	;possible swap
	PSHST1		;Save R0
	JSR	REPOSN	;Must put PS at valid place for scanscr
	JSR	SCANSCR
	POPST1		
	;R2 = current col
	;R0 = stop addr
	;Check initial condition
FILL21:	JSR	CURTSP
	BEQ	FILL20	;br if normal char
	JSR	CURSRT	;if EOL skip it
	LDA	#0
	STA	R2,X
	BEQ	FILL21	;
FILL20:	JSR	FILL1	;Move till space
	BCC	FILL2	;If spc<filcol join main loop
FILL7:	LDA	#EOL
	LDY	#0
	STA	(PU),Y	;Convert spc/tab/eol to eol
	JSR	CURSRT	;To begnl
	LDA	#0
	STA	R2,X	;reset count
FILL2:	JSR	FILL1	;
	BCC	FILL2	;Stay while under filcol
	JSR	CURSLF	;compensate
FILL5:	JSR	CURSLF
	BNE	FILL8	;Hit EOL/BB before spc - QUIT!!
	CMP	#SPC	;move left till spc
	BNE	FILL5
	BEQ	FILL7	;Always branches
	;
FILLTD:	BGEWAR	PU, R0, FILTD1	;Test done
	JSR	CURTSP	;Z if normal char, NE if EOL
	RTS
FILTD1:	LDY	#$80	;Returns MI if done
	RTS
;
FILL1:	JSR	FILLTD
	BMI	FILLEX
FILL10:	JSR	FILLTD
	BMI	FILL14	;EOB/EO Range
	BNE	FILL3	;EOL
	CMP	#TAB
	BEQ	FILL4	;
	CMP	#SPC
	BEQ	FILL4
	;Just normal char
	JSR	CURSRT
	INC	R2,X	;column count
	JMP	FILL10
	;Found EOL. Check next char.
FILL3:	JSR	CURSRT	;
	JSR	FILLTD	;
	BMI	FILL14
	BEQ	FILL13
	;Another EOL. First see if end of word is too far right
FILL15:	lda	r2,x
	cmp	filcol
	bcs	fill14	;
	; Reset col count and check next char
	LDA	#0
	STA	R2,X	;New line
	JSR	CURSRT
	JSR	FILLTD
	BMI	FILL14
	BEQ	FILL10	;Just start new line
	BNE	FILL15	;Try again
FILL13:	JSR	CURSLF	;Single EOL - back up and treat normally
FILL4:	LDA	#SPC
	LDY	#0
	STA	(PU),Y
	JSR	CURSRT
	INC	R2,X
FILL14:	LDA	R2,X
	CMP	FILCOL
	RTS
;Exit point
FILLEX:	PLA ! PLA	;Pop first level
FILL8:	JSR	REPOSN	;So it looks nice
	RTS
;
;Delete range to kill buffer
;
KILL:	LOADW	PL, R0
	JSR	CURTSP	;Test at cursor
	BMI	KILL1	;Exit if at EB
	BNE	KILLCR	;If EOL special
	JSR	ENDLIN	;Move to EOL
	JSR	CUT	;remove
	JSR	REDCLN	;
KILL1:	RTS
KILLCR:	JSR	CURSRT	;Move over it
	PSHST1
	JSR	SCANSCR	;Save R0
	JSR	POSITN
	POPST1
	JSR	CUT
	JMP	D$DEL2	;Del the CR
	;*RTS*
;
SETPT:	MOVW	PU, PT
	RTS	;EXIT
;
BEGNL:	JSR	ENDLIN
	BMI	BEGNL1
	JSR	CURSRT
BEGNL1:	RTS	;EXIT
;
FWDW:	LOADW	PL, R0	;Save current
	JSR	CURSRT
	BNE	FWDW1	;Over EOL,EB
	CMP	#TAB
	BEQ	FWDW1	;over tab too
	BNE	FWDW5
FWDW2:	JSR	CURSRT
	BMI	FWDW1	;Out on EB, EOL
	BNE	FWDW4
	CMP	#TAB
	BEQ	FWDW4	;and tab
FWDW5:	CMP	#SPC	;If space
	BNE	FWDW2	; to next loop
; On a space.  Wait till no space.
FWDW3:	JSR	CURSRT
	BMI	FWDW1	;Exit on EB
	BNE	FWDW4	; or EOL
	CMP	#TAB
	BEQ	FWDW4	; or tab
	CMP	#SPC
	BEQ	FWDW3
FWDW4:	JSR	CURSLF
FWDW1:	RTS	;EXIT
;
