;
; ECTL2.ASM  Control Character Functions part 2
;
ENDPLIN:
	JSR	BEGLINE
	JSR	CURSLF
	RTS	;EXIT
;
SCRLD:	lda	#1
scrldc:	sta	r2,x
	sta	r3,x
	beq	scrld1
	lda	rowcrs
	sta	r4,x
scrld2:	LOADW	PS, R0
	JSR	S$BCR	;R0 back 1 EOL
	BMI	SCRLD3	;Go draw when reach bb
	STOREW	R0, PS
	JSR	TOS	;leaves r0=r1=0
	WXEP	#ISL	;at top
	inc	r4,x	;compute the line# of the cursor
	dec	r3,x
	bne	scrld2
;Done clearing - now fill in
scrld3:	lda	r4,x
	sta	r0,x	;save current line#
	lda	#0
	sta	R1,X	;new r0=top, r1=r2
	call	r1, DRAWLN	;Draw it
;
scrld5:	lda	r0,x
	cmp	#24
	bcc	scrld1
	jsr	beglin
	jsr	crlf
	jsr	beglin
	dec	r0,x	;keep moving cursor back until it hits line 23
	bpl	scrld5
SCRLD1:	RTS	;EXIT
;
DNLIN:	JSR	GUDCOL
DNL1:	LDA	ROWCRS
	CMP	#23
	BNE	DNL2
	lda	#12
	jsr	SCRLUC
DNL2:	JSR	BEGNL
	BMI	DNLEX	;Exit if at eob
DUMREN:	LDA	#0
	STA	R1,X
DNL4:	LDA	UDCOL
	CMP	R1,X
	BCC	DNL3
	JSR	CURSRT
	BMI	DNLEX
	BNE	DNL3	;At eol - stop
	CMP	#TAB
	BNE	DNL5
	LDA	R1,X
	ORA	#7
	STA	R1,X
DNL5:	INC	R1,X
	BNE	DNL4
DNL3:	JSR	CURSLF
DNLEX:	RTS
;
UPLIN:	JSR	GUDCOL
	LDA	ROWCRS
	BNE	UPL4
	BEQW	PS, TEXBOT, DNLEX;At top line
	lda	#13
	jsr	SCRLDC
UPL4:	JSR	BEGLINE	;Part way there
	JSR	CURSLF
	JSR	BEGLINE
	JMP	DUMREN	;One routine for moving
;
GUDCOL:	LDA	LASTFN
	CMP	#16
	BEQ	GUD1	;If last was u/d use old udcol
	CMP	#14
	BEQ	GUD1
	LDA	COLCRS
	STA	UDCOL
GUD1:	RTS
;
;Open line
;
OPENLN:	LDA	#EOL
	STA	CHARAC
	JSR	I$INS
	JSR	CURSLF
	JSR	SCREEN
	RTS
;
;Search string is in SBUF
;Returns Y/CC = 0 if found
;	else = $80
;
REVSRC:	JSR	SRCSTR
	JSR	SETPT
REVS2:	JSR	CURSLF
	BMI	SEARNF
	JSR	CMPSB
	BNE	REVS2
REVS1:	RTS
;
SEARCH:	JSR	SRCSTR
SRCENT:	JSR	SETPT

SEARC2:	JSR	CMPSB	;compare
	BEQ	SEARC3
	JSR	CURSRT
	BPL	SEARC2
;Not found..go back
SEARNF:	JSR	XSWPCR	;STOPMC done by curser move
	LDY	#$80	;flag not found
	RTS
SEARC3:	JSR	TSTFLS	;Test if over end of buffer
	BMI	SEARNF	; and move cursor past range
	RTS	;EXIT
;
;Input text as search string
;	
SRCSTR:	LDA	LASTFN
	ORA	#1
	CMP	#19	;R or S
	BEQ	SRCST4
	LOADIW	SBUF, R0
	loadb	slen, r1
	jsr	getsst
	storeb	r1, slen
srcst4:	rts
;
GETSST:	JSR	LINE24	;
	WXEP	#58	;':'
	JSR	RDTRCH	;get next char
	cmp	#17	;ctl-Q
	beq	srcst3
	CMP	#32
	BCC	SRCST1	;if ctl char don't change it
srcst3:	JSR	PUSHC
	LDA	#1
	STA	COLCRS
	LDA	#SBUF$L	;max len - assume its right
	JSR	RDKBRR	;Read string from kybd
	BPL	SRCST1	;If len OK just ret
SRCST2:	JSR	STOPMC
SRCST1:	RTS
;
CMPSB:	LDY	#0
CMPLOP:	STY	R0,X	;Save str len
	cpy	slen
	BEQ	CMPFND
	LDA	SBUF,Y
	CMP	(PU),Y
	BEQ	CMPS2
	STA	CHARAC	;
;Now test other case
cmpl2:	ORA	#$20	;cvt upr to lwr
	CMP	#'a'
	BCC	CMPNF
	CMP	#$7B	;one after 'z'
	BCS	CMPNF
	LDA	CHARAC	
	EOR	#$20	;in alphabet - sw
	CMP	(PU),Y
	BNE	CMPNF
;	
CMPS2:	INY
	BNE	CMPLOP
CMPNF:	LDY	#$80	;Mark not found
	RTS
	;Move cursor past string - length was in R0
CMPFND:	LDY	#0
	RTS
;
TSTFLS:	LDA	R0,X
	STA	R1,X
TSTFL1:	JSR	CURSRT
	BMI	CMPNF
	DEC	R1,X
	BMI	CMPFND	;the zero length case
	BNE	TSTFL1	;Returns w/len in R0
	BEQ	CMPFND
;
;Search and replace
;
REPLAC:	LOADIW	SBUF, R0
	loadb	slen, r1
	JSR	GETSST
	storeb	r1, slen
	LOADIW	RBUF, R0;replacement
	loadb	rlen, r1
	JSR	GETSST	;
	storeb	r1, rlen
	LDA	#0
	STA	TEMP2	;Flag query repl
REPLOP:	JSR	SRCENT	;find next. R0=len.
	BMI	REPDON
	CALL	R1, SCREEN	;place curs. Redraw if neces.
	LDA	TEMP2
	BNE	REPLDO
	JSR	RDTRCH
	CMP	#BAK
	BEQ	REPLOP	;delete=skip
	CMP	#SPC
	BEQ	REPLDO
	CMP	#33	;'!'
	BNE	REPDN1	;anything else quits
	INC	TEMP2	;set to loop through rest
REPLDO:	LDA	R0,X	;length
	BEQ	REPINS
	JSR	DELETE	;dels one char
	DEC	R0,X
	BPL	REPLDO
REPINS:	LOADIW	RBUF, R0;pointer to replace str
	loadb	rlen, r1;length of str
RPINLP:	lda	r1,x
	beq	rpin1
	dec	r1,x
	INDIR	LDA, R0
	STA	CHARAC
	INCWR	R0
	JSR	INSERT	;put char in buf
	BMI	REPDON	;test no fit
	bpl	rpinlp
rpin1:	JSR	REDCLN	;redraw current line
	JMP	REPLOP	;loop
REPDN1:	JSR	PUSHC
REPDON:	JSR	LINE24	;just clear cmd line
	RTS
;
;Transpose chars
;
TRANS:	JSR	SETMOD
	JSR	CURTSP	;Get char
	BEQ	TRAN1	;Handle simple
	JSR	CURSLF	;Move back over EOL/EOB
	BMI	TRANEX	;If at BB just exit
TRAN1:	JSR	CURTSP
	BNE	TRAN5	;If second EOL, stop and restore
	STA	R0,X	;Save char
	JSR	CURSLF
	BNE	TRAN5
	STA	R1,X
	LDA	R0,X
	LDY	#0
	STA	(PU),Y
	JSR	CURSRT
	LDA	R1,X
	LDY	#0
	STA	(PU),Y
TRAN5:	JSR	CURSRT
TRANEX:	jsr	screen	;Fix bb probs
	JSR	REDCLN	;redraw current line
	RTS	;EXIT
;
DELBL:	LOADW	PU, R0
	JSR	BEGLINE
	JSR	CUT
	JSR	REDCLN
	RTS	;EXIT
;
DELW:	LOADW	PL, R0
	JSR	CURTSP	;Test at cursor
	BMI	DELW2	;Exit if at EB
	BEQ	DELW1
	JMP	KILLCR	;If EOL special
DELW1:	JSR	FWDW
	JSR	CUT
	JSR	REDCLN
DELW2:	RTS
;
BEGBUF:	JSR	SETPT
BEGBF1:	JSR	CRLF	;no error when at bb
	BPL	BEGBF1
	RTS	;EXIT

ENDBUF:	JSR	SETPT
ENDBF1:	JSR	CRRT	;no error at eob
	BPL	ENDBF1
	RTS	;EXIT
;
YANK:	JSR	SETMOD
	MOVW	PL, PT	;Set PT so it stays
	LOADW	KILLBOT, R0
	CLRWR	R1
YANK2:	BEQWAR	KILLTOP, R0, YANK1
	INDIR	LDA, R0
	STA	CHARAC
	JSR	INSERT
	BMI	YANK1	;Buffer full
	BEQ	YANK3
	INCWR	R1	;Count EOLs
YANK3:	INCWR	R0
	JMP	YANK2
YANK1:	;Now update screen
	BEQZWR	R1, YANK4
	JSR	REDRCS
	RTS
YANK4:	JSR	REDCLN
	RTS
;
REDRCS:	JSR	SCANSCR
	BMI	DOREDR	;If new cursor offscr, redraw
	LDA	ROWCRS	;Get orig row
	STA	R0,X
	JSR	CLRDN	;Clr scrn fm R0 down
	JSR	REDRDN	;Redraw here down
	RTS
DOREDR:	STX	REDRFG
	RTS
;
; Scroll Up routine -- Enter with A = number of lines to scroll
; SCRLU entry point sets to 1
SCRLU:	lda	#1	;compatibility entry point
SCRLUC:	sta	R2,X	;save it
	sta	R3,X	;loop count
	beq	scrlu1	;
SCRL4:	JSR	TOS	;Delete line - clobbers r0 and r1
	WXEP	#DLL	;at top
; Move PS ahead
SCRLU3:	BNEW	PS, PL, SCRLU2
	JSR	CURSRT
	BMI	SCRLU1	;If count exceeds PL, screen went blank
SCRLU2:	LDY	#0
	LDA	(PS),Y
	INCW	PS
	CMP	#EOL
	BNE	SCRLU3
; Now test #lines
	dec	R3,X
	bne	scrl4
;New PS. Draw bot line.
	lda	#24
	sec
	sbc	R2,X
	STA	R0,X
	LDA	#23
	STA	R1,X
	JSR	DRAWLN	;Draw new bot
SCRLU1:	RTS	;EXIT
;
CLRMOD:	sty	modify
	beq	setmd2	;always branches
SETMOD:	lda	modify
	bne	setmd1
	STX	MODIFY
setmd2:	pushst	r6
	jsr	modas1	;Show modify status on title bar
	nop
	jsr	screen	;Replace cursor
	popst	r6
setmd1:	RTS
;
