;
; EDITOR.ASM
;
;Main loop - Enters here after temporary init code completes
;
LOOP:	JSR	LOOP1
	ldx	#initx
	bne	LOOP	;
;
LOOP1:	LDY	#0
	STY	ERRCOD	;No error
	JSR	DOIT	;Get key(s) and exec func
L4:	;Let a key stop a long count
	LDA	CONSOL
	CMP	#6	;'Start' key
	BNE	L5
	JSR	clrctr	;Yes - clr both
L5:	BEQZW	COUNT, L7
	DECW	COUNT
	JSR	DOIT6	;Same FUNCID
	JMP	L4
L7:	LDY	ERRCOD
	BPL	L3
	JSR	PRTSTAT
L3:	LDA	FUNCID
	STA	LASTFN
;Return after function. Check PT valid.
	BGEW	PT, PU, L2
	BLSW	PT, PL, L2
	;PT is in no mans land. Fix it
	MOVW	PU, PT
L2:	lda	redttl	;Check title bar
	beq	l8
	jsr	title	;Now check for cursor still on screen
L8:	LDA	REDRFG
	BNE	L1
	JSR	SCREEN
	RTS
L1:	JSR	RDNOMV	;redraw/norepos
	LDY	#0
	STY	REDRFG
	RTS
;
;Character parsing & dispatch routine
;
DOIT:	JSR	RDTRCH	;Get char
	LDY	#65	;Code for INSERT
	STY	FUNCID	;
	LDY	LITFLG
	BEQ	DOIT2
	LDA	#0	;Insert key, even if ctl
	STA	LITFLG
	BEQ	DOIT6	;Always branches
DOIT2:	CMP	#32
	BCC	DOIT5	;If ctl char, save it as func #
	CMP	#126
	BNE	DOIT6
	DEC	FUNCID	;DELETE code = 64
	BNE	DOIT6
;Loop entry after SHFx
DOIT5:	STA	R0,X
	LDA	#HIGH CHTRAN
	STA	R0+1,X	;Form addr of trans
	INDIR	LDA, R0	;Get func #
	STA	FUNCID
DOIT6:	LDA	FUNCID
	ASL	A
	TAY
	LDA	CJTB,Y
	STA	TEMP2
	INY
	LDA	CJTB,Y
	STA	TEMP2+1
	LDY	#0	;for gen. disk utility routine
	JMP	(TEMP2)
;
;SHF routines - JSRs here
;
SHF1:	JSR	RDTRCH
	CMP	#32
	BCC	CMDLP1
;Check for kbd mac
	CMP	#'('
	BNE	CMDLP3
	LDY	#0
	STY	KBDTOP	;Starting - clear buffer
	iny
	STY	KBDFG	;Set BUILD flag
	STY	KBDVAL	;and set valid
	jsr	showkm	;leaves cursor on title line
	RTS
CMDLP3:	CMP	#')'
	BNE	CMDLP4
	LDY	#0
	STY	KBDFG
	jsr	showkm	;leaves cursor on title line
	MOVW	MACNT, COUNT	;Restore outer count
	LDA	#37	;EXKBMC
	STA	FUNCID	;So next count goes to execute macro
CMDLP4:	RTS		;Automat. use ^X) to mark end
;
CMDLP1:	ADC	#32	;add to form function ID
	JMP	DOIT5
;
SHF2:	JSR	RDTRCH
	CMP	#'@'
	BCC	SHF21	;Quit on any ctl ch
	AND	#$5F	;Map lower to upper - maps DELkey to ^
	JMP	DOIT5
SHF21:	CMP	#'0'
	BCC	CMDLP4
	CMP	#':'
	BCS	CMDLP4
	JSR	PUSHC
	JSR	LINE24
	JSR	GETNUM	;Read a number
	TAY		;Save delimiter
	STOREW	R0, COUNT	;may be zero
	BEQZW	COUNT, CMDLP4	;No num - eat delimiter
	TYA
	JSR	PUSHC	;Push back - delimiter is next command
	JSR	SCANSCR
	JSR	POSITN	;Restore cursor position
	DECW	COUNT	;it's zero-scaled
	JMP	DOIT	;get and do next command
;
; Get char 
;
RDTRCH:	LDA	PUSHCF	;First check push
	beq	RDTRC9
	;Char was pushed back
	LDA	#0
	STA	PUSHCF	;clear flag
	LDA	PUSHCH	;get it
	JMP	RDTRC8	;reenter
	;Check if executing kbd macro
rdtrc9:	LDA	KBDVAL
	BEQ	RDTRC4	;If not valid ignore
	LDA	KBDFG
	BPL	RDTRC4	;Not executing macro
	LDY	KBDTOP
	LDA	KBDMAC,Y;Get key from macro
	INC	KBDTOP
	BNE	RDTRC5
	;Normal kybd read
RDTRC4:	lda	susout
	beq	rdtrd	;Br if output not suspended
	lda	#0
	sta	susout
	stx	redrfg	;repaint
	stx	redttl	;title too
	lda	#7	;^G
	bne	rdtrc5	;Return with ^G *HACK*
rdtrd:	READA	2
rdtrc8:	LDY	KBDFG
	BEQ	RDTRC5
	;Building macro; if executing, code skipped here
	LDY	KBDTOP
	STA	KBDMAC,Y
	INC	KBDTOP
	BPL	RDTRC5
	;Overflow
	LDY	#0
	STY	KBDFG	;Close it
	STY	KBDVAL
	jsr	updtkm	;show it on title bar
RDTRC5:
	STA	CHARAC
	RTS
;Push back routine
PUSHC:	STA	PUSHCH
	STX	PUSHCF
	RTS
;
;DELETES CHAR	Y=0: SUCCESS
;		y=1: OK but not on scrn
;		Y=$80: FAIL
;
D$DEL:	JSR	SETMOD
	JSR	DELETE	;remove 1 fm bf
	BPL	D$DEL1	;if OK cont
	RTS
D$DEL1:	BNE	D$DEL2	;br if EOL...
	JSR	DR$EOL
	LOADIW	D$SPAC, R0
	LOADIW	9, R1
	WRITCHR	0
	LDY	#0
	RTS
D$DEL2:	WXEP	#DLL	;remove line
	JSR	DR$EOL	;
	BMI	D$DEL3
	LDA	#23
	STA	R0,X
	STA	R1,X
	JSR	DRAWLN
	LDY	#0	;Success
	RTS
D$DEL3:	LDY	#1
	RTS
;
;Insert char
;  Y=0: Success
;  Y=1: Success but past screen
;  Y=$80: Will not fit
;
I$INS:	JSR	INSERT
	BMI	INSFL
	LDA	CHARAC
	CMP	#EOL
	BNE	INS1
INS2:	JSR	SCANSCR	;Was CR. Check for fit
	bpl	INS3A
	stx	redrfg	;No - make sure all cases get redrawn
	rts
ins3a:	LDA	COLCRS	;If a beg of ln
	BEQ	INS4	;just ins lin
	LDA	(PU),Y
	CMP	#EOL
	BNE	REDRPT	;Redraw Partial
	;Insert CR at EOL
	WXEP	#EOL
INS4:	WXEP	#ISL	;INSERT LINE
	LDY	#0
INSFL:	RTS
; Is OK - just insert
INS1:	BEQB	COLCRS,#LINSIZ+1,INS1A
	JSR	CURSLF
	JSR	DR$EOL
	JSR	CURSRT
	RTS
;
INS1A:	WXEP	#20
	RTS
;
REDRPT:	LDY	ROWCRS
	STY	R0,X	;Limits for
	CPY	#23	;scrn redraw
	BEQ	RDRT2
	INY
RDRT2:	STY	R1,X
	WXEP	#DLL	;Insert space
	WXEP	#ISL
	WXEP	#ISL
	JSR	DRAWLN
	RTS
;
