;
; EFUNC.ASM - Basic editing functions
;
; Return Y=0 if successful, else Y=$80
;
; Test char at cursor. Y=$80:At end;
; =1:EOL; =0:other  Ch in A and CHARAC.
;
CRTST:	BEQW	PU, TEXTOP, CRTS1
	LDY	#0
	LDA	(PU),Y
	STA	CHARAC
	LDY	#0	;set CCs
	RTS
CRTS1:	LDY	#$80
	RTS
;
;Moves right 1 char.  Char saved
;
CRRT:	JSR	CRTST
	BMI	CRTS1
	STA	(PL),Y
	JSR	MOVPTR
	INCW	PL
	INCW	PU
	LDY	#0
	RTS
;
MOVPTR:	BNEW	PT, PU, CRRT1
	MOVW	PL, PT	;Keep PT still
CRRT1:	RTS
;
;Left 1 char
;
CRLF:	BEQW	PL, TEXBOT, CRTS1
	DECW	PL
	DECW	PU
	LDY	#0
	LDA	(PL),Y
	STA	(PU),Y
	STA	CHARAC
	JSR	MOVPTL
	LDY	#0
	RTS
;
MOVPTL:	BNEW	PT, PL, CRLF1
	MOVW	PU, PT
CRLF1:	RTS
;
CURSLF:	JSR	CRLF
	BMI	FAIL
	BPL	CHTEST
;
CURSRT:	JSR	CRRT
	BMI	FAIL
	BPL	CHTEST
;
CURTSP:	JSR	CRTST
	BMI	FAIL
	BPL	CHTEST
;
FAIL:	JSR	STOPMC	;Error - stop macro
	LDY	#$80
	RTS
;
;Deletes back 1 char
;Deleted character in CHARAC
;
;	Y=0 Normal
;	Y=1 EOL
;	Y=$80 No char deleted
;
DELETE:	BEQW	PL, TEXBOT, FAIL
	JSR	SETMOD
	DECW	PL
	LDY	#0
	LDA	(PL),Y
	STA	CHARAC
;Character test
CHTEST:	LDA	CHARAC
	CMP	#EOL
	BEQ	EOLRET
SUCRET:	LDY	#0	;fill CCs
	RTS
EOLRET:	LDY	#1
	RTS
;
;Char INSERT
;	Y=0 Normal
;	Y=1 EOL
;	Y=$80 Won't Fit
;
INSERT:	JSR	SETMOD
	BEQW	PL, PU, FAIL
	LDY	#0
	LDA	CHARAC
	STA	(PL),Y
	INCW	PL
	JMP	CHTEST
;
; Screen redraw routines
;
;Clears screen from R0 down
;Returns R0 unmodified
CLRDN:	LDA	#0
	STA	R1,X
	JSR	POSITN
	LDA	R0,X
	STA	R2,X
CLRDN1:	WXEP	#DLL
	INC	R2,X
	LDA	R2,X
	CMP	#24
	BNE	CLRDN1
	RTS
;
;Full reposition/redraw
;
SCREEN:	JSR	SCANSCR
	BPL	FULL2	;If OK just place
	bmi	fullrd
RDNOMV:	JSR	SCANSCR
	BPL	FULL1
FULLRD:	JSR	REPOSN	;Center cursor
FULL1:	JSR	REDRAW
	JSR	SCANSCR	;Get cursor cor
FULL2:	JSR	POSITN	;  and position
	RTS
;
;Reposition screen
REPOSN:	LOADW	PL, R1	;Starting point
	FORB	R0, 0, 11
	CALL	R1, S$BCR;Moves R1 back
	NEXTB	R0
REPOS1:	STOREW	R1, PS
	RTS
;
; Redraws just the current line
;
REDCLN:	jsr	screen
	WXEP	#DLL
	WXEP	#ISL
	LDA	ROWCRS
	STA	R0,X
	STA	R1,X
	JMP	DRAWLN
;
HOME:	JSR	TOS
	WXEP	#CLS	;and clear
	RTS
;
TOS:	LDA	#0	;Top of scr
	STA	R0,X
	STA	R1,X
	JSR	POSITN
	RTS
;
; Position cursor
;
rangerr:
	ldy	rowcrs
	jsr	prtstat
	ldy	colcrs
	jmp	prtstat	;rts
;
POSITN:	STOREB	R0, ROWCRS
	STOREB	R1, COLCRS
BELL:	LDA	ROWCRS
	cmp	#25
	bcs	rangerr
	ORA	#$80
	JSR	XIO14
	LDA	COLCRS
	cmp	#80
	bcs	rangerr
	; fall through for second jsr
XIO14:	LDY	#$14
XIOFNC:	STA	IOCB6+ICAX2
	lda	susout
	bne	test2
	LDA	#$0C
	STA	IOCB6+ICAX1
	STY	IOCB6+ICCOM
	LDA	#LOW EDXEP
	STA	IOCB6+ICBAL
	LDA	#HIGH EDXEP
	STA	IOCB6+ICBAH
	TXA ! PHA
	LDX	#$60
	JSR	CIOV
	PLA ! TAX
;test
	tya
	bpl	test2
	jsr	prtstat
test2:
	RTS
;
; Scan Screen: Y=0 if PL on screen
;		$80 otherwise
;		R0.b=Row
;		R1.b=Column
SCANSCR:
	LOADW	PS, R4
	FORB	R0, 0, 23
	FORB	R1, 0, LINSIZ+1
SCNSC5:	BEQWAR	PL, R4, SCNMTCH
	jsr	ldar4i
	BMI	SCNSC2	;eol
	CMP	#TAB
	BNE	SCNSC3
SCNSC4:	LDA	R1,X
	CMP	#LINSIZ+1
	BEQ	SCNSC8
	INC	R1,X
	LDA	R1,X
	AND	#7
	BNE	SCNSC4
	BEQ	SCNSC5
SCNSC3:	NEXTB	R1
SCNSC8:	BEQWAR	PL, R4, SCNMTCH	;Loop here til
	jsr	ldar4i
	BPL	SCNSC8	;br if not eol
SCNSC2:	NEXTB	R0
	LDY	#$80	;Not On Screen
	RTS
SCNMTCH:
	LDY	#0
	RTS
;
DR$EOL:	JSR	SCANSCR
	JSR	BURSTM
	LOADW	PU, R4	;Now upper
DR$L1:	JSR	POSITN
DR$L8:	LDA	COLCRS
	CMP	#LINSIZ+1;Test eo scrn
	BCS	DR$L9
	BEQWAR	TEXTOP, R4, DR$L3
	jsr	ldar4i
	BMI	DR$L3	;br if eol
	BEQ	DR$L5	;if normal char
	cpy	#2
	beq	dr$le
	;is a tab
DR$L6:	LDA	COLCRS
	CMP	#LINSIZ+1
	BEQ	DR$L9
	WXEP	#32	;Tab - wr space
	INC	COLCRS
	LDA	COLCRS
	AND	#7
	BNE	DR$L6
	BEQ	DR$L7
dr$le:	pha
	jsr	l$wxesc
	pla
DR$L5:	JSR	L$WXEP
	INC	COLCRS
DR$L7:	LDA	CH	;Test for more input
	CMP	#$FF
	BEQ	DR$L8
	BNE	DR$L3	;If a new char, forget about the rest
;
DR$L9:	WXEP	#20	;DOT
DR$L3:	LDY	#0
	JSR	NOBURS
	RTS
;
; Search R0 back to next <CR>
; Returns: Y=0   Found one
;	    =$80 At beginning of buffer
;
S$BCR:	JSR	S$BCR3
	BMI	S$BCR1
	DECWR	R0
S$BCR2:	JSR	S$BCR3
	BMI	S$BCR5
	DECWR	R0
	INDIR	LDA, R0
	CMP	#EOL
	BNE	S$BCR2
	INCWR	R0	;To char at BOL
S$BCR5:	LDY	#0
S$BCR1:	RTS
S$BCR3:	BNEWAR	TEXBOT, R0, S$BCR5
	LDY	#$80	;Flag BB
	RTS
;
; Clear editing buffer
;
CLRMAIN: ; Clear bflag and filename
	jsr	t2tobf
	LDA	#0
	STA	bflg,Y
	;
	LDA	#HIGH FNAMES
	STA	TEMP2+1
	LDY	#0
	LDA	#EOL
	STA	(TEMP2),Y
;
INIPTR:	MOVW  TEXTOP, PU ;empty upper
	MOVW4 TEXBOT, PL, PS, PT
	LDA	#0
	STA	MODIFY
	RTS
;
PRTSTAT:
	STY	R0,X	;The code
	LDA	#0
	STA	R0+1,X
	WXEP	#197	;Inverse video E
	JSR	PRT16	;
	jsr	rdtrch	; give guy a chance to read error #
	rts
;
;Gets number from kybd, up to 64000
;Returns w/delimiter in A
;
GETNUM:	CLRWR	R0
GETNM1:	JSR	RDTRCH
	CMP	#EOL
	BEQ	GTNMEX
	CMP	#'0'
	BCC	GTNMER
	CMP	#':'	;9+1
	BCS	GTNMER
	PHA		;Valid num - save 
	JSR	L$WXEP	;Echo valid num
	JSR	SHR0L1	;Mul R0 by 2
	MOVRR	R0, R1
	JSR	SHR0L2	;and by 8 total
	ADDWR	R1, R0, R0
	PLA
	SEC
	SBC	#'0'
	ADDBWR	R0
	JMP	GETNM1
GTNMER:	LDY	#$80	;Number possibly delimited
	RTS
GTNMEX:	LDY	#0	;Number valid
	RTS
;
SHR0L2:	ASL	R0,X
	ROL	R0+1,X
SHR0L1:	ASL	R0,X
	ROL	R0+1,X
	RTS
;
;Routine gets a rec from the kybd using RDTRCH
;Max len in R2 - returns actual len in R1
;COLCRS must be set up proir to call
RDKBRR:	STA	R2,X	;max len
	CLRWR	R1	;count
RDKB1:	LDA	R2,X
	CMP	R1,X	;If max len reached flag error
	BEQ	RDKBER
RDKB3:	JSR	RDTRCH	;make kbd macros work
	CMP	#BAK	;del/bk sp
	BNE	RDKB2
	LDA	R1,X
	BEQ	RDKB1	;Ignore dels if no chars
	DEC	R1,X	;Decr count and pointer
	DECWR	R0
	dec	colcrs
	JSR	BELL
	WXEP	#SPC	;
	dec	colcrs
	JSR	BELL
	JMP	RDKB1
RDKB2:	INC	R1,X	;Counts delimiter, too
	cmp	#17	;ctl-Q
	bne	rdkb4
	jsr	l$wxesc	;make sure funny char prints
	jsr	rdtrch	;get shifted char
	jmp	rdkb5
rdkb4:	CMP	#32	;Take any ctl as delim
	BCC	RDKBEX
	CMP	#0
	BMI	RDKBEX	;or hi bit
rdkb5:	INDIR	STA, R0	;Include delim.
	JSR	L$WXEP	;echo
	INCWR	R0
	JMP	RDKB1
RDKBEX:	JSR	RDEND
	LDY	#0	;No len viol
	RTS
;
RDKBER:	DECWR	R0	;Input too long
	JSR	RDEND
	LDY	#$80
	RTS
;
RDEND:	LDA	#EOL
	INDIR	STA, R0	;Change last char to eol
	MOVRR	R1, R0
	dec	r1,x	;delim not incl in r1
	LDA	CHARAC	;get orig. delim
	RTS
;
;Called from after routine which waits for a key before proceeding.
;If a ctl key, it pushc's, else eats and returns.
;
NEXFNR:
NEXFNC:	WXEP	#190	;Inverse >
	JSR	RDTRCH	;get key
	CMP	#32
	BCC	NEXFN1
	LDY	#0	;success
	RTS
NEXFN1:	JSR	PUSHC
	pla ! pla	;Bag redraw
	RTS
;
;Error - Stop macro execution
STOPMC:	lda	kbdfg
	beq	clrctr	;if no macro exec, just clr ctr
	LDA	#0
	STA	KBDFG	;Clobber kbd mac build/execute
	jsr	clrctr
	jsr	showkm
	rts
;
updtkm:	jsr	showkm
	jsr	screen	;replace cursor
	RTS
;
clrctr:	CLRW	MACNT	;Stop outer count
	CLRW	COUNT	;Stop inner count
	rts
;
;Set kybd to upper case
UPPER:	LDA	702
	STA	OLDSHF
	LDA	#64
	BPL	RECAS1
;Restore case
RECASE:	LDA	OLDSHF
RECAS1:	STA	702
	RTS
;
; Routine places title at bottom of screen
;
title:	jsr	line24		;delete bottom line
	jsr	burstm
	forb	r0, 0, 79
	wxepi	#45		; first do background of '-'
	nextb	r0
	jsr	showkm		;show if making kybd macro
	jsr	modas1		;do * if modified
	lda	#7
	jsr	setc24
	lda	curbuf
	clc
	adc	#['A']
	jsr	l$wxpi		; write buffer name

	lda	#10
	jsr	setc24
	jsr	buffna		; get file name to current fnam
	ldy	#0
titl3:	lda	tfnam,y
	cmp	#eol
	beq	titl2
	jsr	llwxpi		; write filename
	iny
	bpl	titl3
titl2:	lda	#26
	jsr	setc24
	ldy	#0
	sty	redttl		; flag title bar is good
titl4:	lda	defalt,y
	cmp	#eol
	beq	titl5
	jsr	llwxpi
	iny
	bpl	titl4
titl5:	jsr	noburs
	rts
;
showkm:	lda	#1	;show if defining kbd mac
	jsr	setc24
	lda	#45	;set up for no kybd
	ldy	kbdfg
	beq	shokm1
	lda	#40	;'('
shokm1:	jsr	l$wxpi
	rts
;
modas1:	lda	#4
	jsr	setc24
	lda	#45
	ldy	modify
	beq	titl1
	lda	#42	; * if so
titl1:	jsr	l$wxpi
	rts
;
llwxpi:	sty	ysav
	jsr	l$wxpi
	ldy	ysav
	rts
;eof
