;
; ELIB.ASM - Library routines
;
; X adjustments
;
LXPR6:	INX ! INX
LXPR5:	INX ! INX
LXPR4:	INX ! INX
LXPR3:	INX ! INX
LXPR2:	INX ! INX
LXPR1:	INX ! INX
LXPR0:	RTS
;
LXMR6:	DEX ! DEX
LXMR5:	DEX ! DEX
LXMR4:	DEX ! DEX
LXMR3:	DEX ! DEX
LXMR2:	DEX ! DEX
LXMR1:	DEX ! DEX
LXMR0:	RTS
;
; I/O LIBRARIES
;  ENTER WITH	Y  = CHAN*16
;		R0 = BUF ADR OR DEV/FNA
;       R/W CHR:R1 = BUF LEN
;	OPEN:   A  = ACCESS TYPE
;
; RETURNS WITH	Y  = STATUS
;	READ:   R0 = LENGTH
;	OTHERS:	R0 = BUF ADR
;
L$OPEN:
	STA ICAX1,Y
	LDA #0
	STA ICAX2,Y
	LDA #OPEN
	BNE L$WRRC2
;
L$WRCHR:
	LDA #PUTCHR
L$WRCR2:
	STA ICCOM,Y

	LDA R1,X	;LENGTH FROM
	STA ICBLL,Y	;  R1
	LDA R1+1,X
	STA ICBLH,Y
	JMP L$DOIO
;
L$WRREC:
	LDA #PUTREC
L$WRRC2:
	STA ICCOM,Y

	LDA #LOW 256	;MAX REC LEN
	STA ICBLL,Y
	LDA #HIGH 256
	STA ICBLH,Y
L$DOIO:
	LDA R0,X	;ADR OF DATA
	STA ICBAL,Y	;OR DEVICE/FNAM
	LDA R0+1,X
	STA ICBAH,Y

	STX XSAV
	TYA ! TAX

	JSR CIOV
	TXA
	LDX XSAV
	CPY #0
	RTS	;Y=STAT A=CHAN*16 CC@Y
;
L$RDCHR:
	LDA #GETCHR
	JSR L$WRCR2
	JMP L$RETLN
;
L$RDREC:
	LDA #GETREC
	JSR L$WRRC2	;DOES CIO
L$RETLN:
	TAY		;CHAN

	LDA ICBLL,Y	;RECORD LENGTH
	STA R0,X
	LDA ICBLH,Y
	STA R0+1,X

	LDA ICSTA,Y
	TAY		;STATUS AND CC
	RTS
;
; GENERIC XIO
;
; ENTER: A = OPCODE
;	 Y = CHAN*16
;	R0 = DEV/FNAM
;
; RET:	 Y = STATUS
;	R0 = ORIG.
L$XIO:
	STA ICCOM,Y
L$XIOC:
	LDA R0,X
	STA ICBAL,Y
	LDA R0+1,X
	STA ICBAH,Y
	LDA #0
	STA ICAX1,Y
	LDA #0
	STA ICAX2,Y
	STX XSAV
	TYA ! TAX
	JSR CIOV
	LDX XSAV
	CPY #0
	RTS
;
; CLOSE, READA, WRITA, WXEP, WXESC
; 
; ENTER: Y = CHAN*16
;  WRITA A = DATA
;  WXEP  Y = UNDEF.
;
; RET:	 Y = STATUS  CC@Y
;  READA A = DATA
;
ciov:	;Fake CIOV entry - Test for suspended output
	cpx	#0
	bne	sus1
	ldy	susout
	bne	sus2
	ldy	CONSOL	;check SELECT key
	cpy	#5
	beq	sus3
sus1:	jmp	ciovf	;The real call
	;jsr/rts
sus3:	sty	susout
sus2:	rts
;
L$CLOSE:
	PHA
	LDA #CLOSE
	BNE L$MIO
;
L$READA:
	PHA
	LDA #GETCHR
	BNE L$MIO	;always branches
;
L$WXESC:
	LDA #ESC	;
	BPL L$WXEP	;always
;
L$WXPI:	ORA #$80	;make char inv video
;
L$WXEP:	LDY #0		;Lightweight
;			;wr to scrn
L$WRITA:
	PHA
	LDA #PUTCHR
L$MIO:			;MISC I/O
	STA ICCOM,Y

	LDA #0
	STA ICBLL,Y	;ZERO LENGTH
	STA ICBLH,Y	; MEANS USE 'A'
	STA ICBAL,Y
	STA ICBAH,Y	;SAFE ON ADRS

	STX XSAV
	TYA ! TAX
	PLA
	JSR CIOV
	LDX XSAV
	CPY #0
	RTS
;
; String library
;
;Returns length of string at R0 in R1
L$SLEN:	MOVRR	R0, R2
	CLRWR	R1
L$SLN1:	INDIR	LDA, R2
	CMP	#EOL
	BEQ	L$SLN2
	INCWR	R1
	INCWR	R2
	JMP	L$SLN1
L$SLN2:	RTS
;
;Concats strings at R0 and R1 to R2
;Returns R0 at dest
L$SCAT:	MOVRR	R0, R3
	MOVRR	R2, R4
	CALL	R3, L$SCPY
	MOVRR	R1, R3
	CALL	R3, L$SCPY
	MOVRR	R2, R0
	RTS
;
;Copies string at R0 to R1
;Returns R0 at dest, R1 at EOL of dest
L$SCPY:	MOVRR	R0, R2
	MOVRR	R1, R0
L$SCP2:	INDIR	LDA, R2
	INDIR	STA, R1
	CMP	#EOL
	BEQ	L$SCP1
	INCWR	R2
	INCWR	R1
	JMP	L$SCP2
L$SCP1:	RTS
;
