;
; EMACRO.ASM - Macros for EMAX
;
BGEW	MACRO S1,S2,LABEL ;BR IF S1>=S2
	LDA %1+1
	CMP %2+1
	BNE D%K
	LDA %1
	CMP %2
D%K:	BCS %3
	ENDM
;
BGEWRA	MACRO Rn,S2,LABEL ;BR IF Rn>=S2
	LDA %1+1,X
	CMP %2+1
	BNE D%K
	LDA %1,X
	CMP %2
D%K:	BCS %3
	ENDM
;
BGEWAR	MACRO S1,Rn,LABEL ;BR IF S2>=Rn
	LDA %1+1
	CMP %2+1,X
	BNE D%K
	LDA %1
	CMP %2,X
D%K:	BCS %3
	ENDM
;
BGEB	MACRO S1,S2,LABEL ;BR IF S1>=S2
	LDA %1
	CMP %2
	BCS %3
	ENDM
;
BGEWI	MACRO SS,IMM,LABEL ; BR IF S>=I
IMMV	SET	%2
	LDA %1+1
	CMP #HIGH IMMV
	BNE D%K
	LDA %1
	CMP #LOW IMMV
D%K:	BCS %3
	ENDM
;
BLEW	MACRO S1,S2,LABEL
	LDA %1+1
	CMP %2+1
	BNE D%K
	LDA %1
	CMP %2
	BEQ %3
D%K:	BCC %3
	ENDM
;
BLSW	MACRO S1,S2,LABEL
	LDA %1+1
	CMP %2+1
	BNE D%K
	LDA %1
	CMP %2
D%K:	BCC %3
	ENDM
;
BLSWRR	MACRO r1,r2,LABEL
	LDA %1+1,X
	CMP %2+1,X
	BNE D%K
	LDA %1,X
	CMP %2,X
D%K:	BCC %3
	ENDM
;
BLEWI	MACRO SS,IMM,LABEL ; BR IF I<=S
IMMV	SET	%2
	LDA %1+1
	CMP #HIGH IMMV
	BNE D%K
	LDA %1
	CMP #LOW IMMV
	BEQ %3
D%K:	BCC %3
	ENDM
;
BEQW	MACRO S1,S2,LABEL
	LDA %1
	CMP %2
	BNE D%K
	LDA %1+1
	CMP %2+1
	BEQ %3
D%K:
	ENDM
;
BEQB	MACRO S1,S2,LABEL
	LDA %1
	CMP %2
	BEQ %3
	ENDM
;
BNEB	MACRO S1,S2,LABEL
	LDA %1
	CMP %2
	BNE %3
	ENDM
;
BEQWAR	MACRO S1,rn,LABEL
	LDA %1
	CMP %2,X
	BNE D%K
	LDA %1+1
	CMP %2+1,X
	BEQ %3
D%K:
	ENDM
;
BEQWRR	MACRO Rn,Rm,LABEL
	LDA %1,X
	CMP %2,X
	BNE D%K
	LDA %1+1,X
	CMP %2+1,X
	BEQ %3
D%K:
	ENDM
;
BEQWI	MACRO SS,IMM,LABEL
IMMV	SET	%2
	LDA %1
	CMP #LOW IMMV
	BNE D%K
	LDA %1+1
	CMP #HIGH IMMV
	BEQ %3
D%K:
	ENDM
;
BEQZW	MACRO S1,LABEL
	LDA %1
	ORA %1+1
	BEQ %2
	ENDM
;
BEQZWR	MACRO rn,LABEL
	LDA %1,X
	ORA %1+1,X
	BEQ %2
	ENDM
;
BNEW	MACRO S1,S2,LABEL
	LDA %1
	CMP %2
	BNE %3
	LDA %1+1
	CMP %2+1
	BNE %3
	ENDM
;
BNEWAR	MACRO S1,rn,LABEL
	LDA %1
	CMP %2,X
	BNE %3
	LDA %1+1
	CMP %2+1,X
	BNE %3
	ENDM
;
BNEZW	MACRO S1,LABEL
	LDA %1
	ORA %1+1
	BNE %2
	ENDM
;
BNEZWR	MACRO Rn,LABEL
	LDA %1,X
	ORA %1+1,X
	BNE %2
	ENDM
;
BNEWI	MACRO SS,IMM,LABEL
IMMV	SET	%2
	LDA %1
	CMP #LOW IMMV
	BNE %3
	LDA %1+1
	CMP #HIGH IMMV
	BNE %3
	ENDM
;
BNEWRI	MACRO rn,IMM,LABEL
IMMV	SET	%2
	LDA %1,X
	CMP #LOW IMMV
	BNE %3
	LDA %1+1,X
	CMP #HIGH IMMV
	BNE %3
	ENDM
;
CALL	MACRO rn,dd
	JSR	LXP%1
	JSR	%2
	PHP		;Save status around pop
	JSR	LXM%1
	PLP
	ENDM
;
CLRW	MACRO DD
	LDA #0
	STA %1
	STA %1+1
	ENDM
;
CLRWR	MACRO Rn
	LDA #0
	STA %1,X
	STA %1+1,X
	ENDM
;
CLRB	MACRO dd
	LDA #0
	STA %1
	ENDM
;
LOADW	MACRO ss,rn
	LDA %1
	STA %2,X
	LDA %1+1
	STA %2+1,X
	ENDM
;
LOADB	MACRO ss,rn
	LDA %1
	STA %2,X
	ENDM
;
INDIR	MACRO opc,rn
	%1 (%2,X)
	ENDM
;
LOADIW	MACRO IMM,rn
IMMV	SET	%1
	LDA #LOW IMMV
	STA %2,X
	LDA #HIGH IMMV
	STA %2+1,X
	ENDM
;
LOADWY	MACRO base, displ, Rn
	LDY	#%2
	LDA	(%1),Y
	STA	%3,X
	INY
	LDA	(%1),Y
	STA	%3+1,X
	ENDM
;
MOVC	MACRO ss,dd	;Move CR-term
	LDY #0		;string
D1%K:	LDA %1,Y
	STA %2,Y
	CMP #EOL
	BEQ D%K
	INY
	BNE D1%K	;256 CHARS MAX
D%K:	
	ENDM	
;
MOVCI	MACRO SRC,DEST
	LDY #0	; MOVE INDIRECT TO <CR>
D%K:	LDA (%1),Y
	STA (%2),Y
	CMP #EOL
	BEQ D1%K
	INY
	BNE D%K
D1%K:
	ENDM
;
MOVIW	MACRO IMM, DD
IMMV	SET	%1
	LDA #LOW IMMV
	STA %2
	LDA #HIGH IMMV
	STA %2+1
	ENDM
;
MOVW	MACRO ss,dd
	LDA %1
	STA %2
	LDA %1+1
	STA %2+1
	ENDM
;
MOVW3	MACRO ss,d1,d2
	LDA %1
	STA %2
	STA %3
	LDA %1+1
	STA %2+1
	STA %3+1
	ENDM
;
MOVW4	MACRO ss,d1,d2,d3
	LDA %1
	STA %2
	STA %3
	STA %4
	LDA %1+1
	STA %2+1
	STA %3+1
	STA %4+1
	ENDM
;
MOVRR	MACRO rn,rm
	LDA %1,X
	STA %2,X
	LDA %1+1,X
	STA %2+1,X
	ENDM
;
MOVBRR	MACRO rn,rm
	LDA %1,X
	STA %2,X
	ENDM
;
MOVB	MACRO ss,dd
	LDA %1
	STA %2
	ENDM
;
; Define local registers
;
R0	= 0
R1	= 2
R2	= 4
R3	= 6
R4	= 8
R5	= 10
R6	= 12
;
ADDW	MACRO S1,S2,DD
	CLC
	LDA %1
	ADC %2
	STA %3
	LDA %1+1
	ADC %2+1
	STA %3+1
	ENDM
;
ADDWRAA	MACRO Rn,SS,DD
	CLC
	LDA %1,X
	ADC %2
	STA %3
	LDA %1+1,X
	ADC %2+1
	STA %3+1
	ENDM
;
ADDWR	MACRO Rn,Rm,Rp
	CLC
	LDA %1,X
	ADC %2,X
	STA %3,X
	LDA %1+1,X
	ADC %2+1,X
	STA %3+1,X
	ENDM
;
ADDBW	MACRO S1,DD
	CLC
	LDA %1
	ADC %2
	STA %2
	BCC D%K
	INC %2+1
D%K:	
	ENDM
;
ADDBWR	MACRO Rn	;Adds A to Rn
	CLC
	ADC %1,X
	STA %1,X
	BCC D%K
	INC %1+1,X
D%K:	
	ENDM
;
ADDIW	MACRO IMM,SS,DD
IMMV	SET	%1
	CLC
	LDA #LOW IMMV
	ADC %2
	STA %3
	LDA #HIGH IMMV
	ADC %2+1
	STA %3+1
	ENDM
;
;	SUBTRACT S1 FROM S2 TO DD
;
SUBW	MACRO S1,S2,DD
	SEC
	LDA %2
	SBC %1
	STA %3
	LDA %2+1
	SBC %1+1
	STA %3+1
	ENDM
;
SUBIW	MACRO IMM,SS,DD
IMMV	SET	%1
	SEC
	LDA %2
	SBC #LOW IMMV
	STA %3
	LDA %2+1
	SBC #HIGH IMMV
	STA %3+1
	ENDM
;
SUBWAAR	MACRO S1,S2,Rn
	SEC
	LDA %2
	SBC %1
	STA %3,X
	LDA %2+1
	SBC %1+1
	STA %3+1,X
	ENDM
;
SUBWR	MACRO r1,r2,r3
	SEC
	LDA %2,X
	SBC %1,X
	STA %3,X
	LDA %2+1,X
	SBC %1+1,X
	STA %3+1,X
	ENDM
;
;
; X adjustment
;
PSHST1	MACRO
	INX
	INX
	ENDM
;
POPST1	MACRO
	DEX
	DEX
	ENDM
;
PUSHST	MACRO Rn
	JSR  LXP%1
	ENDM
;
POPST	MACRO Rn
	JSR  LXM%1
	ENDM
;
PUSHX	MACRO
	TXA
	PHA
	ENDM
;
POPX	MACRO
	PLA
	TAX
	ENDM
;
PUSHW	MACRO SS
	LDA %1
	PHA
	LDA %1+1
	PHA
	ENDM
;
POPW	MACRO DD
	PLA
	STA %1+1
	PLA
	STA %1
	ENDM
;
INDW	MACRO SS,DD
	LDY  #0
	LDA  (%1),Y
	STA  %2
	INY
	LDA  (%1),Y
	STA  %2+1
	ENDM
;
INCW	MACRO DD
	INC %1
	BNE D%K
	INC %1+1
D%K:
	ENDM
;
INCWR	MACRO rn
	INC %1,X
	BNE D%K
	INC %1+1,X
D%K:
	ENDM
;
DECW	MACRO DD
	LDA %1
	BNE D%K
	DEC %1+1
D%K:	DEC %1
	ENDM
;
DECWR	MACRO rn
	LDA %1,X
	BNE D%K
	DEC %1+1,X
D%K:	DEC %1,X
	ENDM
;
OPEN	MACRO CHAN,ACCESS ;FNA IN R0
	LDY #$%10
	LDA #%2
	JSR L$OPEN
	ENDM
;
XIO	MACRO OPC,CHAN	;FNA IN R0
	LDY #$%20
	LDA %1		;OPCODE
	JSR L$XIO
	ENDM
;
READCHR	MACRO CHAN	;REC ADR IN R0
	LDY #$%10	;LEN IN R1
	JSR L$RDCHR	;RTN LEN IN R0
	ENDM
;
READREC	MACRO CHAN	;REC ADR IN R0
	LDY #$%10
	JSR L$RDREC	;RTN LEN IN R0
	ENDM
;
WRITREC	MACRO CHAN	;REC ADR IN R0
	LDY #$%10
	JSR L$WRREC
	ENDM
;
WRITCHR	MACRO CHAN	;REC ADR IN R0
	LDY #$%10	;REC LEN IN R1
	JSR L$WRCHR
	ENDM
;
CLOSE	MACRO CHAN
	LDY #$%10
	JSR L$CLOSE
	ENDM
;
READA	MACRO CHAN	;GET ONE BYTE
	LDY #$%10
	JSR L$READA
	ENDM
;
WRITA	MACRO CHAN	;WRITE ONE BYTE
	LDY #$%10
	JSR L$WRITA
	ENDM	
;
WXEP	MACRO CHAR
	LDA %1
	JSR L$WXEP
	ENDM
;
WXEPI	MACRO CHAR
	LDA %1
	JSR L$WXPI
	ENDM
;
ERROR	MACRO ERRLAB	;STATUS IN Y
	BPL E%K
	JMP %1
E%K:
	ENDM
;
ERREOF	MACRO ERRLAB,EOFLAB
	BPL E%K
	CPY #EOF
	BEQ E1%K
	JMP %1
E1%K:	JMP %2
E%K:
	ENDM
;
STOREW	MACRO rn,dd
	LDA %1,X
	STA %2
	LDA %1+1,X
	STA %2+1
	ENDM
;
STOREB	MACRO rn,dd
	LDA %1,X
	STA %2
	ENDM
;
FORB	MACRO rn,init,final
	LDA	#%2
	STA	%1,X
%1FINAL	SET	%3
%1LOOP	SET	*
%1INCR	SET	1
	ENDM
;
FORBS	MACRO rn,init,final,step
	LDA	#%2
	STA	%1,X
%1FINAL	SET	%3
%1LOOP	SET	*
%1INCR	SET	%4
	ENDM
;
NEXTB	MACRO rn
	LDA	%1,X
	CMP	#%1FINAL
	BCS	N%K

	IF %1INCR - 1
	ADC	#%1INCR
	STA	%1,X
	ELSE
	INC	%1,X
	ENDIF

	JMP	%1LOOP
N%K:
	ENDM
;Macro loops on Rm rather than imm
NEXTIF	MACRO rn, rm
	LDA	%1,X
	INC	%1,X
	CMP	%2,X
	BCS	N%K
	JMP	%1LOOP
N%K:
	ENDM
;
STRLEN	MACRO	SS	;Ret:
	LOADIW	%1, R0	;Str in R0
	JSR	L$SLEN	;Len in R1
	ENDM
;
STRCPY	MACRO	SS, DD
	LOADIW	%1, R0	;Ret:
	LOADIW	%2, R1	;Dest in R0
	JSR	L$SCPY	;One past in R1
	ENDM
;
STRCAT	MACRO	S1, S2, DD
	LOADIW	%1, R0	;Ret:
	LOADIW	%2, R1	;Dest in R0
	LOADIW	%3, R2
	JSR	L$SCAT
	ENDM
;
