;
; EMINIT.ASM - EMAX Initialization Routine
;
; Temporary program - Space will be reused for data storage
;
	LDX	#INITX
	LDA	#78
	STA	FILCOL	;Default fill value
	LDA	#0
	STA	REDRFG
	STA	COUNT
	STA	COUNT+1	;Val of 0 means do one
	STA	MACNT
	STA	MACNT+1
	STA	LITFLG	;Not in literals mode
	sta	susout	;Output not suspended
;
; Open Keyboard and Screen
; Actually, assumes ch#0 = screen@edit
;
	jsr	keyopn
	JSR	EXINIT	;Mostly sets up buffer descriptors
	JSR	CLRMAIN	;Set up buffer pointers
	JSR	USRINI	;execute user initialization
	JSR	TITLE
	JSR	FULLRD	;full redraw
	LDA	#0
	STA	702	;Lower case
	LDA	#89	;Just a little
	STA	RMARGN	;  offscreen
;Initialization done
	JMP	MAIN	;Enter main loop
;
keyopn:	close	2
	LOADIW	KNAM, R0
	OPEN	2, OREAD
	rts
;
EXINIT:	MOVIW	KILBUF, KILLBOT  ;Init
	MOVW	KILLBOT, KILLTOP ; kill
	;Clear file names and buffer data
	MOVIW	FNAMES, TEMP2
	LDY	#0
CLRFNA:	LDA	#EOL
	STA	(TEMP2),Y	;No file name
	INY
	BNE	CLRFNA
	;Set up bufbots
	FORB	R0,0,15
	ldy	r0,x
	LDA	#LOW [RAMTOP]	;Set buffer pointers
	STA	bufbtl,Y	;at hi mem limit
	LDA	#HIGH [RAMTOP]
	STA	bufbth,Y
	lda	#0
	sta	bflg,y
	NEXTB	R0
	;
	LDA	#0
	STA	SELBUF
	STA	CURBUF
	STA	KBDFG	;Not defining kbd macro
	STA	KBDVAL	;Buf not valid
	STA	PUSHCF	;no char pushed
	;
	MOVC	D1DEF, DEFALT	;def=D1:

	lda	MEMLO
	sta	TEXBOT
	sta	bufbtl	;b0
	lda	MEMLO+1
	sta	TEXBOT+1
	sta	bufbth	;b0

	MOVIW	RAMTOP, TEXTOP
	RTS
;
; User Initialization facility
;
;
USINRC	= $6000		; User's input
;
lensav:	db	0
	;
USRINI:	LOADIW	CDEV, R0
USRIN1:	OPEN	3, OREAD
	BMI	USINEX	; Quit on any error
USRIN2:	LOADIW	USINRC, R0
	READREC	3
	BMI	USINEX	; Quit on any error
	storeb	r0, lensav
	LDA	USINRC	; Get command char
	CMP	#'@'	; To file?
	BNE	USRIN3
	CLOSE	3
	LOADIW	USINRC+1, R0
	JMP	USRIN1
USRIN3:	CMP	#'X'
	BEQ	DOAXIO
	CMP	#'K'
	BEQ	KEYDEF
	cmp	#'P'
	beq	poke
	CMP	#'Q'
	BNE	USRIN2
USINEX:	CLOSE 	3
	RTS		; Now go to editor
;
poke:	ldy	#2	;Poke to memory - user had
	jsr	gethex	;better know what he's doing
	bmi	pokex
	sta	r0+1,x
	dey
	jsr	gethex
	bmi	pokex
	sta	r0,x
	jsr	gethex
	bmi	pokex
	sta	(r0,x)
pokex:	jmp	usrin2
;
KEYDEF:	LDY	#2
	JSR	GETHEX
	BMI	KEYEX
	CMP	#$60
	BCS	KEYEX
	ORA	#LOW [CHTRAN]
	STA	R0,X
	LDA	#HIGH [CHTRAN]
	STA	R0+1,X
	JSR	GETHEX
	CMP	#$65
	BCS	KEYEX
	STA	(R0,X)
KEYEX:	JMP	USRIN2
;
DOAXIO:	LDY	#2
	JSR	GETHEX
	BMI	DOXEX
	STA	IOCB5+ICCOM
	JSR	GETHEX
	BMI	DOXEX
	STA	IOCB5+ICAX1	
	JSR	GETHEX
	BMI	DOXEX
	STA	IOCB5+ICAX2
	LDA	#LOW [USINRC+11]
	STA	IOCB5+ICBAL
	LDA	#HIGH [USINRC+11]
	STA	IOCB5+ICBAH
	sec
	lda	lensav
	sbc	#12
	sta	iocb5+icbll
	lda	#0
	sta	iocb5+icblh
	TXA ! PHA
	LDX	#$50
	JSR	CIOV
	PLA ! TAX
	CPY	#0
	BPL	DOXEX
	JSR	PRTSTAT		;Print always for now
	WXEP	#EOL
DOXEX:	JMP	USRIN2
;
GETHEX:	LDA	USINRC,Y
	JSR	HEXCH
	BMI	GETHXX
	ASL A !	ASL A !	ASL A !	ASL A
	STA	TEMP2
	INY
	LDA	USINRC,Y
	JSR	HEXCH
	BMI	GETHXX
	ORA	TEMP2
	INY ! INY
GETHXX:	RTS	
;
HEXCH:	CMP	#'0'
	BCC	HEX1
	CMP	#'9'+1
	BCC	HEX2
	CMP	#'A'
	BCC	HEX1
	CMP	#'F'+1
	BCS	HEX1
	SEC
	SBC	#['A'-'9']-1
HEX2:	SEC
	SBC	#'0'
	RTS
HEX1:	LDY	#$80	;Flag invalid input
	RTS
;
;end
