;
; EMSET.ASM - Sets up ROM/RAM for running EMAX
;
	LDX	#INITX
	;Get the inter vects
	movw	$FFFE, VFFFE1+1	;reset
	movw	$FFFC, VFFFC1+1	;irq
	movw	$FFFA, VFFFA1+1	;nmi
	jsr	romofi
	;
	;Build my vects
	moviw	VFFFE, $FFFE
	moviw	VFFFC, $FFFC
	moviw	VFFFA, $FFFA
	;
	;Ints back on
	jsr	romoni
	jsr	romoff
	;
	; Relocate EMAX to RAM under ROM
	;
	loadiw	$7000, R0	;Moves Tab, eminit, elib
	loadiw	$C800, R1
relop1:	lda	(R0,X)
	sta	(R1,X)
	incwr	r0
	incwr	r1
	bnewri	r1, $D000, relop1
	;
	loadiw	$8000, R0	;All else
	loadiw	$D800, R1
relop2:	lda	(R0,X)
	sta	(R1,X)
	incwr	r0
	incwr	r1
	bnewri	r1, $E900, relop2
;
;That's it for now
	jmp	eminit		;Continue init
;
romofi:	php ! pha
	sei
	lda	#0
	sta	nmien	;Turn off NMI
	lda	#$10	;kbd scan off
	sta	$232	;kbd scan shadow
	sta	$D20F	;kbd scan
	lda	portb
	sta	romonv	;save old
	and	#$FE
	sta	romofv
	sta	portb	;load with ROM off
	pla ! plp
	rts
	;
	;ROM On
	;
romoni:	php ! pha
	lda	romonv
	sta	portb
	lda	#$13	;kbd scan on
	sta	$232	;kbd scan shadow
	sta	$D20F	;kbd scan
	lda	#$40
	sta	nmien
	cli
	pla ! plp
	rts
;
;eof
