;
; FILER.ASM - File processor
;
;scroll screen
PRVSCR:	lda	#23
	jsr	SCRLDC
	RTS
NEXSCR:	lda	#23
	jsr	SCRLUC
	RTS
;
;Set fill column
;
SETFIL:	JSR	LINE24
	WXEP	#35	;'#'
	JSR	GETNUM	;Read number from kybd
	LDA	R0+1,X
	BNE	STFLEX	;Must be under 255
	LDA	R0,X
	BEQ	STFLEX	;and over zero
	STA	FILCOL
STFLEX:	RTS
;
;Set up to execute kbd macro
;
EXKBMC:	LDA	#$80
	STA	KBDFG
	LDY	#0
	STY	KBDTOP	;Reset pointer
	;Special hack to make count work - but now has two levels
	MOVW	COUNT, MACNT
	CLRW	COUNT	;Start executing cmnds once only
	RTS
;
XSWPCR:	JSR	SWPCUR
NOFUNC:	RTS
;
; QUIT Function
;
QUIT:	JSR	YES
	jsr	home
	JMP	(DUPSYS)
;Verify
YES:	JSR	LINE24
	WXEP	#63	;'?'
	JSR	RDTRCH
	AND	#$5F	;cvt to upr
	CMP	#'Y'
	BEQ	YES1
	PLA ! PLA	;return up a level if no
YES1:	RTS
;
CLRBUF:	JSR	YES
	STX	REDRFG
	JSR	CLRMAIN
RTS1:	RTS	;used by findf
;
;Load in a new file.
;
FINDF:	LDA	#13	;Max len
	LDY	#'F'
	JSR	GETINB	;File name
	BMI	RTS1	;Exit if null or too big
	;See if file is already in
	FORB	R0, 0, 13	;Buffer 14 not valid
	LDA	#HIGH FNAMES
	STA	TEMP2+1	;Build addr of fnam
	LDA	R0,X	;Buffer #
	JSR	ASLA4
	STA	TEMP2	;TEMP2 = adrs of file name
	;Look for match
	LDY	#0
FLINBF:	LDA	INBUF,Y
	CMP	(TEMP2),Y
	BNE	FLIBF1
	CMP	#EOL
	BNE	FLIBF2
	;Equal
	LDA	R0,X
	STA	SELBUF
	JSR	MOVCBF	;Go to last buffer
	STX	REDRFG
	JMP	GOTOBF	;and enter BUFFER routine
FLIBF2:	INY
	BNE	FLINBF
FLIBF1:	NEXTB	R0
	;Not present - Read file in
	JSR	BLDFN2
	OPEN	3, OREAD;filnam at R0
	BPL	FINDF1
	JMP	ERROR3
	;Locate next unused buffer
FINDF1:	STX	REDRFG	;Signal redraw
	JSR	T2TOBF	;Y=curbuf,a=bflg
	BNE	FINDF3	;
	;Test cur buf modified
	LDA	MODIFY	;
	BEQ	FINDF2	;
FINDF3:	JSR	PAKCUR	;Buffer used - try next one
	JSR	BUFP1	;
	LDA	CURBUF
	CMP	#14
	BCC	FINDF1	;Loop back
	LDY	#NOMOBF	;No more buffers
	JMP	ERROR3
	;Open file.
FINDF2:	LDY	CURBUF
	STY	SELBUF
	LDA	#1	;Mark buffer used
	STA	bflg,Y
	;Copy filename from B15 to current
	JSR	FNABUF
	JSR	INIPTR	;Init buffer pointers
	LOADW	PL, R0
	SUBWAAR	PL, PU, R1 ;buf size
	READCHR	3	;act siz in R0
	BPL	FINDF4	;Does not fit-give it to them anyway
	CPY	#$88
	BNE	FINDF6	;Not EOF
	;OK, and at EOF
FINDF5:	ADDWRAA	R0, PL, PL ;Adv PL to EOB
	JSR	BEGBUF
	CLOSE	3
	RTS
; 
FINDF4:	JSR	FINDF5
	LDY	#TOOLRG
FINDF6:	JMP	ERROR3

;
;Copy filename from temp to current buffer
;
FNABUF:	JSR	GETBPT
	STA	R1,X
	LDA	#HIGH FNAMES
	STA	R1+1,X
	LOADIW	TFNAM, R0
	JSR	L$SCPY	;Copy TFNAM to FNAMES(curbuf)
	RTS
;And back
BUFFNA:	JSR	GETBPT
	STA	R0,X
	LDA	#HIGH FNAMES
	STA	R0+1,X
	LOADIW	TFNAM, R1
	JSR	L$SCPY
	RTS
;
;Set Default
;
SETDEF:	LDA	#54	;Max len
	LDY	#'G'
	JSR	GETINB
	BMI	SD4	;Skip if null or too big
	LDY	#0	;Loop tests
SD3:	LDA	INBUF,Y	;for a colon
	CMP	#EOL	;If so, default
	BEQ	SD1	;is replaced.
	CMP	#':'	;Otherwise,
	BEQ	SD2	;new string is
	INY		;appended.
	BNE	SD3
SD2:	LDA	#EOL
	STA	DEFALT	;Clear
SD1:	STRCAT	DEFALT, INBUF, DEFALT
SD4:	RTS
;
;Print directory
;
ALLFST:	DB	'*.*',EOL
DIRECY:	STX	REDRFG	;Signal redraw
	LDA	#13
	LDY	#'D'
	JSR	GETINB	;File name
	BPL	DIRE2	;null=full
	MOVC	ALLFST, INBUF
DIRE2:	JSR	BLDFN2
	OPEN	3, ODIR	;filnam at R0
	BPL	DIRE5
	JMP	ERROR3
DIRE5:	JSR	HOME
	;Get filenames
	FORB	R0, 0, 22
	FORBS	R1, 0, 60, 20
	JSR	POSITN
	PUSHST	R2
	LOADIW	INBUF, R0
	READREC	3
	BMI	DIRE4
	LOADIW	INBUF, R0
	WRITREC	0
DIRE4:	PHP
	POPST	R2
	PLP
	BMI	DIRE7
	NEXTB	R1
	NEXTB	R0
DIRE3:	CLOSE	3
	JMP	NEXFNC
DIRE7:	CPY	#$88
	BEQ	DIRE3
;
; General error handler - careful: above code falls through!
;
ERROR3:	STY	ERRCOD	;Save err code across CLOSE
	CLOSE	3
	JSR	STOPMC
	LDY	#$80	;Flag error to caller
	RTS
;
;
; Print current buffer
;
PRINT:	LOADIW	PRINTD, R0
	JSR	PUTFIL
	RTS
;
;Build filename
;
BLDFN2:	MOVC	INBUF, TFNAM
BLDFN:	STRCAT	DEFALT, TFNAM, INBUF
	RTS
;
WRITFN:	STX	REDRFG
	LDA	#13
	LDY	#'W'
	JSR	GETINB	;Get fnam for wr
	BMI	WRITF5	;Exit on null
	JSR	BLDFN2
	JSR	FNABUF	;Save filename in cur buf
	JSR	LINE24
	JMP	WRITF6	;Redo part but sets up R0
;
WRDEF1:	JSR	LINE24
	STX	REDRFG
WRDEF:	STX	REDTTL	;new title bar when done
	JSR	BUFFNA	;Copy buf to fna
	LDA	TFNAM
	CMP	#EOL	;
	BNE	WRITF6
	;No file name - make one up
	LDA	CURBUF
	CLC
	ADC	#'A'
	STA	TFNAM
	LDA	#EOL
	STA	TFNAM+1
	;Write the file
WRITF6:	JSR	BLDFN		;wr to default
	WRITREC	0		;Echo first
WRITF3:	JSR	PUTFIL
	;Mark buffer not modified
	BMI	WRITF2		;Error reply
	JSR	T2TOBF		;y=curbuf,a=bflg[y]
	ORA	#1		;Set Used bit
	STA	bflg,Y		;and rewrite
	LDA	#0
	STA	MODIFY
WRITF5:	LDY	#0	;Flag success
WRITF2:	RTS
;
PUTFIL:	OPEN	3, OWRIT;filnam at R0
	BPL	PUTF1
	JMP	ERROR3
PUTF1:	JSR	ENDBUF	;does SETPT
	LOADW	TEXBOT, R0
	SUBWAAR	TEXBOT, PL, R1
	WRITCHR	3
	BPL	PUTF2
	JMP	ERROR3
PUTF2:	CLOSE	3
	JSR	SWPCUR
	LDY	#0	;success
	RTS
;
;Write buffers, exit if no errors.
;
WRITEX:	JSR	WRMOD
	BMI	WRMDB2	;Go to SELBUF=0 etc
WROKEX:	JMP	(DUPSYS)
;
;Write out all modified buffers.  Keep log on screen. Stop on error.
;
WRMODB:	LDA	SELBUF
	PHA
	JSR	WRMOD	;Do writes- leaves on last buffer
	PLA
	STA	SELBUF	;Restore buffer
	tya
	bpl	wrmdb2
	rts		;On error, pop out to print error code
WRMDB2:	JSR	MOVBFC	;Move back to it
	JMP	NEXFNR
;
WRMOD:	STX	REDRFG
	JSR	MOVCBF	;Go to top buffer
	LDA	#0
	STA	SELBUF
	JSR	MOVBFC
	JSR	HOME
	;Pointing at buffer 0.
WRMD1:	LDA	CURBUF
	CMP	#14
	BEQ	WRMDEX
	JSR	T2TOBF	;Gets bflg into A
	AND	#2	;Test modify flag
	BEQ	WRMD2
	JSR	WRDEF	;Is - write to fn/bn
	BPL	WRMD3	;
	LDY	#$80	;Flag error
	RTS
wrmd3:	stx	modify	;Keep modified status
WRMD2:	JSR	PAKCUR
	JSR	BUFP1
	JMP	WRMD1	;Loop within
WRMDEX:	LDY	#0	;Success
	RTS
;
;XEP Reset/Burst Mode Control
;
XRESET:	LDY	#$16
	LDA	#$C2	;Reset XEP80
	JSR	XIOFNC
	jsr	burstm
	INC	RMARGN	;Forces right margin to get moved further right
	stx	redrfg
	stx	redttl
	RTS
;
NOBURS:	LDA	#0
	BEQ	XBC15
BURSTM:	LDA	#$01	;Burst mode
XBC15:	LDY	#$15
	JSR	XIOFNC
	rts
;
;General purpose disk utility
;
UTLY:	DB 'NXMLUR'
DKLOAD:	INY
UNLOCK:	INY
LOCK:	INY
MAKDIR:	INY
DELFIL:	INY
RENAME:	
	STX	REDRFG
	lda	xiotab,y	;Translate the cmd code
	STA	ICCOM+IOCB3
	LDA	UTLY,Y
	TAY		;Get prompt char
	LDA	#30	;Max len of name/names
	JSR	GETINB	;File name
	BMI	CRED1	;Exit if null or too big
	JSR	BLDFN2	;Add dir nam to defalt
	jsr	home
	LDY	#$30
	JSR	L$XIOC
	BPL	CRED1
	JMP	ERROR3
CRED1:	CLOSE	3
	RTS
;
; Get input filename, compare length, etc
; Length in R0
GETINB:	PHA		;sav max len
	TYA		;save prompt char
	JSR	LINE24
	JSR	L$WXEP
	WXEP	#62	;'>'
	STRLEN	DEFALT	;R1 = length
	WRITCHR	0	;Write def as prompt
	LOADIW	INBUF, R0
	JSR	UPPER	;set upper case
	LDY	R1,X	;
	INY		;new value for colcrs
	INY
	STY	COLCRS
	PLA		;max len
	JSR	RDKBRR	;Get input rec from kybd
	PHP
	JSR	RECASE
	PLP
	BMI	GETIN1	;Too long
	LDA	R0,X
	CMP	#1
	BEQ	GETIN1
	LDY	#0	;Input OK
	RTS
GETIN1:	LDY	#$80	;Flag null input
	RTS		;or error
;
;Move cursor to prompt line
;
LINE24:	PHA
	LDA	#24	;Low screen
	STA	ROWCRS
	LDA	#0
	STA	COLCRS
	JSR	BELL
	WXEP	#DLL
	STX	REDTTL	;mark title bar is gone
	PLA
	RTS
;
