;
; PAGE6 Code - Always resident - turns ROM on and off, makes
; real call to CIOV.  All data buffers stay out in real RAM.
; Version intercepts interrupts and sends them to ROM
;
CIOVF:	jsr	romon	;Enable OS
	jsr	$E456	;ROM CIOV
	jsr	romoff	;Enable EMAX
	rts		;
	;
	;ROM Off
	;
romoff:	php ! pha
	lda	#0
	sta	portb	;load with ROM off
	pla ! plp
	rts
romofv	= romoff+3
	;
	;ROM On
	;
romon:	php ! pha
	lda	#0
	sta	portb
	pla ! plp
	rts
romonv	= romon+3
	;
	;ROM on before going to DUP
	;
DUPSYS:	dw	dupr
dupr:	jsr	xreset
	jsr	romon
	jmp	($000A)
	;
	;Interrupt interceptors
	;  RESET
VFFFE:	pha
	jsr	romon
	lda	#high vfffa2
	pha
	lda	#low vfffa2
	pha
	pha		;fake ccs
VFFFE1:	jmp	0
	;  IRQ
VFFFC:	pha
	jsr	romon
	lda	#high vfffa2
	pha
	lda	#low vfffa2
	pha
	pha		;fake ccs
VFFFC1:	jmp	0
	;  NMI
VFFFA:	pha
	jsr	romon
	lda	#high vfffa2
	pha
	lda	#low vfffa2
	pha
	pha		;fake ccs
VFFFA1:	jmp	0
vfffa2:	jsr	romoff
	pla
	rti
	;
	;For CIO to find the device names
	;
PRINTD:	db  'P:',EOL
EDXEP:	db  'E:',EOL
KNAM:	DB  'K:',EOL
D1DEF:	DB  'D1:',EOL
CDEV:	DB  'D:EMAX.INI',EOL	; Device for command input
D$SPAC:	db  '         '
	;
	;XIO code conversion - for compat w/ diff OSs
	;
XIOTAB:	db	32,33,34,35,36,39	;MYDOS
;
;end of PAGE6.ASM
