Unit FLPLAY;

Interface

Uses Colors,Win,Global,Mouseu;

Procedure PlayFli(fname:string;dlgid:longint;hclid:longint);

Implementation

Uses VESA,CRT;

Type
  FLI_HEADER =  Record
                  Filesize : longint;
                  Signature : Word;
                  NumFrames : Word;
                  Width : Word;
                  Height : Word;
                  bpp : word;
                  flags : word;
                  delaytime : longint;
                  reserved : word;
                  Filler: array[1..106] of byte;
                end;

  FLI_FRAME = Record
                framesize : longint;
                signature : word;
                numchunks : word;
                reserved : array[1..8] of byte;
              end;

  CHUNK_HEADER = Record
                   Chunksize : longint;
                   chunktype : word;
                 end;


Type
 bptr = array[0..63999] of byte;

var
 hcl : handle_client;
 hdlg : handle_dialog;

 max : pbyte;
 flipal : pal_type;
 buffer : ^bptr;
 f : file;
 cd : pbyte;
 fh : fli_header;
 ch : chunk_header;
 ff : fli_frame;
 p : pal_ptr;

Procedure COLOR_64_CHUNK;
var
 np : word;
 pal : pal_type;
 skip : byte;
 x : integer;
 z : byte;
 change : byte;
 yo : integer;
 cdp : pbyte;
Begin
 cdp := cd;
 np := cdp^; inc(cdp);
 np := np+cdp^ shl 8; inc(cdp);
 z := 0;
 for x := 1 to np do
   Begin
     skip := cdp^; inc(cdp);
     inc(z,skip);
     change := cdp^; inc(cdp);
     if (change=0) then yo := 256 else yo := change;
     for change := 0 to (yo-1) do
       Begin
         p^[z].r := cdp^; inc(cdp);
         p^[z].g := cdp^; inc(cdp);
         p^[z].b := cdp^; inc(cdp);
         inc(z);
       end;
   end;
 {setnewpal;}
 {setpalettedac(flipal);}
end;

Procedure Delta_FLI_CHUNK;
var
 numequal : word;
 numchanged : word;
 ypos : byte;
 curpos : word;
 np : byte;
 skip : byte;
 size : shortint;
 color : byte;
 cdp : pbyte;
Begin
 cdp := cd;
 numequal := cdp^; inc(cdp);
 numequal := numequal + cdp^ shl 8; inc(cdp);
 numchanged := cdp^; inc(cdp);
 numchanged := numchanged + cdp^ shl 8; inc(cdp);
 for ypos := numequal to numequal+numchanged-1 do
   Begin
     np := cdp^; inc(cdp);
     curpos := (ypos shl 8)+(ypos shl 6);
      while (np>0) do
      Begin
        dec(np);
        skip := cdp^; inc(cdp); inc(curpos,skip);
        size := cdp^; inc(cdp);
        if (size>0) then
          Begin
            move(cdp^,buffer^[curpos],size);
            inc(cdp,size);
            inc(curpos,size);
          end else
          Begin
            color := cdp^; inc(cdp);
            size := -size;
            while size>0 do
              Begin
                buffer^[curpos] := color;
                dec(size);
                inc(curpos);
              end;
          end;
      end;
   end;
 remap(hcl^.data,p,320,200);
 setnewpal;
end;

Procedure FLI_BLACK_CHUNK;
Begin
  fillchar(buffer^,sizeof(buffer^),0);
end;

Procedure FLI_BYTE_RUN_CHUNK;
var
 x,ypos : word;
 np : shortint;
 size : shortint;
 color : byte;
 curpos : word;
 z : integer;
 cdp : pbyte;
 numequal,numchanged : word;
Begin
 exit;
 cdp := cd;
 for ypos := 0 to fh.height-1 do
   Begin
     curpos := (ypos shl 8)+(ypos shl 6);
     np := cdp^; inc(cdp);
     while(np>0) do
       Begin
         size := cdp^; inc(cdp);
         if (size>0) then
            Begin
              move(cdp^,buffer^[curpos],size);
              inc(cdp,size);
              inc(curpos,size);
            end else
            Begin
              size := -size;
              color := cdp^; inc(cdp);
                while (size>0) do
                  Begin
                    buffer^[curpos] := color;
                    inc(curpos);
                    dec(size);
                  end;
            end;
        dec(np);
       end;
   end;
end;

Procedure FLI_COPY_CHUNK;
Begin
  blockread(f,buffer^,64000);
end;

Procedure PlayFli(fname:string;dlgid:longint;hclid:longint);
var
 x,y : integer;
 nextcount : longint;
Begin
  flipal := modpal;
  hcl := get_handle_client(hclid);
  if hcl=nil then exit;
  buffer := @hcl^.data^;

  new(p);

  fillchar(buffer^,sizeof(buffer^),0);
  getmem(cd,64000);

  assign(f,fname);
  reset(f,1);

  blockread(f,fh,sizeof(fh));
  if (fh.signature<>$AF11) then exit;

  IF Fh.delaytime=0 THEN
		fh.delaytime:=1;

  fh.delaytime :=fh.delaytime*1000 DIV 90;

  for x := 1 to fh.numframes do
    Begin
      blockread(f,ff,sizeof(ff));
      if ff.numchunks>0 then
      for y := 1 to ff.numchunks do
        Begin
          blockread(f,ch,sizeof(ch));
          blockread(f,cd^,ch.chunksize-sizeof(ch));
          case ch.chunktype of
            12 : DELTA_FLI_CHUNK;
            16 : FLI_COPY_chunk;
            15 : FLI_BYTE_RUN_CHUNK;
            11 : COLOR_64_CHUNK;
            13 : FLI_BLACK_CHUNK;
            else
              Begin
                setnewpal;
                dispose(p);
                freemem(cd,64000);
                message_box('FLI',lpad('Unexpected Value in FLI Packet',40)+lpad('Aborting FLI Playback',40)
                            ,OK,standard_close_dialog,0);
                close(f);
                exit;
              end;
          end;
        end;
      nextcount := timercounter+fh.delaytime;
      REPEAT
         dialogmouseroutine;
         hcl := get_handle_client(hclid);
         if hcl=nil then
           Begin
             setnewpal;
             freemem(cd,64000);
             close(f);
             dispose(p);
             exit;
           end;
         buffer := @hcl^.data^;
      UNTIL (TimerCounter>nextcount) or keypressed;
     if keypressed then x := fh.numframes-1;
     while keypressed do readkey;
    end;
 close(f);
 freemem(cd,64000);
 dispose(p);
end;

end.
