Unit FontVesa;

Interface

Uses Crt,Dos,vesa,global,s_new,Remote;

Const
   NumChars        = 256;

Type
   OneChar =Array[1..20] Of Byte;
Var
   Background_Color : byte;
   Foreground_Color: byte;
   Masked_Fonts : Boolean;
   CharGap : integer;
   CharSet : Array[1..NumChars] Of OneChar;
   CharLength:Integer;

Procedure Load8x8Font(fname:string);
Procedure Load8x10Font(fname:string);
Procedure Load8x14Font(fname:string);
Procedure Load8x16Font(fname:string);
Procedure Load8x20Font(fname:string);
Procedure Textxy(s2:s_type;xpos,ypos:integer);
Procedure Textxystr(s2:string;xpos,ypos:integer);
Procedure Centerx(s:string;ypos:integer);
Procedure TC(f,b:byte);

Implementation

Uses win;

Var
      f : file;
      x,y:integer;

Procedure TC(f,b:byte);
Begin
  foreground_color := f;
  background_color := b;
end;

Procedure Load8x8Font(fname:string);
begin
fillchar(charset,sizeof(charset),0);
assign(f,fname+'.F8');
reset(f,8);
for x := 1 to 256 do
 blockread(f,charset[x],1);
close(f);
Charlength := 8;
end;

Procedure Load8x10Font(fname:string);
begin
fillchar(charset,sizeof(charset),0);
assign(f,fname+'.F10');
reset(f,10);
for x := 1 to 256 do
 blockread(f,charset[x],1);
close(f);
Charlength := 10;
end;

Procedure Load8x14Font(fname:string);
begin
fillchar(charset,sizeof(charset),0);
assign(f,fname+'.F14');
reset(f,14);
for x := 1 to 256 do
 blockread(f,charset[x],1);
close(f);
Charlength := 14;
end;

Procedure Load8x16Font(fname:string);
begin
fillchar(charset,sizeof(charset),0);
assign(f,fname+'.FNT');
reset(f,16);
for x := 1 to 256 do
 blockread(f,charset[x],1);
close(f);
Charlength := 16;
end;

Procedure Load8x20Font(fname:string);
begin
fillchar(charset,sizeof(charset),0);
assign(f,fname+'.F20');
reset(f,20);
for x := 1 to 256 do
 blockread(f,charset[x],1);
close(f);
Charlength := 20;
end;

Procedure NTChar(c:char;x,y:integer);
Const
 bpos : Array[1..8] of byte =
        (128,64,32,16,8,4,2,1);
Var
 Count : integer;
 ch : integer;
 start,finish : integer;
 startx,endx : integer;

begin
 start := 1;
 finish := charlength;
 startx := 1;
 endx := 8;
 while (y+start-1<clipy1) do inc(start);
 while (y+finish-1>clipy2) do dec(finish);
 if start>finish then exit;
 while (x+startx-1<clipx1) do inc(startx);
 while (x+endx-1>clipx2) do dec(endx);
 if startx>endx then exit;

if (c=#179) then
  Begin
    vline(x+3,y-2,x+3,y+9,foreground_color);
    vline(x+4,y-2,x+4,y+9,foreground_color);
    exit;
  end else
if (c=#197) then
  Begin
    vline(x+3,y-2,x+3,y+9,foreground_color);
    vline(x+4,y-2,x+4,y+9,foreground_color);
  end;
For ch := startx to endx do
 begin
 For Count := start to finish do
       {if (y+count-1<=clipy2) and (y+count-1>=clipy1) then}
       If not(Charset[Ord(C)+1][Count] and Bpos[ch]=0) then
           {if (x-1+ch<=Clipx2) and (x-1+ch>=Clipx1) then}
           vplot(x-1+ch,y+count-1,foreground_color,false);
{ For Count := start to finish do
       If not(Charset[Ord(C)+1][Count] and Bpos[ch+4]=0) then
           vplot(x+3+ch,y+count-1,foreground_color);}
     end;
end;

Procedure NMASKED_TChar(c:char;x,y:integer);
Const
 bpos : Array[1..8] of byte =
        (128,64,32,16,8,4,2,1);
Var
 Count : integer;
 ch : integer;
 start,finish : integer;
 startx,endx : integer;

begin
 start := 1;
 finish := charlength;
 startx := 1;
 endx := 8;
 while (y+start-1<clipy1) do inc(start);
 while (y+finish-1>clipy2) do dec(finish);
 if start>finish then exit;
 while (x+startx-1<clipx1) do inc(startx);
 while (x+endx-1>clipx2) do dec(endx);
 if startx>endx then exit;

fill(x-1+startx,y+start-1,x-1+endx,y+finish-1,background_color);
For ch := startx to endx do
 begin
 For Count := start to finish do
       {if (y+count-1<=clipy2) and (y+count-1>=clipy1) then}
       If not(Charset[Ord(C)+1][Count] and Bpos[ch]=0) then
           {if (x-1+ch<=Clipx2) and (x-1+ch>=Clipx1) then}
           vplot(x-1+ch,y+count-1,foreground_color,false);
{ For Count := start to finish do
       If not(Charset[Ord(C)+1][Count] and Bpos[ch+4]=0) then
           vplot(x+3+ch,y+count-1,foreground_color);}
     end;
end;

{Procedure NMasked_TChar(c:char;x,y:integer);
Const
 bpos : Array[1..8] of byte =
        (128,64,32,16,8,4,2,1);
Var
 Count : integer;
 ch : integer;
begin
For ch := 1 to 4 do
 begin
 For Count := 1 to CharLength do
       if (y+count-1<clipy2) and (y+count-1>clipy1) then
       If not(Charset[Ord(C)+1][Count] and Bpos[ch]=0) then
           vplot(x-1+ch,y+count-1,foreground_color) else
           vplot(x-1+ch,y+count-1,background_color);
 For Count := 1 to CharLength do
       if (y+count-1<clipy2) and (y+count-1>clipy1) then
       If not(Charset[Ord(C)+1][Count] and Bpos[ch+4]=0) then
           vplot(x+3+ch,y+count-1,foreground_color) else
           vplot(x+3+ch,y+count-1,background_color);
     end;
 end;
}

Procedure Textxy(s2:s_type;xpos,ypos:integer);
var
 s : string;
begin
 if s2.length<1 then exit;
 s := s2.pstr;
 REMOTE_Textxystr(s,xpos,ypos);
  Case Masked_Fonts of
          True : For x := 1 to s2.length do
                 NTchar(s[x],xpos+((x-1)*(8+CharGap)),ypos);
          False : For x := 1 to s2.Length do
                  NMasked_Tchar(s[x],xpos+((x-1)*(8+CharGap)),ypos);
        end;
end;

Procedure Textxystr(s2:string;xpos,ypos:integer);
var
 s : string;
begin
 REMOTE_Textxystr(s2,xpos,ypos);
 if length(s2)<1 then exit;
 s := s2;
  Case Masked_Fonts of
          True : For x := 1 to system.length(s) do
                 NTchar(s[x],xpos+((x-1)*(8+CharGap)),ypos);
          False : For x := 1 to system.Length(s) do
                  NMasked_Tchar(s[x],xpos+((x-1)*(8+CharGap)),ypos);
        end;
end;

Procedure Centerx(s:string;ypos:integer);
var
 ncw : byte;
begin
 ncw := 8+chargap;
 Textxystr(s,((vesa_info.bytesperscan shr 1)-((length(s)*ncw) div 2)),ypos);
end;

begin
 Masked_Fonts := true;
 Background_Color := Blue;
 Foreground_Color := 31;
 Load8x8font(Fontdir+'WINDOWS');
 CharGap := 0;
{ writeln('Font Extensions v1.0');
 delay(750);}
end.