{DEFINE DEBUG}
Unit Mail;

Interface

Uses TCP,PPP,SB;

Procedure GETMAIL;      {Initializes POP3 Routines}
Procedure POP_Callback; {Handles Retrieving MAIL}

Const
  POP3_Port  = 110;
  maildomain = 'ares.csd.net';
  username   = 'tsp';
  password   = 'hardnova';

var
  temp : string;
  mail_active : boolean;
  delete_mail : boolean;
  {$IFDEF DEBUG} f : text; {$ENDIF}
  msg : text;
  ts : string;
  mail_callback : longint;
  mail_stage : byte;
  mail_socket : pSOCKET;

  mail_data  : pbyte;
  mail_datap : pbyte;
  mail_datasize : word;
  mail_allocsize : word;
  num_messages  : word;
  cur_message   : word;
  total_messages : word;
  message_list  : array[1..1024] of Record
                                      mnum  : word;
                                      msize : longint;
                                    end;

Implementation

uses win,global,mimecode;

Procedure GETMAIL;
Begin
  if mail_active then
    Begin
      if (mail_stage<4) then
        Begin
          Delete_Callback(nil,get_handle_callback(mail_callback));
          Close_Socket(mail_socket);
          if (mail_allocsize)>0 then
          Begin
            freemem(mail_data,mail_allocsize);
            mail_allocsize := 0;
            mail_data := nil;
          end;
        end else
      Begin
        message_box('POP3','Mail session already in progress!',OK,4,0);
        exit;
      end;
    end;
  mail_active := true;
  mail_stage := 0;
  mail_callback := unique_id;
  mail_data := nil;
  mail_datap := nil;
  mail_allocsize := 0;
  mail_datasize := 0;
  temp := '';
  Add_Callback(mail_callback,nil,mail_callback,1);
  {$IFDEF DEBUG} assign(f,'POP3.LOG'); rewrite(f); {$ENDIF}
end;

Function Fillbuffer:boolean;
Begin
  fillbuffer := true;
  if (mail_data<>nil) then freemem(mail_data,mail_allocsize);
  Read_Socket(mail_socket,mail_datasize,mail_data);
  if mail_datasize=0 then
     Begin
       fillbuffer := false;
       exit;
     end;
  mail_datap := mail_data;
  mail_allocsize := mail_datasize;
end;

Function Getbyte(var ok:boolean):byte;
Begin
  ok := false;
  getbyte := 250;
  if (mail_datasize=0) then if not (fillbuffer) then exit;
  dec(mail_datasize);
  getbyte := mail_datap^;
  inc(mail_datap);
  ok := true;
end;

Function GetCommand:string;
var
  s : string;
  c,c2 : char;
  done : boolean;
  stage : byte;
  _ok : boolean;
Begin
  done := false;
  stage := 0;
  s := ''; getcommand := '';
  repeat
      c := char(getbyte(_ok));
      if not _ok then done := true else
      Begin
        if c=#13 then
          Begin
            c2 := char(getbyte(_ok));
            if _ok then
              Begin
                if c2=#10 then
                  Begin
                    if length(s)=0 then s := ' ';
                    done := true;
                  end else s := s + c + c2;
              end else
               Begin
                 s := s + c;
                 done := true;
               end;
          end else s := s + c;
      end;
  until done;
  if not (_ok) then
    Begin
      temp := temp+s;
      getcommand := '';
    end else
    Begin
      getcommand := temp+s;
      temp := '';
    end;
  {$IFDEF DEBUG} if length(s)>0 then writeln(f,s); {$ENDIF}
end;

Function WS(cs:string):byte;
var
 t3,t32 : ppp.pbyte;
 l : word;
Begin
  cs := cs + #13 + #10;
  l := length(cs);
  t3 := str2pbyte(cs);
  t32 := t3;
  ws := Write_Socket(mail_socket,length(cs),t3);
  freemem(t32,l);
  {$IFDEF DEBUG} write(f,cs);{$ENDIF}
end;

Procedure POP_Callback;
var
 s : string;
 x : byte;
Begin
  if not (mail_active) then exit;
  case mail_stage of
    {Open Socket}
    0 : Begin
          if mail_socket<>nil then close_socket(mail_socket);
          mail_socket := Open_Socket(maildomain,getsocket,POP3_Port);
          inc(mail_stage);
        end;
    {Check if Socket has been opened}
    1 : if mail_socket^.status=S_SOCKET_OPEN then inc(mail_stage);

    {Read Socket for greeting}
    2 : Begin
          ts := Getcommand;
          if length(ts)>0 then if pos('+OK',ts)=1 then inc(mail_stage);
        end;

    {Write Socket}
    3 : Begin
          inc(mail_stage);
          {mail_stage := 254;}
        end;

    {Send USER name}
    4 : Begin
          ws('USER '+username);
          inc(mail_stage);
        end;

    {Verify user can connect}
    5 : Begin
          ts := Getcommand;
          if length(ts)>0 then
          Begin
            if pos('+OK',ts)=1 then
              Begin
                ws('PASS '+password);
                inc(mail_stage);
              end else mail_stage := 254;
          end;
        end;

    {Password Authentication OK}
    6 : Begin
          ts := Getcommand;
          if length(ts)>0 then
           Begin
             if pos('+OK',ts)=1 then
               Begin
                 inc(mail_stage);
               end else mail_stage := 254;
           end;
        end;

    {Check to see the status of mail account}
    7 : Begin
          ws('STAT'); { Get Info }
          inc(mail_stage);
        end;

    {Check # of messages waiting, quit if 0 messages}
    8 : Begin
          ts := GetCommand;
          if length(ts)>0 then
            Begin
              if pos('+OK',ts)=1 then
                Begin
                  delete(ts,1,4); {delete +OK_}
                  s := ts;
                  x := pos(' ',s);
                  if (x>0) then delete(s,x,255);
                  num_messages := stoi(s);
                  if num_messages=0 then mail_stage := 254 else inc(mail_stage);
               end else mail_stage := 254;
            end;
        end;

     {Inquire on status of all messages!}
     9  : Begin
            ws('LIST');
            inc(mail_stage);
          end;
    10  : Begin
            ts := getcommand;
            if length(ts)>0 then
              Begin
                if pos('+OK',ts)=1 then
                 Begin
                   delete(ts,1,4);
                   x := pos(' ',ts);
                   if (x>0) then delete(ts,x,255);
                   fillchar(message_list,sizeof(message_list),0);
                   num_messages := stoi(ts); {messages to list}
                   cur_message  := 1;
                   if num_messages=0 then mail_stage := 254 else inc(mail_stage);
                 end else mail_stage := 254;
              end;
          end;
    {Fill Message # List in}
    11 : Begin
           ts := getcommand;
           if length(ts)>0 then
            Begin
              if (ts='.') then mail_stage := 12 else
              Begin
                s := ts; delete(s,1,pos(' ',s)); {message size}
                delete(ts,pos(' ',ts),255); {message #}
                message_list[cur_message].mnum  := stoi(ts);
                message_list[cur_message].msize := stoi(s);
                inc(cur_message);
              end;
            end;
         end;

    12 : Begin
           cur_message := 1;
           mail_stage := 13;
         end;

    13 : Begin
           ws('RETR '+itos(message_list[cur_message].mnum));

           assign(msg,'MSG'+itos(message_list[cur_message].mnum)+'.DAT');
           rewrite(msg);

           inc(mail_stage);
           statusbarwin(cpad('Retrieving Message #'+itos(cur_message)+'/'+itos(num_messages),40),
                        message_list[cur_message].msize);
         end;
    14 : Begin
           ts := getcommand;
           if length(ts)>0 then
            Begin
              if pos('+OK',ts)=1 then inc(mail_stage) else
                 Begin
                   statusbarwinclose;
                   mail_stage := 254;
                   close(msg);
                 end;
            end;
         end;
    15  : Begin
            ts := getcommand;
            if length(ts)>0 then
               Begin
                 if (ts='.') then
                   Begin
                     if delete_mail then inc(mail_stage) else
                       Begin
                         statusbarwinclose;
                         close(msg);
                         inc(cur_message);
                         if (cur_message>num_messages) then mail_stage := 254 else
                         mail_stage := 13;
                       end;
                   end else
                   Begin
                     update_bar(length(ts)+2);
                     writeln(msg,ts);
                   end;
               end;
          end;
    16  : Begin
            statusbarwinclose;
            ws('DELE '+itos(message_list[cur_message].mnum));
            inc(mail_stage);
          end;
    17  : Begin
            ts := getcommand;
            if length(ts)>0 then
             Begin
               close(msg);
               inc(cur_message);
               if not(pos('+OK',ts)=1) then mail_stage := 254 else
                Begin
                  if (cur_message>num_messages) then mail_stage := 254 else
                   mail_stage := 13;
                end;
             end;
          end;
    253 : Begin
            message_box('POP3','Session did not terminate properly!',OK,4,0);
            mail_stage := 252;
          end;
    254 : Begin
            ws('QUIT');
            inc(mail_stage);
          end;

    255 : Begin
            ts := GetCommand;
            if length(ts)>0 then
            Begin
              if num_messages=0 then message_box('POP3','No Mail on Server!',OK,4,0) else
                                     message_box('POP3','Total of '+itos(num_messages)+' Message(s) Received',OK,4,0);

              Delete_Callback(nil,get_handle_callback(mail_callback));
              Close_Socket(mail_socket);
              mail_stage := 253;
              if (mail_allocsize)>0 then
               Begin
                 freemem(mail_data,mail_allocsize);
                 mail_allocsize := 0;
                 mail_data := nil;
               end;
              mail_active := false;
              {$IFDEF DEBUG} close(f);{$ENDIF}
            end;
          end;
  end;
end;

Begin
  mail_active := false;
  mail_socket := nil;
  delete_mail := false;
end.
