{$G+}{$F+}
unit vesa;

Interface

uses crt,dos,mouseu,binu{$IFDEF DPMI},winapi{$ENDIF};

Type
  BMP_HEADER = Record
                 bftype : array[1..2] of char;
                 bfsize : longint;
                 bfreserved1 : word;
                 bfreserved2 : word;
                 bfoffbits : longint;
                 bisize  : longint;
                 biwidth : longint;
                 biheight : longint;
                 biplanes : word;
                 bibitcount : word;
                 bicompression : longint;
                 bisizeimage : longint;
                 bixpelspermeter : longint;
                 biypelspermeter : longint;
                 biclrused : longint;
                 biclrimportant : longint;
                 bmicolors : array[1..1024] of byte;
               end;
  pal_ptr = ^pal_type;
  pal_type = Array[0..255] of Record
                               r,g,b : byte;
                             end;
  mimage = Record
              mousecursor : array[0..15,0..15] of byte;
              imagesave : array[0..15,0..15] of byte;
              xpos,ypos : integer;
           end;

Const
  _640x400x256 = $100;
  _640x480x256 = $101;
  _800x600x256 = $103;
  _1024x768x256 = $105;
  _1280x1024x256 = $107;
  lores  = $101;
  medres = $103;
  hires  = $105;
  superhires = $107;

  COPY_PUT = 0;
  MASKED_PUT = 1;
  AND_PUT = 2;
  XOR_PUT = 3;

var
  maxx,maxy : word;
  clipx1,clipx2,clipy1,clipy2 : integer;
  wclipx1,wclipx2,wclipy1,wclipy2 : integer;
  page : word;
  pal : pal_type;
  ms : boolean;
  mcursor : mimage;
  usewindowclip : boolean;

  lfb : boolean;
  VESA_selector : word;
  VESA_LFB_START : pointer;

  Setbank:Procedure;
  bmppal : array[1..1024] of byte;
  win : bmp_header;

{$I VESA.VAR}

Procedure ClipSet(x1,y1,x2,y2:integer);
Procedure WindowClip(x1,y1,x2,y2:integer);
Procedure setpaletteDAC(pal : pal_type);
Function  MakePalette(bh:bmp_header):pal_ptr;
Procedure LoadPalette(f:string);
Function  setvesamode(video_mode:word;useLFB:boolean):boolean;
Procedure getvesainfo(vm:word);
Procedure CheckVesa;
procedure WriteIt;

Procedure Fill(x1,y1,x2,y2:integer;color:byte);
Procedure InitMouse;
Procedure HandleMouse;far;
Procedure sm;
Procedure hm;
Procedure SetVesaMouse(mask: graphcursmasktype);
Procedure Hline(x1,x2,y:integer;color:byte);
Procedure Vrline(y1,y2,x:integer;color:byte);
Procedure Box(x1,y1,x2,y2:integer;color:byte);

procedure vline(x1,y1,x2,y2:Word;Color:Byte);
Procedure VPlot(xpos,ypos:word;color:byte);
Procedure vhrzline(y,x1,x2:integer;c:byte);
Procedure vputrect(buffer:Pointer;x,y,xlen,ylen,width:word;PutType:Byte);
Procedure vgetrect(buffer:Pointer;x,y,xlen,ylen,width:word);
Function  VGet(xpos,ypos:word):byte;
Function  GetMAXX:Word;
Function  GetMAXY:Word;
procedure EnableVGA;
procedure DisableVGA;
Procedure SETPAL(Palette:Pointer);
Procedure FadeOut;
Procedure WriteBmp(fname:string);


implementation

Uses colors;

Function BitSet(b:word;o:byte):boolean;
var
 w : word;
Begin
  w := 1 shl o;
  if (b and w)=w then bitset := true else bitset := false;
end;

Procedure SETPAL(Palette:Pointer);
Var
   PS,
   PO   : Word;
Begin
     ps := Seg(Palette^);
     po := Ofs(Palette^);
     Asm
        push ds
        mov  si,po
        mov  ax,ps
        mov  ds,ax
        mov  cx,255
        mov  dx,cx
        add  cx,cx
        add  cx,dx
        mov  al,0
        mov  dx,03c8h
        out dx,al
        inc dx
        cld
        rep outsb
        pop ds
     End;
End;


Procedure EnableVGA;Assembler;
Asm
   mov  dx,03c4h
   mov  al,1
   out  dx,al
   inc  dx
   in   al,dx
   and  al,0dfh
   out  dx,al
End;

Procedure DisableVGA;Assembler;
Asm
   mov  dx,03c4h
   mov  al,1
   out  dx,al
   inc  dx
   in   al,dx
   or   al,20h
   out  dx,al
End;

function GetMAXX;
Begin
     GetMAXX := vesa_info.scrwidth;
End;

function GetMAXY;
Begin
     GetMAXY := vesa_info.scrheight;
End;

{$IFDEF DPMI}
type
  TDPMIRegs = record
    edi, esi, ebp, reserved, ebx, edx, ecx, eax: LongInt;
    flags, es, ds, fs, gs, ip, cs, sp, ss: Word;
  end;

  PBuffer = ^byte;

var
  R: TDPMIRegs;
  Address : LongInt;
  TempBuf : PBuffer;

function DPMIRealInt(IntNo, CopyWords: Word; var R: TDPMIRegs): Boolean; assembler;
asm
  mov ax, 0300h
  mov bx, IntNo
  mov cx, CopyWords
  les di, R
  int 31h
  jc @error
  mov ax, 1
  jmp @done
@error:
  xor ax, ax
  @Done:
end;

function LongFromBytes(HighByte, LowByte: Byte): LongInt; assembler;
asm
  mov dx, 0
  mov ah, HighByte
  mov al, LowByte
end;

function LongFromWord(LoWord: Word): LongInt; assembler;
asm
  mov dx, 0
  mov ax, LoWord;
end;

function RealToProt(P: Pointer; Size: Word; var Sel: Word): Pointer;far;
begin
  SetSelectorBase(Sel, LongInt(HiWord(LongInt(P))) Shl 4 + LoWord(LongInt(P)));
  SetSelectorLimit(Sel, Size);
  RealToProt := Ptr(Sel, 0);
end;

Procedure GetVesaInfo(vm:word);
begin
{  FillChar(R, SizeOf(TDPMIRegs), #0);
  R.Eax := LongFromWord($4F01);
  R.Ecx := LongFromWord(vm);
  Address := GlobalDosAlloc(sizeof(vesa_info));
  R.es := HIWord(Address);
  DPMIRealInt($10,sizeof(vesa_info) shr 1,R);
  TempBuf := Ptr(LoWord(Address), 0);
  move (tempbuf^,vesa_info,sizeof(vesa_info));
  GlobalDosFree(LoWord(Address));
}
{  FillChar(R, SizeOf(TDPMIRegs), #0);
  R.Eax := LongFromWord($4F01);
  R.Ecx := LongFromWord(vm);
  Address := GlobalDosAlloc(sizeof(vesa_info));
  if address=0 then
    Begin
      writeln('Shit on me!');
      delay(4000);
      terminate_bad;
    end;
  R.es := HIWord(Address);
  DPMIRealInt($10,sizeof(vesa_info) shr 1,R);
  TempBuf := Ptr(LoWord(Address), 0);
  move (tempbuf^,vesa_info,sizeof(vesa_info));
  GlobalDosFree(LoWord(Address));
}
 with vesa_info do
  Begin
      modeattr      := 155; { Mode Attributes }
      winaattr      := 7; { Window A attributes }
      winbattr      := 0; { Window B attributes }
      granularity   := 64; { Window Granularity in K }
      windowsize    := 64; { Window Size in K }
      winaseg       := 40960; { Window A Start segment }
      winbseg       := 0; { Window B Start segment }
      winfunctptr   := nil {ptr(49152,17986)};
      bytesperscan  := 800; { Bytes per scan line }
      scrwidth      := 800; { Screen width in pixels }
      scrheight     := 600; { Screen height in pixels }
      charwidth     := 8; { Char width in pixels }
      charheight    := 8; { Char Height in pixels }
      nummemplanes  := 1; { Number of memory planes }
      bitsperpixel  := 8; { Bits per pixel }
      numofbanks    := 1; { Number of banks }
      memmodel      := 4; { Memory model }
      banksize      := 0; { Size of bank in K }
      numimgpages   := 11; { Number of images pages }
  end;
end;

Procedure CheckVesa;
begin
  FillChar(R, SizeOf(TDPMIRegs), #0);
  R.Eax := LongFromWord($4F00);
  Address := GlobalDosAlloc(sizeof(vesa_oem));
  R.es := HIWord(Address);
  DPMIRealInt($10,sizeof(vesa_oem) shr 1,R);
  TempBuf := Ptr(LoWord(Address), 0);
  move (tempbuf^,vesa_oem,sizeof(vesa_oem));
  GlobalDosFree(LoWord(Address));
end;
{$ELSE}
Procedure getvesainfo(vm:word);
var
 p : pointer;
begin
  p := ptr(seg(vesa_info),ofs(vesa_info));
asm
 mov ax,$4f01
 mov cx,vm
 les di,p
 int $10
end;
end;

Procedure checkvesa;
var
 r : registers;
Begin
 r.ax := $4f00;
 r.es := seg(vesa_oem);
 r.di := ofs(vesa_oem);
 intr($10,r);
end;
{$ENDIF}

Procedure SMODE(mode:word;uselfb:boolean);
var
 sel : word;
 p : pointer;
 p2 : pointer;
Begin
asm
  mov bx,mode
  mov al,uselfb
  cmp al,0
  jz  @continue
  add bx,16384 {Request LFB}
@continue:
  mov ax,4f02h
  int 10h

  mov status_al,al
  mov status_ah,ah
end;
if uselfb then lfb := true;

{$IFNDEF DPMI}
  setbank := vesa_info.winfunctptr;
{$ENDIF}

bankend := vesa_info.windowsize shl 10;
if bankend=0 then dec(bankend);

scx := 0;
sdx := 0;
actstart := 0;
visstart := 0;
pageno := 0;
pagelen := vesa_info.scrheight;
end;

Procedure vgetrect(buffer:Pointer;x,y,xlen,ylen,width:word);assembler;
asm
  pusha
  push ds

  mov cx,ylen
  les di,buffer
  dec word ptr xlen
@@loop:
  push di
  push cx
  mov ax,y
  mov bx,x

  mul  vesa_info.bytesperscan
  add  ax,bx
  jnc  @@l1
  inc  dx
@@l1:
  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange:
  pop dx
  pop cx

  mov si,ax
  mov cx,BankEnd
  sub cx,si
  mov bx,xlen
  cmp bx,cx
  ja @@bchange
  mov cx,bx
@@bchange:
  sub bx,cx
@@draw:
  push ds
  mov ds,vesa_info.winaseg
  inc cx
  shr cx,1
  rep movsw
  adc cx,cx
  rep movsb
  pop ds
  cmp bx,0
  je  @@end
  inc  dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange2
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange2:
  pop dx
  pop cx

  dec bx
  mov cx,bx
  xor bx,bx
  xor si,si
  jmp @@draw

@@end:
  pop cx
  pop di
  add di,width
  inc word ptr y
  dec cx
  cmp cx,0
  jle @@donothing
  jmp @@loop
@@donothing:
  pop ds
  popa
end;

Procedure vputrect(buffer:Pointer;x,y,xlen,ylen,width:word;PutType:Byte);assembler;
var
 bufseg,bufofs : word;
 gran,was,bps : word;
 cb,be : word;
asm
   pusha
   push ds
   les di,buffer
   mov bufseg,es
   mov bufofs,di

   mov ax,vesa_info.bytesperscan
   mov bps,ax
   mov ax,vesa_info.granularity
   mov gran,ax
   mov ax,currentbank
   mov cb,ax
   mov ax,bankend
   mov be,ax

   cmp word ptr ylen,0
   ja @@ok
   jmp @@donothing
@@ok:
   mov es,vesa_info.winaseg
   mov cx,ylen
   mov ds,bufseg
   mov si,bufofs
   dec word ptr xlen
@@loop:
   push si
   push cx
   mov ax,y
   mov bx,x

   mul  bps
   add  ax,bx
   jnc  @@l1
   inc  dx

@@l1:
   push cx
   push dx
   mov cx,gran
   shl dx,cl
   cmp dx,cb
   jz @@nochange
   mov cb,dx
   push ax
   push bx
   xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
   pop bx
   pop ax
@@nochange:
   pop dx
   pop cx

   mov di,ax
   mov cx,Be
   sub cx,di
   mov bx,xlen
   cmp bx,cx
   ja @@bchange
   mov cx,bx
@@bchange:
   sub bx,cx
@@draw:
   inc cx
   cmp byte ptr puttype,XOR_PUT
   jnz @@n1
@@xorloop:
   lodsb
@@noand1:
   xor es:[di],al
   inc di
   loop @@xorloop
   jmp @@putok
@@n1:
   cmp byte ptr puttype,AND_PUT
   jnz @@n2
@@andloop:
   lodsb
@@noand2:
   and es:[di],al
   inc di
   loop @@andloop
   jmp @@putok
@@n2:
   cmp byte ptr puttype,MASKED_PUT
   jnz @@n3
@@transloop:
   lodsb
@@noand3:
   or al,al
   jz  @@dontput
   mov es:[di],al
@@dontput:
   inc di
   loop @@transloop
   jmp @@putok
@@n3:
   cld
   shr cx,1
   cmp cx,0
   jz @@33
@@11:
   lodsw
@@noand4:
   stosw
   loop @@11
@@33:
   adc cx,cx
   jz @@putok
@@22:
   lodsb
@@noand5:
   stosb
@@putok:
   cmp bx,0
   je  @@end
   inc  dx

   push cx
   push dx
   mov cx,gran
   shl dx,cl
   cmp dx,cb
   jz @@nochange2
   mov cb,dx
   push ax
   push bx
   xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
   pop bx
   pop ax
@@nochange2:
   pop dx
   pop cx

   dec bx
   mov cx,bx
   xor bx,bx
   xor di,di
   jmp @@draw
@@end:
   pop cx
   pop si
   add si,width
   inc word ptr y
   dec cx
   jz @@donothing
   jmp @@loop
@@donothing:
   pop ds
   mov ax,cb
   mov currentbank,ax
   popa
end;


Procedure fillblock(x1,y1,x2,y2:word;color:word);assembler;
asm
  push ds
  push es
  push si
  push di

  mov es,vesa_info.winaseg
  mov ax,y2
  cmp ax,y1
  ja  @@yok
  mov bx,y2
  mov ax,y1
  mov y2,ax
  mov y1,bx

@@yok:
  mov ax,x2
  cmp ax,x1
  ja  @@xok
  mov bx,x2
  mov ax,x1
  mov x2,ax
  mov x1,bx

@@xok:
   mov cx,y2
   sub cx,y1
   jz  @@donothing
   inc cx
@@loop:
   push cx
   mov ax,y1
   mov bx,x1

   mul  vesa_info.bytesperscan
   add  ax,bx
   jnc  @@l1
   inc  dx
 @@l1:
   push cx
   push dx
   mov cx,vesa_info.granularity
   shl dx,cl
   cmp dx,currentbank
   jz @@nochange
   mov currentbank,dx
   push ax
   push bx
   xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
   pop bx
   pop ax
@@nochange:
   pop dx
   pop cx

   mov di,ax
   mov ax,Color
   mov ah,al
   mov cx,BankEnd
   sub cx,di
   mov bx,x2
   sub bx,x1
   cmp bx,cx
   ja @@bchange
   mov cx,bx
@@bchange:
   sub bx,cx
@@draw:
   inc cx
   shr cx,1
   rep stosw
   adc cx,cx
   rep stosb
   cmp bx,0
   je  @@end
   inc  dx

   push cx
   push dx
   mov cx,vesa_info.granularity
   shl dx,cl
   cmp dx,currentbank
   jz @@nochange2
   mov currentbank,dx
   push ax
   push bx
   xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
   pop bx
   pop ax
@@nochange2:
   pop dx
   pop cx

   dec bx
   mov cx,bx
   xor bx,bx
   xor di,di
   jmp @@draw
@@end:
   pop cx
   dec cx
   inc word ptr y1
   cmp cx,0
   jnz @@loop
@@donothing:
   pop di
   pop si
   pop es
   pop ds
end;


Procedure Fill(x1,y1,x2,y2:integer;color:byte);
var
 x,y : integer;
 draw : boolean;
Begin
    if (x1<clipx1) and (x2<clipx1) then exit;
    if (x1>clipx2) and (x2>clipx2) then exit;
    if (y1<clipy1) and (y2<clipy1) then exit;
    if (y1>clipy2) and (y2>clipy2) then exit;
    if (x1>x2) then exit;
    if (y1>y2) then exit;
    if x1<clipx1 then x1 := clipx1;
    if x2>clipx2 then x2 := clipx2;
    if y1<clipy1 then y1 := clipy1;
    if y2>clipy2 then y2 := clipy2;
    fillblock(x1,y1,x2,y2,color);
end;

Procedure setpaletteDAC(pal : pal_type);
 const
   DAC_WI = $3c8;
   DAC_DI = $3c9;
var
 i : integer;
Begin
   for i := 0 to 255 do
    Begin
      port[DAC_WI] := i;
      port[DAC_DI] := pal[i].r;
      port[DAC_DI] := pal[i].g;
      port[DAC_DI] := pal[i].b;
    end;
end;

Procedure LoadPalette(f:string);
var
 t : file of pal_type;
Begin
 assign(t,f);
 reset(t);
 read(t,pal);
 setpalettedac(pal);
end;


Function MakePalette(bh:bmp_header):pal_ptr;
var
 x : byte;
 z : integer;
 cpal : pal_ptr;
Begin
 new(cpal);
 z := 1;
 for x := 0 to 255 do
  Begin
    cpal^[x].b := bh.bmicolors[z] shr 2;
    cpal^[x].g := bh.bmicolors[z+1] shr 2;
    cpal^[x].r := bh.bmicolors[z+2] shr 2;
    inc(z,4);
  end;
 Makepalette := cpal;
end;


procedure WriteIt;
var
  i: Integer;
begin
  with vesa_info do begin
   writeln('MODE ATTRIBUTE   : ',modeattr);{ Mode Attributes }
   writeln('WIN A ATTRIBUTE  : ',winaattr    );  { Window A attributes }
   writeln('WIN B ATTRIBUTE  : ',winbattr    );  { Window B attributes }
   writeln('GRANULARITY      : ',granularity );  { Window Granularity in K }
   writeln('WINDOW SIZE      : ',windowsize  );  { Window Size in K }
   writeln('WIN A SEGMENT    : ',winaseg     );  { Window A Start segment }
   writeln('WIN B SEGMENT    : ',winbseg     );  { Window B Start segment }
   writeln('WIN FUNCT PTR    : ',seg(winfunctptr),':',ofs(winfunctptr));
   writeln('BYTES PER SCAN   : ',bytesperscan);  { Bytes per scan line }
   writeln('SCREEN WIDTH     : ',scrwidth    );  { Screen width in pixels }
   writeln('SCREEN HEIGHT    : ',scrheight   );  { Screen height in pixels }
   writeln('CHARACTER WIDTH  : ',charwidth   );  { Char width in pixels }
   writeln('CHARACTER HEIGHT : ',charheight  );  { Char Height in pixels }
   writeln('NUM MEM PLANES   : ',nummemplanes);  { Number of memory planes }
   writeln('BITS PER PIXEL   : ',bitsperpixel);  { Bits per pixel }
   writeln('NUM BANKS        : ',numofbanks );   {Number of banks }
   writeln('MEMORY MODEL     : ',memmodel   );   { Memory model }
   writeln('BANKSIZE         : ',banksize   );   { Size of bank in K }
   writeln('NUM IMG PAGES    : ',numimgpages);   { Number of images pages }
  end;
 readln;
end;

Function setvesamode(video_mode:word;useLFB:boolean):boolean;
Begin
  setvesamode := false;
  getvesainfo(video_mode); {writeit;}
  smode(video_mode,uselfb);
  if (status_al<>$4f) then exit;
  if (status_ah<>0) then exit;
{  case status_ah of
   $0 : writeln('Call Successful');
   $1 : writeln('Call Failed');
   $2 : writeln('Software Supports function, hardware does not!');
   $3 : writeln('Function call invalid in current video mode!');
  end;
}
  currentbank := 0;
  vputmode := COPY_PUT;
  vesa_info.winaseg := SEGA000;

  maxx := getmaxx;
  maxy := getmaxy;
  mousemaxx := maxx;
  mousemaxy := maxy;
  clipx1 := 0;
  clipx2 := maxx;
  clipy1 := 0;
  clipy2 := maxy;
  wclipx1 := 0;
  wclipx2 := maxx;
  wclipy1 := 0;
  wclipy2 := maxy;
  setvesamode := true;
end;

Procedure DrawMouse;
var
 x,y : integer;
Begin
 for x := 0 to 15 do
   for y := 0 to 15 do
     if (mcursor.mousecursor[x,y]>0) then vplot(x+mcursor.xpos,y+mcursor.ypos,15);
end;

Procedure SaveImage(xpos,ypos:integer);
var
 x,y : integer;
Begin
 mcursor.xpos := xpos;
 mcursor.ypos := ypos;
 for x := 0 to 15 do
   for y := 0 to 15 do
     mcursor.imagesave[x,y] := vget(mcursor.xpos+x,mcursor.ypos+y);
end;

Procedure RestoreImage;
var
 x,y : integer;
Begin
 for x := 0 to 15 do
   for y := 0 to 15 do
     vplot(mcursor.xpos+x,mcursor.ypos+y,mcursor.imagesave[x,y]);
end;

Procedure InitMouse;
var
 r : registers;
Begin
  resetmouse;
  getbuttonstatus;
  setvesamouse(standardshapecurs);
end;

Procedure SetVesaMouse(mask: graphcursmasktype);
var
 x,y,z : integer;
 s,s2 : string[16];

function choi(c:char):integer;
var
 e,x : integer;
Begin
 val(c,x,e);
 choi := x;
end;
Begin
 for y := 0 to 15 do
   Begin
     s := wordtobin(mask.mask[1][y]);
     s2 := wordtobin(mask.mask[0][y]);
     for x := 0 to 15 do
         mcursor.mousecursor[x,y] := choi(s[x+1]);
   end;
end;

Procedure HandleMouse;
Begin
   if (ms) then
    Begin
      getbuttonstatus;
      if ((mousex shr 1)<>mcursor.xpos) or (mousey<>mcursor.ypos) then
      Begin
        restoreimage;
        saveimage(mousex shr 1,mousey);
        drawmouse;
      end;
    end;
end;

Procedure sm;
Begin
  if (ms) then exit;
   getbuttonstatus;
   saveimage(mousex shr 1,mousey);
   drawmouse;
  ms := true;
end;

Procedure hm;
Begin
 if not(ms) then exit;
 restoreimage;
 ms := false;
end;

Procedure VPlot(xpos,ypos:word;color:byte);assembler;
asm
  mov es,vesa_info.winaseg
  mov bx,xpos
  mov ax,ypos

  mul  vesa_info.bytesperscan
  add  ax,bx
  jnc  @@l1
  inc  dx
@@l1:
  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange
  mov currentbank,dx

  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax

@@nochange:
  pop dx
  pop cx

  mov di,ax
  mov al,color

  mov es:[di],al
end;

Function VGet(xpos,ypos:word):byte;assembler;
asm
  mov es,vesa_info.winaseg
  mov bx,xpos
  mov ax,ypos

  mul  vesa_info.bytesperscan
  add  ax,bx
  jnc  @@l1
  inc  dx
@@l1:
  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange
  mov currentbank,dx

  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax

@@nochange:
  pop dx
  pop cx

  mov di,ax
  mov al,es:[di]
  xor ah,ah
@@lpdone:
end;


Procedure Hline(x1,x2,y:integer;color:byte);
var
 x : integer;
Begin
    if (x1<clipx1) and (x2<clipx1) then exit;
    if (x1>clipx2) and (x2>clipx2) then exit;
    if x1<clipx1 then x1 := clipx1;
    if x2>clipx2 then x2 := clipx2;
    if y<clipy1 then exit;
    if y>clipy2 then exit;
    if x1>x2 then exit;
    vhrzline(y,x1,x2,color);
end;

Procedure Vrline(y1,y2,x:integer;color:byte);
var
 y : integer;
Begin
    if (y1<clipy1) and (y2<clipy1) then exit;
    if (y1>clipy2) and (y2>clipy2) then exit;
    if y1<clipy1 then y1 := clipy1;
    if y2>clipy2 then y2 := clipy2;
    if x>Clipx2 then exit;
    if x<Clipx1 then exit;
    if y1>y2 then exit;

    {vline(x,y1,x,y2,color);}
    for y := y1 to y2 do vplot(x,y,color);
end;

Procedure Box(x1,y1,x2,y2:integer;color:byte);
Begin
  Hline(x1,x2,y1,color);
  Hline(x1,x2,y2,color);
  Vrline(y1,y2,x1,color);
  Vrline(y1,y2,x2,color);
end;

Procedure AdjustWindowClip;
Begin
 if (wclipx1>clipx1) then clipx1 := wclipx1;
 if (wclipy1>clipy1) then clipy1 := wclipy1;
 if (wclipx2<clipx2) then clipx2 := wclipx2;
 if (wclipy2<clipy2) then clipy2 := wclipy2;
end;

Procedure ClipSet(x1,y1,x2,y2:integer);
Begin
 if (x1<0) then x1 := 0;
 if (x2>maxx) then x2 := maxx;
 if (y1<0) then y1 := 0;
 if (y2>maxy) then y2 := maxy;
 clipx1 := x1;
 clipy1 := y1;
 clipx2 := x2;
 clipy2 := y2;
 if (usewindowclip) then adjustwindowclip;
end;

Procedure WindowClip(x1,y1,x2,y2:integer);
Begin
 if (x1<0) then x1 := 0;
 if (x2>maxx) then x2 := maxx;
 if (y1<0) then y1 := 0;
 if (y2>maxy) then y2 := maxy;
 wclipx1 := x1;
 wclipy1 := y1;
 wclipx2 := x2;
 wclipy2 := y2;
end;


Procedure vhrzline(y,x1,x2:integer;c:byte);assembler;
asm
  mov es,vesa_info.winaseg
  mov ax,x2        {x2 = bp+8   x1 = bp+10  y = bp + 12 c = bp+6}
  cmp ax,x1
  ja  @@xok
  mov bx,x2
  mov ax,x1
  mov x2,ax
  mov x1,bx
@@xok:
  mov ax,y
  mov bx,x1

  mul  vesa_info.bytesperscan
  add  ax,bx
  jnc  @@l1
  inc  dx
@@l1:
  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange:
  pop dx
  pop cx


  mov di,ax
  mov ax,word ptr c
  mov ah,al
  mov cx,BankEnd
  sub cx,di
  mov bx,x2
  sub bx,x1
  cmp bx,cx
  ja @@bchange
  mov cx,bx
@@bchange:
  sub bx,cx
@@draw:
  inc cx
  shr cx,1
  rep stosw
  adc cx,cx
  rep stosb
  cmp bx,0
  je  @@end
  inc  dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange2
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange2:
  pop dx
  pop cx

  dec bx
  mov cx,bx
  xor bx,bx
  xor di,di
  jmp @@draw
@@end:
end;

Procedure Vline(x1,y1,x2,y2:Word;Color:Byte);assembler;
var
  _DX,_DY,incr1,incr2 : word;
asm
  mov es,vesa_info.winaseg
  mov ax,y1
  mov bx,x1

  mul  vesa_info.bytesperscan
  add  ax,bx
  jnc  @@l1
  inc  dx
@@l1:
  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange:
  pop dx
  pop cx

  mov di,ax

  mov ax,x1
  sub ax,x2
  jg @@ld1
  neg ax
@@ld1:
  mov _DX,ax
  mov ax,y1
  sub ax,y2
  jg @@ld2
  neg ax
@@ld2:
  mov _DY,ax
  cmp ax,_DX
  jle @@xline
  jmp @@yline

@@xline:
  mov cx,_DX
  sal ax,1
  mov incr1,ax
  sub ax,_DX
  mov bx,ax

  mov ax,_DY
  sub ax,_DX
  sal ax,1
  mov incr2,ax

  mov _DX,0
  mov ax,x1
  sub ax,x2

  jg @@ld3
  mov _DX,1
@@ld3:
  mov _DY,0
  mov ax,y1
  sub ax,y2
  jg @@ld5
  mov _DY,1
@@ld5:
  mov ax,word ptr color

  mov es:[di],al

  cmp cx,0
  je @@xloopend
@@xloop:
  cmp _DX,0
  je @@ld7
  inc di
  jnz @@ld8
  inc dx
  push dx

  pop  dx
  jmp @@ld8
@@ld7:
  dec di
  jnz @@ld8
  dec dx
  push dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange2
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange2:
  pop dx
  pop cx

  pop dx
@@ld8:
  cmp bx,0
  jge @@ld9
  add bx,incr1
  jmp @@ld11
@@ld9:
  add bx,incr2
  cmp _DY,0
  je @@ld10
  add di,vesa_info.bytesperscan
  jnc @@ld11
  inc dx
  push dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange3
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange3:
  pop dx
  pop cx

  pop dx
  jmp @@ld11
@@ld10:
  sub di,vesa_info.bytesperscan
  jnc @@ld11
  dec dx
  {push dx}

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange4
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange4:
  pop dx
  pop cx

  {pop dx}
@@ld11:

  mov es:[di],al

  dec cx
  cmp cx,0
  jle @@xloopend
  jmp @@xloop
@@xloopend:
  jmp @@done

@@yline:
  mov cx,_DY
  mov ax,_DX
  sal ax,1
  mov incr1,ax
  sub ax,_DY

  mov bx,ax
  mov ax,_DX
  sub ax,_DY
  sal ax,1
  mov incr2,ax

  mov _DX,0
  mov ax,x1
  sub ax,x2
  jg @@ld12
  mov _DX,1
  @@ld12:
  mov _DY,0
  mov ax,y1
  sub ax,y2
  jg @@ld13
  mov _DY,1
@@ld13:

  mov ax,[bp+6]

  mov es:[di],al

  cmp cx,0
  je  @@yloopend
@@yloop:
  cmp _DY,0
  je @@ld14

  add di,vesa_info.bytesperscan
  jnc @@ld15
  inc dx
  push dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange5
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange5:
  pop dx
  pop cx

  pop dx
  jmp @@ld15
@@ld14:
  sub di,vesa_info.bytesperscan
  jnc @@ld15
  dec dx
  push dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange6
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange6:
  pop dx
  pop cx

  pop dx
@@ld15:
  cmp bx,0
  jge @@ld16
  add bx,incr1
  jmp @@ld18
@@ld16:
  add bx,incr2
  cmp _DX,0
  je @@ld17
  inc di
  jnz @@ld18
  inc dx
  push dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange7
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange7:
  pop dx
  pop cx

  pop dx
  jmp @@ld18
@@ld17:
  dec di
  jnz @@ld18
  dec dx
  push dx

  push cx
  push dx
  mov cx,vesa_info.granularity
  shl dx,cl
  cmp dx,currentbank
  jz @@nochange8
  mov currentbank,dx
  push ax
  push bx
  xor bx,bx
   {$IFDEF DPMI}
     mov ax,4f05h
     int 10h
   {$ELSE}
     call Setbank
   {$ENDIF}
  pop bx
  pop ax
@@nochange8:
  pop dx
  pop cx
  pop dx
@@ld18:
  mov es:[di],al
  dec cx
  cmp cx,0
  jle @@yloopend
  jmp @@yloop
@@yloopend:
@@done:
end;


Procedure FadeOut;assembler;
    Label OneCycle,ReadLoop,DecLoop,Continue,Retr,Wait,Retr2,Wait2;
      Asm
        PUSH  AX
        PUSH  BX
        PUSH  CX
        PUSH  DX

        MOV   CX,64
OneCycle:

        MOV     DX,3DAh
Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait
Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr

        MOV   DX,03C7h
        XOR   AL,AL
        OUT   DX,AL
        INC   DX
        INC   DX
        XOR   BX,BX
ReadLoop:
        IN    AL,DX
        MOV   Byte Ptr pal[BX],AL
        INC   BX
        CMP   BX,256*3
        JL    ReadLoop

        XOR   BX,BX
DecLoop:
        CMP   Byte Ptr pal[BX],0
        JE    Continue
        DEC   Byte Ptr pal[BX]

Continue:
        INC   BX
        CMP   BX,256*3
        JL    DecLoop

        MOV     DX,3DAh
Wait2:  IN      AL,DX
        TEST    AL,08h
        JZ      Wait2
Retr2:  IN      AL,DX
        TEST    AL,08h
        JNZ     Retr2

        MOV   DX,03C8h
        MOV   AL,0
        OUT   DX,AL
        INC   DX
        MOV   SI,OFFSET pal
        CLD
        PUSH  CX
        MOV   CX,256*3
        REP   OUTSB
        POP   CX

        LOOP  OneCycle
        POP   DX
        POP   CX
        POP   BX
        POP   AX
End; { FadeOut }

Procedure FadeOutw;assembler;
    Label OneCycle,ReadLoop,DecLoop,Continue,Retr,Wait,Retr2,Wait2;
asm
        MOV   CX,64
OneCycle:

        MOV     DX,3DAh
Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait
Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr

        MOV   DX,03C7h
        XOR   AL,AL
        OUT   DX,AL
        INC   DX
        INC   DX
        XOR   BX,BX
ReadLoop:
        IN    AL,DX
        MOV   Byte Ptr pal[BX],AL
        INC   BX
        CMP   BX,256*3
        JL    ReadLoop

        XOR   BX,BX
DecLoop:        
        CMP   Byte Ptr pal[BX],63
        JE    Continue
        INC   Byte Ptr pal[BX]
Continue:
        INC   BX
        CMP   BX,256*3
        JL    DecLoop

        MOV     DX,3DAh
Wait2:  IN      AL,DX
        TEST    AL,08h
        JZ      Wait2
Retr2:  IN      AL,DX
        TEST    AL,08h
        JNZ     Retr2

        MOV   DX,03C8h
        MOV   AL,0
        OUT   DX,AL
        INC   DX
        MOV   SI,OFFSET pal
        CLD
        PUSH  CX
        MOV   CX,256*3
        REP   OUTSB
        POP   CX

        LOOP  OneCycle

End; { FadeOut }


Procedure MakeBMPPal;
var
 x,z : integer;
Begin
  z := 1;
  for x := 0 to 255 do
    Begin
      bmppal[z] := modpal[x].b shl 2;
      bmppal[z+1] := modpal[x].g shl 2;
      bmppal[z+2] := modpal[x].r shl 2;
      bmppal[z+3] := 0;
      inc(z,4);
    end;
end;

Procedure WriteBmp(fname:string);
var
 f : file;
 idx : byte;
 xpos,ypos : integer;
 x,y : integer;
 data : array[0..1023] of byte;
Begin
 assign(f,fname+'.BMP');
 rewrite(f,1);
 makebmppal;
 move(bmppal,win.bmicolors,1024);

 win.bibitcount := 8;
 win.biclrused := 256;
 win.biclrimportant := 256;
 win.biplanes := 1;
 win.biwidth := maxx;
 win.biheight := maxy;
 win.bfsize := 1024+(win.biheight*win.biwidth);
 win.bfoffbits := 1078;
 win.bftype[1] := 'B';
 win.bftype[2] := 'M';
 win.bicompression := 0;
 win.bisizeimage := maxx*maxy;
 win.bixpelspermeter := 0;
 win.biypelspermeter := 0;
 win.biclrused := 256;
 win.biclrimportant := 256;

 blockwrite(f,win,sizeof(win));
 for y := win.biheight-1 downto 0 do
  Begin
   for x := 0 to win.biwidth-1 do data[x] := vget(x,y);
   blockwrite(f,data,win.biwidth);
  end;
 close(f);
end;


Begin
 clip := 0;
 ms := false;
 fillchar(mcursor,sizeof(mcursor),#0);
 usewindowclip := false;
 page := 0;
{ writeln('DPMI VESA Extensions v1.0');
 delay(750);}
end.

