{$G+}{$F+}
{DEFINE COLORCONVERT16}

unit vesa;

Interface

uses crt,dos,mouseu,binu{$IFDEF DPMI},winapi{$ENDIF},term;

Type
  BMP_HEADER = Record
                 bftype : array[1..2] of char;
                 bfsize : longint;
                 bfreserved1 : word;
                 bfreserved2 : word;
                 bfoffbits : longint;
                 bisize  : longint;
                 biwidth : longint;
                 biheight : longint;
                 biplanes : word;
                 bibitcount : word;
                 bicompression : longint;
                 bisizeimage : longint;
                 bixpelspermeter : longint;
                 biypelspermeter : longint;
                 biclrused : longint;
                 biclrimportant : longint;
                 bmicolors : array[1..1024] of byte;
               end;
  pal_ptr = ^pal_type;
  pal_type = Array[0..255] of Record
                               r,g,b : byte;
                             end;
  mimage = Record
              mousecursor : array[0..15,0..15] of word;
              imagesave : array[0..15,0..15] of word;
              xpos,ypos : integer;
           end;

Const
  _640x400x256 = $100;
  _640x480x256 = $101;
  _800x600x256 = $103;
  _1024x768x256 = $105;
  _1280x1024x256 = $107;

  _640x480x32k = $110;
  _640x480x64k = $111;

  lores  = $101;
  medres = $103;
  hires  = $105;
  superhires = $107;

  COPY_PUT = 0;
  MASKED_PUT = 1;
  AND_PUT = 2;
  XOR_PUT = 3;

var
  maxx,maxy : word;
  clipx1,clipx2,clipy1,clipy2 : integer;
  wclipx1,wclipx2,wclipy1,wclipy2 : integer;
  page : word;
  pal : pal_type;
  ms : boolean;
  mcursor : mimage;
  usewindowclip : boolean;

{  lfb : boolean;
  VESA_selector : word;
  VESA_LFB_START : pointer;}

  Setbank:Procedure;
  bmppal : array[1..1024] of byte;
{  bhwin : bmp_header; }

{$I VESA.VAR}

Procedure ClipSet(x1,y1,x2,y2:integer);
Procedure WindowClip(x1,y1,x2,y2:integer);
Procedure setpaletteDAC(pal : pal_type);
Function  MakePalette(bh:bmp_header):pal_ptr;
Procedure LoadPalette(f:string);
Function  setvesamode(video_mode:word;v2:boolean):boolean;
{$IFDEF DPMI}
Procedure GetVesaInfo(vm:word;p2:boolean);
{$ELSE}
Procedure GetVesaInfo(vm:word);
{$ENDIF}
Procedure CheckVesa;
procedure WriteIt;

Procedure InitMouse;
Procedure HandleMouse;far;
Procedure sm;
Procedure hm;
Procedure SetVesaMouse(mask: graphcursmasktype);

Function  GetMAXX:Word;
Function  GetMAXY:Word;
procedure EnableVGA;
procedure DisableVGA;
{Procedure SETPAL(Palette:Pointer);}
Procedure FadeOut;
Procedure Hourglass;
Procedure Arrow;
Procedure WriteBmp(fname:string);
Procedure MakeBMPPal;
Procedure VSync;

Procedure Box  (x1,y1,x2,y2:integer;color:word);
Procedure Fill (x1,y1,x2,y2:integer;color:word);
Procedure VrLine(y1,y2,x:integer;color:word);
Procedure Hline (x1,x2,y:integer;color:word);

Function  RGBColor15(r,g,b:word):word;
Function  PalColor15(c:byte):word;
Function  RGBColor16(r,g,b:word):word;
Function  PalColor16(c:byte):word;

procedure circle(xc,yc,ra:integer;c:byte);
procedure fillcircle(xc,yc,ra:integer;c:byte);
procedure fillcircle2(xc,yc,ra:integer;c1,c2:byte);


var
 FillBlock : Procedure (x1,y1,x2,y2:word;color:word);
 Vline     : procedure (x1,y1,x2,y2:Word;color:word);
 VPlot      : Procedure (xpos,ypos:word;color:word;remote:boolean);
 Vhrzline  : Procedure (y,x1,x2:integer;c:word);
 VPutRect  : Procedure (buffer:Pointer;x,y,xlen,ylen,width:word;PutType:Byte);
 VGetRect  : Procedure (buffer:Pointer;x,y,xlen,ylen,width:word);
 VGet      : Function  (xpos,ypos:word):word;

implementation

uses win,colors,remote;


Function  RGBColor15(r,g,b:word):word;
Begin
  RGBColor15 := word(r shl 11) + word(g shl 6) + word(b shl 1);
end;

Function PalColor15(c:byte):word;
Begin
  PalColor15 := RGBColor15(modpal[c].r shr 1,modpal[c].g shr 1,modpal[c].b shr 1);
end;

Function  RGBColor16(r,g,b:word):word;
Begin
  RGBColor16 := (r shl 11) + (g shl 6) + (b);
end;

Function PalColor16(c:byte):word;
var
 r,g,b : word;
Begin
  r := modpal[c].r shr 1;
  g := modpal[c].g shr 1;
  b := modpal[c].b shr 1;
  PalColor16 := r shl 11+g shl 6+b;
end;

Function BitSet(b:word;o:byte):boolean;
var
 w : word;
Begin
  w := 1 shl o;
  if (b and w)=w then bitset := true else bitset := false;
end;


Procedure MakeBMPPal;
var
 x,z : integer;
Begin
  z := 1;
  for x := 0 to 255 do
    Begin
      bmppal[z] := modpal[x].b shl 2;
      bmppal[z+1] := modpal[x].g shl 2;
      bmppal[z+2] := modpal[x].r shl 2;
      bmppal[z+3] := 0;
      inc(z,4);
    end;
end;

Procedure WriteBmp(fname:string);
var
 f : file;
 idx : byte;
 xpos,ypos : integer;
 x,y : integer;
 data : array[0..1023] of byte;
 bhwin : bmp_header;
Begin
 assign(f,fname+'.BMP');
 rewrite(f,1);
 makebmppal;
 move(bmppal,bhwin.bmicolors,1024);

 bhwin.bibitcount := 8;
 bhwin.biclrused := 256;
 bhwin.biclrimportant := 256;
 bhwin.biplanes := 1;
 bhwin.biwidth := maxx;
 bhwin.biheight := maxy;
 bhwin.bfsize := 1024+(bhwin.biheight*bhwin.biwidth);
 bhwin.bfoffbits := 1078;
 bhwin.bftype[1] := 'B';
 bhwin.bftype[2] := 'M';
 bhwin.bicompression := 0;
 bhwin.bisizeimage := maxx*maxy;
 bhwin.bixpelspermeter := 0;
 bhwin.biypelspermeter := 0;
 bhwin.biclrused := 256;
 bhwin.biclrimportant := 256;

 blockwrite(f,bhwin,sizeof(bhwin));
 for y := bhwin.biheight-1 downto 0 do
  Begin
   for x := 0 to bhwin.biwidth-1 do data[x] := vget(x,y);
   blockwrite(f,data,bhwin.biwidth);
  end;
 close(f);
end;


Procedure SETPAL(Palette:Pointer);
Var
   PS,
   PO   : Word;
Begin
     ps := Seg(Palette^);
     po := Ofs(Palette^);
     Asm
        push ds
        mov  si,po
        mov  ax,ps
        mov  ds,ax
        mov  cx,255
        mov  dx,cx
        add  cx,cx
        add  cx,dx
        mov  al,0
        mov  dx,03c8h
        out dx,al
        inc dx
        cld
        rep outsb
        pop ds
     End;
End;


Procedure EnableVGA;Assembler;
Asm
   mov  dx,03c4h
   mov  al,1
   out  dx,al
   inc  dx
   in   al,dx
   and  al,0dfh
   out  dx,al
End;

Procedure DisableVGA;Assembler;
Asm
   mov  dx,03c4h
   mov  al,1
   out  dx,al
   inc  dx
   in   al,dx
   or   al,20h
   out  dx,al
End;

function GetMAXX;
Begin
     GetMAXX := vesa_info.scrwidth+1;
End;

function GetMAXY;
Begin
     GetMAXY := vesa_info.scrheight+1;
End;

{$IFDEF DPMI}
type
  TDPMIRegs = record
    edi, esi, ebp, reserved, ebx, edx, ecx, eax: LongInt;
    flags, es, ds, fs, gs, ip, cs, sp, ss: Word;
  end;

  PBuffer = ^byte;

var
  R: TDPMIRegs;
  Address : LongInt;
  TempBuf : PBuffer;

function DPMIRealInt(IntNo, CopyWords: Word; var R: TDPMIRegs): Boolean; assembler;
asm
  mov ax, 0300h
  mov bx, IntNo
  mov cx, CopyWords
  les di, R
  int 31h
  jc @error
  mov ax, 1
  jmp @done
@error:
  xor ax, ax
  @Done:
end;

function LongFromBytes(HighByte, LowByte: Byte): LongInt; assembler;
asm
  mov dx, 0
  mov ah, HighByte
  mov al, LowByte
end;

function LongFromWord(LoWord: Word): LongInt; assembler;
asm
  mov dx, 0
  mov ax, LoWord;
end;

function RealToProt(P: Pointer; Size: Word; var Sel: Word): Pointer;far;
begin
  SetSelectorBase(Sel, LongInt(HiWord(LongInt(P))) Shl 4 + LoWord(LongInt(P)));
  SetSelectorLimit(Sel, Size);
  RealToProt := Ptr(Sel, 0);
end;

Procedure GetVesaInfo(vm:word;p2:boolean);
begin
  FillChar(R, SizeOf(TDPMIRegs), #0);
  R.Eax := LongFromWord($4F01);
  R.Ecx := LongFromWord(vm);
  Address := GlobalDosAlloc(sizeof(vesa_info));
  R.es := HIWord(Address);
  DPMIRealInt($10,sizeof(vesa_info) shr 1,R);
  TempBuf := Ptr(LoWord(Address), 0);
  move (tempbuf^,vesa_info,sizeof(vesa_info));
  GlobalDosFree(LoWord(Address));

(* with vesa_info do
  Begin
      modeattr      := 155; { Mode Attributes }
      winaattr      := 7; { Window A attributes }
      winbattr      := 0; { Window B attributes }
      if p2 then
      granularity   := 4 else
      granularity   := 64; { Window Granularity in K }
      windowsize    := 64; { Window Size in K }
      winaseg       := 40960; { Window A Start segment }
      winbseg       := 0; { Window B Start segment }
      winfunctptr   := nil {ptr(49152,17986)};
      bytesperscan  := 640; { Bytes per scan line }
      scrwidth      := 640; { Screen width in pixels }
      scrheight     := 480; { Screen height in pixels }
      charwidth     := 8; { Char width in pixels }
      charheight    := 8; { Char Height in pixels }
      nummemplanes  := 1; { Number of memory planes }
      bitsperpixel  := 8; { Bits per pixel }
      numofbanks    := 1; { Number of banks }
      memmodel      := 4; { Memory model }
      banksize      := 0; { Size of bank in K }
      numimgpages   := 11; { Number of images pages }
  end;*)
end;

Procedure CheckVesa;
begin
  FillChar(R, SizeOf(TDPMIRegs), #0);
  R.Eax := LongFromWord($4F00);
  Address := GlobalDosAlloc(sizeof(vesa_oem));
  R.es := HIWord(Address);
  DPMIRealInt($10,sizeof(vesa_oem) shr 1,R);
  TempBuf := Ptr(LoWord(Address), 0);
  move (tempbuf^,vesa_oem,sizeof(vesa_oem));
  GlobalDosFree(LoWord(Address));
end;
{$ELSE}
Procedure getvesainfo(vm:word);
var
 p : pointer;
begin
  p := ptr(seg(vesa_info),ofs(vesa_info));
asm
 mov ax,$4f01
 mov cx,vm
 les di,p
 int $10
end;
end;

Procedure checkvesa;
var
 r : registers;
Begin
 r.ax := $4f00;
 r.es := seg(vesa_oem);
 r.di := ofs(vesa_oem);
 intr($10,r);
end;
{$ENDIF}

Procedure SMODE(mode:word;uselfb:boolean);
var
 sel : word;
 p : pointer;
 p2 : pointer;
Begin
asm
  mov bx,mode
  mov al,uselfb
  cmp al,0
  jz  @continue
  add bx,16384 {Request LFB}
@continue:
  mov ax,4f02h
  int 10h

  mov status_al,al
  mov status_ah,ah
end;
{$IFNDEF DPMI}
  setbank := vesa_info.winfunctptr;
{$ENDIF}

bankend := vesa_info.windowsize shl 10;
if bankend=0 then dec(bankend);

scx := 0;
sdx := 0;
actstart := 0;
visstart := 0;
pageno := 0;
pagelen := vesa_info.scrheight;
end;

{$I _8bit}
{$I _15bit}
{$I _16bit}

Function Clipbox(Var x1,y1,x2,y2:integer):Boolean;
var
 t : integer;
Begin
  Clipbox := false;
  if (x1>x2) then exit;
  if (y1>y2) then exit;
  Clipbox := true;

  if (x1<clipx1) then x1 := clipx1;
  if (y1<clipy1) then y1 := clipy1;
  if (x2>clipx2) then x2 := clipx2;
  if (y2>clipy2) then y2 := clipy2;
  if (x1>x2) then Clipbox := false;
  if (y1>y2) then Clipbox := false;
end;

Procedure Fill(x1,y1,x2,y2:integer;color:word);
var
 x,y : integer;
 draw : boolean;
Begin
    if Clipbox(x1,y1,x2,y2) then
    Begin
      {$IFDEF COLORCONVERT16} color := PalColor16(color); {$ENDIF}
      fillblock(x1,y1,x2,y2,color);
    end;
end;

Procedure setpaletteDAC(pal : pal_type);
 const
   DAC_WI = $3c8;
   DAC_DI = $3c9;
var
 i : integer;
Begin
  if vesa_info.bitsperpixel<>8 then exit;
   for i := 0 to 255 do
    Begin
      port[DAC_WI] := i;
      port[DAC_DI] := pal[i].r;
      port[DAC_DI] := pal[i].g;
      port[DAC_DI] := pal[i].b;
    end;
end;

Procedure LoadPalette(f:string);
var
 t : file of pal_type;
Begin
 assign(t,f);
 reset(t);
 read(t,pal);
 setpalettedac(pal);
 close(t);
end;


Function MakePalette(bh:bmp_header):pal_ptr;
var
 x : byte;
 z : integer;
 cpal : pal_ptr;
Begin
 new(cpal);
 z := 1;
 for x := 0 to 255 do
  Begin
    cpal^[x].b := bh.bmicolors[z] shr 2;
    cpal^[x].g := bh.bmicolors[z+1] shr 2;
    cpal^[x].r := bh.bmicolors[z+2] shr 2;
    inc(z,4);
  end;
 Makepalette := cpal;
end;


procedure WriteIt;
var
  i: Integer;
begin
  with vesa_info do begin
   writeln('MODE ATTRIBUTE   : ',modeattr);{ Mode Attributes }
   writeln('WIN A ATTRIBUTE  : ',winaattr    );  { Window A attributes }
   writeln('WIN B ATTRIBUTE  : ',winbattr    );  { Window B attributes }
   writeln('GRANULARITY      : ',granularity );  { Window Granularity in K }
   writeln('WINDOW SIZE      : ',windowsize  );  { Window Size in K }
   writeln('WIN A SEGMENT    : ',winaseg     );  { Window A Start segment }
   writeln('WIN B SEGMENT    : ',winbseg     );  { Window B Start segment }
   writeln('WIN FUNCT PTR    : ',seg(winfunctptr),':',ofs(winfunctptr));
   writeln('BYTES PER SCAN   : ',bytesperscan);  { Bytes per scan line }
   writeln('SCREEN WIDTH     : ',scrwidth    );  { Screen width in pixels }
   writeln('SCREEN HEIGHT    : ',scrheight   );  { Screen height in pixels }
   writeln('CHARACTER WIDTH  : ',charwidth   );  { Char width in pixels }
   writeln('CHARACTER HEIGHT : ',charheight  );  { Char Height in pixels }
   writeln('NUM MEM PLANES   : ',nummemplanes);  { Number of memory planes }
   writeln('BITS PER PIXEL   : ',bitsperpixel);  { Bits per pixel }
   writeln('NUM BANKS        : ',numofbanks );   {Number of banks }
   writeln('MEMORY MODEL     : ',memmodel   );   { Memory model }
   writeln('BANKSIZE         : ',banksize   );   { Size of bank in K }
   writeln('NUM IMG PAGES    : ',numimgpages);   { Number of images pages }
  end;
 readln;
end;

Function setvesamode(video_mode:word;v2:boolean):boolean;
Begin
  setvesamode := false;
  getvesainfo(video_mode,v2);
  smode(video_mode,false);
  if (status_al<>$4f) or (status_ah<>0) then
    Begin
      writeln('Error Initializing VESA video mode ',video_mode);
      {if uselfb then writeln('with Linear Frame Buffer');}
      writeln('STATUS_AL : ',status_al);
      writeln('STATUS_AH : ',status_ah);
      writeln('Record everything seen above and contact the Help Desk');
      writeln('for support.');
      {terminate_bad;}
    end;
{  case status_ah of
   $0 : writeln('Call Successful');
   $1 : writeln('Call Failed');
   $2 : writeln('Software Supports function, hardware does not!');
   $3 : writeln('Function call invalid in current video mode!');
  end;
}
  currentbank := 0;
  vputmode := COPY_PUT;
  vesa_info.winaseg := SEGA000;
  maxx := (getmaxx-1);
  maxy := getmaxy-1;
  mousemaxx := maxx;
  mousemaxy := maxy;
  clipx1 := 0;
  clipx2 := maxx;
  clipy1 := 0;
  clipy2 := maxy;
  wclipx1 := 0;
  wclipx2 := maxx;
  wclipy1 := 0;
  wclipy2 := maxy;
  setvesamode := true;

  case (vesa_info.bitsperpixel) of
   8  : Begin
          Fillblock := Fillblock8;
          Vline     := Vline8;
          VPlot      := VPlot8;
          Vhrzline  := Vhrzline8;
          VPutRect  := VPutRect8;
          VGetRect  := VgetRect8;
          VGet      := Vget8;
       end;
   15 : Begin
          Fillblock := Fillblock15;
          Vline     := Vline15;
          VPlot      := VPlot15;
          Vhrzline  := Vhrzline15;
          VPutRect  := VPutRect15;
          VGetRect  := VgetRect15;
          VGet      := Vget15;
        end;
   16 : Begin
          Fillblock := Fillblock16;
          Vline     := Vline16;
          VPlot      := VPlot16;
          Vhrzline  := Vhrzline16;
          VPutRect  := VPutRect16;
          VGetRect  := VgetRect16;
          VGet      := Vget16;
        end;
   end;

end;

Procedure DrawMouse;
var
 x,y : integer;
Begin
 for x := 0 to 15 do
   for y := 0 to 15 do
     if (mcursor.mousecursor[x,y]>0) then vplot(x+mcursor.xpos,y+mcursor.ypos,15,false);
end;

Procedure SaveImage(xpos,ypos:integer);
var
 x,y : integer;
Begin
 mcursor.xpos := xpos;
 mcursor.ypos := ypos;
 for x := 0 to 15 do
   for y := 0 to 15 do
     mcursor.imagesave[x,y] := vget(mcursor.xpos+x,mcursor.ypos+y);
end;

Procedure RestoreImage;
var
 x,y : integer;
Begin
 for x := 0 to 15 do
   for y := 0 to 15 do
     vplot(mcursor.xpos+x,mcursor.ypos+y,mcursor.imagesave[x,y],false);
end;

Procedure InitMouse;
var
 r : registers;
Begin
  resetmouse;
  getbuttonstatus;
  setvesamouse(standardshapecurs);
end;

Procedure SetVesaMouse(mask: graphcursmasktype);
var
 x,y,z : integer;
 s,s2 : string[16];

function choi(c:char):integer;
var
 e,x : integer;
Begin
 val(c,x,e);
 choi := x;
end;
Begin
 for y := 0 to 15 do
   Begin
     s := wordtobin(mask.mask[1][y]);
     s2 := wordtobin(mask.mask[0][y]);
     for x := 0 to 15 do
         mcursor.mousecursor[x,y] := choi(s[x+1]);
   end;
end;

Procedure Hourglass;
Begin
  lbactive := false;
  SetVesaMouse(hourglasscurs);
  hm;
  sm;
  handlemouse;
end;

Procedure Arrow;
Begin
  lbactive := true;
  SetVesaMouse(standardshapecurs);
  hm;
  sm;
  handlemouse;
end;


Procedure HandleMouse;
var
 cx1,cy1,cx2,cy2 : integer;
Begin
   cx1 := clipx1;
   cy1 := clipy1;
   cx2 := clipx2;
   cy2 := clipy2;
   clipset(0,0,maxx,maxy);
   if (ms) then
    Begin
      getbuttonstatus;
      if ((_mousex)<>mcursor.xpos) or (_mousey<>mcursor.ypos) then
      Begin
        restoreimage;
        saveimage(_mousex,_mousey);
        drawmouse;
      end;
    end;
   clipset(cx1,cy1,cx2,cy2);
end;

Procedure sm;
Begin
  if (ms) then exit;
   getbuttonstatus;
   saveimage(_mousex,_mousey);
   drawmouse;
  ms := true;
end;

Procedure hm;
Begin
 if not(ms) then exit;
 restoreimage;
 ms := false;
end;

Procedure Hline(x1,x2,y:integer;color:word);
var
 x : integer;
Begin
    x := y+1;
    if clipbox(x1,y,x2,x) then
      Begin
        {$IFDEF COLORCONVERT16} color := PalColor16(color); {$ENDIF}
        vhrzline(y,x1,x2,color);
      end;
    {if (x1<clipx1) and (x2<clipx1) then exit;
    if (x1>clipx2) and (x2>clipx2) then exit;
    if (x1<clipx1) then x1 := clipx1;
    if (x2>clipx2) then x2 := clipx2;
    if (y<clipy1) then exit;
    if (>clipy2) then exit;
    if (x2-x1)<1 then exit;}
end;

Procedure Vrline(y1,y2,x:integer;color:word);
var
 y : integer;
Begin
    {if (y1<clipy1) and (y2<clipy1) then exit;
    if (y1>clipy2) and (y2>clipy2) then exit;
    if y1<clipy1 then y1 := clipy1;
    if y2>clipy2 then y2 := clipy2;
    if (x>Clipx2) then exit;
    if (x<Clipx1) then exit;
    if (y2-y1)<1 then exit;}

    y := x+1;
    if clipbox(x,y1,y,y2) then
      Begin
        {$IFDEF COLORCONVERT16} color := PalColor16(color); {$ENDIF}
        vline(x,y1,x,y2,color);
      end;
    {for y := y1 to y2 do vplot(x,y,color);}
end;

Procedure Box(x1,y1,x2,y2:integer;color:word);
Begin
  Hline(x1,x2,y1,color);
  Hline(x1,x2,y2,color);
  Vrline(y1,y2,x1,color);
  Vrline(y1,y2,x2,color);
end;

Procedure AdjustWindowClip;
Begin
 if (wclipx1>clipx1) then clipx1 := wclipx1;
 if (wclipy1>clipy1) then clipy1 := wclipy1;
 if (wclipx2<clipx2) then clipx2 := wclipx2;
 if (wclipy2<clipy2) then clipy2 := wclipy2;
end;

Procedure ClipSet(x1,y1,x2,y2:integer);
Begin
 if (x1<0) then x1 := 0;
 if (x2>maxx-1) then x2 := maxx-1;
 if (y1<0) then y1 := 0;
 if (y2>maxy-1) then y2 := maxy-1;
 clipx1 := x1;
 clipy1 := y1;
 clipx2 := x2;
 clipy2 := y2;
 if (usewindowclip) then adjustwindowclip;
end;

Procedure WindowClip(x1,y1,x2,y2:integer);
Begin
 if (x1<0) then x1 := 0;
 if (x2>maxx) then x2 := maxx;
 if (y1<0) then y1 := 0;
 if (y2>maxy) then y2 := maxy;
 wclipx1 := x1;
 wclipy1 := y1;
 wclipx2 := x2;
 wclipy2 := y2;
end;

Procedure FadeOut;assembler;
    Label OneCycle,ReadLoop,DecLoop,Continue,Retr,Wait,Retr2,Wait2;
      Asm
        PUSH  AX
        PUSH  BX
        PUSH  CX
        PUSH  DX

        MOV   CX,64
OneCycle:
        MOV     DX,3DAh
Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait
Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr

        MOV   DX,03C7h
        XOR   AL,AL
        OUT   DX,AL
        INC   DX
        INC   DX
        XOR   BX,BX
ReadLoop:
        IN    AL,DX
        MOV   Byte Ptr pal[BX],AL
        INC   BX
        CMP   BX,256*3
        JL    ReadLoop

        XOR   BX,BX
DecLoop:
        CMP   Byte Ptr pal[BX],0
        JE    Continue
        DEC   Byte Ptr pal[BX]

Continue:
        INC   BX
        CMP   BX,256*3
        JL    DecLoop

        MOV     DX,3DAh
Wait2:  IN      AL,DX
        TEST    AL,08h
        JZ      Wait2
Retr2:  IN      AL,DX
        TEST    AL,08h
        JNZ     Retr2

        MOV   DX,03C8h
        MOV   AL,0
        OUT   DX,AL
        INC   DX
        MOV   SI,OFFSET pal
        CLD
        PUSH  CX
        MOV   CX,256*3
        REP   OUTSB
        POP   CX

        LOOP  OneCycle
        POP   DX
        POP   CX
        POP   BX
        POP   AX
End; { FadeOut }

Procedure FadeOutw;assembler;
    Label OneCycle,ReadLoop,DecLoop,Continue,Retr,Wait,Retr2,Wait2;
asm
        MOV   CX,64
OneCycle:

        MOV     DX,3DAh
Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait
Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr

        MOV   DX,03C7h
        XOR   AL,AL
        OUT   DX,AL
        INC   DX
        INC   DX
        XOR   BX,BX
ReadLoop:
        IN    AL,DX
        MOV   Byte Ptr pal[BX],AL
        INC   BX
        CMP   BX,256*3
        JL    ReadLoop

        XOR   BX,BX
DecLoop:        
        CMP   Byte Ptr pal[BX],63
        JE    Continue
        INC   Byte Ptr pal[BX]
Continue:
        INC   BX
        CMP   BX,256*3
        JL    DecLoop

        MOV     DX,3DAh
Wait2:  IN      AL,DX
        TEST    AL,08h
        JZ      Wait2
Retr2:  IN      AL,DX
        TEST    AL,08h
        JNZ     Retr2

        MOV   DX,03C8h
        MOV   AL,0
        OUT   DX,AL
        INC   DX
        MOV   SI,OFFSET pal
        CLD
        PUSH  CX
        MOV   CX,256*3
        REP   OUTSB
        POP   CX

        LOOP  OneCycle

End; { FadeOut }

Procedure VSync;assembler;
asm
@OneCycle:
        MOV     DX,3DAh
@Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      @Wait
@Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     @Retr
end;

procedure cir(xc,yc,ra:integer; c,c2:byte; filled:boolean);
var x,y,d:integer;
    ch:char;

procedure swapbig(var sm,bi:integer);
var t:integer;
begin
 if sm>bi then begin t:=sm;sm:=bi;bi:=t;end;
end;

procedure circpnt(x,y,xc,yc:integer);
var xxcp,xxcm,xycp,xycm,yxcp,yxcm,yycp,yycm:integer;
begin
 xxcp:=xc+x;xxcm:=xc-x;xycp:=xc+y;xycm:=xc-y;
 yxcp:=yc+x;yxcm:=yc-x;yycp:=yc+y;yycm:=yc-y;
if not filled then begin
 vplot(xxcp,yycp,c,true);
 vplot(xxcm,yycp,c2,true);
 vplot(xxcp,yycm,c,true);
 vplot(xxcm,yycm,c2,true);
 vplot(xycp,yxcp,c,true);
 vplot(xycm,yxcp,c2,true);
 vplot(xycp,yxcm,c,true);
 vplot(xycm,yxcm,c2,true);
 end
 else
 begin
 swapbig(xxcp,xxcm);
 swapbig(xycp,xycm);

 vhrzline(yycp,xxcp,xxcm,c);
 vhrzline(yycm,xxcp,xxcm,c);
 vhrzline(yxcp,xycp,xycm,c);
 vhrzline(yxcm,xycp,xycm,c);
 end;
end;

begin
 x:=0;
 y:=ra;
 d:=3-(2*ra);
 while (x<y) do
  begin
   circpnt(x,y,xc,yc);
   if (d<0) then d:=d+(4*x)+6 else begin d:=d+4*(x-y)+10;dec(y);end;
   x:=x+1;
  end;
  if (x=y) then circpnt(x,y,xc,yc);
end;

procedure circle(xc,yc,ra:integer;c:byte);
begin
 cir(xc,yc,ra,c,c,false);
end;

procedure fillcircle(xc,yc,ra:integer;c:byte);
begin
 cir(xc,yc,ra,c,c,true);
end;

procedure fillcircle2(xc,yc,ra:integer;c1,c2:byte);
begin
 cir(xc,yc,ra,c1,c2,false);
end;


{Procedure Vplot(xpos,ypos:word;color:word);
Begin
  plot(xpos,ypos,color);
end;
}
Begin
 Fillblock := Fillblock8;
 Vline     := Vline8;
 VPlot      := VPlot8;
 Vhrzline  := Vhrzline8;
 VPutRect  := VPutRect8;
 VGetRect  := VgetRect8;
 VGet      := Vget8;

 lbactive := true;
 clip := 0;
 ms := false;
 fillchar(mcursor,sizeof(mcursor),#0);
 usewindowclip := false;
 page := 0;
 writeln('DPMI VESA Extensions v1.0');
end.

