{ A simple program to demonstrate how you can use mouse in text mode....

  Grafic's mode is comming (include VESA mode's)...

  If you want more documentation about mouse programming, mail me....



                                    by Ricardo Azevedo Pereira  (07/02/1998)

  MAIL =>   ricardo.a.pereira@usa.net (mail me if you have any problem)

}

program mouses;



uses crt,dos;



const

  mtypes : Array [0..4] Of String [6] = ('bus', 'serial', 'inport', 'ps/2', 'hp');



var

   tecla,x,y:integer;

   verhi,verlo,mousetype:Byte;



{ *** Start the mouse driver *** }

{ Syntax : Inicrato }



procedure inicrato;

var

   r:registers;

begin

     r.ax:=00;

     intr($33,r)

end;



{ *** show the mouse *** }

{ Syntax : Rato }



procedure rato;

var

   r:registers;

begin

     r.ax:=01;

     Intr($33,r)

end;



{ *** tell us the mouse coordinates *** }

{ Syntax : Ratopos (  x ,  y ) }



procedure ratopos(var x,y:integer);

var

   r:registers;

begin

     r.ax:=03;

     Intr($33,r);

     x:=R.cx;

     y:=R.dx

end;



{ *** tell us if some mouse key are pressed :  0 - nop         *** }

{                                              1 - left key        }

{                                              2 - right key       }

{ Syntax : integer := Ratotec }



function ratotec:integer;

var

   r:registers;

begin

     r.ax:=03;

     Intr($33,r);

     ratotec:=r.bx

end;



{ *** hide mouse *** }

{ Syntax : Escrato }



procedure escrato;

var

   r:registers;

begin

     r.ax:=02;

     intr($33,r)

end;



{ *** define a window for mouse *** }

{ Syntax : Definir ( xi , yi , xf , yf ) }



procedure definir(xi,yi,xf,yf:integer);

var

   r:registers;

begin

     r.ax:=7;

     r.cx:=xi;

     r.dx:=xf;

     intr($33,r);

     r.ax:=8;

     r.cx:=yi;

     r.dx:=yf;

     intr($33,r)

end;



{ * tell us if mouse is installed : TRUE - installed , FALSE - nop * }

{ Syntax : boolean := Verrato }



function verrato:boolean;

var

   r:registers;

begin

     verrato:=false;

     r.ax:=0;

     intr($33,r);

     if r.ax<>0 then verrato:=true

end;



{ *** put the mouse cursor in X,Y, in the screen, obvious!!! *** }

{ Syntax : Ratocoord ( x , y ) }



procedure ratocoord(x,y:integer);

var

   r:registers;

begin

     r.ax:=$4;

     r.cx:=x;

     r.dx:=y;

     intr($33,r)

end;



{ *** "see" if the mouse is in a determineded window *** }

{ Syntax : boolean := Detecta( xi , yi , xf , yf ) }



function detecta(xi,yi,xf,yf:integer):boolean;

var

   x,y:integer;

begin

     detecta:=false;ratopos(x,y);

     if (xi<x) and (xf>x) and (yi<y) and (yf>y) then

        detecta:=true

end;



{*** see the version of mouse driver, and mouse type ***}

{ Syntax : version }

procedure version;

var

   r:registers;

begin

     r.ax:=$24;

     intr ($33,r);

     verhi:=r.bh;

     verlo:=r.bl;

     mousetype:=r.ch;

     writeln ('Mouse version => ',verhi,'.',verlo);

     writeln ('Mouse type    => ',mtypes[mousetype]);

end;

{main}

begin

     x:=0;

     y:=0;

     clrscr;

     if verrato=true then

        writeln ('mouse installed...')

     else

     begin

          writeln ('no installed....');

          repeat until keypressed;

          exit;

     end;

     version;

     writeln ('press the mouse buttons');

     inicrato;

     rato;

     ratocoord (0,0);

     definir (0,0,133,121);

     repeat

           ratopos (x,y);

           gotoxy (12,12); writeln ('X -',x,'- Y -',y,'-');

           tecla:=ratotec;

           if tecla=1 then

           begin

                escrato;

                writeln ('press the right key for exit ');

           end;

           if tecla=2 then

              halt (1);

     until tecla=1 or 2;

end.

{end}