// AtariServerDoc.cpp : implementation of the CAtariServerDoc class
//

#include "stdafx.h"
#include "common.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAtariServerDoc

IMPLEMENT_DYNCREATE(CAtariServerDoc, CDocument)

BEGIN_MESSAGE_MAP(CAtariServerDoc, CDocument)
	//{{AFX_MSG_MAP(CAtariServerDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAtariServerDoc construction/destruction

CAtariServerDoc::CAtariServerDoc()
{
}


CAtariServerDoc::~CAtariServerDoc()
{
	DeleteContents();
}



/////////////////////////////////////////////////////////////////////////////
// CAtariServerDoc serialization

void CAtariServerDoc::Serialize(CArchive& ar)
{
	CWaitCursor		cursorWait;
	CDeviceSet		*cds;

	if (ar.IsStoring())
	{
		POSITION	setpos = m_listDeviceSets.GetHeadPosition();

		ar << (int)m_listDeviceSets.GetCount();

		while( setpos )
		{
			cds = (CDeviceSet *)m_listDeviceSets.GetNext(setpos);

			ar << cds->GetPortName();
			ar << cds->GetDescription();

			cds->Serialize(ar);
		}
	}
	else
	{
		CString		cstrPort, cstrDescription;
		int			i,nSets;

		ar >> nSets;

		for(i=0; i< nSets; i++)
		{
			cds = new CDeviceSet(this);

			ar >> cstrPort;
			ar >> cstrDescription;

			if( cds->OpenPort( cstrPort, cstrDescription ) )
			{
				AddDeviceSet( cds );
				cds->Serialize(ar);
			}
			else
			{
				BOOL		flag;
				CString		cstrjunk;

				delete cds;

				CString	cstrError;

				cstrError.Format( IDS_MSG_CANTOPENPORT, (LPCTSTR)cstrPort, (LPCTSTR)cstrDescription );
				AfxMessageBox( (LPCTSTR)cstrError, MB_ICONERROR + MB_OK );

				for(int i=0; i<4; i++)
				{
					ar >> flag;
					if( flag ){ ar >> cstrjunk;  ar >> cstrjunk; }
				}
			}
		}
	}
	SetModifiedFlag(FALSE);
	UpdateAllViews(NULL);
}


/////////////////////////////////////////////////////////////////////////////
// CAtariServerDoc diagnostics

#ifdef _DEBUG
void CAtariServerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAtariServerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAtariServerDoc commands



void CAtariServerDoc::DeleteContents() 
{
	while( !m_listDeviceSets.IsEmpty() ) delete m_listDeviceSets.RemoveHead();
	SetModifiedFlag(FALSE);

	ASSERT( m_listDiskDataInstances.GetCount() == 0 );

	CDocument::DeleteContents();
}





BOOL CAtariServerDoc::OnNewDocument() 
{
	if( !CDocument::OnNewDocument() )
		return FALSE;

//	DeleteContents();
//	SetPathName("",FALSE);
//	SetModifiedFlag(FALSE);

	return TRUE;
}





BOOL CAtariServerDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	return TRUE;
}






void CAtariServerDoc::AddDeviceSet( CDeviceSet *cds )
{
	m_listDeviceSets.AddTail( cds );
	SetModifiedFlag(TRUE);
	cds->m_portWindow = NULL;
	return;
}



