// AtariServerView.cpp : implementation file
//

#include "stdafx.h"
#include "common.h"

#include "DlgOpenPort.h"
#include "DlgCreateDisk.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAtariServerView

IMPLEMENT_DYNCREATE(CAtariServerView, CScrollView)

CAtariServerView::CAtariServerView()
{
	m_TimerCountdown		= SCRN_UPDATE_RELOAD;
	m_timerRefreshScreen	= 0;
}




CAtariServerView::~CAtariServerView()
{
	DestroyContents();
}




void CAtariServerView::DestroyContents(void)
{
	CAtariServerDoc	*pDoc = GetMyDocument();
	CDeviceSet		*cds;

	while( !pDoc->m_listDeviceSets.IsEmpty() )
	{
		cds = (CDeviceSet *)pDoc->m_listDeviceSets.GetHead();
		delete cds->m_portWindow;
	}

	ASSERT( pDoc->m_listDiskDataInstances.GetCount() == 0 );
}




BEGIN_MESSAGE_MAP(CAtariServerView, CScrollView)
	//{{AFX_MSG_MAP(CAtariServerView)
	ON_COMMAND(ID_OPENPORT, OnOpenCommPort)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAtariServerView drawing




BOOL CAtariServerView::DestroyWindow() 
{
	if( m_timerRefreshScreen ) KillTimer( m_timerRefreshScreen );

	return CScrollView::DestroyWindow();
}




void CAtariServerView::OnInitialUpdate()
{
	if( !m_timerRefreshScreen )
		m_timerRefreshScreen = SetTimer( 1, SCRN_TIMER_PERIOD, NULL );

	CScrollView::OnInitialUpdate();
}





void CAtariServerView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CAtariServerDoc		*pDoc = GetMyDocument();

	CDeviceSet			*cds;
	CPortWindow			*pwin;
	CRect				rectPortWin;
	CRect				tempRect, rectViewClient;
	int					yOff;
	POSITION			pos;
	CSize				sizeView;


	CheckDeviceSets();
	SortDeviceSets();


	sizeView.cx = sizeView.cy = 0;
	SetScrollSizes(MM_TEXT, sizeView);

	yOff = 0;

	pos = pDoc->m_listDeviceSets.GetHeadPosition();
	while(pos)
	{
		cds = (CDeviceSet *)pDoc->m_listDeviceSets.GetNext(pos);
		if( (pwin = cds->m_portWindow) )
		{
			pwin->GetWindowRect( rectPortWin );
			yOff += rectPortWin.Height();
		}
	}


	if( pDoc->m_listDeviceSets.GetCount() > 0 )
	{
		sizeView.cx = rectPortWin.Width();
		sizeView.cy = yOff;
	}
	else sizeView.cx = sizeView.cy= 100;


	if( pDoc->m_listDeviceSets.GetCount() > 0 )
	{
		CMainFrame	*mainWnd = (CMainFrame *)AfxGetMainWnd();

		
		CRect	rectViewWin,rectAppWin,rectAppWinOverhead;
		CRect	rectViewClient,rectViewWinOverhead;

		GetClientRect( rectViewClient );
		GetWindowRect( rectViewWin );

		mainWnd->GetWindowRect( rectAppWin );

		//
		// Compute the size overhead imposed by the app window on
		// the view window
		//
		rectAppWinOverhead.left = rectAppWinOverhead.top = 0;
		rectAppWinOverhead.right = (rectAppWin.Width() - rectViewWin.Width());
		rectAppWinOverhead.bottom = (rectAppWin.Height() - rectViewWin.Height());
		// 
		// Compute the size overhead imposed by the view window on its client.
		//
		rectViewWinOverhead.left = rectViewWinOverhead.top = 0;
		rectViewWinOverhead.right = (rectViewWin.Width() - rectViewClient.Width());
		rectViewWinOverhead.bottom = (rectViewWin.Height() - rectViewClient.Height());


		CRect	rectViewSize(0,0, sizeView.cx, sizeView.cy);

		rectAppWin.right	= rectAppWin.left + (rectViewSize.Width() + rectViewWinOverhead.Width() + rectAppWinOverhead.Width() );
		rectAppWin.bottom	= rectAppWin.top + (rectViewSize.Height() + rectViewWinOverhead.Height() + rectAppWinOverhead.Height() );



		mainWnd->m_rectWindowSize = rectAppWin;

		mainWnd->m_hscrollHeight = GetSystemMetrics( SM_CYHSCROLL );
		mainWnd->m_vscrollWidth = GetSystemMetrics( SM_CXVSCROLL );

		mainWnd->MoveWindow( rectAppWin );
		mainWnd->MoveWindow( rectAppWin );	// beat on the window until it resizes right....
	}
	SetScrollSizes(MM_TEXT, sizeView);
}



 


void CAtariServerView::CheckDeviceSets(void)
{
	CAtariServerDoc		*pDoc = GetMyDocument();
	CDeviceSet			*cds;
	CPortWindow			*pwin;

	POSITION	pos = pDoc->m_listDeviceSets.GetHeadPosition();

	while(pos)
	{
		cds = (CDeviceSet *)pDoc->m_listDeviceSets.GetNext(pos);
		if( !cds->m_portWindow )
		{
			CreatePortWindowForDeviceSet( cds );

			pwin = cds->m_portWindow;

			for(int i=1; i<=4; i++)	pwin->AttachDiskDeviceToControls(i);
		}
	}
	return;
}





void CAtariServerView::SortDeviceSets(void)
{
	CAtariServerDoc		*pDoc = GetMyDocument();

	BOOL				isSorting;
	CDeviceSet			*cds1, *cds2;
	CString				cstrPort1, cstrPort2;
	POSITION			pos1,pos2;

	do
	{
		isSorting = FALSE;
		pos1 = pDoc->m_listDeviceSets.GetHeadPosition();
		while(pos1)
		{
			pos2 = pos1;
			cds1 = (CDeviceSet *)pDoc->m_listDeviceSets.GetNext(pos2);
			if( !pos2 ) break;
			cds2 = (CDeviceSet *)pDoc->m_listDeviceSets.GetAt(pos2);

			cstrPort1 = cds1->GetPortName();
			cstrPort2 = cds2->GetPortName();

			if( cstrPort1.Compare((LPCTSTR)cstrPort2) > 0 )
			{
				pDoc->m_listDeviceSets.SetAt(pos1, cds2);
				pDoc->m_listDeviceSets.SetAt(pos2, cds1);
				isSorting = TRUE;
			}
			else pos1 = pos2;
		}
	}
	while( isSorting );
}








void CAtariServerView::OnDraw(CDC* pDC) 
{
	CAtariServerDoc		*pDoc = GetMyDocument();

	CPortWindow			*pwin;
	CDeviceSet			*cds;
	POSITION			pos;
	CPoint				scrollPos;
	CRect				rectPortWin;
	CRect				tempRect, rectViewClient;
	int					yOff;
	CSize				sizeTotal;


	scrollPos = GetDeviceScrollPosition();
	yOff = -scrollPos.y;

	pos = pDoc->m_listDeviceSets.GetHeadPosition();
	while(pos)
	{
		cds = (CDeviceSet *)pDoc->m_listDeviceSets.GetNext(pos);
		if( (pwin= cds->m_portWindow) )
		{
			pwin->GetWindowRect( rectPortWin );

			rectPortWin.right	= rectPortWin.Width();
			rectPortWin.left	= 0;
			rectPortWin.bottom	= rectPortWin.Height();
			rectPortWin.top		= 0;

			rectPortWin.OffsetRect(-scrollPos.x , yOff);

			pwin->MoveWindow( rectPortWin );
			pwin->UpdateWindow();

			yOff += rectPortWin.Height();
		}
	}
}





/////////////////////////////////////////////////////////////////////////////
// CAtariServerView diagnostics

#ifdef _DEBUG
void CAtariServerView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CAtariServerView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAtariServerView message handlers



void CAtariServerView::OnOpenCommPort() 
{
	CDlgOpenPort		dlgPort;

	if( dlgPort.DoModal() == IDOK )
	{
		CAtariServerDoc	*pDoc = GetMyDocument();

		CreatePortWindowForDeviceSet( dlgPort.m_devSet );

		pDoc->UpdateAllViews(NULL);
	}
}




void CAtariServerView::CreatePortWindowForDeviceSet( class CDeviceSet *cds )
{
	CAtariServerDoc		*pDoc = GetMyDocument();
	CPortWindow			*pwin = new CPortWindow();

	pDoc->m_listDeviceSets.AddTail( cds );

	pwin->SetParentView( this );

	cds->m_portWindow	= pwin;
	pwin->m_devSet		= cds;

	pwin->Create( IDD_PORTWINDOW, (CWnd *)this );

	for(int i=1; i<=4; i++)	pwin->AttachDiskDeviceToControls(i);
}










void CAtariServerView::OnTimer(UINT nIDEvent) 
{
	CAtariServerDoc		*pDoc = GetMyDocument();
	CDeviceSet			*cds;
	CPortWindow			*pwin;
	BOOL				updateStats = FALSE;
	POSITION			pos;

	if( --m_TimerCountdown == 0 ) 
	{
		m_TimerCountdown = SCRN_UPDATE_RELOAD;
		updateStats = TRUE;
	}

	pos = pDoc->m_listDeviceSets.GetHeadPosition();
	while(pos)
	{
		cds= (CDeviceSet *)pDoc->m_listDeviceSets.GetNext(pos);

		if( (pwin = cds->m_portWindow) )
			pwin->TimerTick( updateStats );
	}

	CScrollView::OnTimer(nIDEvent);
}





LRESULT CAtariServerView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if( message == WM_CLOSEPORTWIN )
	{
		delete (CPortWindow *)lParam;

		CAtariServerDoc	*pDoc = GetMyDocument();
		pDoc->SetModifiedFlag(TRUE);
		pDoc->UpdateAllViews(NULL);
		return TRUE;
	}
	return CScrollView::WindowProc(message, wParam, lParam);
}









