// DiskData.cpp: implementation of the CDiskData class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "common.h"

//#include "io.h"
//#include "fcntl.h"
//#include "sys/types.h"
//#include "sys/stat.h"
#include "stdio.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDiskData::CDiskData( CAtariServerDoc *pDoc )
{
	m_isDirty = FALSE;
	m_dskDataBytes = NULL;

	m_hFile = NULL;

	m_nSectorsRead = m_nSectorsWritten = 0;

	nRefCount = 1;

	m_myDoc = pDoc;
}




CDiskData::~CDiskData()
{
	ASSERT( nRefCount==0 );

	if( m_dskDataBytes ) 
	{
		diskFlush();
		if( m_hFile ) fclose(m_hFile);

		m_myDoc->m_listDiskDataInstances.RemoveAt( m_myDoc->m_listDiskDataInstances.Find( (CObject *)this ) );

		delete m_dskDataBytes;
	}
}












BOOL CDiskData::diskCreate( CString cstrFileName, CString cstrPathName, CString desc, int dtype )
{
	FILE	*hFile;
	int		nBytes, nBytesPerSector, nNumSectors;
	LPBYTE	sbuf;
	DISKHDR	dskHeader;

	if( !(hFile= fopen((LPCTSTR)cstrPathName,"wb")) ) return FALSE;

	GetDiskGeometry( dtype, nBytesPerSector, nNumSectors );

	nBytes = nBytesPerSector * nNumSectors;
	sbuf = new BYTE[nBytes];

	memset( &dskHeader,0,sizeof(DISKHDR));

	dskHeader.version		= REV_LATEST;
	dskHeader.diskType		= dtype;
	dskHeader.bytesPerSector = nBytesPerSector;
	dskHeader.numSectors	 = nNumSectors ;
	dskHeader.writeProtect = 0;
	
	desc.TrimLeft();
	desc = desc.Left(MAX_NAMELEN);
	desc.TrimRight();
	strcpy( (LPTSTR)dskHeader.diskName, (LPCTSTR)desc );

	fwrite( &dskHeader, sizeof(DISKHDR), 1, hFile);
	fwrite( sbuf, 1, nBytes, hFile );
	fclose( hFile );

	delete sbuf;

	return diskOpen(cstrFileName, cstrPathName);
}








BOOL CDiskData::diskOpen( CString cstrFileName, CString cstrPathName )
{
	FILE		*hFile;
	DISKHDR		dskHeader;

	m_cstrFileName = cstrFileName;
	m_cstrPathName = cstrPathName;

	if( !(hFile = fopen((LPCTSTR)m_cstrPathName, "r+b")) )	return FALSE;

	fread( &dskHeader, sizeof(DISKHDR), 1, hFile);

	m_dskType			= dskHeader.diskType;
	m_dskWriteProtect	= (dskHeader.writeProtect)?TRUE:FALSE;
	m_dskDesc			= CString((LPCTSTR)dskHeader.diskName);
	m_dskBytesPerSector = dskHeader.bytesPerSector;
	m_dskNumberSectors	= dskHeader.numSectors;

	m_dskSizeBytes = dskHeader.bytesPerSector * dskHeader.numSectors;

	switch( m_dskType )
	{
	case DTYPE_810:
		break;

	case DTYPE_815:
		break;

	default:
		fclose(hFile);
		return FALSE;
	}

	m_dskDataBytes = new BYTE[ m_dskSizeBytes ];
	fread( m_dskDataBytes, 1, m_dskSizeBytes, hFile);


	m_hFile = hFile;
	m_isDirty = FALSE;


	m_myDoc->m_listDiskDataInstances.AddTail( this );
	return TRUE;
}






void CDiskData::diskFlush(void)
{
	ASSERT( m_dskDataBytes );

	if( m_isDirty )
	{
		DISKHDR	dskHeader;

		memset( &dskHeader,0,sizeof(DISKHDR));

		dskHeader.version		= REV_LATEST;
		dskHeader.diskType		= m_dskType;

		dskHeader.bytesPerSector = m_dskBytesPerSector;
		dskHeader.numSectors	 = m_dskNumberSectors ;


		if( m_dskWriteProtect )
			dskHeader.writeProtect = 0;
		else
			dskHeader.writeProtect = -1;

		strcpy( (LPTSTR)dskHeader.diskName, (LPCTSTR)m_dskDesc );

		fseek( m_hFile, 0, SEEK_SET );
		fwrite( &dskHeader, sizeof(DISKHDR), 1, m_hFile);
		fwrite( m_dskDataBytes, 1, m_dskSizeBytes, m_hFile );
		fflush( m_hFile );

		m_isDirty = FALSE;
	}
	return;
}









void CDiskData::diskSetWriteProtect( BOOL state )
{
	if( m_dskWriteProtect != state )
	{
		m_dskWriteProtect = state;
		m_isDirty = TRUE;
	}
}






void CDiskData::diskSetNewDesc( CString desc )
{
	desc.TrimLeft();
	desc = desc.Left(MAX_NAMELEN);
	desc.TrimRight();

	if( desc.Compare( (LPCTSTR)m_dskDesc ) )
	{
		m_dskDesc = desc;
		m_isDirty = TRUE;
	}
}







CString	CDiskData::diskGetDiskTypeName(void)
{
	CString		rval;

	if( m_dskType == DTYPE_810 )
		rval.LoadString( IDS_FMT_DTYPE810 );
	else if( m_dskType == DTYPE_815 )
		rval.LoadString( IDS_FMT_DTYPE810 );

	return rval;
}





void CDiskData::GetDiskGeometry( int dtype, int &nBytesPerSector, int &nNumSectors )
{
	if( dtype == DTYPE_810 )
	{
		nBytesPerSector	= 128;
		nNumSectors		= 720;
	}
	else if( dtype == DTYPE_815 )
	{
		nBytesPerSector	= 256;
		nNumSectors		= 720;
	}

#ifdef _DEBUG
	else _asm int 3;
#endif

}
