// DiskDevice.cpp: implementation of the CDiskDevice class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "common.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CDiskDevice::CDiskDevice( CAtariServerDoc *pDoc )
{
	m_SettingControls = FALSE;

	m_chkWriteProt		= NULL;
	m_staticDriveNum	= NULL;
	m_txtDriveDesc		= NULL;
	m_staticDriveType	= NULL;
	m_staticDriveStat	= NULL;
	m_cmdAction			= NULL;

	m_diskData			= NULL;

	m_myDoc				= pDoc;
}


CDiskDevice::~CDiskDevice()
{
	if( m_diskData ) diskClose();
}






void CDiskDevice::scrCtlSet( CPortWindow *cpw )
{
	CString		cstr;

	m_SettingControls = TRUE;

	switch( m_nDiskNum )
	{
	case 1:
		m_chkWriteProt		= &cpw->m_chkWriteProt1;
		m_staticDriveNum	= &cpw->m_staticDriveNum1;
		m_txtDriveDesc		= &cpw->m_txtDriveDesc1;
		m_staticDriveType	= &cpw->m_staticDriveType1;
		m_staticDriveStat	= &cpw->m_staticDriveStat1;
		m_cmdAction			= &cpw->m_cmdAction1;
		break;
	case 2:
		m_chkWriteProt		= &cpw->m_chkWriteProt2;
		m_staticDriveNum	= &cpw->m_staticDriveNum2;
		m_txtDriveDesc		= &cpw->m_txtDriveDesc2;
		m_staticDriveType	= &cpw->m_staticDriveType2;
		m_staticDriveStat	= &cpw->m_staticDriveStat2;
		m_cmdAction			= &cpw->m_cmdAction2;
		break;
	case 3:
		m_chkWriteProt		= &cpw->m_chkWriteProt3;
		m_staticDriveNum	= &cpw->m_staticDriveNum3;
		m_txtDriveDesc		= &cpw->m_txtDriveDesc3;
		m_staticDriveType	= &cpw->m_staticDriveType3;
		m_staticDriveStat	= &cpw->m_staticDriveStat3;
		m_cmdAction			= &cpw->m_cmdAction3;
		break;
	case 4:
		m_chkWriteProt		= &cpw->m_chkWriteProt4;
		m_staticDriveNum	= &cpw->m_staticDriveNum4;
		m_txtDriveDesc		= &cpw->m_txtDriveDesc4;
		m_staticDriveType	= &cpw->m_staticDriveType4;
		m_staticDriveStat	= &cpw->m_staticDriveStat4;
		m_cmdAction			= &cpw->m_cmdAction4;
		break;
	}

	cstr.LoadString( IDS_MSG_DISMOUNT );
	m_cmdAction->SetWindowText( cstr );

	m_txtDriveDesc->EnableWindow(TRUE);
	m_txtDriveDesc->SetWindowText( m_diskData->diskGetDiskDesc() );
	m_txtDriveDesc->UpdateWindow();

	m_staticDriveType->SetWindowText( m_diskData->diskGetDiskTypeName() );

	cstr.Format(IDS_FMT_SHOWDISKNUM, m_nDiskNum );
	m_staticDriveNum->SetWindowText( cstr );

	m_chkWriteProt->EnableWindow(TRUE);

	RefreshControls();
	UpdateStats();
	m_SettingControls = FALSE;
}



void	CDiskDevice::scrCtlClear()
{
	m_SettingControls = TRUE;

	CString	cstr;
	cstr.LoadString( IDS_MSG_MOUNT );
	m_cmdAction->SetWindowText( cstr );

	m_chkWriteProt->EnableWindow(FALSE);
	m_chkWriteProt->SetCheck(0);
	m_chkWriteProt->SetWindowText("");
	m_chkWriteProt->UpdateWindow();
	
	m_staticDriveNum->SetWindowText("");

	m_txtDriveDesc->EnableWindow(FALSE);
	m_txtDriveDesc->SetWindowText("");
	m_txtDriveDesc->UpdateWindow();

	m_staticDriveType->SetWindowText("");
	m_staticDriveStat->SetWindowText("");

	m_SettingControls = FALSE;
}













void	CDiskDevice::diskSetData( int nDiskNum, CDiskData	*myDisk )
{
	m_diskData = myDisk;
	m_nDiskNum = nDiskNum;

	m_myDoc->SetModifiedFlag(TRUE);
	return;
}






void CDiskDevice::diskClose()
{
	ASSERT( m_diskData );

	if( m_diskData->DropReference() )
	{
		m_diskData->diskFlush();
		delete m_diskData;
	}
	m_diskData = NULL;

	m_myDoc->SetModifiedFlag(TRUE);
}




void CDiskDevice::diskSetWriteProtect( BOOL state )
{
	ASSERT( m_diskData );

	if( m_SettingControls ) return;

	m_diskData->diskSetWriteProtect(state);
}


void CDiskDevice::diskSetNewDesc( CString desc )
{
	ASSERT( m_diskData );

	if( m_SettingControls ) return;

	m_diskData->diskSetNewDesc(desc);
}




void CDiskDevice::UpdateStats(void)
{
	if( m_diskData )
	{
		CString		cstr;

		if( m_staticDriveStat )
		{
			cstr.Format(IDS_FMT_DISKSTATS, m_diskData->m_nSectorsRead, m_diskData->m_nSectorsWritten );
			m_staticDriveStat->SetWindowText(cstr);
		}
	}
}






void CDiskDevice::RefreshControls(void)
{
	CString		cstr;
	if( m_diskData->diskGetWriteProtect() )
	{
		m_chkWriteProt->SetCheck(1);
		cstr.LoadString(IDS_MSG_RDONLY);
	}
	else
	{
		m_chkWriteProt->SetCheck(0);
		cstr.LoadString(IDS_MSG_RDWR);
	}
	m_chkWriteProt->SetWindowText(cstr);
	m_chkWriteProt->UpdateWindow();
}










DWORD  CDiskDevice::cmdGetStatus( LPBYTE buff )
{
	int	dtype = m_diskData->diskGetDiskType();

	switch( dtype )
	{
	case DTYPE_810:
	case DTYPE_815:
		buff[0]= 0;
		// 					buff[0] |= 1;		// =1 if last command bad
		// 					buff[0] |= 2;		// =1 if last data bad

		if( m_diskData->diskGetWriteProtect() )	buff[0] |= 8;

		buff[0] |= 0x10;		// disk is active

		if( dtype == DTYPE_810 )
			buff[0] |= 0;
		else if( dtype == DTYPE_815 )
			buff[0] |= 0x60;

		buff[1] = 0;
		buff[2] = 2;
		buff[3] = 0;
		buff[4] = calcChecksum(buff,4);
		break;
	}

	return 5;
}






int		CDiskDevice::cmdGetEffectiveSectorSizeFromNumber( int sectorNum )
{
	int nBytesPerSector = m_diskData->diskGetBytesPerSector();

	if( m_diskData->diskGetDiskType() == DTYPE_815 )
	{
		if( sectorNum <= 3 ) nBytesPerSector = 128;
	}
	return nBytesPerSector;
}




DWORD	CDiskDevice::cmdGetSector( int sectorNum, LPBYTE buff)
{
	if( sectorNum < 0 || sectorNum >= m_diskData->diskGetNumberSectors() ) return -1;

	int		nBytesPerSector = m_diskData->diskGetBytesPerSector();
	int		nBytes2Copy		= cmdGetEffectiveSectorSizeFromNumber( sectorNum );
	LPBYTE	diskBuff		= m_diskData->GetDiskData();

	
	memcpy( buff, &diskBuff[ sectorNum * nBytesPerSector ], nBytes2Copy );

	buff[ nBytes2Copy ]= calcChecksum(buff, nBytes2Copy );

	++m_diskData->m_nSectorsRead;

	return nBytes2Copy+1;
}






BOOL  CDiskDevice::cmdPutSector( int sectorNum, LPBYTE buff )
{
	if( sectorNum < 0 || sectorNum >= m_diskData->diskGetNumberSectors() ) return FALSE;

	int		nBytesPerSector = m_diskData->diskGetBytesPerSector();
	int		nBytes2Copy		= cmdGetEffectiveSectorSizeFromNumber( sectorNum );
	LPBYTE	diskBuff		= m_diskData->GetDiskData();

	if( buff[ nBytes2Copy ] == calcChecksum(buff, nBytes2Copy ) ) return FALSE;

	memcpy( &diskBuff[ sectorNum * nBytesPerSector ], buff, nBytes2Copy );

	++m_diskData->m_nSectorsWritten;

	m_diskData->diskSetDirty();
	return TRUE;
}






DWORD CDiskDevice::cmdFormatDisk( LPBYTE buff )
{
	int		i,dtype			= m_diskData->diskGetDiskType();
	LPBYTE	diskBuff		= m_diskData->GetDiskData();
	int		nBytesPerSector = m_diskData->diskGetBytesPerSector();

	for(i=0; i< m_diskData->diskGetNumberSectors(); i++)
		memset( &diskBuff[ nBytesPerSector * i ],0 ,nBytesPerSector );

	switch( dtype )
	{
	case DTYPE_810:
	case DTYPE_815:
		memset(buff, 0, nBytesPerSector );
		buff[0]   = 0xff;
		buff[1]   = 0xff;
		buff[126] = 0xff;
		buff[127] = 0xff;
		break;
	}

	buff[ nBytesPerSector ]= calcChecksum(buff, nBytesPerSector );

	m_diskData->diskSetDirty();
	return nBytesPerSector+1;
}



