// DlgCreateDisk.cpp : implementation file
//

#include "stdafx.h"
#include "common.h"

#include "DlgCreateDisk.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgCreateDisk dialog


CDlgCreateDisk::CDlgCreateDisk(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgCreateDisk::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgCreateDisk)
	m_cstrDiskDesc = _T("");
	m_cstrDiskFilename = _T("");
	//}}AFX_DATA_INIT
}


void CDlgCreateDisk::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgCreateDisk)
	DDX_Text(pDX, IDC_TXT_DISKDESCRIPTION, m_cstrDiskDesc);
	DDX_Text(pDX, IDC_TXT_DISKFILENAME, m_cstrDiskFilename);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgCreateDisk, CDialog)
	//{{AFX_MSG_MAP(CDlgCreateDisk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgCreateDisk message handlers

BOOL CDlgCreateDisk::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_diskDataNewDisk = NULL;

	CheckRadioButton( IDC_RAD_810, IDC_RAD_815, IDC_RAD_810 ); 
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



void CDlgCreateDisk::OnOK() 
{
	CString cstrFileName, cstrPathName, cstrTemp;
	int		i,diskType;

	UpdateData(TRUE);

	m_cstrDiskFilename.TrimLeft();

	if( (i= m_cstrDiskFilename.Find((TCHAR)'.')) > -1 )
		m_cstrDiskFilename = m_cstrDiskFilename.Left(i-1);

	m_cstrDiskFilename.TrimRight();

	if( m_cstrDiskFilename.GetLength() == 0 ) return;

	cstrTemp.LoadString(IDS_FMT_DISKFILEEXT);

	cstrFileName = m_cstrDiskFilename + cstrTemp;
	cstrPathName = theApp.m_cstrDiskFileDirectory + "\\" + cstrFileName;

	int ctlID = GetCheckedRadioButton( IDC_RAD_810, IDC_RAD_815 ); 

	if( ctlID == IDC_RAD_810 )
		diskType = DTYPE_810;
	else if( ctlID == IDC_RAD_815 )
		diskType = DTYPE_815;
	else return;

	CMainFrame		*mainWnd = (CMainFrame *)AfxGetMainWnd();
	CAtariServerDoc *pDoc = (CAtariServerDoc *)mainWnd->GetActiveDocument();

	CDiskData	*diskData = new CDiskData(pDoc);

	if( !diskData->diskCreate( cstrFileName, cstrPathName, m_cstrDiskDesc, diskType ) )
	{
		cstrTemp.Format(IDS_MSG_CANTCREATEDISK,(LPCTSTR)cstrFileName);
		AfxMessageBox( cstrTemp, MB_ICONERROR | MB_OK );
		delete diskData;
		return;
	}

	m_diskDataNewDisk = diskData;
	CDialog::OnOK();
}
