// DlgSelectDisk.cpp : implementation file
//

#include "stdafx.h"
#include "common.h"

#include "DlgSelectDisk.h"
#include "DlgCreateDisk.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgSelectDisk dialog


CDlgSelectDisk::CDlgSelectDisk(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgSelectDisk::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgSelectDisk)
	//}}AFX_DATA_INIT

	m_cstrSelectedDisk= NULL;
}



CDlgSelectDisk::~CDlgSelectDisk()
{
	while( !m_listDiskRecords.IsEmpty() ) delete m_listDiskRecords.RemoveHead();
}




void CDlgSelectDisk::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgSelectDisk)
	DDX_Control(pDX, IDC_TXT_SECTORSFREE, m_txtSectorsFree);
	DDX_Control(pDX, IDC_TXT_WRITEPROT, m_txtWriteProt);
	DDX_Control(pDX, IDC_BUT_FILESCAN, m_cmdShowByFileScan);
	DDX_Control(pDX, IDC_BUT_FILENAME, m_cmdShowByFilename);
	DDX_Control(pDX, IDC_BUT_DESCRIPTION, m_cmdShowByDescription);
	DDX_Control(pDX, IDC_STATIC_SHOWSORTBY, m_staticShowSortBy);
	DDX_Control(pDX, IDC_LIST_DISKFILES, m_lbDiskFiles);
	DDX_Control(pDX, IDC_ITEMLIST, m_lbItems);
	DDX_Control(pDX, IDC_TXT_FILENAME, m_txtDiskFileName);
	DDX_Control(pDX, IDC_TXT_DISKTYPE, m_txtDiskType);
	DDX_Control(pDX, IDC_TXT_DESCRIPTION, m_txtDiskDesc);
	DDX_Control(pDX, IDC_STATIC_ITEMLIST_HEADER, m_staticListHeader);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgSelectDisk, CDialog)
	//{{AFX_MSG_MAP(CDlgSelectDisk)
	ON_BN_CLICKED(IDC_CREATENEW, OnCreatenew)
	ON_BN_CLICKED(IDC_BUT_DESCRIPTION, OnButDescription)
	ON_BN_CLICKED(IDC_BUT_FILENAME, OnButFilename)
	ON_BN_CLICKED(IDC_BUT_FILESCAN, OnButFilescan)
	ON_LBN_DBLCLK(IDC_ITEMLIST, OnDblclkItemlist)
	ON_LBN_SELCHANGE(IDC_ITEMLIST, OnSelchangeItemlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgSelectDisk message handlers


BOOL CDlgSelectDisk::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_cstrSelectedDisk = NULL;

	LoadFilenames();

	OnButFilename();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}








void CDlgSelectDisk::OnCreatenew() 
{
	CDlgCreateDisk	dlgCreate;

	if( dlgCreate.DoModal() == IDOK )
	{
		m_cstrSelectedDisk = dlgCreate.m_diskDataNewDisk;
		EndDialog( IDOK );
	}
}







void CDlgSelectDisk::LoadFilenames() 
{
	CWaitCursor			cursorWait;
	HANDLE				hFindFile;
	WIN32_FIND_DATA		findFile;

	CDiskRecord		*cdr;
	CDiskData		*diskData,*tstDisk;

	CString			cstrWildcard, cstrPathName, cstrFileName,cstrTest;

	CMainFrame			*mainWnd = (CMainFrame *)AfxGetMainWnd();
	CAtariServerDoc		*pDoc = (CAtariServerDoc *)mainWnd->GetActiveDocument();
	POSITION			ddpos;

	cstrWildcard.LoadString( IDS_FMT_DISKFILEFILTER );
	cstrWildcard = theApp.m_cstrDiskFileDirectory + "\\" + cstrWildcard.Mid( cstrWildcard.Find((TCHAR)'\t')+1 );

	if( (hFindFile = FindFirstFile( (LPCTSTR)cstrWildcard, &findFile )) == INVALID_HANDLE_VALUE ) return;

	for(;;)
	{
		if( !(findFile.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) )
		{
			cstrFileName = CString(findFile.cFileName);
			cstrPathName = theApp.m_cstrDiskFileDirectory + "\\" + cstrFileName;

			ddpos	 = pDoc->m_listDiskDataInstances.GetHeadPosition();
			diskData = NULL;
			while(ddpos)
			{
				tstDisk = (CDiskData *)pDoc->m_listDiskDataInstances.GetNext(ddpos);

				cstrTest = tstDisk->fileGetDiskPathName();

				if( cstrTest.Compare( cstrPathName )==0 ){ diskData = tstDisk; break; }
			}
			if( !diskData )
				diskData = new CDiskData(pDoc);
			else
				diskData->AddReference();

			if( diskData->diskOpen( cstrFileName, cstrPathName ) )
			{
				cdr = new CDiskRecord( diskData );

				cdr->m_cstrFileName = diskData->fileGetDiskFileName();

				ReadDiskDirectory(cdr);

				m_listDiskRecords.AddTail(cdr);
			}
			else
			{
				diskData->DropReference();
				delete diskData;
				diskData = NULL;
			}
		}
		if( !FindNextFile( hFindFile, &findFile ) ) break;
	}
	

	FindClose( hFindFile );
}






void CDlgSelectDisk::ReadDiskDirectory( CDiskRecord *cdr )
{
	int		i,j;
	BYTE	*diskBuf = (cdr->m_diskData)->GetDiskData();
	int		nBytesPerSector = (cdr->m_diskData)->diskGetBytesPerSector();

	//
	// Get Vtoc
	//
	LPSECTOR_VTOC	vtoc = (LPSECTOR_VTOC)&diskBuf[ nBytesPerSector * (0x168-1) ];

	cdr->m_SectorsFree = ((WORD)vtoc->numUnusedSectors & 0x7FFF);

	//
	// Read Directory
	//
	LPSECTOR_DIR		dirSector;
	LPSECTOR_DIRENTRY	dirEntry;
	CString				cstrFile, cstr;

	for(i=0x169; i<= 0x170; i++)
	{
		dirSector = (LPSECTOR_DIR)&diskBuf[ nBytesPerSector * (i-1) ];

		for(j=0; j<8; j++ )
		{
			dirEntry = &dirSector->dirEntries[j];

			if( (dirEntry->flag & 0x40) )
			{
				cstr = CString((LPCTSTR)dirEntry->fileName, 8);
				cstr.TrimRight();

				cstrFile = cstr;

				cstr = CString((LPCTSTR)dirEntry->fileExt, 3);
				cstr.TrimRight();

				if( cstr.GetLength() ) cstrFile += "." + cstr;

				cdr->m_listDiskFiles.AddTail(cstrFile);
			}
			else if( dirEntry->flag == 0 ) goto donedir;
		}
	}
donedir:

	return;
}






void CDlgSelectDisk::OnButFilename() 
{
	CWaitCursor		cwait;
	CString			cstr;

	m_cmdShowByFilename.GetWindowText( cstr );
	m_staticShowSortBy.SetWindowText( cstr );

	m_lbItems.ResetContent();
	m_lbDiskFiles.ResetContent();
	m_txtDiskDesc.SetWindowText("");
	m_txtDiskFileName.SetWindowText("");
	m_txtDiskType.SetWindowText("");
	m_txtWriteProt.SetWindowText("");
	m_txtSectorsFree.SetWindowText("");

	int			nListNdx,nRecNum = 0;
	POSITION	pos = m_listDiskRecords.GetHeadPosition();
	CDiskRecord	*dskRec;

	while(pos)
	{
		dskRec = (CDiskRecord *)m_listDiskRecords.GetNext(pos);
		nListNdx = m_lbItems.AddString( dskRec->m_cstrFileName );
		m_lbItems.SetItemData( nListNdx, nRecNum++ );
	}

	if( m_lbItems.GetCount() > 0 )
	{
		m_lbItems.SetCurSel(0);
		ShowListItem();
	}
}



void CDlgSelectDisk::OnButDescription() 
{
	CWaitCursor		cwait;
	CString			cstr;

	m_cmdShowByDescription.GetWindowText( cstr );
	m_staticShowSortBy.SetWindowText( cstr );

	m_lbItems.ResetContent();
	m_lbDiskFiles.ResetContent();
	m_txtDiskDesc.SetWindowText("");
	m_txtDiskFileName.SetWindowText("");
	m_txtDiskType.SetWindowText("");
	m_txtWriteProt.SetWindowText("");
	m_txtSectorsFree.SetWindowText("");

	int			nListNdx,nRecNum = 0;
	POSITION	pos = m_listDiskRecords.GetHeadPosition();
	CDiskRecord	*cdr;

	while(pos)
	{
		cdr = (CDiskRecord *)m_listDiskRecords.GetNext(pos);
		nListNdx = m_lbItems.AddString( (cdr->m_diskData)->diskGetDiskDesc() );
		m_lbItems.SetItemData( nListNdx, nRecNum++ );
	}

	if( m_lbItems.GetCount() > 0 )
	{
		m_lbItems.SetCurSel(0);
		ShowListItem();
	}
}



void CDlgSelectDisk::OnButFilescan() 
{
	CWaitCursor		cwait;
	CString			cstr;

	m_cmdShowByFileScan.GetWindowText( cstr );
	m_staticShowSortBy.SetWindowText( cstr );

	m_lbItems.ResetContent();
	m_lbDiskFiles.ResetContent();
	m_txtDiskDesc.SetWindowText("");
	m_txtDiskFileName.SetWindowText("");
	m_txtDiskType.SetWindowText("");
	m_txtWriteProt.SetWindowText("");
	m_txtSectorsFree.SetWindowText("");

	int			nListNdx,nRecNum = 0;
	POSITION	pos = m_listDiskRecords.GetHeadPosition(), posFiles;
	CDiskRecord	*cdr;

	while(pos)
	{
		cdr = (CDiskRecord *)m_listDiskRecords.GetNext(pos);

		posFiles = cdr->m_listDiskFiles.GetHeadPosition();
		while( posFiles )
		{
			nListNdx = m_lbItems.AddString( cdr->m_listDiskFiles.GetNext(posFiles) );
			m_lbItems.SetItemData( nListNdx, nRecNum );
		}
		nRecNum++;
	}

	if( m_lbItems.GetCount() > 0 )
	{
		m_lbItems.SetCurSel(0);
		ShowListItem();
	}
}








void CDlgSelectDisk::OnDblclkItemlist() 
{
	m_lbItems.UpdateWindow();
	if( ShowListItem() )
	{
		SelectListItem();
		EndDialog(IDOK);
	}
}


void CDlgSelectDisk::OnSelchangeItemlist() 
{
	m_lbItems.UpdateWindow();
	ShowListItem();
}





BOOL CDlgSelectDisk::ShowListItem()
{
	CString			cstr;
	CDiskRecord		*cdr;
	POSITION		pos;
	int				nListIndex,nDiskIndex;
	
	nListIndex= m_lbItems.GetCurSel();

	ASSERT( nListIndex != LB_ERR );

	nDiskIndex = (int)m_lbItems.GetItemData(nListIndex);

	cdr = (CDiskRecord *)m_listDiskRecords.GetAt( m_listDiskRecords.FindIndex( nDiskIndex ) );

	m_txtDiskFileName.SetWindowText( cdr->m_cstrFileName );
	m_txtDiskType.SetWindowText( (cdr->m_diskData)->diskGetDiskTypeName() );
	m_txtDiskDesc.SetWindowText( (cdr->m_diskData)->diskGetDiskDesc() );

	if( (cdr->m_diskData)->diskGetWriteProtect() )
		cstr.LoadString(IDS_MSG_RDONLY);
	else
		cstr.LoadString(IDS_MSG_RDWR);

	m_txtWriteProt.SetWindowText(cstr);


	cstr.Format(IDS_FMT_SECTORSFREE, cdr->m_SectorsFree );
	m_txtSectorsFree.SetWindowText(cstr);


	m_lbDiskFiles.ResetContent();

	pos = cdr->m_listDiskFiles.GetHeadPosition();
	while(pos)
	{
		m_lbDiskFiles.AddString( cdr->m_listDiskFiles.GetNext(pos) );
	}
	return TRUE;
}




void CDlgSelectDisk::SelectListItem()
{
	CDiskRecord		*cdr;
	int				nListIndex,nDiskIndex;

	nListIndex= m_lbItems.GetCurSel();

	ASSERT( nListIndex != LB_ERR );

	nDiskIndex = (int)m_lbItems.GetItemData(nListIndex);
	cdr = (CDiskRecord *)m_listDiskRecords.GetAt( m_listDiskRecords.FindIndex( nDiskIndex ) );

	m_cstrSelectedDisk = cdr->m_diskData;
	cdr->m_diskData = NULL;
}






void CDlgSelectDisk::OnOK() 
{
	SelectListItem();
	CDialog::OnOK();
}




