// DlgSelectPath.cpp : implementation file
//

#include "stdafx.h"
#include "AtariServer.h"
#include "DlgSelectPath.h"
#include "direct.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgSelectPath dialog


CDlgSelectPath::CDlgSelectPath(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgSelectPath::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgSelectPath)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_cstrPathSel = CString();
}


void CDlgSelectPath::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgSelectPath)
	DDX_Control(pDX, IDC_STATUS, m_staticStatus);
	DDX_Control(pDX, IDC_PROGRESS_SCAN, m_progressScan);
	DDX_Control(pDX, IDC_TREE_PATHS, m_treePaths);
	DDX_Control(pDX, IDC_COMBO_DRIVES, m_comboDrives);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgSelectPath, CDialog)
	//{{AFX_MSG_MAP(CDlgSelectPath)
	ON_CBN_SELCHANGE(IDC_COMBO_DRIVES, OnSelchangeComboDrives)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgSelectPath message handlers

UINT threadScanDrive( LPVOID pParam )
{
	return ((CDlgSelectPath *)pParam)->entryScanDrive();
}




BOOL CDlgSelectPath::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CString		tmp, cstrDrives((TCHAR)0,2048), cstrDefault, cstrDrive, cstrVol((TCHAR)0,2048);
	int			i,nItem, nDefItem= 0;
	//DWORD		dwJunk;
	
	cstrDefault = CString( m_cstrPathSel );

	if( cstrDefault.Mid(1,1) != ':' ) 
		cstrDefault = CString((TCHAR)(_getdrive()+'A')-1);
	else
		cstrDefault = cstrDefault.Left(1);

	cstrDefault.MakeLower();


	GetLogicalDriveStrings( cstrDrives.GetLength(), (char *)(LPCTSTR)cstrDrives );


	i= 0;
	while( !(cstrDrive= CString((LPCTSTR)cstrDrives.Mid(i)) ).IsEmpty() )
	{
		i += cstrDrive.GetLength()+1;

		//if( !GetVolumeInformation( (LPCTSTR)cstrDrive, (LPTSTR)(LPCTSTR)cstrVol, cstrVol.GetLength(), NULL, &dwJunk, &dwJunk, NULL, 0 ) )
		//	cstrVol = CString();

		cstrDrive.MakeLower();
		//cstrDrive += "  " + cstrVol;

		nItem = m_comboDrives.AddString( cstrDrive );

		if( cstrDrive.Left(1) == cstrDefault.Left(1) ) nDefItem = nItem;

	}

	m_comboDrives.SetCurSel( nDefItem );

	m_boolTerminate		= FALSE;
	m_boolTerminated	= FALSE;
	m_boolScanNow		= FALSE;
	m_boolScanReset		= FALSE;

	m_threadDriveScan = AfxBeginThread( (AFX_THREADPROC)threadScanDrive, (LPVOID)this, THREAD_PRIORITY_NORMAL );
	m_threadDriveScan->m_bAutoDelete = TRUE;

	updateTree();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



void CDlgSelectPath::killThread()
{
	if( !m_boolTerminated )
	{
		m_boolScanNow	= FALSE;
		m_boolTerminate = TRUE;
		while( !m_boolTerminated ) Sleep(50);
		Sleep(50);
	}
}









BOOL CDlgSelectPath::DestroyWindow() 
{
	killThread();
	return CDialog::DestroyWindow();
}








void CDlgSelectPath::OnCancel() 
{
	killThread();
	m_cstrPathSel= CString();	
	CDialog::OnCancel();
}





void CDlgSelectPath::OnOK() 
{
	int			csel;

	m_cstrPathSel= CString();	

	if( (csel= m_comboDrives.GetCurSel()) != CB_ERR )
	{
		CString		cstrDrive((TCHAR)0,_MAX_PATH) ,cstrDir;
		TV_ITEM		tvi;
		int			i;

		killThread();
		m_treePaths.UpdateWindow();

		tvi.mask		= TVIF_TEXT;
		tvi.pszText		= (LPSTR)(LPCTSTR)cstrDrive;
		tvi.cchTextMax	= cstrDrive.GetLength();

		if( m_treePaths.GetCount() &&  (tvi.hItem = m_treePaths.GetSelectedItem()) )
		{
			m_treePaths.GetItem( &tvi );

			cstrDir= CString( tvi.pszText );

			while( (tvi.hItem = m_treePaths.GetParentItem( tvi.hItem )) )
			{
				m_treePaths.GetItem( &tvi );
				cstrDir= CString( tvi.pszText ) + "\\" + cstrDir;
			}
		}

		m_comboDrives.GetLBText( csel, cstrDrive );
		if( (i=cstrDrive.Find((TCHAR)32)) > -1 ) cstrDrive = cstrDrive.Left( i );
		cstrDrive.TrimLeft();
		cstrDrive.TrimRight();


		m_cstrPathSel = cstrDrive + cstrDir;
		m_cstrPathSel.MakeLower();

		CDialog::OnOK();
	}
	else MessageBeep( 0xFFFFFFFF );
}




void CDlgSelectPath::OnSelchangeComboDrives() 
{
	updateTree();
}











void CDlgSelectPath::updateTree()
{
	int			csel;

	if( (csel= m_comboDrives.GetCurSel()) != CB_ERR )
	{
		CWaitCursor	cursorWait;
		CString		tmp,cstrDrive;
		int			i;


		m_boolScanNow = FALSE;
		while( !m_boolScanReset ) Sleep(50);
		
		tmp.LoadString(IDS_STAT_SCANNING);
		m_staticStatus.SetWindowText( tmp );

		m_comboDrives.GetLBText( csel, cstrDrive );
		if( (i=cstrDrive.Find((TCHAR)32)) > -1 ) cstrDrive = cstrDrive.Left( i );
		cstrDrive.TrimLeft();
		cstrDrive.TrimRight();
		cstrDrive.MakeLower();

		m_progressScan.SetPos(0);
		m_treePaths.DeleteAllItems();

		UpdateWindow();

		m_cstrScanDrive = cstrDrive;

		m_boolScanNow = TRUE;
		while( m_boolScanReset ) Sleep(50);
	}
	else MessageBeep( 0xFFFFFFFF );
}






UINT CDlgSelectPath::entryScanDrive()
{
	CString	tmp;

	while( !m_boolTerminate )
	{
		m_boolScanReset = TRUE;

		if( m_boolScanNow )
		{
			m_boolScanReset = FALSE;

			scanSubdirectories( CString( m_cstrScanDrive ) );

			if( m_boolScanNow )
			{
				tmp.LoadString(IDS_STAT_READY);
				m_staticStatus.SetWindowText( tmp );
				m_progressScan.SetPos(0);
			}
			m_boolScanNow= FALSE;
		}
		else Sleep(50);
	}

	m_boolTerminated = TRUE;
	return 0;
}





//
// do depth first directory scan
//

void CDlgSelectPath::scanSubdirectories( CString scanPath )
{
	CObList				listDirs;
	CStringList			*cstrDirList;
	CString				tmp,dirName,cstrTemp,cstrPath,cstrBasePath;
	WIN32_FIND_DATA		ffind;
	HANDLE				hfind;
	TV_INSERTSTRUCT		tis;
	int					i,nRootDirs= -1;

	memset( &tis,0,sizeof(TV_INSERTSTRUCT) );
	tis.hInsertAfter	= TVI_SORT;
	tis.item.mask		= TVIF_TEXT;


	cstrDirList = new CStringList;
	listDirs.AddTail( cstrDirList );

	cstrDirList->AddHead( (cstrTemp.Format("%s\t%li", (LPCTSTR)scanPath, (long)TVI_ROOT ), cstrTemp)  );
	cstrDirList->AddTail("");



	while( !listDirs.IsEmpty() && m_boolScanNow )
	{
		cstrDirList = (CStringList *)listDirs.GetTail();


		tmp = cstrDirList->GetHead(); i = tmp.Find((TCHAR)9);

		cstrBasePath= tmp.Left(i);
		tis.hParent	= (HTREEITEM)atol( (LPCTSTR)tmp.Mid(i+1) );

		dirName = cstrDirList->RemoveTail();

		if( !dirName.IsEmpty() )
		{
			tis.item.pszText	= (LPSTR)(LPCTSTR)dirName;
			tis.item.cchTextMax	= dirName.GetLength();

			tis.hParent = m_treePaths.InsertItem( &tis );
		}
		
		cstrPath = cstrBasePath + dirName;
		if( cstrPath.Right(1) != '\\' ) cstrPath += CString("\\");


		if( cstrDirList->GetCount() == 1 )
		{
			listDirs.RemoveTail();
			delete cstrDirList;
		}

		hfind = FindFirstFile( cstrPath + "*.*", &ffind );

		if( hfind != INVALID_HANDLE_VALUE )
		{
			cstrDirList = new CStringList;

			do
			{
				if( (ffind.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) )
				{
					if( ffind.cFileName[0] != '.' )
					{
						dirName = CString( ffind.cFileName );

						dirName.MakeLower();

						cstrDirList->AddHead( dirName );
					}
				}
			}
			while( (FindNextFile(hfind, &ffind) || GetLastError() != ERROR_NO_MORE_FILES) && m_boolScanNow );

			FindClose( hfind );

			if( !cstrDirList->IsEmpty() )
			{
				cstrDirList->AddHead( (cstrTemp.Format("%s\t%li", (LPCTSTR)cstrPath, (long)tis.hParent ), cstrTemp)  );

				listDirs.AddTail( cstrDirList );
			}
			else
				delete cstrDirList;
		}


		if( listDirs.GetCount() == 1 )
		{
			cstrDirList = (CStringList *)listDirs.GetHead();

			if( nRootDirs == -1 )
			{
				m_progressScan.SetRange(0, (nRootDirs = cstrDirList->GetCount()) );
			}

			m_progressScan.SetPos( nRootDirs - cstrDirList->GetCount() );
		}
	}

	while( !listDirs.IsEmpty() ) delete (CStringList *)listDirs.RemoveHead();

	return;
}











/*
//
// do breadth first directory scan
//

void CDlgSelectPath::scanSubdirectories( CString scanPath )
{
	CObList				listDirs1, listDirs2, *listDirSrc,*listDirDest;
	int					nListDir = 0;
	CStringList			*cstrDirListSrc, *cstrDirListDest;
	CString				dirName,cstrTemp,cstrPath,cstrBasePath;
	WIN32_FIND_DATA		ffind;
	HANDLE				hfind;
	TV_INSERTSTRUCT		tis;
	HTREEITEM			thisItem;


	memset( &tis,0,sizeof(TV_INSERTSTRUCT) );
	tis.hInsertAfter	= TVI_SORT;
	tis.item.mask		= TVIF_TEXT;


	cstrDirListSrc = new CStringList;
	listDirs1.AddTail( cstrDirListSrc );

	cstrDirListSrc->AddTail( "" );
	cstrDirListSrc->AddTail( (cstrTemp.Format("%li",(long)TVI_ROOT ), cstrTemp) );
	cstrDirListSrc->AddTail( scanPath );



	while( (!listDirs1.IsEmpty() || !listDirs2.IsEmpty()) && (!m_boolTerminate && m_boolScanNow ) )
	{
		if( nListDir++ & 1 )
		{
			listDirSrc = &listDirs2;
			listDirDest = &listDirs1;
		}
		else
		{
			listDirSrc = &listDirs1;
			listDirDest = &listDirs2;
		}

		
		while( !listDirSrc->IsEmpty() && ( !m_boolTerminate && m_boolScanNow ))
		{
			cstrDirListSrc = (CStringList *)listDirSrc->RemoveHead();

			cstrBasePath= cstrDirListSrc->RemoveHead();
			

			while( !cstrDirListSrc->IsEmpty() && ( !m_boolTerminate && m_boolScanNow ) )
			{
				tis.hParent	= (HTREEITEM)atol( (LPCTSTR)cstrDirListSrc->RemoveHead() );

				cstrPath = cstrBasePath + cstrDirListSrc->RemoveHead();

				if( cstrPath.Right(1) != '\\' ) cstrPath += CString("\\");

				hfind = FindFirstFile( cstrPath + "*.*", &ffind );


				if( hfind != INVALID_HANDLE_VALUE )
				{
					cstrDirListDest = new CStringList;
					cstrDirListDest->AddTail( cstrPath );

					do
					{
						if( (ffind.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) )
						{
							if( ffind.cFileName[0] != '.' )
							{
								dirName = CString( ffind.cFileName );

								dirName.MakeLower();

								tis.item.pszText	= (LPSTR)(LPCTSTR)dirName;
								tis.item.cchTextMax	= dirName.GetLength();

								thisItem = m_treePaths.InsertItem( &tis );

								cstrDirListDest->AddTail( (cstrTemp.Format("%li",(int)thisItem), cstrTemp) );
								cstrDirListDest->AddTail( dirName );
							}
						}
					}
					while( (FindNextFile(hfind, &ffind) || GetLastError() != ERROR_NO_MORE_FILES) && ( !m_boolTerminate && m_boolScanNow ));

					FindClose( hfind );

					if( !cstrDirListDest->IsEmpty() )
						listDirDest->AddTail( cstrDirListDest );
					else
						delete cstrDirListDest;
				}
			}

			delete cstrDirListSrc;
		}
	}

	while( !listDirs1.IsEmpty() ) delete (CStringList *)listDirs1.RemoveHead();
	while( !listDirs2.IsEmpty() ) delete (CStringList *)listDirs2.RemoveHead();

	return;
}

*/
