//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "wintypes.h"
#include "switches.h"

int		m_iArgsCurr;
int		m_iArgsOrig;
char**	m_ppcArgvOrig;
char**	m_ppcArgvCurr;
char*		m_szSwitch;

//gets one token from cmdline
BOOL SWITCHES_GetSwitch()
{
	if ( !m_iArgsCurr )
		return FALSE;

	m_szSwitch = *( m_ppcArgvCurr++ );

	m_iArgsCurr--;

	return TRUE;
}

//gets one token, returns TRUE if value
BOOL SWITCHES_GetValue()
{
	if ( !SWITCHES_GetSwitch() )
		return FALSE;

	switch( *m_szSwitch )
	{
		case '-':
		case '/':
			return FALSE;

		default:
			return TRUE;
	}
}

//parses commandline, lefts all non-switches, deletes other
BOOL SWITCHES_Init( int* pargc, char* argv[] )
{
	BOOL bRet = TRUE;
	SWITCH_REC* sCurrSwitch = NULL;

	m_iArgsCurr = *pargc - 1;
	m_iArgsOrig = 1;
	m_ppcArgvOrig = argv + 1;
	m_ppcArgvCurr = argv + 1;

	while( m_iArgsCurr )
	{
		if ( SWITCHES_GetValue() )
		{
			bRet = TRUE;

			*( m_ppcArgvOrig++ ) = * ( m_ppcArgvCurr - 1 );
			m_iArgsOrig++;
		}
		else
		{
			m_szSwitch++;

			sCurrSwitch = g_aSwitches;

			do
			{
				if ( !strcmp( m_szSwitch, sCurrSwitch->szName ) )
					break;

				sCurrSwitch++;
			} while( sCurrSwitch->szName );

			if ( sCurrSwitch->pfbSwitchFunction )
			{
				bRet = ( * ( sCurrSwitch->pfbSwitchFunction ) )( sCurrSwitch->pPar1 );
			}
			else
			{
				printf( "Invalid switch: %s\n", *( m_ppcArgvCurr - 1 ) );
				return FALSE;
			}
		}

		if ( !bRet )
			break;

	} //endwhile

	*pargc = m_iArgsOrig;

	return bRet;
}


//displays help information
#ifndef SWITCH_HELP_COL
#define SWITCH_HELP_COL 30
#endif
BOOL SWFN_HELP( void* p )
{
	SWITCH_REC* pCmd = g_aSwitches;
	int iPrinted;

	if ( p )
	{
		printf( "%s\n", (char*)p );
	}

	printf( "Options:\n" );

	do
	{
		if ( pCmd->szHelp )
		{
			iPrinted = printf( "-%s", pCmd->szName );

			if ( pCmd->szPars )
			{
				iPrinted += printf( " %s", pCmd->szPars );
			}
			
			if ( iPrinted < SWITCH_HELP_COL - 1 )
				for( ; iPrinted < SWITCH_HELP_COL - 1; iPrinted++ )
					putchar( ' ' );

			printf( " -%s\n", pCmd->szHelp );

		}

		pCmd++;
	} while( pCmd->szName );

	return FALSE;
}

BOOL SWFN_BOOLT( void* pType )
{
	* ((int*) pType ) = TRUE;
	return TRUE;
}

BOOL SWFN_BOOLF( void* pType )
{
	* ((int*) pType ) = FALSE;
	return TRUE;
}

BOOL SWFN_NUMH( void* pType )
{
	char* szOrigSw = m_szSwitch;

	if ( !SWITCHES_GetValue() )
	{
		printf( "Missing value for switch '%s'\n", szOrigSw );
		return FALSE;
	}

	sscanf( m_szSwitch, "%lX", (DWORD*)pType );

	return TRUE;
}


