/*=========================================================================
 *           Envision: Font editor for Atari                              *
 ==========================================================================
 * File: envison.h                                                        *
 * Author: Mark Schmelzenbach                                             *
 * Started: 07/29/97                                                      *
 =========================================================================*/
#include <stdio.h>
#include <grx20.h>

void bye();
int plotchr(int sx, int sy, int chr, int typ, unsigned char *f);
int string(int x, int y, char *str);
int drawbutton(int x, int y, char *txt); 
char *get_filename(char *title, char *image);
int get_number(char *title, int def, int max);
int select_char(char *title);
int do_options();
int command(int cmd, int stat);

int read_xfd_font(char *image, char *file, unsigned char *data, int max);
int write_xfd_font(char *image, char *file, unsigned char *data, int max, FILE *in);
int write_xfd_data(char *image, char *file, unsigned char *data, int start, int end);

int read_font(char *file, unsigned char *font); 
int write_font(char *file, unsigned char *font); 
int write_data(char *file, unsigned char *font, int start, int end, int a);

int write_map(char *file, unsigned char *font, unsigned char *map, int raw);
unsigned char *read_map(char *file, unsigned char *font, unsigned char *map);
unsigned char *read_xfd_map(char *image, char *file, unsigned char *font, unsigned char *map);
int write_xfd_map(char *image, char *file, unsigned char *font, unsigned char *map, int raw);

typedef struct opt {
  char *disk_image;
  int write_tp;
  int base, step;  
} opt;

extern unsigned char *dfont, *font, *map;
extern int echr;
extern GrContext *upd, *dialog, *chars, *back;
extern opt options;
extern unsigned char clut[5];
extern int cmds[12];
extern int sx, sy, cx, cy, scx, scy, dc, mode, ratio;
extern int base;

