/*
 * Atari include file.
 */

/*
 * errors
 */
typedef enum   {
               ATARI_ERR_OK = 0,
               ATARI_ERR_NO_ENTRY_FOUND,
               ATARI_ERR_END_OF_FILE,
               ATARI_ERR_DISK_NOT_FOUND,
               ATARI_ERR_DIRECTORY_NOT_FOUND,
               ATARI_ERR_DIRECTORY_READ,
               ATARI_ERR_DIRECTORY_WRITE,
               ATARI_ERR_INVALID_VTOC_ENTRY,
               ATARI_ERR_SECTOR_NOT_FOUND,
               ATARI_ERR_FILE_READ,
               ATARI_ERR_FILE_WRITE,
               ATARI_ERR_FILE_CORRUPTED,
               ATARI_ERR_FILE_LENGTH,
               ATARI_ERR_FILE_ALREADY_EXISTS,
               ATARI_ERR_NO_FREE_SECTOR,
               ATARI_ERR_BITMAP_READ,
               ATARI_ERR_BITMAP_WRITE,
               ATARI_ERR_SECTOR_ALREADY_FREE,
               ATARI_ERR_FILE_SEEK
               } AtariError;

/*
 * file attributes.
 */
#define ATARI_ATTR_DELETED              0x80
#define ATARI_ATTR_IN_USE               0x40
#define ATARI_ATTR_LOCKED               0x20
#define ATARI_ATTR_UNKNOWN              0x02
#define ATARI_ATTR_OPEN_FOR_OUTPUT      0x01

/*
 * structure for AtariFindFirst and AtariFindNext.
 */
typedef struct AtariFile
               {

               /*
                * entry index in the directory (0-63)
                */
               long           lIndex;

               /*
                * entry items
                */
               unsigned       wStart;
               unsigned       wSize;
               unsigned char  wAttrib;
               char           szName[13];

               /*
                * data sector
                */
               unsigned char  szSector[128];

               /*
                * sector information (size and link)
                */
               unsigned       wSectorLng;
               unsigned       wNextSector;
               } AtariFile;

/*
 * function prototyes
 */
AtariError AtariFindFirst(const char *szDisk, AtariFile *Info);
AtariError AtariFindNext(const char *szDisk, AtariFile *Info);
AtariError AtariGetFileFromIndex(const char *szDisk, AtariFile *Info, long lIndex);
AtariError AtariReadFirstSector(const char *szDisk, AtariFile *Info);
AtariError AtariReadNextSector(const char *szDisk, AtariFile *Info);
AtariError AtariCheckFile(const char *szDisk, AtariFile *Info, const char *szFile);
AtariError AtariCreateFile(const char *szDisk, AtariFile *Info, const char *szFile);
AtariError AtariWriteSector(const char *szDisk, AtariFile *Info);
