/*
** DisCtl.c
** Disassembly control used to display a disassembly listing.
*/

#define   WM_DIS_BASE              (WM_USER + 1234)

/*
** messages to set or get sprite control parameters
*/
typedef enum
          {
          WM_DIS_SET_BUFFER = WM_DIS_BASE,        /* wParam = buffer size, lParam = buffer addr */
          WM_DIS_SET_LINENUM,                     /* wParam = TRUE if line number sould be displayed */
          WM_DIS_GET_LINENUM,                     /* return TRUE if line number is displayed */
          WM_DIS_SET_SCROLL,                      /* lParam = first line to display (DWORD) */
          WM_DIS_GET_SCROLL,                      /* return first line displayed (DWORD) */
          WM_DIS_REFRESH,                         /* redraw dump control */
          } DIS_MSG;

/*
** notifications found in HIWORD(lParam) in WM_COMMAND message
*/
typedef enum
          {
          DIS_SCROLL_CHANGED,                     /* user has scrolled the window */
          } DIS_NOTIFICATION;

/*
** maximum size of a buffer.
*/
#define   DIS_MAX_BUFFER_SIZE      32500

/*
** structure of one buffer. This is a linked list with only a pointer on the next buffer.
*/
typedef struct DIS_BUFFER
          {
          WORD                     wNbLines;
          WORD                     wLastIndex;
          struct DIS_BUFFER        *pNext;
          BYTE                     pDis[DIS_MAX_BUFFER_SIZE];
          } DIS_BUFFER;

/*
** register control class
*/
BOOL CALLBACK __export DisInit(HINSTANCE hInst);
