PROGRAM ShowWAV;
USES CRT;
TYPE
 Header=RECORD
  RIFFId:ARRAY[1..4] of Char;
  CLen:Longint;
  WAVEId:ARRAY[1..4] of Char;
  FMTId:ARRAY[1..4] of Char;
  FMTLen:LongInt;
  FMTTAg:Word;
  Channels:Word;
  Freq:LongInt;
  Transmis:LongInt;
  Bytes:Word;
  Bits:Word;
  DATAId:ARRAY[1..4] Of Char;
  DATALen:LongInt;
 END;
CONST TITLE:ARRAY[1..3] of Char='DIG';
VAR
 NAME:String;
 FWAV:FILE;
 FDIG:FILE;
 BUF:Pointer;
 Color,BYTE1,BYTE2:BYTE;
 DIG_LEN:Word;
 DIG_FREQ:Byte;
 i,How:integer;
BEGIN
  Color:=TextAttr;
  IF PARAMCOUNT<>2 THEN BEGIN
    TextColor(LIGHTRED);
    Writeln('WAV_DIG v1.0');
    Writeln('Convert *.WAV file into *.DIG file');
    Writeln;
    TextColor(YELLOW);
    Writeln('Use:  WAV_DIG  file.wav file.dig');
    TextColor(Color);Writeln;
    HALT;
  END;
  ASSIGN(FWAV,PARAMSTR(1));
  {$I-}
  RESET(FWAV,1);
  {$I+}
  IF IORESULT<>0 THEN BEGIN
     TextColor(LIGHTRED);
     Writeln('Error by opening file : ',PARAMSTR(1));
     TextColor(Color);Writeln;
     Halt;
  END;
  ASSIGN(FDIG,PARAMSTR(2));
  {$I-}
  REWRITE(FDIG,1);
  {$I+}
  IF IORESULT<>0 THEN BEGIN
     TextColor(LIGHTRED);
     Writeln('Error by creating file : ',PARAMSTR(2));
     TextColor(Color);Writeln;
     Halt;
  END;

  GetMem(Buf,SizeOf(Header));
  BlockRead(FWAV,BUF^,SizeOf(Header));
  WITH Header(BUF^) DO BEGIN
    TextColor(LIGHTBLUE);
    CLRSCR;
    Writeln;
      Write('File          : ');
    TextColor(WHITE);Writeln(PARAMSTR(1));
    TextColor(LIGHTBLUE);
      Write('Typ           : ');
    TextColor(WHITE);
    IF Channels=1 THEN Writeln('MONO') ELSE Writeln('STEREO');
    TextColor(LIGHTBLUE);
    Write('Czstotliwo : ');
    TextColor(WHITE);Writeln(FREQ div 1024,' kHz');
    TextColor(LIGHTBLUE);
    Write('Ilo bajtw  : ');
    TextColor(WHITE);Writeln(DATALen);
    TextColor(LIGHTBLUE);
    Write('Czas [s]      :');
    TextColor(WHITE);Writeln(DATALen/FREQ:5:2);
    Writeln;
    Writeln;
    BlockWrite(FDIG,TITLE,3);
    NAME:=COPY(PARAMSTR(1),1,LENGTH(PARAMSTR(1))-4);
    BlockWrite(FDIG,NAME[1],16);
    DIG_LEN:=DATALen;
    BlockWrite(FDIG,DIG_LEN,2);
    DIG_FREQ:=FREQ DIV 124; { FREQ/124=? }
    BlockWrite(FDIG,DIG_FREQ,1);

    WHILE NOT EOF(FWAV) DO BEGIN
      BlockRead(FWAV,BYTE1,1);
      {$I-}
      BlockRead(FWAV,BYTE2,1);
      {$I+}
      IF IOResult<>0 Then BYTE2:=0;
      BYTE1:=BYTE1 SHR 4;
      BYTE2:=BYTE2 AND $F0;
      BYTE1:=BYTE1+BYTE2;
      BlockWrite(FDIG,BYTE1,1);
    END;

  END;
  TextColor(GREEN);
  Writeln('Convert: O.K.');
  TextColor(Color);Writeln;
  Close(FWAV);
  Close(FDIG);
END.
