PROGRAM ShowWAV;
USES CRT;
TYPE
 Header=RECORD
  RIFFId:ARRAY[1..4] of Char;
  CLen:Longint;
  WAVEId:ARRAY[1..4] of Char;
  FMTId:ARRAY[1..4] of Char;
  FMTLen:LongInt;
  FMTTAg:Word;
  Channels:Word;
  Freq:LongInt;
  Transmis:LongInt;
  Bytes:Word;
  Bits:Word;
  DATAId:ARRAY[1..4] Of Char;
  DATALen:LongInt;
 END;
CONST TITLE:ARRAY[1..3] of Char='DIG';
VAR
 NAME:String;
 FWAV:FILE;
 FSMP:FILE;
 BUF:Pointer;
 Color,BYTE1,BYTE2:BYTE;
 SMP_LEN:Word;
 SMP_FREQ:Byte;
 i,How:integer;
BEGIN
  Color:=TextAttr;
  IF PARAMCOUNT<>2 THEN BEGIN
    TextColor(LIGHTRED);
    Writeln('WAV_SMP v1.0');
    Writeln('Convert *.WAV file into *.SMP file');
    Writeln;
    TextColor(YELLOW);
    Writeln('Use:  WAV_SMP  file.wav file.smp');
    Writeln;
    TextColor(Color);Writeln;
    HALT;
  END;
  ASSIGN(FWAV,PARAMSTR(1));
  {$I-}
  RESET(FWAV,1);
  {$I+}
  IF IORESULT<>0 THEN BEGIN
     TextColor(LIGHTRED);
     Writeln('Error by opening file : ',PARAMSTR(1));
     TextColor(Color);Writeln;
     Halt;
  END;
  ASSIGN(FSMP,PARAMSTR(2));
  {$I-}
  REWRITE(FSMP,1);
  {$I+}
  IF IORESULT<>0 THEN BEGIN
     TextColor(LIGHTRED);
     Writeln('Error by creating file : ',PARAMSTR(2));
     TextColor(Color);Writeln;
     Halt;
  END;

  GetMem(Buf,SizeOf(Header));
  BlockRead(FWAV,BUF^,SizeOf(Header));
  WITH Header(BUF^) DO BEGIN
    TextColor(LIGHTBLUE);
    CLRSCR;
    Writeln;
      Write('File          : ');
    TextColor(WHITE);Writeln(PARAMSTR(1));
    TextColor(LIGHTBLUE);
      Write('Typ           : ');
    TextColor(WHITE);
    IF Channels=1 THEN Writeln('MONO') ELSE Writeln('STEREO');
    TextColor(LIGHTBLUE);
    Write('Czstotliwo : ');
    TextColor(WHITE);Writeln(FREQ div 1024,' kHz');
    TextColor(LIGHTBLUE);
    Write('Ilo bajtw  : ');
    TextColor(WHITE);Writeln(DATALen);
    TextColor(LIGHTBLUE);
    Write('Czas [s]      :');
    TextColor(WHITE);Writeln(DATALen/FREQ:5:2);
    Writeln;
    Writeln;
    BlockWrite(FSMP,TITLE,3);
    NAME:=COPY(PARAMSTR(1),1,LENGTH(PARAMSTR(1))-4);
    BlockWrite(FSMP,NAME[1],13);
    SMP_LEN:=DATALen;
    BlockWrite(FSMP,SMP_LEN,2);
    SMP_FREQ:=FREQ DIV 124; { FREQ/124=? }
    BlockWrite(FSMP,SMP_FREQ,1);

    WHILE NOT EOF(FWAV) DO BEGIN
      BlockRead(FWAV,BYTE1,1);
      {$I-}
      BlockRead(FWAV,BYTE2,1);
      {$I+}
      IF IOResult<>0 Then BYTE2:=0;
      BYTE1:=BYTE1 AND $F0;
      BYTE2:=BYTE2 SHR 4;
      BYTE1:=BYTE1+BYTE2;
      IF BYTE1=0 THEN BYTE1:=$01;
      BlockWrite(FSMP,BYTE1,1);
    END;
      BYTE1:=0; {dodatkowy bajt oznaczajcy koniec}
      BlockWrite(FSMP,BYTE1,1);
  END;
  TextColor(GREEN);
  Writeln('Convert: O.K.');
  TextColor(Color);Writeln;
  Close(FWAV);
  Close(FSMP);
END.
