//    ROM2EXE - Converts Atari cartridge images to Atari EXE files
//    Copyright (c) 1999 Jindrich Kubec <kubecj@asw.cz>
//									http://www.asw.cz/~kubecj
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "wintypes.h"
#include "unistd.h"
#include "fcntl.h"

int main( int argc, char* argv[] )
{
	printf( "ROM2EXE v1.00 (c) 1998-1999 Jindrich Kubec <kubecj@asw.cz>\n" );
	printf( "  Latest version can be found at http://www.asw.cz/~kubecj\n" );
	printf( "  Published under GPL. See GPL.TXT\n\n" );

	if ( argc < 3 )
	{
		printf( "Not enough parameters\n" );
		printf( "USAGE: rom2exe cartimage exefile\n" );
		return 1;
	}

	BYTE pbtLoader[ 256 ];

	int hIn1 = open( argv[1], O_RDONLY | O_BINARY, S_IREAD );

	if ( hIn1 == -1 )
	{
		printf( "Can't open source file! (%s)\n", argv[ 1 ] );
		return 1;
	}

	BYTE* pbtData = new BYTE [ 0x4000 ];
	memset( pbtData, 0, 0x4000 );

	if ( !pbtData )
	{
		printf( "Not enough memory!\n" );
		return 1;
	}

	long lCartSize = read( hIn1, pbtData, 0x4000 );

	close( hIn1 );

	char* szLoaderName;

	switch( lCartSize )
	{
		case 0x2000:
			szLoaderName = "a000bfff.STB";
			break;
			
		case 0x4000:
			szLoaderName = "8000bfff.STB";
			break;

		default:
			printf( "Invalid source file size!\n" );
			delete [] pbtData;
			return 1;
	}

	char szLoaderFull[ 256 ];
	strcpy( szLoaderFull, argv[ 0 ] );
	*( strrchr( szLoaderFull, '/' ) + 1 ) = '\0';
	strcat( szLoaderFull, szLoaderName );

	hIn1 = open( szLoaderFull, O_RDONLY | O_BINARY, S_IREAD );

	if ( hIn1 == -1 )
	{
		printf( "Can't find stub file! (%s)\n", szLoaderFull );
		delete [] pbtData;
		return 1;
	}

	int hOut = open( argv[2], O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE );

	if ( -1 == hOut )
	{
		printf( "Can't create output file! (%s)\n", argv[2] );
		delete [] pbtData;
		return 1;
	}

	write( hOut, pbtLoader, read( hIn1, pbtLoader, 256 ) );

	write( hOut, pbtData, lCartSize );

	close( hOut );

	close( hIn1 );


	delete [] pbtData;

	printf( "Done!\n" );

	return 0;
}

