/****************************************************************************
*
*  ATTENTION!!!
*
*  THIS FILE HAS BEEN MODIFIED!!! IT IS NOT PART OF THE OFFICAL
*  POV-RAY 2.2 DISTRIBUTION!!!
*
*  THIS FILE IS PART OF "FASTER THAN POV-RAY" (VERSION 1.1),
*  A SPED-UP VERSION OF POV-RAY 2.2. USE AT YOUR OWN RISK!!!!!!
*
*  New files: addon0.c, addon1.c, addon2.c, addon3.c, addon.h
*
*  The additional modules were written by Dieter Bayer.
*
*  Send comments, suggestions, bugs to:
*
*  dieter@cip.e-technik.uni-erlangen.de
*
*  If I have enough time I will try to fix any bugs.
*
*  All changed/added lines are enclosed in #ifdef DB_CODE ... #endif
*
*  The new/changed modules speed-up ray-tracing in two ways:
*
*   - Objects are projected onto the viewing plane a priori. Thus
*     the number of ray/object intersection tests is reduced for
*     primary rays.
*
*   - A light buffer is used for every spotlight. Each object is
*     projected a priori onto the six sides of a cube enclosing
*     the light source. Thus the number of ray/object intersection
*     tests is reduced for shadow rays.
*
*  The vista projection of qaudrics was taken from:
*
*    A. Hashimoto, T. Akimoto, K. Mase, and Y. Suenaga, "Vista
*    Ray-Tracing: High Speed Ray Tracing Using Perspective
*    Projection Image", New Advances in Computer Graphics,
*    Proceedings of CG International '89, R. A. Earnshaw,
*    B. Wyvill (Eds.), Springer, ...
*
*  The idea for the light buffer was taken from:
*
*    E. Haines and D. Greenberg, "The Light Buffer: A Shadow-
*    Testing Accelerator", IEEE CG&A, Vol. 6, No. 9, Sept. 1986, pp. 6-16
*
*****************************************************************************/

/****************************************************************************
*  addon3.c
*
*  This module was written by Dieter Bayer.
*
*  This module contains the functions used to recompute the 
*  automatically generated bounding boxes and to removed unnecessary
*  bounding objects.
*
*  01.04.1994 : Creation
*
*  29.04.1994 : Version 2.0
*
******************************************************************************/

#include <time.h>
#include "frame.h"
#include "vector.h"
#include "povproto.h"
#include "addon.h"

#ifdef DB_CODE



/* external variables */

extern FRAME Frame;
extern unsigned int Options, Extended_Options;

extern METHODS Bicubic_Patch_Methods;
extern METHODS Blob_Methods;
extern METHODS Box_Methods;
extern METHODS Cone_Methods;
extern METHODS Csg_Height_Field_Methods;
extern METHODS CSG_Intersection_Methods;
extern METHODS CSG_Merge_Methods;
extern METHODS CSG_Union_Methods;
extern METHODS Disc_Methods;
extern METHODS Ellipsoid_Methods;
extern METHODS Height_Field_Methods;
extern METHODS Light_Source_Methods;
extern METHODS Plane_Methods;
extern METHODS Poly_Methods;
extern METHODS Quadric_Methods;
extern METHODS Smooth_Triangle_Methods;
extern METHODS Sphere_Methods;
extern METHODS Triangle_Methods;



/* static variables */

static long int FoundEllipsoid = 0;
static long int FoundCylinder = 0;
static long int FoundCone = 0;



/* static functions */

static void Recompute_Bbox PARAMS((OBJECT *Object, long *count));

static void Remove_Bound PARAMS((OBJECT *Object, long *removed));



/****************************************************************************
   Recompute all automatically generated bounding boxes (slabs).
 ****************************************************************************/

void Recompute_Bboxes()
{
  long count;
  OBJECT *Object;

  count = 0;

  fprintf(stderr, "Reducing bounding boxes");

  Begin_Point();

  for (Object = Frame.Objects; Object != NULL; Object = Object->Sibling)
  {
    if (Object->Methods == &Light_Source_Methods)
      Recompute_Bbox(((LIGHT_SOURCE *)Object)->Children, &count);
    else
      Recompute_Bbox(Object, &count);
  }

  fprintf(stderr,"(%ld reduced)", count);

  End_Point();
}



/****************************************************************************
   Recompute the bounding box of an object.

   Calculate the bounding box of CSG intersections by
   intersecting the bounding boxes of all children.
   
   Consider bounding and clipping objects.
 ****************************************************************************/

static void Recompute_Bbox(Object, count)
OBJECT *Object;
long *count;
{
  int counted, i, j;
  DBL Old_Volume, New_Volume, Bounds_Volume, Clip_Volume;
  VECTOR Min, Max, P;
  OBJECT *Sib;
  BBOX New_Bounds, Old_Bounds, Bounds_Bounds, Clip_Bounds;
  METHODS *Methods;
  HEIGHT_FIELD *Height_Field;

  if (Object == NULL)
    return;

  counted = FALSE;

  /* check for bounds too large (I want everything to stay
     inside the largest bounding box) */

  Object->Bounds.Min.x = max(Object->Bounds.Min.x, -BOUND_HUGE/2);
  Object->Bounds.Min.y = max(Object->Bounds.Min.y, -BOUND_HUGE/2);
  Object->Bounds.Min.z = max(Object->Bounds.Min.z, -BOUND_HUGE/2);
  Object->Bounds.Max.x = min(Object->Bounds.Max.x, +BOUND_HUGE/2);
  Object->Bounds.Max.y = min(Object->Bounds.Max.y, +BOUND_HUGE/2);
  Object->Bounds.Max.z = min(Object->Bounds.Max.z, +BOUND_HUGE/2);

  /* init New_Bounds */

  New_Bounds.Min.x = New_Bounds.Min.y = New_Bounds.Min.z = -BOUND_HUGE;
  New_Bounds.Max.x = New_Bounds.Max.y = New_Bounds.Max.z = +BOUND_HUGE;

  BOUNDS_VOLUME (New_Volume, New_Bounds);

  /* get Old_Bounds with bounds from current object */

  Old_Bounds = Object->Bounds;

  BOUNDS_VOLUME (Old_Volume, Old_Bounds);

  /* init Bounds_Bounds with bounds from object's bounding object */

  Bounds_Bounds.Min.x = Bounds_Bounds.Min.y = Bounds_Bounds.Min.z = -BOUND_HUGE;
  Bounds_Bounds.Max.x = Bounds_Bounds.Max.y = Bounds_Bounds.Max.z = +BOUND_HUGE;

  if (Object->Bound != NULL)
  {
    Min.x = Min.y = Min.z = -BOUND_HUGE;
    Max.x = Max.y = Max.z = +BOUND_HUGE;

    for (Sib = Object->Bound; Sib != NULL; Sib = Sib->Sibling)
    {
/*
      Recompute_Bbox(Sib, count);
*/
      if (!Test_Inverted(Sib))
      {
	Min.x = max(Min.x, Sib->Bounds.Min.x);
	Min.y = max(Min.y, Sib->Bounds.Min.y);
	Min.z = max(Min.z, Sib->Bounds.Min.z);
	Max.x = min(Max.x, Sib->Bounds.Max.x);
	Max.y = min(Max.y, Sib->Bounds.Max.y);
	Max.z = min(Max.z, Sib->Bounds.Max.z);
      }
    }

    Bounds_Bounds.Min = Min;
    Bounds_Bounds.Max = Max;
  }

  BOUNDS_VOLUME (Bounds_Volume, Bounds_Bounds);

  /* init Clip_Bounds with bounds from object's clipping object */

  Clip_Bounds.Min.x = Clip_Bounds.Min.y = Clip_Bounds.Min.z = -BOUND_HUGE;
  Clip_Bounds.Max.x = Clip_Bounds.Max.y = Clip_Bounds.Max.z = +BOUND_HUGE;

  if (Object->Clip != NULL)
  {
    Min.x = Min.y = Min.z = -BOUND_HUGE;
    Max.x = Max.y = Max.z = +BOUND_HUGE;

    for (Sib = Object->Clip; Sib != NULL; Sib = Sib->Sibling)
    {
/*
      Recompute_Bbox(Sib, count);
*/
      if (!Test_Inverted(Sib))
      {
	Min.x = max(Min.x, Sib->Bounds.Min.x);
	Min.y = max(Min.y, Sib->Bounds.Min.y);
	Min.z = max(Min.z, Sib->Bounds.Min.z);
	Max.x = min(Max.x, Sib->Bounds.Max.x);
	Max.y = min(Max.y, Sib->Bounds.Max.y);
	Max.z = min(Max.z, Sib->Bounds.Max.z);
      }
    }

    Clip_Bounds.Min = Min;
    Clip_Bounds.Max = Max;
  }

  BOUNDS_VOLUME (Clip_Volume, Clip_Bounds);

  Methods = Object->Methods;

  /* check for CSG/primitive objects */

  if (Object->Type & COMPOUND_OBJECT)
  {
    if (Methods == &Light_Source_Methods)
    {
      Recompute_Bbox(((LIGHT_SOURCE *)Object)->Children, count);
    }
    else
    {
      /* CSG object */

      if (Methods == &CSG_Intersection_Methods)
      {
	Min.x = Min.y = Min.z = -BOUND_HUGE;
	Max.x = Max.y = Max.z = +BOUND_HUGE;

	/* get the bounding box by recursively calculating the children's
	   bounding boxes. */

	for (Sib = ((CSG *)Object)->Children; Sib != NULL; Sib = Sib->Sibling)
	{
	  Recompute_Bbox(Sib, count);

	  /* inverted objects must not be considered! */

	  if (!Test_Inverted(Sib))
	  {
	    Min.x = max(Min.x, Sib->Bounds.Min.x);
	    Min.y = max(Min.y, Sib->Bounds.Min.y);
	    Min.z = max(Min.z, Sib->Bounds.Min.z);
	    Max.x = min(Max.x, Sib->Bounds.Max.x);
	    Max.y = min(Max.y, Sib->Bounds.Max.y);
	    Max.z = min(Max.z, Sib->Bounds.Max.z);
	  }
	}
      }
      else
      {
	Min.x = Min.y = Min.z = +BOUND_HUGE;
	Max.x = Max.y = Max.z = -BOUND_HUGE;

	/* get the bounding box by recursively calculating the children's
	   bounding boxes. */

	for (Sib = ((CSG *)Object)->Children; Sib != NULL; Sib = Sib->Sibling)
	{
	  Recompute_Bbox(Sib, count);

	  Min.x = min(Min.x, Sib->Bounds.Min.x);
	  Min.y = min(Min.y, Sib->Bounds.Min.y);
	  Min.z = min(Min.z, Sib->Bounds.Min.z);
	  Max.x = max(Max.x, Sib->Bounds.Max.x);
	  Max.y = max(Max.y, Sib->Bounds.Max.y);
	  Max.z = max(Max.z, Sib->Bounds.Max.z);
	}
      }

      New_Bounds.Min = Min;
      New_Bounds.Max = Max;

      BOUNDS_VOLUME(New_Volume, New_Bounds);
    }
  }
  else
  {
    /* primitive object*/

    /* the bounding box for height fields is not calculated in POV-Ray 2.2 */

    if ((Methods == &Height_Field_Methods) || 
        (Methods == &Csg_Height_Field_Methods))
    {
      Height_Field = (HEIGHT_FIELD *)Object;

      New_Bounds.Min = Height_Field->bounding_box->bounds[0];
      New_Bounds.Max = Height_Field->bounding_box->bounds[1];
      recompute_bbox(&New_Bounds, Height_Field->Trans);
      BOUNDS_VOLUME (New_Volume, New_Bounds);
    }

    /* the bounding box for bicubic patches is not calculated in POV-Ray 2.2 */

    if (Methods == &Bicubic_Patch_Methods)
    {
      Min.x = Min.y = Min.z = +BOUND_HUGE;
      Max.x = Max.y = Max.z = -BOUND_HUGE;
      for (i = 0; i < 4; i++)
      {
	for (j = 0; j < 4; j++)
	{
	  P = ((BICUBIC_PATCH *)Object)->Control_Points[i][j];
	  Min.x = min (Min.x, P.x);
	  Min.y = min (Min.y, P.y);
	  Min.z = min (Min.z, P.z);
	  Max.x = max (Max.x, P.x);
	  Max.y = max (Max.y, P.y);
	  Max.z = max (Max.z, P.z);
	}
      }
      New_Bounds.Min = Min;
      New_Bounds.Max = Max;
      BOUNDS_VOLUME (New_Volume, New_Bounds);
    }
  }

  /* check which bounding box fits best */

  if ((New_Volume < Old_Volume) && (New_Volume > 0.0))
  {
    Object->Bounds = New_Bounds;
    Old_Volume = New_Volume;
    if (!counted)
    {
      (*count)++;
      counted = TRUE;
      Print_Point(POINT_MOD);
    }
  }

  if ((Bounds_Volume < Old_Volume) && (Bounds_Volume > 0.0))
  {
    Object->Bounds = Bounds_Bounds;
    Old_Volume = Bounds_Volume;
    if (!counted)
    {
      (*count)++;
      counted = TRUE;
      Print_Point(POINT_MOD);
    }
  }

  if ((Clip_Volume < Old_Volume) && (Clip_Volume > 0.0))
  {
    Object->Bounds = Clip_Bounds;
    if (!counted)
    {
      (*count)++;
      counted = TRUE;
      Print_Point(POINT_MOD);
    }
  }
}




/****************************************************************************
   Check if the object is inverted.
 ****************************************************************************/

int Test_Inverted(Object)
OBJECT *Object;
{
  METHODS *methods;

  methods = Object->Methods;

  if (methods == &Blob_Methods)
    return(((BLOB *)Object)->Inverted);

  if (methods == &Box_Methods) 
    return(((BOX *)Object)->Inverted);

  if (methods == &Cone_Methods) 
    return(((CONE *)Object)->Inverted);

  if (methods == &Csg_Height_Field_Methods) 
    return(((HEIGHT_FIELD *)Object)->Inverted);

  if (methods == &CSG_Intersection_Methods) 
    return(((CSG *)Object)->Inverted);

  if (methods == &CSG_Union_Methods) 
    return(((CSG *)Object)->Inverted);

  if (methods == &Disc_Methods) 
    return(((DISC *)Object)->Inverted);

  if (methods == &Ellipsoid_Methods) 
    return(((SPHERE *)Object)->Inverted);

  if (methods == &Height_Field_Methods) 
    return(((HEIGHT_FIELD *)Object)->Inverted);

  if (methods == &Poly_Methods)  
    return(((POLY *)Object)->Inverted);
  
  if (methods == &Quadric_Methods) 
    return(((QUADRIC *)Object)->Inverted);

  if (methods == &Sphere_Methods) 
    return(((SPHERE *)Object)->Inverted);

  return(FALSE);
}



/****************************************************************************
   Remove unnecessary bounding objects.
 ****************************************************************************/

void Remove_Unnecessary_Bounds()
{
  long removed;
  OBJECT *Sib;

  removed = 0;

  fprintf(stderr, "Removing bounds");

  Begin_Point();

  for (Sib = Frame.Objects; Sib != NULL; Sib = Sib->Sibling)
  {
    Remove_Bound(Sib, &removed);
  }

  fprintf(stderr, "(%ld removed)\n", removed);

  End_Point();
}



/****************************************************************************
   Remove bounding objects from finite primitive objects.
 ****************************************************************************/

static void Remove_Bound(Object, removed)
OBJECT *Object;
long *removed;
{
  OBJECT *Sib;

  if (Object == NULL)
    return;

  if (Object->Type & COMPOUND_OBJECT)
  {
    if (Object->Type & LIGHT_SOURCE_OBJECT)
    {
      Remove_Bound(((LIGHT_SOURCE *)Object)->Children, removed);
    }
    else
    {
/*   
      Don't know if this is a good idea ...
      
      Object->Bound = NULL;
*/
      
      for (Sib = ((CSG *)Object)->Children; Sib != NULL; Sib = Sib->Sibling)
      {
	Remove_Bound(Sib, removed);
      }
    }
  }
  else
  {
    if (Object->Bound != NULL)
    {
      /* remove bounding boxes around finite objects.
         (it's a waste of time to bound these objects)
         (I'm not sure about Blobs) */

      if ((Object->Methods == &Bicubic_Patch_Methods) ||
	  (Object->Methods == &Box_Methods) ||
	  (Object->Methods == &Csg_Height_Field_Methods) ||
	  (Object->Methods == &Cone_Methods) ||
	  (Object->Methods == &Disc_Methods) ||
	  (Object->Methods == &Ellipsoid_Methods) ||
	  (Object->Methods == &Height_Field_Methods) ||
	  (Object->Methods == &Plane_Methods) ||
	  (Object->Methods == &Quadric_Methods) ||
	  (Object->Methods == &Sphere_Methods) ||
	  (Object->Methods == &Smooth_Triangle_Methods) ||
	  (Object->Methods == &Triangle_Methods))
      {
	Object->Bound = NULL;
	Print_Point(POINT_MOD);
	(*removed)++;
      }
    }
  }
}



/****************************************************************************
 ****************************************************************************/

void Print_Quadric_Stats()
{
/*
  This gives wrong results....
  
  if (FoundCone)
    fprintf(stderr, "Quadric-Cone found: %ld\n", FoundCone);
  if (FoundCylinder)
    fprintf(stderr, "Quadric-Cylinder found: %ld\n", FoundCylinder);
  if (FoundEllipsoid)
    fprintf(stderr, "Quadric-Ellipsoids found: %ld\n", FoundEllipsoid);
*/
}



/****************************************************************************
   Compute a bounding box around quadrics.

   This function calculates the bounding box for quadrics given in
   their normal form, i.e. f(x,y,z) = A*x*x + B*y*y + C*z*z + J = 0.
   That's the form normally used in the declaration of quadric shapes.

   The quadrics can still be translated, rotated, and scaled after declaration.

   Currently clipped cones, cylinders, and ellipsoids are supported.

   (Btw, a quadric ellipsoid is intersected faster than a scaled sphere!!!
    The problem that quadrics don't respond to automatic bounding is
    solved for some quadric shapes with this function. With this function
    the modules for cones/cylinders and ellipsoids may even be obsolete.)

 ****************************************************************************/

void Compute_Quadric_BBox(Quadric)
QUADRIC *Quadric;
{
  DBL kx, ky, kz, k, a, b, c;
  DBL rx, ry, rz, rx1, rx2, ry1, ry2, rz1, rz2, x, y, z;
  DBL New_Volume, Old_Volume;
  VECTOR Min, Max;
  BBOX Clip, New, Old;
  OBJECT *Sib;

  if (!(Extended_Options & USE_BOUND_QUADRICS))
    return;

  /* inverted quadrics are infinite */

/*
  that's true ... but it makes no difference in intersecting the quadric ...
		  it only affects the inside/outside test ...

  if (Quadric->Inverted)
    return;
*/

  /* check for 'normal' form. if the quadric isn't in it's normal form
     we can't do anything (we could, but that would be to tedious!
     diagonalising the quadric's 4x4 matrix, i.e. finding its eigenvalues
     and eigenvectors -> solving a 4th order polynom) */

  kx = Quadric->Mixed_Terms.x;
  ky = Quadric->Mixed_Terms.y;
  kz = Quadric->Mixed_Terms.z;

  if ((fabs(kx) > EPSILON) || (fabs(ky) > EPSILON) || (fabs(kz) > EPSILON))
    return;

  kx = Quadric->Terms.x;
  ky = Quadric->Terms.y;
  kz = Quadric->Terms.z;

  if ((fabs(kx) > EPSILON) || (fabs(ky) > EPSILON) || (fabs(kz) > EPSILON))
    return;

  /* get old bounding box */

  Old = Quadric->Bounds;

  /* init new bounding box */

  New.Min.x = New.Min.y = New.Min.z = -BOUND_HUGE;
  New.Max.x = New.Max.y = New.Max.z = +BOUND_HUGE;

  /* get the bounding box of the clipping object */

  Clip.Min.x = Clip.Min.y = Clip.Min.z = -BOUND_HUGE;
  Clip.Max.x = Clip.Max.y = Clip.Max.z = +BOUND_HUGE;

  if (Quadric->Clip != NULL)
  {
    Min.x = Min.y = Min.z = -BOUND_HUGE;
    Max.x = Max.y = Max.z = +BOUND_HUGE;

    /* intersect the members bounding boxes */

    for (Sib = Quadric->Clip; Sib != NULL; Sib = Sib->Sibling)
    {
      if (!Test_Inverted(Sib))
      {
	Min.x = max(Min.x, Sib->Bounds.Min.x);
	Min.y = max(Min.y, Sib->Bounds.Min.y);
	Min.z = max(Min.z, Sib->Bounds.Min.z);
	Max.x = min(Max.x, Sib->Bounds.Max.x);
	Max.y = min(Max.y, Sib->Bounds.Max.y);
	Max.z = min(Max.z, Sib->Bounds.Max.z);
      }
    }

    Clip.Min = Min;
    Clip.Max = Max;
  }

  /* get coefficients of 'normal' form: kx*x*x + ky*y*y + kz*z*z + k */

  kx = Quadric->Square_Terms.x;
  ky = Quadric->Square_Terms.y;
  kz = Quadric->Square_Terms.z;
  k  = Quadric->Constant;

  /* we want kx to be non-negative */

  if (kx < 0.0)
  {
    kx = -kx;
    ky = -ky;
    kz = -kz;
    k  = -k;
  }

  /*************************************************************

     check for ellipsoid

       x*x     y*y     z*z
      ----- + ----- + ----- - 1 = 0
       a*a     b*b     c*c

   *************************************************************/

  if ((kx > 0.0) && (ky > 0.0) && (kz > 0.0) && (k < 0.0))
  {
    FoundEllipsoid++;

    a = sqrt(-k/kx);
    b = sqrt(-k/ky);
    c = sqrt(-k/kz);

    New.Min.x = -a;
    New.Min.y = -b;
    New.Min.z = -c;
    New.Max.x = a;
    New.Max.y = b;
    New.Max.z = c;
  }

  /*************************************************************

     check for cylinder (x-axis)

	y*y     z*z
       ----- + ----- - 1 = 0
	b*b     c*c

   *************************************************************/

  if ((kx == 0.0) && (ky > 0.0) && (kz > 0.0) && (k < 0.0))
  {
    FoundCylinder++;

    b = sqrt(-k/ky);
    c = sqrt(-k/kz);

    New.Min.y = -b;
    New.Min.z = -c;
    New.Max.y = b;
    New.Max.z = c;
  }

  /*************************************************************

     check for cylinder (y-axis)

	x*x     z*z
       ----- + ----- - 1 = 0
	a*a     c*c

   *************************************************************/

  if ((kx > 0.0) && (ky == 0.0) && (kz > 0.0) && (k < 0.0))
  {
    FoundCylinder++;

    a = sqrt(-k/kx);
    c = sqrt(-k/kz);

    New.Min.x = -a;
    New.Min.z = -c;
    New.Max.x = a;
    New.Max.z = c;
  }

  /*************************************************************

     check for cylinder (z-axis)

	x*x     y*y
       ----- + ----- - 1 = 0
	a*a     b*b

   *************************************************************/

  if ((kx > 0.0) && (ky > 0.0) && (kz == 0.0) && (k < 0.0))
  {
    FoundCylinder++;

    a = sqrt(-k/kx);
    b = sqrt(-k/ky);

    New.Min.x = -a;
    New.Min.y = -b;
    New.Max.x = a;
    New.Max.y = b;
  }

  /*************************************************************

     check for cone (x-axis)

	x*x 	y*y     z*z
       ----- - ----- - ----- = 0
	a*a     b*b     c*c

   *************************************************************/

  if ((kx > 0.0) && (ky < 0.0) && (kz < 0.0) && (k == 0.0))
  {
    FoundCone++;

    a = sqrt(1.0/kx);
    b = sqrt(-1.0/ky);
    c = sqrt(-1.0/kz);

    /* get radii for lower x value */

    x = Clip.Min.x;

    ry1 = fabs(x * b / a);
    rz1 = fabs(x * c / a);

    /* get radii for upper x value */

    x = Clip.Max.x;

    ry2 = fabs(x * b / a);
    rz2 = fabs(x * c / a);

    ry = max(ry1, ry2);
    rz = max(rz1, rz2);

    New.Min.y = -ry;
    New.Min.z = -rz;
    New.Max.y = ry;
    New.Max.z = rz;
  }

  /*************************************************************

     check for cone (y-axis)

	x*x 	y*y     z*z
       ----- - ----- + ----- = 0
	a*a     b*b     c*c

   *************************************************************/

  if ((kx > 0.0) && (ky < 0.0) && (kz > 0.0) && (k == 0.0))
  {
    FoundCone++;

    a = sqrt(1.0/kx);
    b = sqrt(-1.0/ky);
    c = sqrt(1.0/kz);

    /* get radii for lower y value */

    y = Clip.Min.y;

    rx1 = fabs(y * a / b);
    rz1 = fabs(y * c / b);

    /* get radii for upper y value */

    y = Clip.Max.y;

    rx2 = fabs(y * a / b);
    rz2 = fabs(y * c / b);

    rx = max(rx1, rx2);
    rz = max(rz1, rz2);

    New.Min.x = -rx;
    New.Min.z = -rz;
    New.Max.x = rx;
    New.Max.z = rz;
  }

  /*************************************************************

     check for cone (z-axis)

	x*x 	y*y     z*z
       ----- + ----- - ----- = 0
	a*a     b*b     c*c

   *************************************************************/

  if ((kx > 0.0) && (ky > 0.0) && (kz < 0.0) && (k == 0.0))
  {
    FoundCone++;

    a = sqrt(1.0/kx);
    b = sqrt(1.0/ky);
    c = sqrt(-1.0/kz);

    /* get radii for lower z value */

    z = Clip.Min.z;

    rx1 = fabs(z * a / c);
    ry1 = fabs(z * b / c);

    /* get radii for upper z value */

    z = Clip.Max.z;

    rx2 = fabs(z * a / c);
    ry2 = fabs(z * b / c);

    rx = max(rx1, rx2);
    ry = max(ry1, ry2);

    New.Min.x = -rx;
    New.Min.y = -ry;
    New.Max.x = rx;
    New.Max.y = ry;
  }

  /* intersect clipping object's and quadric's bounding boxes */

  if (Quadric->Clip != NULL)
  {
    Min.x = max(New.Min.x, Clip.Min.x);
    Min.y = max(New.Min.y, Clip.Min.y);
    Min.z = max(New.Min.z, Clip.Min.z);

    Max.x = min(New.Max.x, Clip.Max.x);
    Max.y = min(New.Max.y, Clip.Max.y);
    Max.z = min(New.Max.z, Clip.Max.z);

    New.Min = Min;
    New.Max = Max;
  }

  /* use old or new bounding box? */

  BOUNDS_VOLUME(New_Volume, New);

  BOUNDS_VOLUME(Old_Volume, Old);

  if (New_Volume < Old_Volume)
  {
    Quadric->Bounds = New;
  }
}



#endif
