/****************************************************************************
*
*  ATTENTION!!!
*
*  THIS FILE HAS BEEN MODIFIED!!! IT IS NOT PART OF THE OFFICAL
*  POV-RAY 2.2 DISTRIBUTION!!!
*
*  THIS FILE IS PART OF "FASTER THAN POV-RAY" (VERSION 1.1),
*  A SPED-UP VERSION OF POV-RAY 2.2. USE AT YOUR OWN RISK!!!!!!
*
*  New files: addon0.c, addon1.c, addon2.c, addon3.c, addon.h
*
*  The additional modules were written by Dieter Bayer.
*
*  Send comments, suggestions, bugs to:
*
*  dieter@cip.e-technik.uni-erlangen.de
*
*  If I have enough time I will try to fix any bugs.
*
*  All changed/added lines are enclosed in #ifdef DB_CODE ... #endif
*
*  The new/changed modules speed-up ray-tracing in two ways:
*
*   - Objects are projected onto the viewing plane a priori. Thus
*     the number of ray/object intersection tests is reduced for
*     primary rays.
*
*   - A light buffer is used for every spotlight. Each object is
*     projected a priori onto the six sides of a cube enclosing
*     the light source. Thus the number of ray/object intersection
*     tests is reduced for shadow rays.
*
*  The vista projection of qaudrics was taken from:
*
*    A. Hashimoto, T. Akimoto, K. Mase, and Y. Suenaga, "Vista
*    Ray-Tracing: High Speed Ray Tracing Using Perspective
*    Projection Image", New Advances in Computer Graphics,
*    Proceedings of CG International '89, R. A. Earnshaw,
*    B. Wyvill (Eds.), Springer, ...
*
*  The idea for the light buffer was taken from:
*
*    E. Haines and D. Greenberg, "The Light Buffer: A Shadow-
*    Testing Accelerator", IEEE CG&A, Vol. 6, No. 9, Sept. 1986, pp. 6-16
*
*****************************************************************************/

/****************************************************************************
*                boxes.c
*
*  This module implements the box primitive.
*  This file was written by Alexander Enzmann.	He wrote the code for
*  boxes and generously provided us these enhancements.
*
*  from Persistence of Vision Raytracer
*  Copyright 1993 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other 
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If 
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's Graphics Developer's
*  Forum.  The latest version of POV-Ray may be found there as well.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/

#include "frame.h"
#include "vector.h"
#include "povproto.h"

METHODS Box_Methods =
  { 
  All_Box_Intersections,
  Inside_Box, Box_Normal,
  Copy_Box, Translate_Box, Rotate_Box, Scale_Box, Transform_Box,
  Invert_Box, Destroy_Box
};

#ifdef DB_CODE
  #define LOWERX 0
  #define UPPERX 1
  #define LOWERY 2
  #define UPPERY 3
  #define LOWERZ 4
  #define UPPERZ 5
  extern RAY *CM_Ray;
#endif

extern long Ray_Box_Tests, Ray_Box_Tests_Succeeded;

#define close(x, y) (fabs(x-y) < EPSILON ? 1 : 0)

#ifdef DB_CODE
/******************************************************************************
 ******************************************************************************/
int All_Box_Intersections (Object, Ray, Depth_Stack)
OBJECT *Object;
RAY *Ray;
ISTACK *Depth_Stack;
{
  int Side1, Side2;
  DBL Depth1, Depth2;
  VECTOR IPoint;
  register int Intersection_Found;

  Intersection_Found = FALSE;

  if (Intersect_Boxx (Ray, (BOX *)Object, &Depth1, &Depth2, &Side1, &Side2))
  {
    IPoint.x = Ray->Initial.x + Depth1 * Ray->Direction.x;
    IPoint.y = Ray->Initial.y + Depth1 * Ray->Direction.y;
    IPoint.z = Ray->Initial.z + Depth1 * Ray->Direction.z;

    if (Point_In_Clip (&IPoint, Object->Clip))
    {
      push_box_entry(Depth1,IPoint,Object,Side1,Depth_Stack);
      Intersection_Found = TRUE;
    }

    if (Depth2 != Depth1)
    {
      IPoint.x = Ray->Initial.x + Depth2 * Ray->Direction.x;
      IPoint.y = Ray->Initial.y + Depth2 * Ray->Direction.y;
      IPoint.z = Ray->Initial.z + Depth2 * Ray->Direction.z;

      if (Point_In_Clip (&IPoint, Object->Clip))
      {
	push_box_entry(Depth2,IPoint,Object,Side2,Depth_Stack);
	Intersection_Found = TRUE;
      }
    }
  }
  return (Intersection_Found);
}
#else
int All_Box_Intersections (Object, Ray, Depth_Stack)
OBJECT *Object;
RAY *Ray;
ISTACK *Depth_Stack;
  {
  DBL Depth1, Depth2;
  VECTOR IPoint;
  register int Intersection_Found;

  Intersection_Found = FALSE;

  if (Intersect_Boxx (Ray, (BOX *)Object, &Depth1, &Depth2))
    {
    VScale (IPoint, Ray->Direction, Depth1);
    VAddEq (IPoint, Ray->Initial);

    if (Point_In_Clip (&IPoint, Object->Clip))
      {
      push_entry(Depth1,IPoint,Object,Depth_Stack);
      Intersection_Found = TRUE;
      }

    if (Depth2 != Depth1)
      {
      VScale (IPoint, Ray->Direction, Depth2);
      VAddEq (IPoint, Ray->Initial);

      if (Point_In_Clip (&IPoint, Object->Clip))
        {
        push_entry(Depth2,IPoint,Object,Depth_Stack);
        Intersection_Found = TRUE;
        }
      }
    }
  return (Intersection_Found);
  }
#endif

#ifdef DB_CODE
/******************************************************************************
   caching saves for primary rays (all but the first):               
     6 ADD for axis aligned boxes                                    
     15 ADD, 9 MUL for all other boxes                               
 ******************************************************************************/
int Intersect_Boxx (Ray, box, Depth1, Depth2, Side1, Side2)
RAY *Ray;
BOX *box;
DBL *Depth1, *Depth2;
int *Side1, *Side2;
{
  DBL t, tmin, tmax;
  VECTOR P, D;
  int Sidemin, Sidemax;
  VECTOR P0, P1;

  Ray_Box_Tests++;

  /* Transform the point into the boxes space */
  if (Ray == CM_Ray)
  {
    if (box->CMCached)
    {
      P  = box->CMP;
      P0 = box->CMP0;
      P1 = box->CMP1;
      if (box->Trans != NULL)
      {
	MInvTransDirection(&D, &Ray->Direction, box->Trans);
      }
      else
      {
	D = Ray->Direction;
      }
    }
    else
    {
      if (box->Trans != NULL)
      {
	MInvTransPoint(&P, &Ray->Initial, box->Trans);
	MInvTransDirection(&D, &Ray->Direction, box->Trans);
      }
      else
      {
	P = Ray->Initial;
	D = Ray->Direction;
      }
      P0.x = box->bounds[0].x - P.x;
      P0.y = box->bounds[0].y - P.y;
      P0.z = box->bounds[0].z - P.z;
      P1.x = box->bounds[1].x - P.x;
      P1.y = box->bounds[1].y - P.y;
      P1.z = box->bounds[1].z - P.z;
      box->CMP  = P;
      box->CMP0 = P0;
      box->CMP1 = P1;
      box->CMCached = TRUE;
    }
  }
  else
  {
    if (box->Trans != NULL)
    {
      MInvTransPoint(&P, &Ray->Initial, box->Trans);
      MInvTransDirection(&D, &Ray->Direction, box->Trans);
    }
    else
    {
      P = Ray->Initial;
      D = Ray->Direction;
    }
    P0.x = box->bounds[0].x - P.x;
    P0.y = box->bounds[0].y - P.y;
    P0.z = box->bounds[0].z - P.z;
    P1.x = box->bounds[1].x - P.x;
    P1.y = box->bounds[1].y - P.y;
    P1.z = box->bounds[1].z - P.z;
  }

  tmin = 0.0;
  tmax = HUGE_VAL;

  /* Sides first */
  if (D.x < -EPSILON)
  {
    t = P0.x / D.x;
    if (t < tmin)
      return 0;
    if (t <= tmax)
    {
      tmax = t;
      Sidemax = LOWERX;
    }
    t = P1.x / D.x;
    if (t >= tmin)
    {
      if (t > tmax)
	return 0;
      tmin = t;
      Sidemin = UPPERX;
    }
  }
  else if (D.x > EPSILON)
  {
    t = P1.x / D.x;
    if (t < tmin)
      return 0;
    if (t <= tmax)
    {
      tmax = t;
      Sidemax = UPPERX;
    }
    t = P0.x / D.x;
    if (t >= tmin)
    {
      if (t > tmax)
	return 0;
      tmin = t;
      Sidemin = LOWERX;
    }
  }
  else if (P.x < box->bounds[0].x || P.x > box->bounds[1].x)
    return 0;

  /* Check Top/Bottom */
  if (D.y < -EPSILON)
  {
    t = P0.y / D.y;
    if (t < tmin)
      return 0;
    if (t <= tmax)
    {
      tmax = t;
      Sidemax = LOWERY;
    }
    t = P1.y / D.y;
    if (t >= tmin)
    {
      if (t > tmax)
	return 0;
      tmin = t;
      Sidemin = UPPERY;
    }
  }
  else if (D.y > EPSILON)
  {
    t = P1.y / D.y;
    if (t < tmin)
      return 0;
    if (t <= tmax)
    {
      tmax = t;
      Sidemax = UPPERY;
    }
    t = P0.y / D.y;
    if (t >= tmin)
    {
      if (t > tmax)
	return 0;
      tmin = t;
      Sidemin = LOWERY;
    }
  }
  else if (P.y < box->bounds[0].y || P.y > box->bounds[1].y)
    return 0;

  /* Now front/back */
  if (D.z < -EPSILON)
  {
    t = P0.z / D.z;
    if (t < tmin)
      return 0;
    if (t <= tmax)
    {
      tmax = t;
      Sidemax = LOWERZ;
    }
    t = P1.z / D.z;
    if (t >= tmin)
    {
      if (t > tmax)
	return 0;
      tmin = t;
      Sidemin = UPPERZ;
    }
  }
  else if (D.z > EPSILON)
  {
    t = P1.z / D.z;
    if (t < tmin)
      return 0;
    if (t <= tmax)
    {
      tmax = t;
      Sidemax = UPPERZ;
    }
    t = P0.z / D.z;
    if (t >= tmin)
    {
      if (t > tmax)
	return 0;
      tmin = t;
      Sidemin = LOWERZ;
    }
  }
  else if (P.z < box->bounds[0].z || P.z > box->bounds[1].z)
    return 0;

  *Depth1 = tmin;  *Side1 = Sidemin;
  *Depth2 = tmax;  *Side2 = Sidemax;

  /* printf("Box intersects: %g, %g\n", *Depth1, *Depth2); */
  if ((*Depth1 < Small_Tolerance) || (*Depth1 > Max_Distance))
    if ((*Depth2 < Small_Tolerance) || (*Depth2 > Max_Distance))
      return (FALSE);
    else
    {
      *Depth1 = *Depth2;
      *Side1  = *Side2;
    }
  else
    if ((*Depth2 < Small_Tolerance) || (*Depth2 > Max_Distance))
    {
      *Depth2 = *Depth1;
      *Side2  = *Side1;
    }

  Ray_Box_Tests_Succeeded++;
  return (TRUE);
}
#else
int Intersect_Boxx (Ray, box, Depth1, Depth2)
RAY *Ray;
BOX *box;
DBL *Depth1, *Depth2;
  {
  DBL t, tmin, tmax;
  VECTOR P, D;

  Ray_Box_Tests++;

  /* Transform the point into the boxes space */
  if (box->Trans != NULL) 
    {
    MInvTransPoint(&P, &Ray->Initial, box->Trans);
    MInvTransDirection(&D, &Ray->Direction, box->Trans);
    }
  else 
    {
    P.x = Ray->Initial.x;
    P.y = Ray->Initial.y;
    P.z = Ray->Initial.z;
    D.x = Ray->Direction.x;
    D.y = Ray->Direction.y;
    D.z = Ray->Direction.z;
    }

    tmin = 0.0;
  tmax = HUGE_VAL;

  /* Sides first */
  if (D.x < -EPSILON) 
    {
    t = (box->bounds[0].x - P.x) / D.x;
    if (t < tmin)
      return 0;
    if (t <= tmax)
      tmax = t;
    t = (box->bounds[1].x - P.x) / D.x;
    if (t >= tmin) 
      {
      if (t > tmax)
        return 0;
      tmin = t;
      }
    }
  else if (D.x > EPSILON) 
    {
    t = (box->bounds[1].x - P.x) / D.x;
    if (t < tmin)
      return 0;
    if (t <= tmax)
      tmax = t;
    t = (box->bounds[0].x - P.x) / D.x;
    if (t >= tmin) 
      {
      if (t > tmax)
        return 0;
      tmin = t;
      }
    }
  else if (P.x < box->bounds[0].x || P.x > box->bounds[1].x)
    return 0;

  /* Check Top/Bottom */
  if (D.y < -EPSILON) 
    {
    t = (box->bounds[0].y - P.y) / D.y;
    if (t < tmin)
      return 0;
    if (t <= tmax)
      tmax = t;
    t = (box->bounds[1].y - P.y) / D.y;
    if (t >= tmin) 
      {
      if (t > tmax)
        return 0;
      tmin = t;
      }
    }
  else if (D.y > EPSILON) 
    {
    t = (box->bounds[1].y - P.y) / D.y;
    if (t < tmin)
      return 0;
    if (t <= tmax)
      tmax = t;
    t = (box->bounds[0].y - P.y) / D.y;
    if (t >= tmin) 
      {
      if (t > tmax)
        return 0;
      tmin = t;
      }
    }
  else if (P.y < box->bounds[0].y || P.y > box->bounds[1].y)
    return 0;

  /* Now front/back */
  if (D.z < -EPSILON) 
    {
    t = (box->bounds[0].z - P.z) / D.z;
    if (t < tmin)
      return 0;
    if (t <= tmax)
      tmax = t;
    t = (box->bounds[1].z - P.z) / D.z;
    if (t >= tmin) 
      {
      if (t > tmax)
        return 0;
      tmin = t;
      }
    }
  else if (D.z > EPSILON) 
    {
    t = (box->bounds[1].z - P.z) / D.z;
    if (t < tmin)
      return 0;
    if (t <= tmax)
      tmax = t;
    t = (box->bounds[0].z - P.z) / D.z;
    if (t >= tmin) 
      {
      if (t > tmax)
        return 0;
      tmin = t;
      }
    }
  else if (P.z < box->bounds[0].z || P.z > box->bounds[1].z)
    return 0;

  *Depth1 = tmin;
  *Depth2 = tmax;

  /* printf("Box intersects: %g, %g\n", *Depth1, *Depth2); */
  if ((*Depth1 < Small_Tolerance) || (*Depth1 > Max_Distance))
    if ((*Depth2 < Small_Tolerance) || (*Depth2 > Max_Distance))
      return (FALSE);
    else
      *Depth1 = *Depth2;
  else
    if ((*Depth2 < Small_Tolerance) || (*Depth2 > Max_Distance))
      *Depth2 = *Depth1;

  Ray_Box_Tests_Succeeded++;
  return (TRUE);
  }
#endif

int Inside_Box (IPoint, Object)
VECTOR *IPoint;
OBJECT *Object;
  {
  VECTOR New_Point;
  BOX *box = (BOX *) Object;

  /* Transform the point into the boxes space */
  if (box->Trans != NULL)
    MInvTransPoint(&New_Point, IPoint, box->Trans);
  else
    New_Point = *IPoint;

  /* Test to see if we are inside the box */
  if (New_Point.x < box->bounds[0].x || New_Point.x > box->bounds[1].x)
    return ((int) box->Inverted);
  if (New_Point.y < box->bounds[0].y || New_Point.y > box->bounds[1].y)
    return ((int) box->Inverted);
  if (New_Point.z < box->bounds[0].z || New_Point.z > box->bounds[1].z)
    return ((int)box->Inverted);
  /* Inside the box */
  return 1-box->Inverted;
  }

#ifdef DB_CODE
/******************************************************************************
   caching of the box side and precomputing of the normals saves     
     some compares and fabs for axis aligned boxes                   
     plus 21 MUL, 17 ADD, 1 DIV, 1 SQRT for all other boxes         
 ******************************************************************************/
void Box_Normal (Result, Object, Intersection)
OBJECT *Object;
VECTOR *Result;
INTERSECTION *Intersection;
{
  BOX *box = (BOX *) Object;

  switch (Intersection->box_side)
  {
    case UPPERX :
      *Result = box->Normal_x;
      break;
    case LOWERX :
      Result->x = -box->Normal_x.x;
      Result->y = -box->Normal_x.y;
      Result->z = -box->Normal_x.z;
      break;
    case UPPERY :
      *Result = box->Normal_y;
      break;
    case LOWERY :
      Result->x = -box->Normal_y.x;
      Result->y = -box->Normal_y.y;
      Result->z = -box->Normal_y.z;
      break;
    case UPPERZ :
      *Result = box->Normal_z;
      break;
    case LOWERZ :
      Result->x = -box->Normal_z.x;
      Result->y = -box->Normal_z.y;
      Result->z = -box->Normal_z.z;
      break;
    default:
      Result->x = 1.0;
      Result->y = 0.0;
      Result->z = 0.0;
      break;
  }
}
#else
void Box_Normal (Result, Object, IPoint)
OBJECT *Object;
VECTOR *Result, *IPoint;
  {
  VECTOR New_Point;
  BOX *box = (BOX *) Object;

  /* Transform the point into the boxes space */
  if (box->Trans != NULL)
    MInvTransPoint(&New_Point, IPoint, box->Trans);
  else 
    {
    New_Point.x = IPoint->x;
    New_Point.y = IPoint->y;
    New_Point.z = IPoint->z;
    }

    Result->x = 0.0; Result->y = 0.0; Result->z = 0.0;
  if (close(New_Point.x, box->bounds[1].x))
    Result->x = 1.0;
  else if (close(New_Point.x, box->bounds[0].x))
    Result->x = -1.0;
  else if (close(New_Point.y, box->bounds[1].y))
    Result->y = 1.0;
  else if (close(New_Point.y, box->bounds[0].y))
    Result->y = -1.0;
  else if (close(New_Point.z, box->bounds[1].z))
    Result->z = 1.0;
  else if (close(New_Point.z, box->bounds[0].z))
    Result->z = -1.0;
  else 
    {
    /* Bad result, should we do something with it? */
      Result->x = 1.0;
    }

  /* Transform the point into the boxes space */
  if (box->Trans != NULL) 
    {
    MTransNormal(Result, Result, box->Trans);
    VNormalize(*Result, *Result);
    }
  }
#endif

void *Copy_Box (Object)
OBJECT *Object;
  {
  BOX *New;

  New  = Create_Box();
  *New = *((BOX *) Object);

  New->Trans = Copy_Transform(((BOX *)Object)->Trans);

  return (New);
  }

void Translate_Box (Object, Vector)
OBJECT *Object;
VECTOR *Vector;
  {
  TRANSFORM Trans;

  if (((BOX *)Object)->Trans == NULL)
    {
    VAddEq(((BOX *)Object)->bounds[0], *Vector);
    VAddEq(((BOX *)Object)->bounds[1], *Vector);
#ifdef DB_CODE
    Object->Bounds.Min = ((BOX *)Object)->bounds[0];
    Object->Bounds.Max = ((BOX *)Object)->bounds[1];
#else
    Object->Bounds.Lower_Left = ((BOX *)Object)->bounds[0];
#endif
    }
  else
    {
    Compute_Translation_Transform(&Trans, Vector);
    Transform_Box(Object, &Trans);
    }
  }

#ifdef DB_CODE
/*****************************************************************************
 *****************************************************************************/
void Rotate_Box (Object, Vector)
OBJECT *Object;
VECTOR *Vector;
{
  BOX *Box = (BOX *)Object;
  TRANSFORM Trans;
  Compute_Rotation_Transform(&Trans, Vector);
  MTransDirection(&Box->Normal_x, &Box->Normal_x, &Trans);
  MTransDirection(&Box->Normal_y, &Box->Normal_y, &Trans);
  MTransDirection(&Box->Normal_z, &Box->Normal_z, &Trans);
  Transform_Box(Object, &Trans);
}
#else
void Rotate_Box (Object, Vector)
OBJECT *Object;
VECTOR *Vector;
  {
  TRANSFORM Trans;
  Compute_Rotation_Transform(&Trans, Vector);
 Transform_Box(Object, &Trans);
  }
#endif

void Scale_Box (Object, Vector)
OBJECT *Object;
VECTOR *Vector;
  {
  BOX *Box = (BOX *)Object;
  TRANSFORM Trans;
  DBL temp;

  if (((BOX *)Object)->Trans == NULL)
    {
    VEvaluateEq(Box->bounds[0], *Vector);
    VEvaluateEq(Box->bounds[1], *Vector);
    if (Box->bounds[0].x > Box->bounds[1].x) {
       temp = Box->bounds[0].x;
       Box->bounds[0].x = Box->bounds[1].x;
       Box->bounds[1].x = temp;
       }
    if (Box->bounds[0].y > Box->bounds[1].y) {
       temp = Box->bounds[0].y;
       Box->bounds[0].y = Box->bounds[1].y;
       Box->bounds[1].y = temp;
       }
    if (Box->bounds[0].z > Box->bounds[1].z) {
       temp = Box->bounds[0].z;
       Box->bounds[0].z = Box->bounds[1].z;
       Box->bounds[1].z = temp;
       }
#ifdef DB_CODE
    Box->Bounds.Min = Box->bounds[0];
    Box->Bounds.Max = Box->bounds[1];
#else
    Box->Bounds.Lower_Left = Box->bounds[0];
    VSub(Object->Bounds.Lengths, Box->bounds[1], Box->bounds[0]);
#endif
    }
  else
    {
    Compute_Scaling_Transform(&Trans, Vector);
    Transform_Box(Object, &Trans);
    }
  }

void Invert_Box (Object)
OBJECT *Object;
  {
  ((BOX *)Object)->Inverted = 1 - ((BOX *)Object)->Inverted;
  }

void Transform_Box (Object, Trans)
OBJECT *Object;
TRANSFORM *Trans;
  {
  BOX *box = (BOX *)Object;
  if (box->Trans == NULL)
    box->Trans = Create_Transform();
  Compose_Transforms(box->Trans, Trans);
#ifdef DB_CODE
  Object->Bounds.Min = box->bounds[0];
  Object->Bounds.Max = box->bounds[1];
#else
  Object->Bounds.Lower_Left = box->bounds[0];
  VSub(Object->Bounds.Lengths, box->bounds[1], box->bounds[0]);
#endif
  recompute_bbox(&Object->Bounds, box->Trans);
  }

BOX *Create_Box ()
  {
  BOX *New;

  if ((New = (BOX *) malloc (sizeof (BOX))) == NULL)
    MAError ("box");

  INIT_OBJECT_FIELDS(New, BOX_OBJECT, &Box_Methods)

    Make_Vector (&(New->bounds[0]), -1.0, -1.0, -1.0);
  Make_Vector (&(New->bounds[1]),  1.0,  1.0,  1.0);
  /* Recalculate the bounds */
#ifdef DB_CODE
  Make_Vector(&New->Bounds.Min, -1.0, -1.0, -1.0);
  Make_Vector(&New->Bounds.Max, 1.0, 1.0, 1.0);
#else
  Make_Vector(&New->Bounds.Lower_Left, -1.0, -1.0, -1.0);
  Make_Vector(&New->Bounds.Lengths, 2.0, 2.0, 2.0);
#endif
#ifdef DB_CODE
  /* normal vectors */
  Make_Vector(&New->Normal_x, 1.0, 0.0, 0.0);
  Make_Vector(&New->Normal_y, 0.0, 1.0, 0.0);
  Make_Vector(&New->Normal_z, 0.0, 0.0, 1.0);
  New->CMCached = FALSE;
#endif
 /* Unlike HField, we don't always have a trans here */
  New->Trans = NULL;
  New->Inverted = FALSE;
  return (New);
  }

void Destroy_Box (Object)
OBJECT *Object;
  {
  Destroy_Transform(((BOX *)Object)->Trans);
  free (Object);
  }
