/****************************************************************************
*
*  ATTENTION!!!
*
*  THIS FILE HAS BEEN MODIFIED!!! IT IS NOT PART OF THE OFFICAL
*  POV-RAY 2.2 DISTRIBUTION!!!
*
*  THIS FILE IS PART OF "FASTER THAN POV-RAY" (VERSION 1.1),
*  A SPED-UP VERSION OF POV-RAY 2.2. USE AT YOUR OWN RISK!!!!!!
*
*  New files: addon0.c, addon1.c, addon2.c, addon3.c, addon.h
*
*  The additional modules were written by Dieter Bayer.
*
*  Send comments, suggestions, bugs to:
*
*  dieter@cip.e-technik.uni-erlangen.de
*
*  If I have enough time I will try to fix any bugs.
*
*  All changed/added lines are enclosed in #ifdef DB_CODE ... #endif
*
*  The new/changed modules speed-up ray-tracing in two ways:
*
*   - Objects are projected onto the viewing plane a priori. Thus
*     the number of ray/object intersection tests is reduced for
*     primary rays.
*
*   - A light buffer is used for every spotlight. Each object is
*     projected a priori onto the six sides of a cube enclosing
*     the light source. Thus the number of ray/object intersection
*     tests is reduced for shadow rays.
*
*  The vista projection of qaudrics was taken from:
*
*    A. Hashimoto, T. Akimoto, K. Mase, and Y. Suenaga, "Vista
*    Ray-Tracing: High Speed Ray Tracing Using Perspective
*    Projection Image", New Advances in Computer Graphics,
*    Proceedings of CG International '89, R. A. Earnshaw,
*    B. Wyvill (Eds.), Springer, ...
*
*  The idea for the light buffer was taken from:
*
*    E. Haines and D. Greenberg, "The Light Buffer: A Shadow-
*    Testing Accelerator", IEEE CG&A, Vol. 6, No. 9, Sept. 1986, pp. 6-16
*
*****************************************************************************/

/****************************************************************************
*                normal.c
*
*  This module implements solid texturing functions that perturb the surface
*  normal to create a bumpy effect. 
*
*  from Persistence of Vision Raytracer
*  Copyright 1993 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other 
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If 
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's Graphics Developer's
*  Forum.  The latest version of POV-Ray may be found there as well.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/

/*
   Some texture ideas garnered from SIGGRAPH '85 Volume 19 Number 3, 
   "An Image Synthesizer" By Ken Perlin.
   Further Ideas Garnered from "The RenderMan Companion" (Addison Wesley)
*/

#include "frame.h"
#include "vector.h"
#include "povproto.h"
#include "texture.h"

extern unsigned short crctab[256];

#ifdef DB_CODE
/******************************************************************************
  replaced some divisions by multiplications.
 ******************************************************************************/
void ripples (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
{
  register int i;
  VECTOR point;
  register DBL length, scalar, index;

  if (Options & DEBUGGING)
    printf ("ripples %g %g %g", x, y, z);

  for (i = 0 ; i < NUMBER_OF_WAVES ; i++)
  {
    point.x = x - Wave_Sources[i].x;
    point.y = y - Wave_Sources[i].y;
    point.z = z - Wave_Sources[i].z;

    VDot (length, point, point);
    if (length == 0.0)
      length = 1.0;

    length = sqrt(length);
    index = length * Tnormal->Frequency + Tnormal->Phase;
    scalar = cycloidal(index) * Tnormal->Amount /
	     (length * (DBL)NUMBER_OF_WAVES);

    if (Options & DEBUGGING)
      printf (" index %g scalar %g length %g\n", index, scalar, length);

    normal->x += scalar * point.x;
    normal->y += scalar * point.y;
    normal->z += scalar * point.z;
  }
  VNormalize (*normal, *normal);
}
#else
void ripples (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
  {
  register int i;
  VECTOR point;
  register DBL length, scalar, index;

  if (Options & DEBUGGING)
    printf ("ripples %g %g %g", x, y, z);

  for (i = 0 ; i < NUMBER_OF_WAVES ; i++) 
    {
    point.x = x;
    point.y = y;
    point.z = z;
    VSub (point, point, Wave_Sources[i]);
    VDot (length, point, point);
    if (length == 0.0)
      length = 1.0;

    length = sqrt(length);
    index = length*Tnormal->Frequency
    + Tnormal -> Phase;
    scalar = cycloidal (index) * Tnormal -> Amount;

    if (Options & DEBUGGING)
      printf (" index %g scalar %g length %g\n", index, scalar, length);

    VScale (point, point, scalar/length/(DBL)NUMBER_OF_WAVES);
    VAdd (*normal, *normal, point);
    }
  VNormalize (*normal, *normal);
  }
#endif

#ifdef DB_CODE
/******************************************************************************
   replace somed divisions by multiplications.                        
 ******************************************************************************/
void waves (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
{
  register int i;
  VECTOR point;
  register DBL length, scalar, index;

  if (Options & DEBUGGING)
    printf ("waves %g %g %g\n", x, y, z);

  for (i = 0 ; i < NUMBER_OF_WAVES ; i++)
    {
    point.x = x - Wave_Sources[i].x;
    point.y = y - Wave_Sources[i].y;
    point.z = z - Wave_Sources[i].z;

    VDot (length, point, point);

    if (length == 0.0)
      length = 1.0;

    length = sqrt(length);
    index = length * Tnormal->Frequency * frequency[i] + Tnormal->Phase;

    scalar =  cycloidal(index) * Tnormal->Amount /
	      (frequency[i] * length *(DBL)NUMBER_OF_WAVES);
    normal->x += scalar * point.x;
    normal->y += scalar * point.y;
    normal->z += scalar * point.z;
  }
  VNormalize (*normal, *normal);
}
#else
void waves (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
  {
  register int i;
  VECTOR point;
  register DBL length, scalar, index, sinValue ;

  if (Options & DEBUGGING)
    printf ("waves %g %g %g\n", x, y, z);

  for (i = 0 ; i < NUMBER_OF_WAVES ; i++) 
    {
    point.x = x;
    point.y = y;
    point.z = z;
    VSub (point, point, Wave_Sources[i]);
    VDot (length, point, point);
    if (length == 0.0)
      length = 1.0;

    length = sqrt(length);
    index = (length * Tnormal -> Frequency * frequency[i])
      + Tnormal -> Phase;
    sinValue = cycloidal (index);

    scalar =  sinValue * Tnormal -> Amount /
    frequency[i];
    VScale (point, point, scalar/length/(DBL)NUMBER_OF_WAVES);
    VAdd (*normal, *normal, point);
    }
  VNormalize (*normal, *normal);
  }
#endif

#ifdef DB_CODE
/******************************************************************************
 ******************************************************************************/
void bumps (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
{
  VECTOR bump_turb;

  if (Tnormal->Amount == 0.0)
    return;                         /* why are we here?? */

  if (Options & DEBUGGING)
    printf ("bumps %g %g %g\n", x, y, z);

  DNoise (&bump_turb, x, y, z);      /* Get Normal Displacement Val. */
  normal->x += Tnormal->Amount * bump_turb.x;
  normal->y += Tnormal->Amount * bump_turb.y;
  normal->z += Tnormal->Amount * bump_turb.z;
  VNormalize (*normal, *normal);     /* normalize normal! */
  return;
}
#else
void bumps (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
  {
  VECTOR bump_turb;

  if (Tnormal -> Amount == 0.0)
    return;                            /* why are we here?? */

  if (Options & DEBUGGING)
    printf ("bumps %g %g %g\n", x, y, z);

  DNoise (&bump_turb, x, y, z);         /* Get Normal Displacement Val. */
  VScale(bump_turb, bump_turb, Tnormal->Amount);
  VAdd (*normal, *normal, bump_turb);   /* displace "normal" */
  VNormalize (*normal, *normal);        /* normalize normal! */
  return;
  }
#endif

/*
   dents is similar to bumps, but uses noise() to control the amount of
   dnoise() perturbation of the object normal...
*/

#ifdef DB_CODE
/******************************************************************************
 ******************************************************************************/
void dents (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
{
  VECTOR stucco_turb;
  DBL noise;

  if (Tnormal->Amount == 0.0)
    return;                        /* why are we here?? */

  noise = Noise (x, y, z);

  noise =  noise * noise * noise * Tnormal->Amount;

  if (Options & DEBUGGING)
    printf ("dents %g %g %g noise %g\n", x, y, z, noise);

  DNoise (&stucco_turb, x, y, z);    /* Get Normal Displacement Val. */

  normal->x += noise * stucco_turb.x;
  normal->y += noise * stucco_turb.y;
  normal->z += noise * stucco_turb.z;
  VNormalize (*normal, *normal);     /* normalize normal! */
  return;
}
#else
void dents (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
  {
  VECTOR stucco_turb;
  DBL noise;

  if (Tnormal -> Amount == 0.0)
    return;                           /* why are we here?? */

  noise = Noise (x, y, z);

  noise =  noise * noise * noise * Tnormal->Amount;

  if (Options & DEBUGGING)
    printf ("dents %g %g %g noise %g\n", x, y, z, noise);

  DNoise (&stucco_turb, x, y, z);       /* Get Normal Displacement Val. */

  VScale (stucco_turb, stucco_turb, noise);
  VAdd (*normal, *normal, stucco_turb); /* displace "normal" */
  VNormalize (*normal, *normal);        /* normalize normal! */
  return;
  }
#endif




/*
   Ideas garnered from the April 89 Byte Graphics Supplement on RenderMan,
   refined from "The RenderMan Companion, by Steve Upstill of Pixar, (C) 1990
   Addison-Wesley.
*/


/*
   wrinkles - This is my implementation of the dented() routine, using
   a surface iterative fractal derived from DTurbulence.  This is a 3-D vers.
   (thanks to DNoise()...) of the usual version using the singular Noise()...
   Seems to look a lot like wrinkles, however... (hmmm)
*/

#ifdef DB_CODE
/******************************************************************************
   Look-up tables save 10 MULs and replaces 10 DIVs by 10 MULs.
 ******************************************************************************/

static DBL freq_1[10] =
  {   1.0,   2.0,   4.0,   8.0,  16.0,
     32.0,  64.0, 128.0, 256.0, 512.0 };

static DBL freq_i[10] =
  { 1.0, 0.5, 0.25, 0.125, 0.0625,
    0.03125, 0.015625, 0.0078125, 0.00390625, 0.001953125 };

void wrinkles (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
{
  register int i;
  VECTOR result, value;

  if (Tnormal->Amount == 0.0)
    return;                             /* why are we here?? */

  if (Options & DEBUGGING)
    printf ("wrinkles %g %g %g\n", x, y, z);

  result.x = result.y = result.z = 0.0;

  for (i = 0; i < 10 ; i++)
  {
    DNoise(&value, x * freq_1[i], y * freq_1[i], z * freq_1[i]);
    result.x += fabs(value.x * freq_i[i]);
    result.y += fabs(value.y * freq_i[i]);
    result.z += fabs(value.z * freq_i[i]);
  }

  normal->x += Tnormal->Amount * result.x;
  normal->y += Tnormal->Amount * result.y;
  normal->z += Tnormal->Amount * result.z;
  VNormalize (*normal, *normal);               /* normalize normal! */
  return;
}
#else
void wrinkles (x, y, z, Tnormal, normal)
DBL x, y, z;
TNORMAL *Tnormal;
VECTOR *normal;
  {
  register int i;
  register DBL scale = 1.0;
  VECTOR result, value;

  if (Tnormal -> Amount == 0.0)
    return;                                /* why are we here?? */

  if (Options & DEBUGGING)
    printf ("wrinkles %g %g %g\n", x, y, z);

  result.x = 0.0;
  result.y = 0.0;
  result.z = 0.0;

  for (i = 0; i < 10 ; scale *= 2.0, i++)
    {
    DNoise(&value, x * scale, y * scale, z * scale);   /* * scale,*/
    result.x += FABS (value.x / scale);
    result.y += FABS (value.y / scale);
    result.z += FABS (value.z / scale);
    }

  VScale(result, result, Tnormal->Amount);
  VAdd (*normal, *normal, result);             /* displace "normal" */
  VNormalize (*normal, *normal);               /* normalize normal! */
  return;
  }
#endif

TNORMAL *Create_Tnormal ()
  {
  TNORMAL *New;

  if ((New = (TNORMAL *) malloc (sizeof (TNORMAL))) == NULL)
    MAError ("normal");

  INIT_TPATTERN_FIELDS(New,NO_NORMAL);
  New->Amount = 0.0;
  return (New);
  }

TNORMAL *Copy_Tnormal (Old)
TNORMAL *Old;
  {
  TNORMAL *New;

  if (Old != NULL)
    {
    New = Create_Tnormal ();
    *New = *Old;

    New->Image = Copy_Image (Old->Image);
    New->Trans = Copy_Transform (Old->Trans);
    }
  else
    New = NULL;

  return (New);
  }

void Translate_Tnormal(Tnormal,Vector)
TNORMAL *Tnormal;
VECTOR *Vector;
  {
  TRANSFORM Trans;

  if (Tnormal == NULL)
    return;

  Compute_Translation_Transform (&Trans, Vector);
  Transform_Tnormal (Tnormal, &Trans);
  }

void Rotate_Tnormal(Tnormal,Vector)
TNORMAL *Tnormal;
VECTOR *Vector;
  {
  TRANSFORM Trans;

  if (Tnormal == NULL)
    return;

  Compute_Rotation_Transform (&Trans, Vector);
  Transform_Tnormal (Tnormal, &Trans);
  }

void Scale_Tnormal(Tnormal,Vector)
TNORMAL *Tnormal;
VECTOR *Vector;
  {
  TRANSFORM Trans;

  if (Tnormal == NULL)
    return;

  Compute_Scaling_Transform (&Trans, Vector);
  Transform_Tnormal (Tnormal, &Trans);
  }

void Transform_Tnormal(Tnormal,Trans)
TNORMAL *Tnormal;
TRANSFORM *Trans;
  {
  if (Tnormal == NULL)
    return;

  if (!Tnormal->Trans)
    Tnormal->Trans = Create_Transform ();

  Compose_Transforms (Tnormal->Trans, Trans);
  }

void Destroy_Tnormal(Tnormal)
TNORMAL *Tnormal;
  {
  if (Tnormal == NULL)
    return;

  Destroy_Image (Tnormal->Image);
  Destroy_Transform (Tnormal->Trans);
  free (Tnormal);
  }

void Post_Tnormal (Tnormal)
TNORMAL *Tnormal;
  {
  if (Tnormal == NULL)
    return;

  if (Tnormal->Type == NO_NORMAL)
    Error("No normal type given");

  Tnormal->Flags |= POST_DONE;

  return;   
  }
