/****************************************************************************
*
*  ATTENTION!!!
*
*  THIS FILE HAS BEEN MODIFIED!!! IT IS NOT PART OF THE OFFICAL
*  POV-RAY 2.2 DISTRIBUTION!!!
*
*  THIS FILE IS PART OF "FASTER THAN POV-RAY" (VERSION 1.1),
*  A SPED-UP VERSION OF POV-RAY 2.2. USE AT YOUR OWN RISK!!!!!!
*
*  New files: addon0.c, addon1.c, addon2.c, addon3.c, addon.h
*
*  The additional modules were written by Dieter Bayer.
*
*  Send comments, suggestions, bugs to:
*
*  dieter@cip.e-technik.uni-erlangen.de
*
*  If I have enough time I will try to fix any bugs.
*
*  All changed/added lines are enclosed in #ifdef DB_CODE ... #endif
*
*  The new/changed modules speed-up ray-tracing in two ways:
*
*   - Objects are projected onto the viewing plane a priori. Thus
*     the number of ray/object intersection tests is reduced for
*     primary rays.
*
*   - A light buffer is used for every spotlight. Each object is
*     projected a priori onto the six sides of a cube enclosing
*     the light source. Thus the number of ray/object intersection
*     tests is reduced for shadow rays.
*
*  The vista projection of qaudrics was taken from:
*
*    A. Hashimoto, T. Akimoto, K. Mase, and Y. Suenaga, "Vista
*    Ray-Tracing: High Speed Ray Tracing Using Perspective
*    Projection Image", New Advances in Computer Graphics,
*    Proceedings of CG International '89, R. A. Earnshaw,
*    B. Wyvill (Eds.), Springer, ...
*
*  The idea for the light buffer was taken from:
*
*    E. Haines and D. Greenberg, "The Light Buffer: A Shadow-
*    Testing Accelerator", IEEE CG&A, Vol. 6, No. 9, Sept. 1986, pp. 6-16
*
*****************************************************************************/

/****************************************************************************
*                planes.c
*
*  This module implements functions that manipulate planes.
*
*  from Persistence of Vision Raytracer
*  Copyright 1993 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other 
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If 
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's Graphics Developer's
*  Forum.  The latest version of POV-Ray may be found there as well.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/

#include "frame.h"
#include "vector.h"
#include "povproto.h"

METHODS Plane_Methods =
  {
  All_Plane_Intersections,
  Inside_Plane, Plane_Normal,
  Copy_Plane,
  Translate_Plane, Rotate_Plane,
  Scale_Plane, Transform_Plane, Invert_Plane, Destroy_Plane
};

extern RAY *CM_Ray;
extern long Ray_Plane_Tests, Ray_Plane_Tests_Succeeded;

#ifndef Plane_Tolerance
#define Plane_Tolerance 1.0e-8
#endif

#ifdef DB_CODE
/******************************************************************************
 ******************************************************************************/
int All_Plane_Intersections (Object, Ray, Depth_Stack)
OBJECT *Object;
RAY *Ray;
ISTACK *Depth_Stack;
{
  DBL Depth;
  VECTOR IPoint;

  if (Intersect_Plane (Ray, (PLANE *)Object, &Depth))
    if (Depth > Plane_Tolerance)
    {
      IPoint.x = Ray->Initial.x + Depth * Ray->Direction.x;
      IPoint.y = Ray->Initial.y + Depth * Ray->Direction.y;
      IPoint.z = Ray->Initial.z + Depth * Ray->Direction.z;
      if (Point_In_Clip (&IPoint, Object->Clip))
      {
	push_entry(Depth,IPoint,Object,Depth_Stack);
	return (TRUE);
      }
    }
  return (FALSE);
}
#else
int All_Plane_Intersections (Object, Ray, Depth_Stack)
OBJECT *Object;
RAY *Ray;
ISTACK *Depth_Stack;
  {
  DBL Depth;
  VECTOR IPoint;

  if (Intersect_Plane (Ray, (PLANE *)Object, &Depth))
    if (Depth > Plane_Tolerance)
      {
      VScale (IPoint, Ray -> Direction, Depth);
      VAddEq (IPoint, Ray -> Initial);
      if (Point_In_Clip (&IPoint, Object->Clip))
	{
	push_entry(Depth,IPoint,Object,Depth_Stack);
	return (TRUE);
	}
      }
  return (FALSE);
  }
#endif

#ifdef DB_CODE
/******************************************************************************
 ******************************************************************************/
int Intersect_Plane (Ray, Plane, Depth)
RAY *Ray;
PLANE *Plane;
DBL *Depth;
{
  DBL NormalDotOrigin, NormalDotDirection;

  Ray_Plane_Tests++;

  NormalDotDirection = Plane->Normal_Vector.x * Ray->Direction.x +
		       Plane->Normal_Vector.y * Ray->Direction.y +
		       Plane->Normal_Vector.z * Ray->Direction.z;

  if ((NormalDotDirection < Plane_Tolerance) &&
      (NormalDotDirection > -Plane_Tolerance))
    return (FALSE);

  if (Ray == CM_Ray)
  {
    if (!Plane->CMCached)
    {
      Plane->CMNormDotOrigin = -Plane->Distance -
			       Plane->Normal_Vector.x * Ray->Initial.x -
			       Plane->Normal_Vector.y * Ray->Initial.y -
			       Plane->Normal_Vector.z * Ray->Initial.z;
      Plane->CMCached = TRUE;
    }
    *Depth = Plane->CMNormDotOrigin / NormalDotDirection;
  }
  else
  {
    NormalDotOrigin = -Plane->Distance -
		      Plane->Normal_Vector.x * Ray->Initial.x -
		      Plane->Normal_Vector.y * Ray->Initial.y -
		      Plane->Normal_Vector.z * Ray->Initial.z;
    *Depth = NormalDotOrigin / NormalDotDirection;
  }

  if ((*Depth >= Plane_Tolerance) && (*Depth <= Max_Distance))
  {
    Ray_Plane_Tests_Succeeded++;
    return (TRUE);
  }
  else
    return (FALSE);
}
#else
int Intersect_Plane (Ray, Plane, Depth)
RAY *Ray;
PLANE *Plane;
DBL *Depth;
  {
  DBL NormalDotOrigin, NormalDotDirection;

  Ray_Plane_Tests++;
  if (Ray == CM_Ray)
    {
    VDot (NormalDotDirection, Plane->Normal_Vector, Ray->Direction);
    if ((NormalDotDirection < Plane_Tolerance) &&
      (NormalDotDirection > -Plane_Tolerance))
      return (FALSE);

    if (!Plane->CMCached)
      {
      VDot (Plane->CMNormDotOrigin, Plane->Normal_Vector, Ray->Initial);
      Plane->CMNormDotOrigin += Plane->Distance;
      Plane->CMNormDotOrigin *= -1.0;
      Plane->CMCached = TRUE;
      }

    *Depth = Plane->CMNormDotOrigin / NormalDotDirection;
    if ((*Depth >= Plane_Tolerance) && (*Depth <= Max_Distance))
      {
      Ray_Plane_Tests_Succeeded++;
      return (TRUE);
      }
    else
      return (FALSE);
    }
  else
    {
    VDot (NormalDotDirection, Plane->Normal_Vector, Ray->Direction);
    if ((NormalDotDirection < Plane_Tolerance) &&
      (NormalDotDirection > -Plane_Tolerance))
      return (FALSE);

    VDot (NormalDotOrigin, Plane->Normal_Vector, Ray->Initial);
    NormalDotOrigin += Plane->Distance;
    NormalDotOrigin *= -1.0;

    *Depth = NormalDotOrigin / NormalDotDirection;
    if ((*Depth >= Plane_Tolerance) && (*Depth <= Max_Distance)) 
      {
      Ray_Plane_Tests_Succeeded++;
      return (TRUE);
      }
    else
      return (FALSE);
    }
  }
#endif

#ifdef DB_CODE
/******************************************************************************
 ******************************************************************************/
int Inside_Plane (IPoint, Object)
VECTOR *IPoint;
OBJECT *Object;
{
  return ((IPoint->x * ((PLANE *)Object)->Normal_Vector.x +
	   IPoint->y * ((PLANE *)Object)->Normal_Vector.y +
	   IPoint->z * ((PLANE *)Object)->Normal_Vector.z +
	   ((PLANE *)Object)->Distance) <= Plane_Tolerance);
}
#else
int Inside_Plane (IPoint, Object)
VECTOR *IPoint;
OBJECT *Object;
  {
  DBL Temp;

  VDot (Temp, *IPoint, ((PLANE *)Object)->Normal_Vector);
  return ((Temp + ((PLANE *)Object)->Distance) <= Plane_Tolerance);
  }
#endif

#ifdef DB_CODE
/******************************************************************************
 ******************************************************************************/
void Plane_Normal (Result, Object, Intersection)
OBJECT *Object;
VECTOR *Result;
INTERSECTION *Intersection;
{
  *Result = ((PLANE *)Object)->Normal_Vector;
}
#else
void Plane_Normal (Result, Object, IPoint)
OBJECT *Object;
VECTOR *Result, *IPoint;
  {
  *Result = ((PLANE *)Object)->Normal_Vector;
  }
#endif

void Translate_Plane (Object, Vector)
OBJECT *Object;
VECTOR *Vector;
  {
  VECTOR Translation;

  VEvaluate (Translation, ((PLANE *)Object)->Normal_Vector, *Vector);
  ((PLANE *)Object)->Distance -= Translation.x + Translation.y + Translation.z;
#ifdef DB_CODE
  Compute_Plane_BBox((PLANE *)Object);
#endif
  }

void Rotate_Plane (Object, Vector)
OBJECT *Object;
VECTOR *Vector;
  {
  TRANSFORM Trans;

  Compute_Rotation_Transform (&Trans, Vector);
  Transform_Plane (Object, &Trans);
  }

void Scale_Plane (Object, Vector)
OBJECT *Object;
VECTOR *Vector;
  {
  DBL Length;

  PLANE *Plane = (PLANE  *) Object;

  VDivEq(Plane->Normal_Vector, *Vector);

  VLength(Length, ((PLANE *)Object)->Normal_Vector);
  VScaleEq (((PLANE *)Object)->Normal_Vector, 1.0 / Length);
  ((PLANE *)Object)->Distance /= Length;
#ifdef DB_CODE
  Compute_Plane_BBox((PLANE *)Object);
#endif
  }

void Invert_Plane (Object)
OBJECT *Object;
  {
  VScaleEq (((PLANE *) Object)->Normal_Vector, -1.0);
  ((PLANE *) Object)->Distance *= -1.0;
#ifdef DB_CODE
  Compute_Plane_BBox((PLANE *)Object);
#endif
  }

PLANE *Create_Plane()
  {
  PLANE *New;

  if ((New = (PLANE *) malloc (sizeof (PLANE))) == NULL)
    MAError ("plane");

  INIT_OBJECT_FIELDS(New,PLANE_OBJECT,&Plane_Methods)

    Make_Vector (&(New -> Normal_Vector), 0.0, 1.0, 0.0);
  New -> Distance = 0.0;
  New -> CMNormDotOrigin = 0.0;
  New -> CMCached = 0;
  return (New);
  }

void *Copy_Plane (Object)
OBJECT *Object;
  {
  PLANE *New;

  New = Create_Plane ();
  *New = * ((PLANE *)Object);

  return (New);
  }

void Transform_Plane (Object, Trans)
OBJECT *Object;
TRANSFORM *Trans;
  {
  MTransPoint (&((PLANE *) Object)->Normal_Vector,
    &((PLANE *) Object)->Normal_Vector, Trans);
#ifdef DB_CODE
  Compute_Plane_BBox((PLANE *)Object);
#endif
  }

void Destroy_Plane (Object)
OBJECT *Object;
  {
  free (Object);
  }

#ifdef DB_CODE
/*****************************************************************************
   Compute bounding box for planes perpendicular to an axis.
   Due too precision problems this does not work with the old
   bounding box structure (Lower_Left/Lengths). 
 *****************************************************************************/
void Compute_Plane_BBox(Plane)
PLANE *Plane;
{
  DBL d;
  VECTOR N, Min, Max;

  N = Plane->Normal_Vector;
  d = -Plane->Distance;

  Min.x = Min.y = Min.z = -BOUND_HUGE/2;
  Max.x = Max.y = Max.z = BOUND_HUGE/2;

  /* y-z-plane */

  if (fabs(1.0 - fabs(N.x)) < EPSILON)
  {
    if (N.x > 0.0)
    {
      Max.x = d;
    }
    else
    {
      Min.x = -d;
    }
  }

  /* x-z-plane */

  if (fabs(1.0 - fabs(N.y)) < EPSILON)
  {
    if (N.y > 0.0)
    {
      Max.y = d;
    }
    else
    {
      Min.y = -d;
    }
  }

  /* x-y-plane */

  if (fabs(1.0 - fabs(N.z)) < EPSILON)
  {
    if (N.z > 0.0)
    {
      Max.z = d;
    }
    else
    {
      Min.z = -d;
    }
  }

  Plane->Bounds.Min = Min;
  Plane->Bounds.Max = Max;
}
#endif

