/****************************************************************************
*
*  ATTENTION!!!
*
*  THIS FILE HAS BEEN MODIFIED!!! IT IS NOT PART OF THE OFFICAL
*  POV-RAY 2.2 DISTRIBUTION!!!
*
*  THIS FILE IS PART OF "FASTER THAN POV-RAY" (VERSION 1.1),
*  A SPED-UP VERSION OF POV-RAY 2.2. USE AT YOUR OWN RISK!!!!!!
*
*  New files: addon0.c, addon1.c, addon2.c, addon3.c, addon.h
*
*  The additional modules were written by Dieter Bayer.
*
*  Send comments, suggestions, bugs to:
*
*  dieter@cip.e-technik.uni-erlangen.de
*
*  If I have enough time I will try to fix any bugs.
*
*  All changed/added lines are enclosed in #ifdef DB_CODE ... #endif
*
*  The new/changed modules speed-up ray-tracing in two ways:
*
*   - Objects are projected onto the viewing plane a priori. Thus
*     the number of ray/object intersection tests is reduced for
*     primary rays.
*
*   - A light buffer is used for every spotlight. Each object is
*     projected a priori onto the six sides of a cube enclosing
*     the light source. Thus the number of ray/object intersection
*     tests is reduced for shadow rays.
*
*  The vista projection of qaudrics was taken from:
*
*    A. Hashimoto, T. Akimoto, K. Mase, and Y. Suenaga, "Vista
*    Ray-Tracing: High Speed Ray Tracing Using Perspective
*    Projection Image", New Advances in Computer Graphics,
*    Proceedings of CG International '89, R. A. Earnshaw,
*    B. Wyvill (Eds.), Springer, ...
*
*  The idea for the light buffer was taken from:
*
*    E. Haines and D. Greenberg, "The Light Buffer: A Shadow-
*    Testing Accelerator", IEEE CG&A, Vol. 6, No. 9, Sept. 1986, pp. 6-16
*
*****************************************************************************/

/****************************************************************************
*  addon.h
*
*  This module was written by Dieter Bayer.
*
*  Some definitions for the addon-modules and lighting.c.
*
*  01.03.1994 : Creation
*
*  29.04.1994 : Version 2.0
*
******************************************************************************/

#ifdef DB_CODE

#define USE_VISTA_BUFFER           1
#define USE_LIGHT_BUFFER           2
#define USE_PREVIEW                4
#define USE_BOUND_QUADRICS         8
#define USE_SPLIT_FINITE_UNIONS    16
#define USE_SPLIT_INFINITE_UNIONS  32

#ifndef MAX_LB_ENTRY
#define MAX_LB_ENTRY 32000
#endif

#ifndef MIN_LB_ENTRY
#define MIN_LB_ENTRY -32000
#endif

#ifndef MAX_VB_ENTRY
#define MAX_VB_ENTRY 32000
#endif

#ifndef MIN_VB_ENTRY
#define MIN_VB_ENTRY -32000
#endif

#define MAX_CLIP_POINTS 20
#define POINT_MOD 100

#define XaxisP 0
#define XaxisM 1
#define YaxisP 2
#define YaxisM 3
#define ZaxisP 4
#define ZaxisM 5

#ifndef min
#define min(x,y) ((x)<(y)?(x):(y))
#endif
#ifndef max
#define max(x,y) ((x)>(y)?(x):(y))
#endif

#ifndef BOUNDS_VOLUME
#define BOUNDS_VOLUME(a,b) \
	((a)=((b).Max.x-(b).Min.x)*((b).Max.y-(b).Min.y)*((b).Max.z-(b).Min.z))
#endif

/* due to precision problems with the projection of bounding boxes
   with infinte dimensions in one or two directions set the 
   infinite volume to a 'low' value */

#ifndef INFINITE_VOLUME
#define INFINITE_VOLUME BOUND_HUGE/1000
#endif




/* public functions defined in addon0.c */

void Clip_Polygon PARAMS((VECTOR *Points, int *PointCnt,
  VECTOR *VX1, VECTOR *VX2, VECTOR *VY1, VECTOR *VY2,
  DBL DX1, DBL DX2, DBL DY1, DBL DY2));

void Fatal_Error PARAMS((char *str));
void Fatal_MAError PARAMS((char *str));

void Begin_Point PARAMS((void));
void Print_Point PARAMS((int Repeat));
void End_Point PARAMS((void));

void MInvers PARAMS((MATRIX *r, MATRIX *m));



/* public functions defined in addon1.c */

void Build_Projections PARAMS((size_t *Mem_Vista_Buffer));

void Init_View_Coordinates PARAMS((void));

void Sort_Objects PARAMS((long int l, long int r));

void Project_Vista PARAMS((MATRIX *A0, TRANSFORM *Trans, DBL *a20, DBL *a02, DBL *a11, DBL *a10, DBL *a01, DBL *a00));

void Build_Vista_Tree PARAMS((size_t *Mem_Vista_Buffer));



/* public functions defined in addon2.c */

void Build_Light_Buffers PARAMS((size_t *Memory));



/* public functions defined in addon3.c */

void Recompute_Bboxes PARAMS((void));
void Remove_Unnecessary_Bounds PARAMS((void));
void Print_Quadric_Stats PARAMS((void));

#endif
