			GLOBL _xxadd	
			GLOBL _xxsub

***************************************
* Subtrahiert 2 Double-Werte          *
* Input: A0,A1 Zeiger auf Double-Werte*
* Output: A0 Zeiger auf Differenz	  *
* zerstrte Register: D0,D1,D2		  *
* (fr Pure C angepat)				  *
* Genauigkeit:Exponent: wie Double    *
*             Mantisse: es wird nur   *
*             oberes Langwort berck- *
*             sichtigt (32 Bit ->ent- *
*             spricht ca. 10 Stellen) *
* Weiteres:	  keine Rundung aber	  *
*             Anpassung bei Bereichs- *
*             berschreitung          *  
* Speed: ca. 3 ...6 mal schneller im  *
*        Vergleich zum Original       *     
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
_xxsub: eor.w  #$8000,(A1)	;Vorzeichen vom Minuenden umkehren
		bsr.s _xxadd		;Additionsroutine verwenden
		eor.w  #$8000,-(A1);da A1 um 2 verschoben und altes Vorzeichen 
		rts				   ;zurck	
***************************************
* Addiert 2 Double-Werte miteinander  *
* Input: A0,A1 Zeiger auf Summanden   *
* Output: A0 Zeiger auf Summe		  *
* zerstrte Register: D0,D1,D2,A1(+2) *
* (fr Pure C angepat)				  *
* Genauigkeit:Exponent: wie Double    *
*             Mantisse: es wird nur   *
*             oberes Langwort berck- *
*             sichtigt (32 Bit ->ent- *
*             spricht ca. 10 Stellen) *
* Weiteres:	  keine Rundung aber	  *
*             Anpassung bei Bereichs- *
*             berschreitung          *  
* Speed: ca. 3 ...6 mal schneller im  *
*        Vergleich zum Original       *     
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
_xxadd:  move.w D3,-(SP)

		 move.w  (A1)+,D1  ;Argument 1 testen	
         bmi     XFPAMI1   ;Springe wenn ARG1 negativ
         beq     XFPART2   ;Rckgabe von ARG2 (ARG1 == 0 !)
 
* + ARG1
         move.w  (A0)+,D0 ;Argument 2 testen
         bmi     XFPAMS   ;Springe wenn ARG2 negativ (gemischte Vorzeichen)
         beq     XFPART1  ;Rckgabe von ARG1 (ARG2 == 0 !)
 
* +ARG1 +ARG2
* -ARG1 -ARG2
XFPALS:  sub.w   D1,D0     ;Differenz der beiden Exponenten
         bmi.s   XFPA2LT   ;springe wenn ARG1 grer
 
* ARG1EXP <= ARG2EXP
         cmp.w   #32,D0   ;maximal 32 Bit (entspricht ca. 10 Kommastellen)
         bcc     XFPART2  ;Springe wenn grere Differenz -> Rckgabe: ARG2
		 move.l  (A0),D1
		 move.l  (A1),D2  ;Mantissen kopieren	
         lsr.l   D0,D2    ;auf Exponent  von ARG2 normieren 
         add.l   D2,D1	  ;Betrge addieren
         bcs.s   XFPA2GC  ;springe wenn Bereichsberschreitung
XFPARSR: move.l  D1,(A0)  ;Mantisse (Exponent wurde nicht gendert !)
		 subq.l  #2,A0	  ;A0 restaurieren	
		 move.w (SP)+,D3
		 rts 	


* gleiche Vorzeichen - berlaufnormalisierung
XFPA2GC: roxr.l  #1,D1    ;CARRY-Flag zurck
         move.w  -(A0),D0 ;Exponent laden
         bmi.s   negativ  ;Springe wenn negativer Exponent
         addq.w  #1,D0    ;Exponent inkrementieren
         cmpi.w  #$7FFF,D0;maximaler Exponent ?	
         beq.s   XFPA2OS  ;Springe wenn Exponentenberlauf
		 move.w  D0,(A0)  ;Exponent
   		 move.l  D1,2(A0) ;Mantisse
		 move.w (SP)+,D3
		 rts 	

negativ: addq.w  #1,D0    ;Exponent inkrementieren
         cmpi.w  #$FFFF,D0	
         beq.s   XFPA2OS  ;Springe wenn Exponentenberlauf
		 move.w  D0,(A0)  ;Exponent
   		 move.l  D1,2(A0) ;Mantisse
		 move.w (SP)+,D3
		 rts 	
		 
XFPA2OS: moveq  #-1,D1    ;Maximale Mantisse
         sub.w   #1,D0    ;maximaler Exponent mit Vorzeichen
		 move.w  D0,(A0)  ;Exponent
		 move.l  D1,2(A0) ;Mantisse
		 move.w (SP)+,D3
		 rts 	

* -ARG1EXP > -ARG2EXP
* +ARG1EXP > +ARG2EXP
XFPA2LT: cmp.w   #-32,D0  ;maximal 32 Bit (entspricht ca. 10 Kommastellen)
         ble     XFPART1  ;"grere" Differenz ->So gebe greren Wert zurck
         neg.w   D0       ;Differenz als Absolutwert
         move.w  D1,D3	  ;Exponent klar machen	
		 move.l  (A0),D1
		 move.l  (A1),D2  ;Mantissen kopieren	
		 lsr.l   D0,D1    ;auf Exponent  von ARG1 normieren 
         add.l   D2,D1    ;Betrge addieren
         bcs.s   XXFPA2GC ;springe wenn Bereichsberschreitung 
		 move.l  D1,(A0)  ;Mantisse
		 move.w  D3,-(A0) ;Exponent
		 move.w (SP)+,D3
		 rts 	

* gleiche Vorzeichen - berlaufnormalisierung
XXFPA2GC:roxr.l  #1,D1    ;CARRY-Flag zurck
         addq.w  #1,D3    ;Exponent inkrementieren
         bmi.s   Xnegativ ;wenn Exponent negativ
         cmpi.w  #$7FFF,D3	
         beq.s   XXFPA2OS  ;Springe wenn Exponentenberlauf
  		 move.l  D1,(A0) ;Mantisse
		 move.w  D3,-(A0)  ;Exponent
 		 move.w (SP)+,D3
		 rts 	

Xnegativ:cmpi.w  #$FFFF,D3	
         beq.s   XXFPA2OS  ;Springe wenn Exponentenberlauf
  		 move.l  D1,(A0) ;Mantisse
		 move.w  D3,-(A0)  ;Exponent
 		 move.w (SP)+,D3
		 rts 	


XXFPA2OS:moveq  #-1,D1    ;Maximale Mantisse
         sub.w   #1,D3    ;maximaler Exponent mit Vorzeichen
		 move.l  D1,(A0)  ;Mantisse
		 move.w  D3,-(A0) ;Exponent
		 move.w (SP)+,D3
		 rts 	
  
* -ARG1
XFPAMI1: move.w  (A0)+,D0  ;Vozeichen von ARG2 testen
         bmi     XFPALS    ;Springe wenn ARG2 negativ (gleiche Vorzeichen)
         beq.s   XFPART1   ;Rckgabe von ARG1 (ARG2 == 0 !)

* gemischte Vorzeichen 
* -ARG1 +ARG2
* +ARG1 -ARG2
XFPAMS:  move.w  D0,D3 	   ;Vorzeichen von ARG2 sichern
         eori.w  #$8000,D0 ;Vorzeichenumkehr
         sub.w   D1,D0     ;Exponentendifferenz
         beq.s   XFPAEQ    ;Springe wenn Exponent gleich
         bmi.s   XFPATLT   ;Springe wenn ARG1 grer
* ARG1 <= ARG2
         cmp.w   #32,D0    ;maximal 32 Bit (entspricht ca. 10 Kommastellen)
         bcc.s   XFPART2   ;grere Differenz ->So gebe ARG2 zurck
		 move.l  (A0),D1
		 move.l  (A1),D2  ;Mantissen kopieren	
         lsr.l   D0,D2     ;auf Exponent  von ARG2 normieren 
         sub.l   D2,D1     ;subtrahiere kleineren vom greren
         bmi     XFPARSR   ;Endergebnis wenn kein berlauf und schon normalisiert

* gemischte Vorzeichen normalisieren
XFPANOR: move.w  D3,D2     ;korrektes Vorzeichen sichern
XFPANRM: sub.w   #1,D3     ;klar machen frs erste Shiften
         cmp.l   #$00007FFF,D1 ;? Klein genug fr FAST SHIFT
         bhi.s   XFPAXQN   ;Springe wenn nicht
         swap.w  D1        ;um 16 Bit nach oben schieben
         sub.w  #16,D3	   ;D3 dementsprechend updaten
XFPAXQN: add.l   D1,D1     ;ein Bit hoch shiften
         dbmi    D3,XFPAXQN;Dekrementiere D3 und springe solange D1 
         				   ;nicht normalisiert (oberste Bit == 0)
         eor.w   D3,D2     ;? gleiche Vorzeichen
         bmi.s   XFPAZRO   ;Springe wenn Unterlauf-> Ergebnis ==0
         move.w  D3,D0     ;Vorzeichen/Exponent zurck
         BEQ.S   XFPAZRO   ;Springe wenn Exponentenunterlauf-> Ergebniss ==0
		 move.l  D1,(A0)	;Mantisse
		 move.w  D0,-(A0)	;Exponent
		 move.w (SP)+,D3
		 rts 	

* Rckgabe ARGUMENT1
XFPART1: move.l (A1),(A0)	
         bne.s  XFNOPATCH	;Eventueller Fehler bei Subtraktion
		 clr.w  D1
XFNOPATCH: move.w  D1,-(A0)	;einfach Wert nach A0 kopieren
           move.l 4(A1),6(A0)	
XFPART2:   move.w (SP)+,D3
    	   RTS              ;Argument 2 zurck (keine nderung)

* Exponentenenunterlauf - Ergebnis Null
XFPAZRO: clr.w -2(A0)
		 clr.l (A0)+ 	  ;Alles Null setzen
		 clr.l (A0)
		 subq  #6,A0
		 move.w (SP)+,D3
         RTS              
 
* ARG1 > ARG2
XFPATLT: cmp.w   #-32,D0  ;? ARG1 >> ARG2
         ble.s   XFPART1  ;ARG 1 zurck wenn Differnz zu "gro"
         neg.w   D0       ;Absolutiere  Differenz
         move.w  D1,D3	  ;Exponent klar machen	
		 move.l  (A0),D1
		 move.l  (A1),D2  ;Mantissen kopieren	
         lsr.l   D0,D1    ;auf Exponent  von ARG1 normieren 
         sub.l   D1,D2    ;subtrahiere kleineren vom greren
         move.l  D2,D1
		 bpl.s   XFPANOR  ;Endergebnis wenn kein berlauf und schon normalisiert
		 move.l  D1,(A0)  ;Mantisse
		 move.w  D3,-(A0) ;Exponent
		 move.w (SP)+,D3
		 rts 	

* Gleiche absolute Exponenten 
XFPAEQ:  move.l  (A0),D1
		 move.l  (A1),D2  ;Mantissen kopieren	
         sub.l   D2,D1    ;Differenz
         beq.s   XFPAZRO  ;Null wenn Mantisse gleich
         bpl.s   XFPANOR  ;Springe wenn ARG2 grer
         neg.l   D1       ;Korrigiere Differenz zu Positiv
         eori.w  #$8000,D3
         move.w	 D3,D2	  ;Vorzeichen fr Normalisierung	 
         bra.s   XFPANRM  ;und Normalisiere
***************************************************
XREF _lxcnv
GLOBL _xwadd,_xladd

_xwadd: ext.l D0 ;Vorzeichenerweiterung
_xladd:	lea temp,A1
		move.w (A0)+,(A1)+ 
		move.l (A0),(A1) 	;nur oberstes Langwort der Mantisse 
		subq #2,A0
		subq #2,A1
		bsr _lxcnv			;in DOUBLE
		subq #6,A0			;A0 korrigieren
		bsr _xxadd
		rts
******************************************************
GLOBL _xwsub,_xlsub

_xwsub: ext.l D0 ;Vorzeichenerweiterung
_xlsub:	lea temp,A1
		move.w (A0)+,(A1)+ 
		move.l (A0),(A1) 	;nur oberstes Langwort der Mantisse 
		subq #2,A0
		subq #2,A1
		bsr _lxcnv			;in DOUBLE
		subq #6,A0			;A0 korrigieren
		eor.w  #$8000,(A0)	;Vorzeichen vom Minuenden umkehren
		bsr   _xxadd		;Additionsroutine verwenden
		rts

ALIGN 4
temp:  DS.W 5
				 
