GLOBL _xxdiv
***************************************
*          DBLDIV  SUBROUTINE         *
* INPUT: A0 Zeiger auf Dividend       *
*        A1 Zeiger auf Divisor        *
* OUTPUT:A0 -  Zeiger auf Produkt  	  *
* zerstrte Register: D0,D1,D2,A1(+2) *
* (fr Pure C angepat)				  *
* Genauigkeit:Exponent: wie Double    *
*             Mantisse: es wird nur   *
*             oberes Langwort berck- *
*             sichtigt (32 Bit ->ent- *
*             spricht ca. 10 Stellen) *
* Weiteres:  -evtl. Rundungsfehler,   *
* ( z.B 1e+14932/1e+4932 =0.999999999)* 
*            -keine Bereichsanpassung!*
* -wenn Divisor Null, so wird grt-  *
* mglicher Wert zurckgeliefert	  *	
* Speed: ca. 3.1 mal schneller im  	  *
*        Vergleich zum Original       *     
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
 
XFPDOUF:bmi.s  XFPDOVFS ;Springe wenn berlauf
XFPDUND:clr.l  (A0)		;Ergebnis ist Null
  		clr.w -(A0)										    
;		clr.l 6(A0)										  
		move.l (SP)+,D4 								    
		move.l (SP)+,D3 ;Register zurck				  
		rts				;back							    
* maximaler Wert
XFPDOVFS:move.l #-1,(A0)  ;maximale Mantisse			  	 														
         eor.l  D2,D4	  ;Vorzeichen richtig setzen		 
         lsr.l  #1,D4	  ;Vorzeichen sichtbar				   
         or.w  #$7FFE,D4  ;maximaler Exponent mit korrektem  	
        				  ;Vorzeichen 
         move.w  D4,-(A0) ;und Exponent setzen			     
   		 move.l (SP)+,D4 									 								
		 move.l (SP)+,D3 ;Register zurck                   
         rts                                				 
		
 
***************
* ENTRY POINT *
***************
* ARG2/ARG1
_xxdiv:move.l D3,-(SP)
	   move.l D4,-(SP)	;Register retten				 
	   move.w (A1)+,D2  ;Exponent/Vorzeichen ARG1(Divisor) 
       move.w (A0)+,D4  ;Exponent/Vorzeichen ARG2(Dividend)  
       add.l  D2,D2     ;isoliere Vorzeichen vom ARG1-Exponent
       add.l  D4,D4     ;isoliere Vorzeichen vom ARG2-Exponent
       move.w #$8000,D3 ;Maske
       eor.w  D3,D4     ;Exponent ARG1 anpassen
       eor.w  D3,D2     ;Exponent ARG2 anpassen 	
       sub.w  D2,D4     ;Exponenten subtrahieren
       bvs.s  XFPDOUF   ;Springe wenn berlauf/Unterlauf 	
       subq.w #4,D4     ;Exponent anpassen
       clr.w  D2       	;nur noch Vorzeichen von ARG1
       move.l (A0),D0	;Mantisse von ARG1 laden
       beq.s  XFPDUND	;gib Null zurck falls ARG2=0
       move.l (A1),D1	;Mantisse von ARG1 laden
       beq.s  XFPDOVFS  ;gib Maximalwert zurck falls ARG1=0
       swap.w D0        ;Vergleich der HIGH-Wrter
       swap.w D1        ;von ARG2 und ARG1
       cmp.w  D1,D0     ;ARG1 < ARG2 ?
       bmi.s  XFPDNOV   ;Springe wenn ARG1 > ARG2
* Anpassen fr Festkomma
       addq.w #2,D4     ;Exponent erhhen
       bvs.s  XFPDOVFS  ;Springe wenn berlauf
       ror.l  #1,D0     ;ARG2 /2
	   andi.w #$7fff,D0 ;falls das unterste Bit in ARG1 gesetzt war !!!
XFPDNOV:
	   swap.w D0       ;wieder ARG2
       eor.w D3,D4     ;wieder als Exponent				 
       eor.l  D2,D4	   ;D1 hat Endvorzeichen und Exponent   
       lsr.l  #1,D4     ;D4 hat nun Vorzeichen und Exponent 	
 
* NOW DIVIDE JUST USING 16 BITS INTO 24
       move.l D0,D3     ;COPY ARG1 FOR INITIAL DIVIDE
       divu.w D1,D3     ;OBTAIN TEST QUOTIENT
       move.w D3,D2     ;SAVE TEST QUOTIENT
 
* NOW MULTIPLY 16-BIT DIVIDE RESULT TIMES FULL 24 BIT DIVISOR AND COMPARE
* WITH THE DIVIDEND.  MULTIPLYING BACK OUT WITH THE FULL 24-BITS ALLOWS
* US TO SEE IF THE RESULT WAS TOO LARGE DUE TO THE 8 MISSING DIVISOR BITS
* USED IN THE HARDWARE DIVIDE.  THE RESULT CAN ONLY BE TOO LARGE BY 1 UNIT.
       mulu.w D1,D3     ;HIGH DIVISOR X QUOTIENT
       sub.l  D3,D0     ;D0=PARTIAL SUBTRACTION
       swap.w D0        ;TO LOW DIVISOR
       swap.w D1        ;REBUILD ARG1 TO NORMAL
       move.w D1,D3     ;SETUP ARG1 FOR PRODUCT
       mulu.w D2,D3     ;FIND REMAINING PRODUCT
       sub.l  D3,D0     ;NOW HAVE FULL SUBTRACTION
       bcc.s  XFPDQOK   ;BRANCH FIRST 16 BITS CORRECT
 
* ESTIMATE TOO HIGH, DECREMENT QUOTIENT BY ONE
       move.l D1,D3     ;REBUILD DIVISOR
       add.l  D3,D0     ;ADD ANOTHER DIVISOR
       sub.w  #1,D2     ;DECREMENT QUOTIENT
 
* COMPUTE LAST 8 BITS WITH ANOTHER DIVIDE.  THE EXACT REMAINDER FROM THE
* MULTIPLY AND COMPARE ABOVE IS DIVIDED AGAIN BY A 16-BIT ONLY DIVISOR.
* HOWEVER, THIS TIME WE REQUIRE ONLY 9 BITS OF ACCURACY IN THE RESULT
* (8 TO MAKE 24 BITS TOTAL AND 1 EXTRA BIT FOR ROUNDING PURPOSES) AND THIS
* DIVIDE ALWAYS RETURNS A PRECISION OF AT LEAST 9 BITS.
XFPDQOK:move.l D1,D3     ;COPY ARG1 AGAIN
        swap.w D3        ;FIRST 16 BITS DIVISOR IN D3.W
        clr.w  D0        ;INTO FIRST 16 BITS OF DIVIDEND
        divu.w D3,D0     ;OBTAIN FINAL 16 BIT RESULT
        swap.w D2        ;FIRST 16 QUOTIENT TO HIGH HALF
        bmi.s  XFPDISN   ;BRANCH IF NORMALIZED
* RARE OCCURRANCE - UNNORMALIZED
* HAPPENDS WHEN MANTISSA ARG1 < ARG2 AND THEY DIFFER ONLY IN LAST 8 BITS
        move.w D0,D2     ;INSERT LOW WORD OF QUOTIENT
        add.l  D2,D2     ;SHIFT MANTISSA LEFT ONE
        sub.w  #1,D4     ;ADJUST EXPONENT DOWN (CANNOT ZERO)
        move.w D2,D0     ;CANCEL NEXT INSTRUCTION
 
* REBUILD OUR FINAL RESULT AND RETURN
XFPDISN:move.w D0,D2     ;APPEND NEXT 16 BITS
        add.l  #1,D2     ;Runden
        move.l D2,(A0)   ;Mantisse als Ergebnis
        move.w D4,-(A0)  ;Exponent als Ergebnis
		move.l (SP)+,D4 ;								    
		move.l (SP)+,D3 ;Register zurck				  
        rts              

****************************************
XREF _lxcnv
GLOBL _xwdiv,_xldiv

_xwdiv: ext.l D0 ;Vorzeichenerweiterung
_xldiv:	lea temp,A1
		move.w (A0)+,(A1)+ 
		move.l (A0),(A1) 	;nur oberstes Langwort der Mantisse 
		subq #2,A0
		subq #2,A1
		bsr _lxcnv			;in DOUBLE
		subq #6,A0			;A0 korrigieren
		exg.l A0,A1			;tauschen
		bsr   _xxdiv			
		move.w (A0)+,-(A1) 
		move.l (A0),2(A1) 	;nur oberstes Langwort der Mantisse 
		rts

ALIGN 4 

temp:  DS.W 5

       END

