***************************************
*          DBLMUL  SUBROUTINE         *
* INPUT: A0,A1 Zeiger auf Faktoren    *
* OUTPUT:A0 -  Zeiger auf Produkt  	  *
* zerstrte Register: D0,D1,D2,A1(+2) *
* (fr Pure C angepat)				  *
* Genauigkeit:Exponent: wie Double    *
*             Mantisse: es wird nur   *
*             oberes Langwort berck- *
*             sichtigt (32 Bit ->ent- *
*             spricht ca. 10 Stellen) *
* Weiteres:  -evtl. Rundungsfehler,   *
* ( z.B 1e+100 * 1e-100 =0.999999999) * 
*            -keine Bereichsanpassung!*
*	      (Preis der Geschwindigkeit )*
*             berschreitung          *  
* Speed: ca. 3 mal schneller im  	  *
*        Vergleich zum Original       *     
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
GLOBL _xxmul
_xxmul:move.l D3,-(SP)	;								 14
	   move.l D4,-(SP)	;Register retten				 14
	   move.w (A0)+,D2  ;Exponent/Vorzeichen ARG2  		  8
       move.w (A1)+,D1  ;Exponent/Vorzeichen ARG1         8
       add.l  D2,D2     ;Vorzeichen von ARG2 sichern (ins Langwort)  6
       add.l  D1,D1     ;Vorzeichen von ARG1 sichern (ins Langwort)  6
       move.w #$8000,D0 ;Maske 							  8
       eor.w  D0,D1     ;Exponent ARG1 anpassen		 	  4
       eor.w  D0,D2     ;Exponent ARG2 anpassen 		  4
       add.w  D1,D2     ;Exponenten addieren              4
       bvs.s  XFFMOUF   ;Springe wenn berlauf/Unterlauf  8/10
       addq.w #4,D2
       clr.w  D1		;nur noch Vorzeichen				 4	    		    
       eor.w  D0,D2 	;wieder als Exponent				 8
       eor.l  D1,D2		;D2 hat Endvorzeichen und Exponent   8
       ror.l  #1,D2     ;Vorzeichen zurck 	              8
       move.l (A0),D0   ;Mantisse von ARG2				 12	
       beq.s  XFFMRTN   ;Mantisse null					  8/10
       move.l D0,D3     ;Kopie						      4
       swap   D3        ;nutze obere signifikanten Bytes  4
       move.l (A1),D1   ;Mantisse von ARG1               12 
       beq.s  XFFMRTN   ;Rckgabe von Null wenn ARG1==0   8/10
       move.l D1,D4		;Vorbereiten fr Multiplikation   4							
       mulu.w D4,D3     ;A3 X B1B2                        38-54 (46)
       swap.w D4        ;TO ARG1 HIGH TWO BYTES           4
       mulu.w D0,D4     ;B3 X A1A2                        38-54 (46)
       add.l  D3,D4     ;ADD PARTIAL PRODUCTS R3R4R5      8
       clr.w  D4        ;CLEAR LOW END RUNOFF             4
       addx.b D4,D4     ;SHIFT IN CARRY IF ANY            4
       swap   D4        ;PUT CARRY INTO HIGH WORD         4
       swap   D0        ;NOW TOP OF ARG2                  4
       swap   D1        ;AND TOP OF ARG1                  4
       mulu.w D1,D0     ;A1A2 X B1B2                      40-70 (54)
       add.l  D4,D0     ;addiere Teilprodukte             8
       bpl.s  XFFMNOR   ;Springe falls Normalisierung     8/10
	   move.l D0,(A0)	;Mantisse						  12
       move.w D2,-(A0)  ;Exponent						  8	
;	   clr.l 6(A0)		;unteres Langwort				  24
	   move.l (SP)+,D4	;								  12
	   move.l (SP)+,D3	;Register zurck				  12	
	   rts				;								  16
*Ergebnis ist Null
XFFMRTN:clr.l  (A0)		;								  20
		clr.w -(A0)		;								  14
;		clr.l 6(A0)		;								  24
		move.l (SP)+,D4 ;								  12
		move.l (SP)+,D3 ;Register zurck				  12
		rts				;back							  16
 
* Normalisiere Ergebnis
XFFMNOR:subq.w  #1,D2    ;Exponent dekrementieren           4
        bvs.s   XFFMRTN  ;Null wenn Exponent nun  Null      8/10
;sinnlos (?!)   bcs.s   XFFMRTN  ;Null wenn invertiertes Vorzeichen 8/10
        add.l   D0,D0    ;Normalisiere		                8
		addq.w  #1,D0	 ;Kann nicht berlaufen				4
		move.l D0,(A0)	 ;Werte zurck						12
        move.w D2,-(A0)	 ;									8	
;  		clr.l  6(A0)	 ;									24
   		move.l (SP)+,D4	 ;									12
		move.l (SP)+,D3	 ;									12
        rts              ;			                        16
 
* berlauf bzw. Unterlauf der Exponenten
XFFMOUF:bpl.s  XFFMRTN    ;Null wenn Unterlauf			   8/10
        move.l #-1,(A0)	  ;maximale Mantisse			  	 20														
        eor.l  D1,D2	  ;Vorzeichen richtig setzen		  8
        lsr.l  #1,D2	  ;Vorzeichen sichtbar				 10  
        or.w  #$7FFE,D2	  ;maximaler Exponent mit korrektem   8	
        				  ;Vorzeichen 
        move.w  D2,-(A0)  ;und Exponent setzen			      8
   		move.l (SP)+,D4   ;									  8								
		move.l (SP)+,D3   ;Register zurck                    8
        rts               ;                   				 16
****************************
XREF _lxcnv
GLOBL _xwmul,_xlmul

_xwmul: ext.l D0 ;Vorzeichenerweiterung
_xlmul:	lea temp,A1
		move.w (A0)+,(A1)+ 
		move.l (A0),(A1) 	;nur oberstes Langwort der Mantisse 
		subq #2,A0
		subq #2,A1
		bsr _lxcnv			;in DOUBLE
		subq #6,A0			;A0 korrigieren
		bsr _xxmul
		rts

temp:  DS.W 5
