
#include "proto.h"
#include <string.h>

#ifdef __MINT_LIB__
#define I_CAST	(char *)
#else

#ifdef __PUREC__
#define I_CAST	(int *)
#else
#define I_CAST	(short *)
#endif

#endif

#define ALERTFLY   1
#define ALERTST1   2
#define ALERTICN   3
#define ALERTST2   4
#define ALERTST3   5
#define ALERTST4   6
#define ALERTST5   7
#define ALERTST6   8
#define ALERTST7   9
#define ALERTST8  10
#define ALERTST9  11
#define ALERTST0  12
#define ALERTBT1  13
#define ALERTBT2  15
#define ALERTBT4  17
#define ALERTBT3  19
#define ALERTBT5  21

static char string[] = "";

static int alert_text[] = {ALERTST1,ALERTST2,ALERTST3,ALERTST4,ALERTST5,ALERTST6,
						   ALERTST7,ALERTST8,ALERTST9,ALERTST0};

static int alert_btn[] = {ALERTBT1,ALERTBT2,ALERTBT3,ALERTBT4,ALERTBT5};
static char alert_hot[6];

static int IMAGE1[] = {
0x007F, 0xFC00, 0x0080, 0x0200, 0x017F, 0xFD00, 0x02FF, 0xFE80, 
0x05FF, 0xFF40, 0x0BFF, 0xFFA0, 0x17FF, 0xFFD0, 0x2FFF, 0xFFE8, 
0x5FFF, 0xFFF4, 0xBFFF, 0xFFFA, 0xBFFF, 0xFFFA, 0xB8C1, 0x8C3A, 
0xB777, 0x75DA, 0xB7F7, 0x75DA, 0xB7F7, 0x75DA, 0xB8F7, 0x743A, 
0xBF77, 0x75FA, 0xBF77, 0x75FA, 0xB777, 0x75FA, 0xB8F7, 0x8DFA, 
0xBFFF, 0xFFFA, 0xBFFF, 0xFFFA, 0x5FFF, 0xFFF4, 0x2FFF, 0xFFE8, 
0x17FF, 0xFFD0, 0x0BFF, 0xFFA0, 0x05FF, 0xFF40, 0x02FF, 0xFE80, 
0x017F, 0xFD00, 0x0080, 0x0200, 0x007F, 0xFC00, 0x0000, 0x0000};

static int IMAGE3[] = {
0x0001, 0x8000, 0x0002, 0x4000, 0x0004, 0x2000, 0x0009, 0x9000, 
0x0013, 0xC800, 0x0027, 0xE400, 0x004F, 0xF200, 0x009F, 0xF900, 
0x013C, 0x3C80, 0x027C, 0x3E40, 0x04FC, 0x3F20, 0x09FC, 0x3F90, 
0x13FC, 0x3FC8, 0x27FC, 0x3FE4, 0x4FFC, 0x3FF2, 0x9FFC, 0x3FF9, 
0x9FFC, 0x3FF9, 0x4FFC, 0x3FF2, 0x27FC, 0x3FE4, 0x13FC, 0x3FC8, 
0x09FF, 0xFF90, 0x04FF, 0xFF20, 0x027C, 0x3E40, 0x013C, 0x3C80, 
0x009F, 0xF900, 0x004F, 0xF200, 0x0027, 0xE400, 0x0013, 0xC800, 
0x0009, 0x9000, 0x0004, 0x2000, 0x0002, 0x4000, 0x0001, 0x8000};

static int IMAGE4[] = {
0x7FFF, 0xFFFE, 0x8000, 0x0001, 0x9FFF, 0xFFF9, 0x4FE0, 0x0FF2, 
0x4FC0, 0x07F2, 0x2787, 0xC3E4, 0x27FF, 0xE3E4, 0x13FF, 0xE3C8, 
0x13FF, 0xC7C8, 0x09FF, 0x0F90, 0x09FE, 0x1F90, 0x04FC, 0x3F20, 
0x04FC, 0x3F20, 0x027C, 0x3E40, 0x027C, 0x3E40, 0x013C, 0x3C80, 
0x013F, 0xFC80, 0x009F, 0xF900, 0x009C, 0x3900, 0x004C, 0x3200, 
0x004F, 0xF200, 0x0027, 0xE400, 0x0027, 0xE400, 0x0013, 0xC800, 
0x0013, 0xC800, 0x0009, 0x9000, 0x0009, 0x9000, 0x0004, 0x2000, 
0x0004, 0x2000, 0x0002, 0x4000, 0x0002, 0x4000, 0x0001, 0x8000};

static int IMAGE5[] = {
0x007F, 0xFC00, 0x0080, 0x0200, 0x013F, 0xF900, 0x027F, 0xFC80, 
0x04FF, 0xFE40, 0x09FF, 0xFF20, 0x13FF, 0xFF90, 0x27FF, 0xFFC8, 
0x4FFF, 0xFFE4, 0x9FFF, 0xFFF2, 0x9FFF, 0xFFF2, 0x9FFF, 0xFFF2, 
0x98C1, 0x8C32, 0x9777, 0x75D2, 0x97F7, 0x75D2, 0x98F7, 0x7432, 
0x9F77, 0x75F2, 0x9777, 0x75F2, 0x98F7, 0x8DF2, 0x9FFF, 0xFFF2, 
0x9FFF, 0xFFF2, 0x9FFF, 0xFFF2, 0x4FFF, 0xFFE4, 0x27FF, 0xFFC8, 
0x13FF, 0xFF90, 0x09FF, 0xFF20, 0x04FF, 0xFE40, 0x027F, 0xFC80, 
0x013F, 0xF900, 0x0080, 0x0200, 0x007F, 0xFC00, 0x0000, 0x0000};

static int IMAGE6[] = {
0x007F, 0xFE00, 0x00C0, 0x0300, 0x01BF, 0xFD80, 0x037F, 0xFEC0, 
0x06FF, 0xFF60, 0x0DFF, 0xFFB0, 0x1BFF, 0xFFD8, 0x37FF, 0xFFEC, 
0x6FFF, 0xFFF6, 0xDFFF, 0xFFFB, 0xB181, 0x860D, 0xA081, 0x0205, 
0xA4E7, 0x3265, 0xA7E7, 0x3265, 0xA3E7, 0x3265, 0xB1E7, 0x3205, 
0xB8E7, 0x320D, 0xBCE7, 0x327D, 0xA4E7, 0x327D, 0xA0E7, 0x027D, 
0xB1E7, 0x867D, 0xBFFF, 0xFFFD, 0xDFFF, 0xFFFB, 0x6FFF, 0xFFF6, 
0x37FF, 0xFFEC, 0x1BFF, 0xFFD8, 0x0DFF, 0xFFB0, 0x06FF, 0xFF60, 
0x037F, 0xFEC0, 0x01BF, 0xFD80, 0x00C0, 0x0300, 0x007F, 0xFE00};

static int IMAGE7[] = {
0x0000, 0x0000, 0x0000, 0x0000, 0x1FFF, 0xFFE0, 0x2C00, 0x00F0, 
0x3407, 0x80D8, 0x2C0F, 0xC0BC, 0x340C, 0xC0DC, 0x2C00, 0xC0BC, 
0x3401, 0x80DC, 0x2C03, 0x00BC, 0x3403, 0x00DC, 0x2C00, 0x00BC, 
0x3403, 0x00DC, 0x2C03, 0x00BC, 0x3400, 0x00DC, 0x2FFF, 0xFFBC, 
0x3555, 0x555C, 0x2AAA, 0xAABC, 0x35FF, 0xFD5C, 0x2B80, 0x06BC, 
0x3538, 0x035C, 0x2B38, 0x02BC, 0x3538, 0x035C, 0x2B38, 0x02BC, 
0x3538, 0x035C, 0x2B38, 0x02BC, 0x3500, 0x035C, 0x1FFF, 0xFFFC, 
0x0FFF, 0xFFFC, 0x07FF, 0xFFF8, 0x0000, 0x0000, 0x0000, 0x0000};

static int IMAGE8[] = {
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0xC790, 0x0000, 0xF844, 0x003D, 0xF830, 
0x01FF, 0xFCB2, 0x07FF, 0xFC00, 0x0FFF, 0xF848, 0x1F3F, 0xF800, 
0x1E67, 0xF800, 0x3FCF, 0xFC00, 0x3CFF, 0xFC00, 0x3C9F, 0xFC00, 
0x7F9F, 0xFE00, 0x7FFF, 0xFE00, 0x7FFF, 0xFE00, 0x7FFF, 0xFE00, 
0x3FFF, 0xFC00, 0x3FFF, 0xFC00, 0x3FFF, 0xFC00, 0x1FFF, 0xF800, 
0x1FFF, 0xF800, 0x0FFF, 0xF000, 0x07FF, 0xE000, 0x01FF, 0x8000, 
0x003C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000};

static int IMAGE9[] = {
0x0000, 0x0000, 0x0001, 0xC000, 0x0073, 0xE000, 0x00FB, 0xE700, 
0x00FB, 0xEF80, 0x1CFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 
0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 
0x3EFB, 0xEF9C, 0x3EFB, 0xEFBC, 0x3EFB, 0xEFBC, 0x3FFF, 0xFF7C, 
0x3FFF, 0xFF7C, 0x3FFF, 0xFF7C, 0x3FFF, 0xFEFC, 0x3FFF, 0xF7F8, 
0x3FFF, 0xDFF8, 0x3FFF, 0x7FF0, 0x3FFF, 0xFFF0, 0x3FFD, 0xFFE0, 
0x1FFD, 0xFFC0, 0x0FFF, 0xFF80, 0x07FF, 0xFF00, 0x03FF, 0xFE00, 
0x03FF, 0xFE00, 0x03FF, 0xFE00, 0x03FF, 0xFE00, 0x0000, 0x0000};

static int IMAGE10[] = {
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FFF, 0xFDE0, 
0x1F80, 0x07F0, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 
0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1FC0, 0x0FF8, 
0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 0x1C00, 0x0038, 
0x1C00, 0x0038, 0x1CF0, 0x0038, 0x1C00, 0x0038, 0x1CFF, 0x6038, 
0x1C00, 0x0038, 0x1CE4, 0x0038, 0x1C00, 0x0038, 0x1CFF, 0x9838, 
0x1C00, 0x0038, 0x14DF, 0x3038, 0x1400, 0x0038, 0x1C00, 0x0038, 
0x0FFF, 0xFFF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000};

static int IMAGE11[] = {
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 
0x0000, 0xE000, 0x0001, 0xF000, 0x0003, 0xF800, 0x0005, 0xFC00, 
0x0008, 0xFE00, 0x0010, 0x7F00, 0x0020, 0x7F80, 0x0040, 0xFFC0, 
0x0087, 0xCF80, 0x010F, 0x8740, 0x010F, 0x82C0, 0x028F, 0x85C0, 
0x0347, 0x0BC0, 0x03A0, 0x17C0, 0x01D0, 0x2FC0, 0x0268, 0x5F80, 
0x0334, 0xBF00, 0x031B, 0x7E00, 0x018C, 0xFC00, 0x00CD, 0xF800, 
0x0065, 0xF000, 0x0039, 0xE000, 0x001D, 0xC000, 0x000D, 0x8000, 
0x0005, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000};

static int IMAGE12[] = {
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FF8, 0x1FFE, 0x7FE0, 0x07FE, 
0x7F80, 0x01FE, 0x7F00, 0x00FE, 0x7E00, 0x007E, 0x7E01, 0xC07E, 
0x7E03, 0xC07E, 0x7F07, 0x80FE, 0x7FFF, 0x01FE, 0x7FFE, 0x01FE, 
0x7FFC, 0x03FE, 0x7FF8, 0x07FE, 0x7FF8, 0x07FE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 0x7FFC, 0x3FFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000};

static int IMAGE13[] = {
0x0000, 0x0000, 0x0000, 0x0700, 0x0000, 0x0F80, 0x0000, 0x0F80, 
0x0000, 0x0F80, 0x0000, 0x0F80, 0x0000, 0x0F80, 0x0000, 0x0F80, 
0x0000, 0x0F80, 0x0000, 0x0F80, 0x0000, 0x0F80, 0x0079, 0xEF9C, 
0x0EFB, 0xEFBC, 0x1EFB, 0xEFBC, 0x1EFB, 0xEF7C, 0x16AA, 0xAF7C, 
0x1EFB, 0xEF7C, 0x0D75, 0xDCBC, 0x038E, 0x37F8, 0x1FFF, 0xDFF8, 
0x1FFF, 0x7FF0, 0x1FFF, 0xFFF0, 0x1FFD, 0xFFE0, 0x1FFF, 0xFFC0, 
0x0FFD, 0xFF80, 0x07FF, 0xFE00, 0x01FF, 0xF400, 0x015F, 0xFC00, 
0x01FF, 0xFC00, 0x01FF, 0xFC00, 0x0000, 0x0000, 0x0000, 0x0000};

static int IMAGE14[] = {
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FFE, 0x7FFE, 0x7FFC, 0x7FFE, 
0x7FE4, 0x4FFE, 0x7FC4, 0x47FE, 0x7FC4, 0x47FE, 0x7FC4, 0x47FE, 
0x7FC4, 0x47FE, 0x7F44, 0x47FE, 0x7E44, 0x47FE, 0x7E44, 0x47FE, 
0x7E44, 0x467E, 0x7E44, 0x447E, 0x7E44, 0x447E, 0x7E40, 0x047E, 
0x7E40, 0x047E, 0x7E40, 0x047E, 0x7E00, 0x087E, 0x7E00, 0x107E, 
0x7E00, 0x407E, 0x7E00, 0x007E, 0x7E01, 0x00FE, 0x7F00, 0x00FE, 
0x7F00, 0x01FE, 0x7F80, 0x03FE, 0x7FC0, 0x0FFE, 0x7FFF, 0xFFFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000};

static int IMAGE15[] = {
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FC0, 0x1FFE, 
0x7F80, 0x0FFE, 0x7F80, 0x0FFE, 0x7FC0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7F80, 0x01FE, 0x7F00, 0x00FE, 0x7F00, 0x00FE, 
0x7F80, 0x01FE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000};

static int IMAGE16[] = {
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FF8, 0x1FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 0x7FFC, 0x3FFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000};

static int IMAGE17[] = {
0x0000, 0x0000, 0x0001, 0x0000, 0x0003, 0x8000, 0x0007, 0xC000, 
0x0007, 0xE000, 0x000F, 0xF000, 0x000F, 0xF800, 0x002F, 0xFC00, 
0x006F, 0xFE00, 0x00DF, 0xFE00, 0x01BF, 0xFC00, 0x037F, 0xFC00, 
0x06FF, 0xF800, 0x037F, 0xFA00, 0x05BF, 0xFB00, 0x06DF, 0xF600, 
0x076F, 0xED00, 0x07B7, 0xDB00, 0x07DB, 0xB700, 0x07ED, 0x6F00, 
0x07F6, 0xDF00, 0x03FB, 0xBE00, 0x01FD, 0x7D80, 0x00FE, 0xFB80, 
0x007E, 0xFB80, 0x003E, 0xFB00, 0x001E, 0xF000, 0x000E, 0xE000, 
0x0006, 0xC000, 0x0002, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000};

static int IMAGE18[] = {
0x0003, 0xC000, 0x0006, 0x6000, 0x000D, 0xB000, 0x001B, 0xD800, 
0x0037, 0xEC00, 0x006F, 0xF600, 0x00DC, 0x3B00, 0x01BC, 0x3D80, 
0x037C, 0x3EC0, 0x06FC, 0x3F60, 0x0DFC, 0x3FB0, 0x1BFC, 0x3FD8, 
0x37FC, 0x3FEC, 0x6FFC, 0x3FF6, 0xDFFC, 0x3FFB, 0xBFFC, 0x3FFD, 
0xBFFC, 0x3FFD, 0xDFFC, 0x3FFB, 0x6FFC, 0x3FF6, 0x37FC, 0x3FEC, 
0x1BFF, 0xFFD8, 0x0DFF, 0xFFB0, 0x06FC, 0x3F60, 0x037C, 0x3EC0, 
0x01BC, 0x3D80, 0x00DC, 0x3B00, 0x006F, 0xF600, 0x0037, 0xEC00, 
0x001B, 0xD800, 0x000D, 0xB000, 0x0006, 0x6000, 0x0003, 0xC000};

static int IMAGE19[] = {
0x0000, 0x0000, 0x003F, 0xFC00, 0x00FF, 0xFF00, 0x01FF, 0xFF80, 
0x03FF, 0xFFC0, 0x03F0, 0x0FC0, 0x03E0, 0x07C0, 0x03E0, 0x07C0, 
0x01C0, 0x07C0, 0x0000, 0x0F80, 0x0000, 0x1F80, 0x0000, 0x3F00, 
0x0000, 0x7E00, 0x0000, 0xFC00, 0x0001, 0xF800, 0x0003, 0xF000, 
0x0007, 0xE000, 0x0007, 0xC000, 0x000F, 0x8000, 0x000F, 0x8000, 
0x000F, 0x8000, 0x000F, 0x8000, 0x000F, 0x8000, 0x0007, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000F, 0x8000, 
0x001F, 0xC000, 0x001F, 0xC000, 0x000F, 0x8000, 0x0000, 0x0000};

static BITBLK alert_icn[] = {
	{ I_CAST IMAGE1, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE3, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE4, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE5, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE6, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE7, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE8, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE9, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE10, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE11, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE12, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE13, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE14, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE15, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE16, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE17, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE18, 4, 32, 0, 0, 1 },
	{ I_CAST IMAGE19, 4, 32, 0, 0, 1 }
};

static OBJECT alert_tree[] = {
	{ -1, 1, 21, G_BOX, NONE, OUTLINED, CAST (0x21100L), 0,0, 52,14 },
	{ 2, -1, -1, (0x9<<8)+G_IBOX, SELECTABLE, NORMAL, CAST (0x57011100L), 50,0, 2,1 },
	{ 3, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,1, 1,1 },
	{ 4, -1, -1, G_IMAGE, NONE, NORMAL, CAST (&alert_icn[0]), 2,1, 12288,7680 },
	{ 5, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,2, 1,1 },
	{ 6, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,3, 1,1 },
	{ 7, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,4, 1,1 },
	{ 8, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,5, 1,1 },
	{ 9, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,6, 1,1 },
	{ 10, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,7, 1,1 },
	{ 11, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,8, 1,1 },
	{ 12, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,9, 1,1 },
	{ 13, -1, -1, G_STRING, NONE, NORMAL, CAST (string), 10,10, 2,1 },
	{ 15, 14, 14, G_BUTTON, 0x5, NORMAL, CAST (string), 2,12, 8,1 },
	{ 13, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 2,0, 1,1 },
	{ 17, 16, 16, G_BUTTON, 0x5, NORMAL, CAST (string), 12,12, 8,1 },
	{ 15, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 2,0, 1,1 },
	{ 19, 18, 18, G_BUTTON, 0x5, NORMAL, CAST (string), 32,12, 8,1 },
	{ 17, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 1,0, 1,1 },
	{ 21, 20, 20, G_BUTTON, 0x5, NORMAL, CAST (string), 22,12, 8,1 },
	{ 19, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 2,0, 1,1 },
	{ 0, 22, 22, G_BUTTON, 0x5, NORMAL, CAST (string), 42,12, 8,1 },
	{ 21, -1, -1, (0x5<<8)+G_IBOX, LASTOB, NORMAL, CAST (0x53011100L), 1,0, 1,1 }
};

static boolean fixed = FALSE;

int xalert(int def,int icn,BITBLK *usr_icn,char *title,char *txt,char *btns,int (*init)(EVENT*),void (*call_func)(EVENT *))
{
	char buttons[128],text[512];
	reg OBJECT *tree = alert_tree,*obj;
	reg char *p,*q,*b;
	reg int i,k,m,w;
	int x,y,c;

	if (fixed==FALSE)
	{
		rsrc_calc(tree,SCALING);
		fixed = TRUE;
	}

	def--;
	if (usr_icn==NULL && icn>=0 && icn<=X_ICN_MAX)
		usr_icn = &alert_icn[icn];

	obj = &tree[ALERTICN];

	x = obj->ob_x;
	m = y = obj->ob_y;

	if (usr_icn)
	{
		obj->ob_spec.bitblk = usr_icn;
		obj->ob_flags &= ~HIDETREE;
		x += obj->ob_width = (w=usr_icn->bi_x + (usr_icn->bi_wb<<3));
		obj->ob_height = usr_icn->bi_y + usr_icn->bi_hl;
		m += (obj->ob_height + gr_ch) & (~(gr_ch-1));
		x += gr_cw<<1;
	}
	else
		obj->ob_flags |= HIDETREE;

	w = x;
	x = (x + 8) & (~7);

	if (usr_icn)
		obj->ob_x += (x - w)>>1;

	strcpy(q=text,txt);
	for (i=w=0;i<10;i++)
	{
		if (q)
		{
			ob_set_text(tree,k=alert_text[i],p=q);

			obj = &tree[k];	
			obj->ob_x = x;
			obj->ob_y = y;
			y += gr_ch;

			q = strchr(q,'|');
			if (q)
				*q++ = '\0';
		
			w = max(w,(int) strlen(p));
			obj->ob_width = w * gr_cw;
		}
		else
			ob_set_text(tree,alert_text[i],string);
	}

	w = x + (max(w,16) + 2) * gr_cw;
	y = max(y+=gr_ch,m);

	strcpy(q=buttons,btns);
	for (m=i=c=0;i<6;i++)
	{
		if (q)
		{
			c = i;
			ob_set_text(tree,k=alert_btn[i],b=p=q);
			q = strchr(q,'|');
			if (q)
				*q++ = '\0';

			tree[k].ob_y = y;

			ob_undoflag(tree,k,HIDETREE);
			if (def==i)
				ob_doflag(tree,k,DEFAULT);
			else
				ob_undoflag(tree,k,DEFAULT);

			if ((p=strchr(p,'['))!=NULL)
			{
				strcpy(p,p+1);
				alert_hot[i] = *p;
			}
			else
				alert_hot[i] = '\0';
			m = max(m,(int) strlen(b));
		}
		else
			ob_doflag(tree,alert_btn[i],HIDETREE);
	}

	x = tree[ALERTICN].ob_x;
	m = (max(m,4) + 2) * gr_cw;
	k = x + ((m + (gr_cw<<1)) * (c + 1));

	if (k<w)
		x += w-k;

	for (i=0;i<=c;i++)
	{
		obj = &tree[k=alert_btn[i]];
		obj->ob_x = x;
		obj->ob_width = m;

		ob_set_hotkey(tree,k,alert_hot[i]);
		x += gr_cw<<1;
		x += m;
	}

	w = max(x,w);

	tree[ALERTFLY].ob_x = w - (gr_cw<<1) - 1;
	tree->ob_width = w;
	tree->ob_height = y + (gr_ch<<1);

	k = xdialog(alert_tree,title,TRUE,FALSE,AUTO_DIAL|MODAL,init,call_func);

	for (i=0;i<=c;i++)
		if (k==alert_btn[i])
			return (i);
	return (-1);
}
