
#include <vdi.h>
#include <tos.h>
#include <stdio.h>
#include <portab.h>

#include "midnight.h"	/* ACC_str + MOD_str + defines fr Module + ACC */


extern MOD_str MOD_struct;

Value	*Value_s = NULL;		/* zeigt auf eine Liste von Pointern	*/


/*
	GRUNDLEGENDES !
	Da die Module ab und zu einmal aufgerufen werden und eben nicht 
	kontinuierlich die Kontrolle ber die Register haben, kann es bei
	Benutzung einer Variablen ber mehrere Programmteile (M_INIT,M_SWITCH...)
	zu Problemen kommen, da ja inzwischen wieder 'Sonstwer' in den Registern
	'rumgespielt hat. Deshalb sind solche Variablen als 'static' zu deklarieren,
	im Notfall (wenn's nicht klappt) auch als Volatile.
	Sicher ist sicher...
*/

void shift_col( void );


int		pxy[10];
int		Copy[8];
MFDB	mfs,mfd;
volatile static int handle;		/* darf nicht im Register stehn			*/

ULONG MOD_main( int Mode, ACC_str *As )
{
	static int	add_x,add_y, x1,x2,y1,y2, dim,i;

	switch( Mode )
	{	case M_INIT:
			MOD_struct.U.b = 0x003f;
			v_opnvwk( As->work_in,&handle,As->work_out );
			if( !handle ) return( 0 );
			mfs.fd_addr= mfd.fd_addr= NULL;	/* Bildschirm nehmen		*/
			vsf_interior( handle,2 );
			vsf_style( handle,8 );
			vsf_perimeter( handle,0 );
			pxy[0]=As->x;
			pxy[1]=As->y;
			pxy[2]=As->x+As->w;
			pxy[3]=As->y+As->h;
			vs_clip( handle,1,pxy );
			break;
		case M_SWITCH:
			vswr_mode( handle,MD_TRANS );
			for( x1=1;(x1<9)&&!EVNT_ask( 50 );x1++ )
			{	vsf_style( handle,x1 );
				v_bar( handle,pxy );
			}
			break;
		case M_DO_IT:
			vswr_mode( handle,MD_REPLACE );
			v_bar( handle,pxy );
			vsf_color( handle,2 );

			shift_col();

			dim= 133;
			x2= (x1= As->x)+As->w - dim;
			y2= (y1= As->y)+As->h - dim;
			add_y= dim>>1;
			if( As->planes <= 2 )
				for( add_x=7;add_x>=0;add_x-- )
				{	vsf_style( handle,add_x );
					if( !add_x ) vsf_interior( handle,0 );
					v_circle( handle,add_y-add_y*(7-add_x)/32,
									add_y-add_y*(7-add_x)/32,
									(add_y-5)*(add_x+1)/8 );
				}
			else
			{	vsf_style( handle,8 );
				for( add_x=15;add_x>1;add_x-- )
				{	vsf_color( handle,add_x );
					v_circle( handle,add_y-add_y/64*(15-add_x),
									add_y-add_y/64*(15-add_x),
									(add_y-5)/15*add_x );
				}
			}

			Copy[4]= x1;
			Copy[5]= y1;
			add_x=3;
			add_y=4;
			while( !EVNT_ask( 20 ) )
			{	Copy[2]= (Copy[0]=Copy[4]) + dim;
				Copy[3]= (Copy[1]=Copy[5]) + dim;
				if( (Copy[4]+add_x >= x2)||(Copy[4]+add_x < x1) )
				{	add_x= (add_x<0?1:-1)*((Random()%3)+2);
					if( As->planes >= 2 ) shift_col();
				}
				Copy[6]= (Copy[4]+= add_x) + dim;
				if( (Copy[5]+add_y >= y2)||(Copy[5]+add_y < y1) )
				{	add_y= (add_y<0?1:-1)*((Random()%3)+2);
					if( As->planes >= 2 ) shift_col();
				}
				Copy[7]= (Copy[5]+= add_y) + dim;
				vro_cpyfm( handle,S_ONLY,Copy,&mfs,&mfd );
			}

			break;
		case M_EXIT:
			if( handle ) v_clsvwk( handle );
			break;
	}

	return( 1 );
}


void shift_col( void )
{
	int i,j,cb=0, col[3] = {0,0,0};

	while( !cb ) cb = Random() & 0x7;
	if( cb & 0x4 ) col[0] = 1000;
	if( cb & 0x2 ) col[1] = 1000;
	if( cb & 0x1 ) col[2] = 1000;
	for( i=0;i<14;i++)
	{	for( j=0;j<3;j++ ) if(col[j]) col[j]-=50;
		vs_color( handle,i+2,col );
	}
}
