; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

	opt		h-o+f+
	org		$4000

	GENLIBRARY = 1

	icl		'library.s'

.macro _MODULEADDRHI
	dta >(mod_:1)
.endm	

.macro _MODULEADDRLO
	dta <(mod_:1)
.endm	
	
.def ?module_count = 0

.macro _MODULELABEL1
	.def mod_:1 = *
.endm

.macro _MODULELABEL
	;workaround for annoying MADS bug where MACRO and REPT parameters don't nest properly
	.rept :1+1
	.if # == :1
		_MODULELABEL1 #
	.endif
	.endr
.endm

.macro _MODULE
	_MODULELABEL ?module_count

	ins	:1
	.def :?module_count = :?module_count + 1
.endm

	_MODULE 'mod_options.lzobx'
	_MODULE 'cpu_insn.lzobx'
	_MODULE 'cpu_flags.lzobx'
	_MODULE 'cpu_decimal.lzobx'
	_MODULE 'cpu_timing.lzobx'
	_MODULE 'cpu_bugs.lzobx'
	_MODULE 'cpu_clisei.lzobx'
	_MODULE 'cpu_illegal.lzobx'
	_MODULE 'antic_default.lzobx'
	_MODULE 'antic_nmist.lzobx'
	_MODULE 'antic_hiresbug.lzobx'
	_MODULE 'antic_vcount.lzobx'
	_MODULE 'antic_wsync.lzobx'
	_MODULE 'antic_addresswrap.lzobx'
	_MODULE 'antic_dlistwrap.lzobx'
	_MODULE 'antic_dlitiming.lzobx'
	_MODULE 'antic_addrmirror.lzobx'
	_MODULE 'antic_pmdma.lzobx'
	_MODULE 'antic_charcontrol.lzobx'
	_MODULE 'antic_dmapattern.lzobx'
	_MODULE 'antic_blockednmi.lzobx'
	_MODULE 'antic_hscrolbug.lzobx'
	_MODULE 'antic_virtdma.lzobx'
	_MODULE 'antic_vscroll.lzobx'
	_MODULE 'antic_vscroldli.lzobx'
	_MODULE 'antic_pfstarttiming.lzobx'
	_MODULE 'antic_pfstoptiming.lzobx'
	_MODULE 'antic_linebuffering.lzobx'
	_MODULE 'pokey_default.lzobx'
	_MODULE 'pokey_noise.lzobx'
	_MODULE 'pokey_irqtiming.lzobx'
	_MODULE 'pokey_timergranularity.lzobx'
	_MODULE 'pokey_twotone.lzobx'
	_MODULE 'pokey_seroc.lzobx'
	_MODULE 'pokey_timerirq.lzobx'
	_MODULE 'pokey_asyncrecv.lzobx'
	_MODULE 'pokey_addrmirror.lzobx'
	_MODULE 'pokey_inittiming.lzobx'
	_MODULE 'gtia_default.lzobx'
	_MODULE 'gtia_phantomdma.lzobx'
	_MODULE 'gtia_consol.lzobx'
	_MODULE 'gtia_collision.lzobx'
	_MODULE 'gtia_collision2.lzobx'
	_MODULE 'gtia_pmretrigger.lzobx'
	_MODULE 'gtia_pmresize.lzobx'
	_MODULE 'gtia_pmoverlap.lzobx'
	_MODULE 'gtia_psuedomodee.lzobx'
	_MODULE 'gtia_addrmirror.lzobx'
modules_end:

	icl		'menu.s'
	icl		'display5200.s'

.proc _boot
	jsr		_crt0init
	jsr		_disp_init
	cli
	jmp		main
.endp

	org		segaddrlo
	:?module_count _MODULEADDRLO #
	dta		<modules_end
	dta		$00

	org		segaddrhi
	:?module_count _MODULEADDRHI #
	dta		>modules_end
	dta		$00

	org		$bfe8
	dta		d"                    "
	dta		$00,$00,a(_boot)
