; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

disp_savepc = *

		opt		o-f-
		org		$20
_disp_row		dta		0
_disp_col		dta		0
_disp_rowptr	dta		a(0)
_disp_cha		dta		0
		
_disp_dlist		equ		$0300
_disp_rowaddrlo	equ		$0380
_disp_rowaddrhi	equ		$0398
		
		org		disp_savepc
		opt		o+f+

;==========================================================================
.nowarn .proc _disp_init
		;copy down initial rows to low memory
		ldx		#47
copyloop1:
		mva		_disp_rowaddrinit,x _disp_rowaddrlo,x
		dex
		bpl		copyloop1

		;clear screen memory
		jsr		_disp_clearScreen
		
		;set up new display list
		jsr		_disp_rewriteDisplayList
		
		;setup colors
		mva		#$ca color1
		mva		#$94 color2
		mva		#$f8 chbase
		mva		#$02 chactl
		mva		#$22 sdmctl
		
		;swap in new display list and vector handlers
		sei
		mwa		#_disp_dlist sdlstl
		cli
		
		;turn on NMIs
		mva		#$40 nmien
		
		;wait for vertical blank
		jsr		_waitVBL
		
		;init params
		mva		#0 _disp_row
		mva		#2 _disp_col
		jsr		_disp_recompRowAddr
		
		;replace putchar vector
		mwa		#_disp_putchar _vputchar
		rts
.endp

;==========================================================================
.proc	_disp_putchar
		sta		_disp_cha
		tya
		pha
		
		jsr		_disp_toggleCursor
		
		lda		_disp_cha
		
		;check for newline
		cmp		#$9b
		beq		newline
		
		;check for clear line
		cmp		#$9c
		beq		isclearline
		
		;check for clear screen
		cmp		#$7d
		beq		isclearscrn

		;draw raw character
		jsr		_disp_putraw
		
		;update position and exit
		inc		_disp_col
		lda		_disp_col
		cmp		#39
		bcs		newline
alldone:
		jsr		_disp_toggleCursor

		pla
		tay
		rts
		
isclearscrn:
		jsr		_disp_clearScreen
		mva		#0 _disp_row
		mva		#2 _disp_col
		jsr		_disp_recompRowAddr
		jmp		alldone
 
isclearline:
		jsr		_disp_clearLine
		jmp		alldone
		
newline:
		;reset X position
		mva		#2 _disp_col
		
		;increment Y position
		inc		_disp_row
		
		;check if we've gone over
		lda		_disp_row
		cmp		#24
		bcc		noscroll
		
		;whoops... looks like we'll have to scroll
		mva		#23 _disp_row
		jsr		_disp_scroll

noscroll:
		jsr		_disp_recompRowAddr
		jmp		alldone
.endp

;==========================================================================
.proc	_disp_clearLine
		lda		#0
		ldy		#40
yloop:
		sta		(_disp_rowptr),y
		dey
		bpl		yloop
		
		mva		#2 _disp_col
		
		jmp		_disp_recompRowAddr
.endp

;==========================================================================
.proc	_disp_scroll
		;rotate row lines
		lda		_disp_rowaddrlo
		pha
		lda		_disp_rowaddrhi
		pha
		
		ldx		#$e9
shiftloop:
		lda		_disp_rowaddrlo-$e8,x
		sta		_disp_rowaddrlo-$e9,x
		lda		_disp_rowaddrhi-$e8,x
		sta		_disp_rowaddrhi-$e9,x
		inx
		bne		shiftloop
		
		pla
		sta		_disp_rowaddrhi+23
		pla
		sta		_disp_rowaddrlo+23
		
		;remake display list
		jsr		_disp_rewriteDisplayList
		
		;clear row 23
		mva		_disp_rowaddrhi+23 _disp_rowptr+1
		mva		_disp_rowaddrlo+23 _disp_rowptr
		
		lda		#0
		ldy		#39
xloop:
		sta		(_disp_rowptr),y
		dey
		bpl		xloop
		inc		_disp_rowptr+1
		
		mva		#23 _disp_row
		jmp		_disp_recompRowAddr
.endp

;==========================================================================
.proc	_disp_recompRowAddr
		ldx		_disp_row
		mva		_disp_rowaddrlo,x _disp_rowptr
		mva		_disp_rowaddrhi,x _disp_rowptr+1
		rts
.endp

;==========================================================================
.proc	_disp_putraw
		;convert to internal encoding
		pha
		rol
		rol
		rol
		rol
		and		#3
		tax
		pla
		eor		convtab,x
		
		;store character
		ldy		_disp_col
		sta		(_disp_rowptr),y

		;all done
		rts
		
convtab:
		dta		$40
		dta		$20
		dta		$60
		dta		$00

.endp
		
;==========================================================================
.proc	_disp_toggleCursor
		ldy		_disp_col
		lda		(_disp_rowptr),y
		eor		#$80
		sta		(_disp_rowptr),y
		rts
.endp

;=========================================================================
.proc	_disp_rewriteDisplayList
		mwa		#$0300 _disp_rowptr
		ldy		#0
		
		;24 blank lines
		lda		#$70
		sta:iny	(_disp_rowptr),y
		sta:iny	(_disp_rowptr),y
		sta:iny	(_disp_rowptr),y
		
		;24 LMS lines
		ldx		#0
lineloop:
		mva:iny	#$42				(_disp_rowptr),y
		mva:iny	_disp_rowaddrlo,x	(_disp_rowptr),y
		mva:iny	_disp_rowaddrhi,x	(_disp_rowptr),y
		inx
		cpx		#24
		bne		lineloop
		
		;add wait for VBL insn
		mva:iny	#$41		(_disp_rowptr),y
		mva:iny	#<$0300		(_disp_rowptr),y
		mva		#>$0300		(_disp_rowptr),y
		rts		
.endp

;=========================================================================
.proc	_disp_clearScreen
		mva		#$04 _disp_rowptr+1
		mva		#$00 _disp_rowptr
		ldx		#$04
xloop:
		ldy		#0
yloop:
		sta		(_disp_rowptr),y
		iny
		bne		yloop
		inc		_disp_rowptr+1
		dex
		bne		xloop
		rts
.endp

;=========================================================================	
_disp_rowaddrinit:
		:24 dta <($0400 + 40*#)
		:24 dta >($0400 + 40*#)
